/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.tasks.context;

import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.project.Project;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

/**
 * @author Dmitry Avdeev
 */
public class RunConfigurationsContextProvider extends WorkingContextProvider {
  @NotNull private final Project myProject;

  public RunConfigurationsContextProvider(@NotNull Project project) {
    myProject = project;
  }

  @Override
  @NotNull
  public String getId() {
    return "runConfigurations";
  }

  @Override
  @NotNull
  public String getDescription() {
    return "Run Configurations";
  }

  @Override
  public void saveContext(Element toElement) {
    RunManagerImpl.getInstanceImpl(myProject).writeContext(toElement);
  }

  @Override
  public void loadContext(Element fromElement) {
    RunManagerImpl.getInstanceImpl(myProject).readContext(fromElement);
  }
}
