---
tweet: What's new in Joplin 3.0
forum_url: https://discourse.joplinapp.org/t/38867
---

# What's new in Joplin 3.0

## Desktop application

### Trash folder

Joplin now support a trash folder - any deleted notes or notebooks will be moved to that folder. You can also choose to have these notes permanently deleted after a number of days.

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20240701-trash.png)

Support for the trash folder has a somewhat long history in Joplin since it's an obvious and important feature to add, yet it can be particularly tricky once you start realising how many parts of the app it's going to impact.

Many attempts have been made over time: my first attempt was based on the note history feature. Indeed since this feature already saves versions of notes, it seems to make sense to use it for the trash feature, and indeed the note history feature [was designed for this originally](https://joplinapp.org/news/20190523-221026). However that approach turned to be needlessly complicated and after modifying hundreds of files just for this, the idea was dropped.

The next one was based on using a [special "trash" tag](https://github.com/laurent22/joplin/issues/483) - deleted notes would have this tag attached to them and would appear in a special "trash" folder. This approach also had [many issues](https://github.com/laurent22/joplin/issues/483) probably the main one being that notebooks can't be tagged, which means we would have to add support for tagged notebooks and that in itself would also be a massive change.

[Various](https://discourse.joplinapp.org/t/trashcan/3998/16), [ideas,](https://discourse.joplinapp.org/t/poll-trash-bin-plugin/19951) were also attempted using plugins, by creating a special "trash folder", but in the end no such plugin was ever created, probably due to limitations of the plugin API.

In the end, turned out that this [old idea](https://github.com/laurent22/joplin/issues/483#issuecomment-585655742) of adding a "deleted" property to each note and notebook was the easiest approach. With this it was simpler to get to a working solution relatively quickly, and then it was a matter of ensuring that deleted notes don't appear where they shouldn't, such as search results, etc.

### Joplin Cloud multi-factor authentication

Multi-factor authentication (MFA), also known as two-factor authentication (2FA) is a security process that requires you to provide two or more verification factors to gain access to a system or account. It typically includes something you know (password), something you have (security token), and something you are (biometric verification).

To better secure your account, Joplin Cloud and all Joplin applications now support MFA. To enable it, go to your Joplin Cloud profile, click on "Enable multi-factor authentication" and follow the instructions. Please note that all your applications will then be disconnected, so you will need to login again (your data of course will remain on the app so you won't have to download it again).

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20240701-mfa.png)

### Note list with multiple columns

In this release we add support for multiple columns in the note list. You can display various properties of the notes, as well as sort the notes by these properties. As usual this feature can be controlled and customised by plugins so for example it should be possible to display custom columns, and display custom information including thumbnails.

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20240701-note-list-multi.png)

### Plugin API enhancement

The plugin API has received several updates to facilitate easy customisation of the app As mentioned above, it is now possible to customise the new note list. Besides this, we've added support for loading PDFs and creating images from them, which can for example be used to create thumbnails.

Many other small enhancements have been made to the plugin API to help you tailor the app to your needs!

### View OCR data

Now when you right-click on an image or PDF you have an option to view the OCR (Optical character recognition) data associated with it. That will allow you for example to easily copy and paste the text.

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20240701-ocr-data.png)

## Plugin support on mobile

As always, most of the above changes also apply to mobile (iOS and Android), for example the trash folder and MFA support.

Additionally the mobile application now adds support for plugins. To enable the feature, go to the settings then to the "Plugins" section. The feature is currently in Beta, in particular it means that some plugins do not work or only partially work. Normally the app should not offer you to install a non-working plugin but that may still happen. In general if you notice any issue with this beta feature please let me us know as we're keen to improve it.

Support for cross-platform plugins in Joplin is great news as it means a lot of new features become available on mobile. As of now, we have checked the following plugins and can confirm that they work on mobile:

- [Quick Links](https://joplinapp.org/plugins/plugin/com.whatever.quick-links/)
- [Inline Tags](https://joplinapp.org/plugins/plugin/com.whatever.inline-tags/)
- [CodeMirror 6 settings](https://joplinapp.org/plugins/plugin/io.github.personalizedrefrigerator.codemirror6-settings/)
- [Function plot](https://joplinapp.org/plugins/plugin/com.hieuthi.joplin.function-plot/)
- [Space indenter](https://joplinapp.org/plugins/plugin/joplin.plugin.space-indenter/)
- [Inline Tag Navigator](https://joplinapp.org/plugins/plugin/joplin.plugin.alondmnt.tag-navigator/)

Those are just some examples - many more are working!

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20240701-mobile-plugins.png)

# Full changelogs

This is just an overview of the main features. The full changelogs are available there:

- Desktop: https://joplinapp.org/help/about/changelog/desktop
- Android: https://joplinapp.org/help/about/changelog/android/
- iOS: https://joplinapp.org/help/about/changelog/ios/