/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.suspendable;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.model.suspendable.callable.CallablePageSource;
import com.jsql.util.LogLevelUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SuspendableGetIndexes
extends AbstractSuspendable {
    private static final Logger LOGGER = LogManager.getRootLogger();

    public SuspendableGetIndexes(InjectionModel injectionModel) {
        super(injectionModel);
    }

    @Override
    public String run(Object ... args) throws JSqlException {
        int nbIndex;
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetIndexes");
        ExecutorCompletionService<CallablePageSource> taskCompletionService = new ExecutorCompletionService<CallablePageSource>(taskExecutor);
        String initialQuery = "";
        int countUnionIndex = this.injectionModel.getMediatorUtils().getPreferencesUtil().isLimitingUnionIndex() ? this.injectionModel.getMediatorUtils().getPreferencesUtil().countUnionIndex() : 50;
        for (nbIndex = 1; nbIndex <= countUnionIndex; ++nbIndex) {
            taskCompletionService.submit(new CallablePageSource(this.injectionModel.getMediatorVendor().getVendor().instance().sqlIndices(nbIndex), this.injectionModel, "union#" + nbIndex, nbIndex));
        }
        try {
            for (nbIndex = 1; nbIndex <= countUnionIndex; ++nbIndex) {
                if (this.isSuspended()) {
                    throw new StoppedByUserSlidingException();
                }
                CallablePageSource currentCallable = (CallablePageSource)taskCompletionService.take().get();
                String regexAllIndexes = String.format("1337%s7331", "\\d+");
                if (!Pattern.compile("(?s).*" + regexAllIndexes + ".*").matcher(currentCallable.getContent()).matches()) continue;
                this.injectionModel.getMediatorStrategy().getSpecificUnion().setNbIndexesFound(currentCallable.getNbIndex());
                this.injectionModel.getMediatorStrategy().getSpecificUnion().setSourceIndexesFound(currentCallable.getContent());
                initialQuery = currentCallable.getQuery().replace("0%2b1", "1");
                if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isPerfIndexDisabled()) {
                    String regexIndexesExceptFirst = String.format("1337%s7331", "(?!17331)\\d+");
                    initialQuery = initialQuery.replaceAll(regexIndexesExceptFirst, "1");
                    LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Calibrating indexes disabled, forcing to index [1]");
                }
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Strategy [Union] triggered by [{}]", () -> currentCallable.getQuery().trim().replaceAll("1337(\\d*)7330%2b1", "$1").replaceAll("\\s+", " "));
                break;
            }
            this.injectionModel.getMediatorUtils().getThreadUtil().shutdown(taskExecutor);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        return initialQuery;
    }
}

