/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.manager;

import com.jsql.util.I18nUtil;
import com.jsql.util.bruter.ActionCoder;
import com.jsql.view.swing.manager.util.ActionBruteForce;
import com.jsql.view.swing.manager.util.JButtonStateful;
import com.jsql.view.swing.manager.util.ModelBrute;
import com.jsql.view.swing.manager.util.ModelSpinner;
import com.jsql.view.swing.panel.preferences.listener.SpinnerMouseWheelListener;
import com.jsql.view.swing.text.JPopupTextField;
import com.jsql.view.swing.text.JPopupTextPane;
import com.jsql.view.swing.text.JTextFieldPlaceholder;
import com.jsql.view.swing.text.JTextPanePlaceholder;
import com.jsql.view.swing.text.JToolTipI18n;
import com.jsql.view.swing.util.I18nViewUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolTip;
import javax.swing.SpinnerNumberModel;

public class ManagerBruteForce
extends JPanel {
    public static final String BRUTEFORCE_RUN_BUTTON_TOOLTIP = "BRUTEFORCE_RUN_BUTTON_TOOLTIP";
    public static final String BRUTEFORCE_HASH_TOOLTIP = "BRUTEFORCE_HASH_TOOLTIP";
    public static final String BRUTEFORCE_EXCLUDE_TOOLTIP = "BRUTEFORCE_EXCLUDE_TOOLTIP";
    private JButtonStateful run;
    private JTextField hash;
    private JComboBox<String> hashTypes;
    private final AtomicReference<JCheckBox> lowerCaseCharacters = new AtomicReference();
    private final AtomicReference<JCheckBox> upperCaseCharacters = new AtomicReference();
    private final AtomicReference<JCheckBox> numericCharacters = new AtomicReference();
    private final AtomicReference<JCheckBox> specialCharacters = new AtomicReference();
    private JTextField exclude;
    private final AtomicReference<JSpinner> minimumLength = new AtomicReference();
    private final AtomicReference<JSpinner> maximumLength = new AtomicReference();
    private final JTextPane result;
    private JProgressBar progressBar;
    private final Component horizontalGlue = Box.createHorizontalGlue();

    public ManagerBruteForce() {
        super(new BorderLayout());
        JPanel panelOptions = this.initOptionsPanel();
        this.add((Component)panelOptions, "North");
        JTextPanePlaceholder placeholder = new JTextPanePlaceholder(I18nUtil.valueByKey("BRUTEFORCE_RESULT"));
        this.result = (JTextPane)new JPopupTextPane(placeholder).getProxy();
        I18nViewUtil.addComponentForKey("BRUTEFORCE_RESULT", placeholder);
        this.result.setName("managerBruterResult");
        this.result.setEditable(false);
        this.add((Component)new JScrollPane(this.result), "Center");
        JPanel panelButton = this.initPanelButton();
        this.add((Component)panelButton, "South");
    }

    private JPanel initPanelButton() {
        JPanel lastLine = new JPanel();
        lastLine.setLayout(new BoxLayout(lastLine, 0));
        final AtomicReference<JToolTipI18n> tooltip = new AtomicReference<JToolTipI18n>(new JToolTipI18n(I18nUtil.valueByKey(BRUTEFORCE_RUN_BUTTON_TOOLTIP)));
        this.run = new JButtonStateful("BRUTEFORCE_RUN_BUTTON_LABEL"){

            @Override
            public JToolTip createToolTip() {
                return (JToolTip)tooltip.get();
            }
        };
        I18nViewUtil.addComponentForKey("BRUTEFORCE_RUN_BUTTON_LABEL", this.run);
        I18nViewUtil.addComponentForKey(BRUTEFORCE_RUN_BUTTON_TOOLTIP, tooltip.get());
        this.run.setToolTipText(I18nUtil.valueByKey(BRUTEFORCE_RUN_BUTTON_TOOLTIP));
        this.run.setName("managerBruterRun");
        this.run.addActionListener(new ActionBruteForce(this));
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setVisible(false);
        this.progressBar.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        lastLine.add(this.horizontalGlue);
        lastLine.add(this.progressBar);
        lastLine.add(this.run);
        return lastLine;
    }

    public void showLoader(boolean isVisible) {
        this.progressBar.setVisible(isVisible);
        this.horizontalGlue.setVisible(!isVisible);
    }

    private JPanel initOptionsPanel() {
        JPanel options = new JPanel(new BorderLayout());
        JPanel firstLine = this.initFirstLine();
        JPanel secondLine = this.initSecondLine();
        JPanel thirdLine = this.initThirdLine();
        JPanel secondAndThirdLine = new JPanel(new BorderLayout());
        secondAndThirdLine.add((Component)secondLine, "North");
        secondAndThirdLine.add((Component)thirdLine, "South");
        options.add((Component)firstLine, "North");
        options.add((Component)secondAndThirdLine, "South");
        return options;
    }

    private JPanel initFirstLine() {
        final AtomicReference<JToolTipI18n> tooltip = new AtomicReference<JToolTipI18n>(new JToolTipI18n(I18nUtil.valueByKey(BRUTEFORCE_HASH_TOOLTIP)));
        JTextFieldPlaceholder placeholder = new JTextFieldPlaceholder(I18nUtil.valueByKey("BRUTEFORCE_HASH_LABEL")){

            @Override
            public JToolTip createToolTip() {
                return (JToolTip)tooltip.get();
            }
        };
        this.hash = (JTextField)new JPopupTextField(placeholder).getProxy();
        I18nViewUtil.addComponentForKey(BRUTEFORCE_HASH_TOOLTIP, tooltip.get());
        I18nViewUtil.addComponentForKey("BRUTEFORCE_HASH_LABEL", this.hash);
        this.hash.setName("managerBruterHash");
        this.hash.setToolTipText(I18nUtil.valueByKey(BRUTEFORCE_HASH_TOOLTIP));
        JPanel firstLine = new JPanel(new BorderLayout());
        firstLine.add((Component)this.hash, "Center");
        return firstLine;
    }

    private JPanel initSecondLine() {
        JPanel secondLine = new JPanel();
        secondLine.setLayout(new BoxLayout(secondLine, 0));
        this.hashTypes = new JComboBox<String>((String[])ActionCoder.getHashes().toArray(String[]::new));
        this.hashTypes.setSelectedIndex(6);
        this.hashTypes.setToolTipText(I18nUtil.valueByKey("BRUTEFORCE_HASH_TYPE_TOOLTIP"));
        I18nViewUtil.addComponentForKey("BRUTEFORCE_HASH_TYPE_TOOLTIP", this.hashTypes);
        secondLine.add(this.hashTypes);
        Arrays.asList(new ModelBrute(this.lowerCaseCharacters, "a-z", "BRUTEFORCE_LCASE_TOOLTIP"), new ModelBrute(this.upperCaseCharacters, "A-Z", "BRUTEFORCE_UCASE_TOOLTIP"), new ModelBrute(this.numericCharacters, "0-9", "BRUTEFORCE_NUM_TOOLTIP"), new ModelBrute(this.specialCharacters, "Special", "BRUTEFORCE_SPEC_TOOLTIP")).forEach(modelBrute -> {
            final AtomicReference<JToolTipI18n> tooltip = new AtomicReference<JToolTipI18n>(new JToolTipI18n(I18nUtil.valueByKey(modelBrute.i18nTooltip)));
            modelBrute.checkbox.set(new JCheckBox(modelBrute.text, true){

                @Override
                public JToolTip createToolTip() {
                    return (JToolTip)tooltip.get();
                }
            });
            modelBrute.checkbox.get().setToolTipText(I18nUtil.valueByKey(modelBrute.i18nTooltip));
            I18nViewUtil.addComponentForKey(modelBrute.i18nTooltip, tooltip.get());
            secondLine.add(Box.createHorizontalStrut(5));
            secondLine.add(modelBrute.checkbox.get());
        });
        return secondLine;
    }

    private JPanel initThirdLine() {
        JPanel thirdLine = new JPanel();
        thirdLine.setLayout(new BoxLayout(thirdLine, 0));
        final AtomicReference<JToolTipI18n> tooltip = new AtomicReference<JToolTipI18n>(new JToolTipI18n(I18nUtil.valueByKey(BRUTEFORCE_EXCLUDE_TOOLTIP)));
        JTextFieldPlaceholder placeholderTooltip = new JTextFieldPlaceholder(I18nUtil.valueByKey("BRUTEFORCE_EXCLUDE_LABEL")){

            @Override
            public JToolTip createToolTip() {
                return (JToolTip)tooltip.get();
            }
        };
        this.exclude = (JTextField)new JPopupTextField(placeholderTooltip).getProxy();
        this.exclude.setToolTipText(I18nUtil.valueByKey(BRUTEFORCE_EXCLUDE_TOOLTIP));
        I18nViewUtil.addComponentForKey("BRUTEFORCE_EXCLUDE_LABEL", this.exclude);
        I18nViewUtil.addComponentForKey(BRUTEFORCE_EXCLUDE_TOOLTIP, tooltip.get());
        thirdLine.add(this.exclude);
        Arrays.asList(new ModelSpinner(1, this.minimumLength, "BRUTEFORCE_MIN_TOOLTIP"), new ModelSpinner(5, this.maximumLength, "BRUTEFORCE_MAX_TOOLTIP")).forEach(model -> {
            final AtomicReference<JToolTipI18n> tooltipMax = new AtomicReference<JToolTipI18n>(new JToolTipI18n(I18nUtil.valueByKey(model.i18n)));
            model.spinner.set(new JSpinner(){

                @Override
                public JToolTip createToolTip() {
                    return (JToolTip)tooltipMax.get();
                }
            });
            model.spinner.get().setModel(new SpinnerNumberModel(model.value, 1, 10000, 1));
            model.spinner.get().addMouseWheelListener(new SpinnerMouseWheelListener());
            model.spinner.get().setToolTipText(I18nUtil.valueByKey(model.i18n));
            I18nViewUtil.addComponentForKey(model.i18n, tooltipMax.get());
            model.spinner.get().setPreferredSize(new Dimension((int)((double)model.spinner.get().getPreferredSize().width / 1.8), model.spinner.get().getPreferredSize().height));
        });
        JLabel labelMin = new JLabel(" " + I18nUtil.valueByKey("BRUTEFORCE_MIN_LABEL"), 4);
        labelMin.setMaximumSize(new Dimension(labelMin.getPreferredSize().width, labelMin.getPreferredSize().height));
        thirdLine.add(Box.createHorizontalStrut(5));
        thirdLine.add(labelMin);
        I18nViewUtil.addComponentForKey("BRUTEFORCE_MIN_LABEL", labelMin);
        thirdLine.add(this.minimumLength.get());
        JLabel labelMax = new JLabel(" " + I18nUtil.valueByKey("BRUTEFORCE_MAX_LABEL"), 4);
        labelMax.setMaximumSize(new Dimension(labelMax.getPreferredSize().width, labelMax.getPreferredSize().height));
        thirdLine.add(Box.createHorizontalStrut(5));
        thirdLine.add(labelMax);
        I18nViewUtil.addComponentForKey("BRUTEFORCE_MAX_LABEL", labelMax);
        thirdLine.add(this.maximumLength.get());
        return thirdLine;
    }

    public JButtonStateful getRun() {
        return this.run;
    }

    public JTextField getHash() {
        return this.hash;
    }

    public JComboBox<String> getHashTypes() {
        return this.hashTypes;
    }

    public JCheckBox getLowerCaseCharacters() {
        return this.lowerCaseCharacters.get();
    }

    public JCheckBox getUpperCaseCharacters() {
        return this.upperCaseCharacters.get();
    }

    public JCheckBox getNumericCharacters() {
        return this.numericCharacters.get();
    }

    public JCheckBox getSpecialCharacters() {
        return this.specialCharacters.get();
    }

    public JTextField getExclude() {
        return this.exclude;
    }

    public JSpinner getMinimumLength() {
        return this.minimumLength.get();
    }

    public JSpinner getMaximumLength() {
        return this.maximumLength.get();
    }

    public JTextPane getResult() {
        return this.result;
    }
}

