/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.accessible;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.AbstractSlidingException;
import com.jsql.model.exception.InjectionFailureException;
import com.jsql.model.exception.LoopDetectedSlidingException;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.vendor.model.Vendor;
import com.jsql.model.suspendable.SuspendableGetRows;
import com.jsql.util.LogLevelUtil;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CallableFile
implements Callable<CallableFile> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    public static final String REQUIRE_STACK = "Read file requirement: stack query";
    private final String pathFile;
    private String sourceFile = "";
    private final SuspendableGetRows suspendableReadFile;
    private final InjectionModel injectionModel;

    public CallableFile(String pathFile, InjectionModel injectionModel) {
        this.pathFile = pathFile;
        this.injectionModel = injectionModel;
        this.suspendableReadFile = new SuspendableGetRows(injectionModel);
    }

    @Override
    public CallableFile call() throws Exception {
        HashMap<Vendor, Readable> mapVendorReadable = new HashMap<Vendor, Readable>();
        mapVendorReadable.put(this.injectionModel.getMediatorVendor().getMysql(), () -> this.injectionModel.getResourceAccess().getExploitMysql().getRead(this.pathFile));
        mapVendorReadable.put(this.injectionModel.getMediatorVendor().getH2(), () -> this.injectionModel.getResourceAccess().getExploitH2().getRead(this.pathFile));
        mapVendorReadable.put(this.injectionModel.getMediatorVendor().getSqlite(), () -> this.injectionModel.getResourceAccess().getExploitSqlite().getRead(this.pathFile));
        mapVendorReadable.put(this.injectionModel.getMediatorVendor().getDerby(), () -> this.injectionModel.getResourceAccess().getExploitDerby().getRead(this.pathFile));
        mapVendorReadable.put(this.injectionModel.getMediatorVendor().getHsqldb(), () -> this.injectionModel.getResourceAccess().getExploitHsqldb().getRead(this.pathFile));
        mapVendorReadable.put(this.injectionModel.getMediatorVendor().getPostgres(), () -> this.injectionModel.getResourceAccess().getExploitPostgres().getRead(this.pathFile));
        Readable readable = (Readable)((Map.Entry)mapVendorReadable.entrySet().stream().filter(entry -> this.injectionModel.getMediatorVendor().getVendor() == entry.getKey()).findFirst().orElse(new AbstractMap.SimpleEntry<Object, Readable>(null, () -> {
            LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Read file not implemented for [{}], share a working example to GitHub to speed up release", (Object)this.injectionModel.getMediatorVendor().getVendor());
            return "";
        }))).getValue();
        String resultToParse = "";
        try {
            resultToParse = readable.call();
        }
        catch (InjectionFailureException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e);
        }
        catch (LoopDetectedSlidingException | StoppedByUserSlidingException e) {
            if (StringUtils.isNotEmpty(e.getSlidingWindowAllRows())) {
                resultToParse = e.getSlidingWindowAllRows();
            } else if (StringUtils.isNotEmpty(e.getSlidingWindowCurrentRows())) {
                resultToParse = e.getSlidingWindowCurrentRows();
            }
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        this.sourceFile = resultToParse;
        return this;
    }

    public String getPathFile() {
        return this.pathFile;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public SuspendableGetRows getSuspendableReadFile() {
        return this.suspendableReadFile;
    }

    @FunctionalInterface
    private static interface Readable {
        public String call() throws AbstractSlidingException;
    }
}

