/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tree;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.tree.CellRendererNode;
import com.jsql.view.swing.tree.action.ActionCheckSingle;
import com.jsql.view.swing.tree.model.AbstractNodeModel;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CellEditorNode
extends AbstractCellEditor
implements TreeCellEditor,
TreeSelectionListener,
MouseListener {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final CellRendererNode defaultTreeRenderer = new CellRendererNode();
    private transient AbstractNodeModel nodeModel;

    public CellEditorNode() {
        MediatorHelper.treeDatabase().addTreeSelectionListener(this);
        MediatorHelper.treeDatabase().addMouseListener(this);
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object nodeRenderer, boolean selected, boolean expanded, boolean leaf, int row) {
        Component componentRenderer = this.defaultTreeRenderer.getTreeCellRendererComponent(tree, nodeRenderer, true, expanded, leaf, row, true);
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)nodeRenderer;
        Object currentNodeModel = currentNode.getUserObject();
        try {
            this.nodeModel = (AbstractNodeModel)currentNodeModel;
            if (componentRenderer instanceof JCheckBox) {
                ((JCheckBox)componentRenderer).addActionListener(new ActionCheckSingle(this.nodeModel, currentNode));
            }
        }
        catch (Exception e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        return componentRenderer;
    }

    @Override
    public Object getCellEditorValue() {
        return this.nodeModel;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        AbstractNodeModel dataModel;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)MediatorHelper.treeDatabase().getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node.getUserObject() instanceof AbstractNodeModel && !(dataModel = (AbstractNodeModel)node.getUserObject()).isLoaded()) {
            dataModel.runAction();
        }
    }

    private void showPopup(MouseEvent mouseEvent) {
        AbstractNodeModel currentTableModel;
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        JTree tree = (JTree)mouseEvent.getSource();
        TreePath path = tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode currentTableNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (currentTableNode.getUserObject() instanceof AbstractNodeModel && (currentTableModel = (AbstractNodeModel)currentTableNode.getUserObject()).isPopupDisplayable()) {
            currentTableModel.showPopup(currentTableNode, path, mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.showPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.showPopup(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

