/*
 *  Copyright (C) 2005-2024 Team Kodi
 *  This file is part of Kodi - https://kodi.tv
 *
 *  SPDX-License-Identifier: GPL-2.0-or-later
 *  See LICENSES/README.md for more information.
 */

#include "InputCodingTableBasePY.h"

#include "ServiceBroker.h"
#include "guilib/GUIComponent.h"
#include "guilib/GUIMessage.h"
#include "guilib/GUIWindowManager.h"
#include "utils/CharsetConverter.h"

#include <stdlib.h>

static std::map<std::string, std::wstring> codemap = {
    {"a", // L"啊阿吖嗄腌锕"
     {0x554a, 0x963f, 0x5416, 0x55c4, 0x814c, 0x9515}},
    {"ai", // L"爱矮挨哎碍癌艾唉哀蔼隘埃皑嗌嫒瑷暧捱砹嗳锿霭"
     {0x7231, 0x77ee, 0x6328, 0x54ce, 0x788d, 0x764c, 0x827e, 0x5509, 0x54c0, 0x853c, 0x9698,
      0x57c3, 0x7691, 0x55cc, 0x5ad2, 0x7477, 0x66a7, 0x6371, 0x7839, 0x55f3, 0x953f, 0x972d}},
    {"an", // L"按安暗岸俺案鞍氨胺庵揞犴铵桉谙鹌埯黯"
     {0x6309, 0x5b89, 0x6697, 0x5cb8, 0x4ffa, 0x6848, 0x978d, 0x6c28, 0x80fa, 0x5eb5, 0x63de,
      0x72b4, 0x94f5, 0x6849, 0x8c19, 0x9e4c, 0x57ef, 0x9eef}},
    {"ang", // L"昂肮盎"
     {0x6602, 0x80ae, 0x76ce}},
    {"ao", // L"袄凹傲奥熬懊敖翱澳拗媪廒骜嗷坳遨聱螯獒鏊鳌鏖岙"
     {0x8884, 0x51f9, 0x50b2, 0x5965, 0x71ac, 0x61ca, 0x6556, 0x7ff1,
      0x6fb3, 0x62d7, 0x5aaa, 0x5ed2, 0x9a9c, 0x55f7, 0x5773, 0x9068,
      0x8071, 0x87af, 0x7352, 0x93ca, 0x9ccc, 0x93d6, 0x5c99}},
    {"ba", // L"把八吧爸拔罢跋巴芭扒坝霸叭靶笆疤耙捌粑茇岜鲅钯魃菝灞"
     {0x628a, 0x516b, 0x5427, 0x7238, 0x62d4, 0x7f62, 0x8dcb, 0x5df4, 0x82ad,
      0x6252, 0x575d, 0x9738, 0x53ed, 0x9776, 0x7b06, 0x75a4, 0x8019, 0x634c,
      0x7c91, 0x8307, 0x5c9c, 0x9c85, 0x94af, 0x9b43, 0x83dd, 0x705e}},
    {"bai", // L"百白摆败柏拜佰伯稗捭掰"
     {0x767e, 0x767d, 0x6446, 0x8d25, 0x67cf, 0x62dc, 0x4f70, 0x4f2f, 0x7a17, 0x636d, 0x63b0}},
    {"ban", // L"半办班般拌搬版斑板伴扳扮瓣颁绊癍坂钣舨阪瘢"
     {0x534a, 0x529e, 0x73ed, 0x822c, 0x62cc, 0x642c, 0x7248, 0x6591, 0x677f, 0x4f34, 0x6273,
      0x626e, 0x74e3, 0x9881, 0x7eca, 0x764d, 0x5742, 0x94a3, 0x8228, 0x962a, 0x7622}},
    {"bang", // L"帮棒绑磅镑邦榜蚌傍梆膀谤浜蒡"
     {0x5e2e, 0x68d2, 0x7ed1, 0x78c5, 0x9551, 0x90a6, 0x699c, 0x868c, 0x508d, 0x6886, 0x8180,
      0x8c24, 0x6d5c, 0x84a1}},
    {"bao", // L"包抱报饱保暴薄宝爆剥豹刨雹褒堡苞胞鲍炮龅孢煲褓鸨趵葆勹"
     {0x5305, 0x62b1, 0x62a5, 0x9971, 0x4fdd, 0x66b4, 0x8584, 0x5b9d, 0x7206,
      0x5265, 0x8c79, 0x5228, 0x96f9, 0x8912, 0x5821, 0x82de, 0x80de, 0x9c8d,
      0x70ae, 0x9f85, 0x5b62, 0x7172, 0x8913, 0x9e28, 0x8db5, 0x8446, 0x52f9}},
    {"bei", //L"被北倍杯背悲备碑卑贝辈钡焙狈惫臂褙悖蓓鹎鐾呗邶鞴孛陂碚埤萆"
     {0x88ab, 0x5317, 0x500d, 0x676f, 0x80cc, 0x60b2, 0x5907, 0x7891, 0x5351, 0x8d1d,
      0x8f88, 0x94a1, 0x7119, 0x72c8, 0x60eb, 0x81c2, 0x8919, 0x6096, 0x84d3, 0x9e4e,
      0x943e, 0x5457, 0x90b6, 0x97b4, 0x5b5b, 0x9642, 0x789a, 0x57e4, 0x8406}},
    {"ben", //L"本奔苯笨锛贲畚坌"
     {0x672c, 0x5954, 0x82ef, 0x7b28, 0x951b, 0x8d32, 0x755a, 0x574c}},
    {"beng", //L"蹦绷甭崩迸蚌泵甏嘣堋"
     {0x8e66, 0x7ef7, 0x752d, 0x5d29, 0x8ff8, 0x868c, 0x6cf5, 0x750f, 0x5623, 0x580b}},
    {"bi", // L"比笔闭鼻碧必避逼毕臂彼鄙壁蓖币弊辟蔽毙庇敝陛毖痹秘泌秕薜荸芘萆匕裨畀俾嬖狴筚箅篦舭荜襞庳铋跸吡愎贲滗濞璧哔髀弼妣婢埤"
     {0x6bd4, 0x7b14, 0x95ed, 0x9f3b, 0x78a7, 0x5fc5, 0x907f, 0x903c, 0x6bd5, 0x81c2,
      0x5f7c, 0x9119, 0x58c1, 0x84d6, 0x5e01, 0x5f0a, 0x8f9f, 0x853d, 0x6bd9, 0x5e87,
      0x655d, 0x965b, 0x6bd6, 0x75f9, 0x79d8, 0x6ccc, 0x79d5, 0x859c, 0x8378, 0x8298,
      0x8406, 0x5315, 0x88e8, 0x7540, 0x4ffe, 0x5b16, 0x72f4, 0x7b5a, 0x7b85, 0x7be6,
      0x822d, 0x835c, 0x895e, 0x5eb3, 0x94cb, 0x8df8, 0x5421, 0x610e, 0x8d32, 0x6ed7,
      0x6fde, 0x74a7, 0x54d4, 0x9ac0, 0x5f3c, 0x59a3, 0x5a62, 0x57e4}},
    {"bian", // L"边变便遍编辩扁贬鞭卞辨辫忭砭匾汴碥蝙褊鳊笾苄窆弁缏煸"
     {0x8fb9, 0x53d8, 0x4fbf, 0x904d, 0x7f16, 0x8fa9, 0x6241, 0x8d2c, 0x97ad,
      0x535e, 0x8fa8, 0x8fab, 0x5fed, 0x782d, 0x533e, 0x6c74, 0x78a5, 0x8759,
      0x890a, 0x9cca, 0x7b3e, 0x82c4, 0x7a86, 0x5f01, 0x7f0f, 0x7178}},
    {"biao", // L"表标彪膘杓婊飑飙鳔瘭飚镳裱骠镖髟"
     {0x8868, 0x6807, 0x5f6a, 0x8198, 0x6753, 0x5a4a, 0x98d1, 0x98d9, 0x9cd4, 0x762d, 0x98da,
      0x9573, 0x88f1, 0x9aa0, 0x9556, 0x9adf}},
    {"bie", // L"别憋鳖瘪蹩"
     {0x522b, 0x618b, 0x9cd6, 0x762a, 0x8e69}},
    {"bin", // L"宾濒摈彬斌滨豳膑殡缤髌傧槟鬓镔玢"
     {0x5bbe, 0x6fd2, 0x6448, 0x5f6c, 0x658c, 0x6ee8, 0x8c73, 0x8191, 0x6ba1, 0x7f24, 0x9acc,
      0x50a7, 0x69df, 0x9b13, 0x9554, 0x73a2}},
    {"bing", // L"并病兵冰丙饼屏秉柄炳摒槟禀邴"
     {0x5e76, 0x75c5, 0x5175, 0x51b0, 0x4e19, 0x997c, 0x5c4f, 0x79c9, 0x67c4, 0x70b3, 0x6452,
      0x69df, 0x7980, 0x90b4}},
    {"bo", // L"拨波播泊博伯驳玻剥薄勃菠钵搏脖帛柏舶渤铂箔膊卜礴跛檗亳鹁踣啵蕃簸钹饽擘孛百趵"
     {0x62e8, 0x6ce2, 0x64ad, 0x6cca, 0x535a, 0x4f2f, 0x9a73, 0x73bb, 0x5265, 0x8584,
      0x52c3, 0x83e0, 0x94b5, 0x640f, 0x8116, 0x5e1b, 0x67cf, 0x8236, 0x6e24, 0x94c2,
      0x7b94, 0x818a, 0x535c, 0x7934, 0x8ddb, 0x6a97, 0x4eb3, 0x9e41, 0x8e23, 0x5575,
      0x8543, 0x7c38, 0x94b9, 0x997d, 0x64d8, 0x5b5b, 0x767e, 0x8db5}},
    {"bu", // L"不步补布部捕卜簿哺堡埠怖埔瓿逋晡钸钚醭卟"
     {0x4e0d, 0x6b65, 0x8865, 0x5e03, 0x90e8, 0x6355, 0x535c, 0x7c3f, 0x54fa, 0x5821,
      0x57e0, 0x6016, 0x57d4, 0x74ff, 0x900b, 0x6661, 0x94b8, 0x949a, 0x91ad, 0x535f}},
    {"ca", // L"擦礤嚓"
     {0x64e6, 0x7924, 0x5693}},
    {"cai", // L"才菜采材财裁猜踩睬蔡彩"
     {0x624d, 0x83dc, 0x91c7, 0x6750, 0x8d22, 0x88c1, 0x731c, 0x8e29, 0x776c, 0x8521, 0x5f69}},
    {"can", // L"蚕残掺参惨惭餐灿骖璨孱黪粲"
     {0x8695, 0x6b8b, 0x63ba, 0x53c2, 0x60e8, 0x60ed, 0x9910, 0x707f, 0x9a96, 0x74a8, 0x5b71,
      0x9eea, 0x7cb2}},
    {"cang", // L"藏仓沧舱苍伧"
     {0x85cf, 0x4ed3, 0x6ca7, 0x8231, 0x82cd, 0x4f27}},
    {"cao", // L"草操曹槽糙嘈艚螬漕艹"
     {0x8349, 0x64cd, 0x66f9, 0x69fd, 0x7cd9, 0x5608, 0x825a, 0x87ac, 0x6f15, 0x8279}},
    {"ce", // L"册侧策测厕恻"
     {0x518c, 0x4fa7, 0x7b56, 0x6d4b, 0x5395, 0x607b}},
    {"cen", // L"参岑涔"
     {0x53c2, 0x5c91, 0x6d94}},
    {"ceng", // L"曾层蹭噌"
     {0x66fe, 0x5c42, 0x8e6d, 0x564c}},
    {"cha", // L"查插叉茶差岔搽察茬碴刹诧楂槎镲衩汊馇檫姹杈锸嚓猹"
     {0x67e5, 0x63d2, 0x53c9, 0x8336, 0x5dee, 0x5c94, 0x643d, 0x5bdf,
      0x832c, 0x78b4, 0x5239, 0x8be7, 0x6942, 0x69ce, 0x9572, 0x8869,
      0x6c4a, 0x9987, 0x6aab, 0x59f9, 0x6748, 0x9538, 0x5693, 0x7339}},
    {"chai", // L"柴拆差豺钗瘥虿侪龇"
     {0x67f4, 0x62c6, 0x5dee, 0x8c7a, 0x9497, 0x7625, 0x867f, 0x4faa, 0x9f87}},
    {"chan", // L"产缠掺搀阐颤铲谗蝉单馋觇婵蒇谄冁廛孱蟾羼镡忏潺禅躔澶"
     {0x4ea7, 0x7f20, 0x63ba, 0x6400, 0x9610, 0x98a4, 0x94f2, 0x8c17, 0x8749,
      0x5355, 0x998b, 0x89c7, 0x5a75, 0x8487, 0x8c04, 0x5181, 0x5edb, 0x5b71,
      0x87fe, 0x7fbc, 0x9561, 0x5fcf, 0x6f7a, 0x7985, 0x8e94, 0x6fb6}},
    {"chang", // L"长唱常场厂尝肠畅昌敞倡偿猖鲳氅菖惝嫦徜鬯阊怅伥昶苌娼"
     {0x957f, 0x5531, 0x5e38, 0x573a, 0x5382, 0x5c1d, 0x80a0, 0x7545, 0x660c,
      0x655e, 0x5021, 0x507f, 0x7316, 0x9cb3, 0x6c05, 0x83d6, 0x60dd, 0x5ae6,
      0x5f9c, 0x9b2f, 0x960a, 0x6005, 0x4f25, 0x6636, 0x82cc, 0x5a3c}},
    {"chao", // L"朝抄超吵潮巢炒嘲剿绰钞怊耖晁"
     {0x671d, 0x6284, 0x8d85, 0x5435, 0x6f6e, 0x5de2, 0x7092, 0x5632, 0x527f, 0x7ef0, 0x949e,
      0x600a, 0x8016, 0x6641}},
    {"che", // L"车撤扯掣彻澈坼砗屮"
     {0x8f66, 0x64a4, 0x626f, 0x63a3, 0x5f7b, 0x6f88, 0x577c, 0x7817, 0x5c6e}},
    {"chen", // L"趁称辰臣尘晨沉陈衬忱郴榇抻谌碜谶宸龀嗔琛"
     {0x8d81, 0x79f0, 0x8fb0, 0x81e3, 0x5c18, 0x6668, 0x6c89, 0x9648, 0x886c, 0x5ff1,
      0x90f4, 0x6987, 0x62bb, 0x8c0c, 0x789c, 0x8c36, 0x5bb8, 0x9f80, 0x55d4, 0x741b}},
    {"cheng", // L"成乘盛撑称城程呈诚秤惩逞骋澄橙承塍柽埕铖噌铛酲裎枨蛏丞瞠徵"
     {0x6210, 0x4e58, 0x76db, 0x6491, 0x79f0, 0x57ce, 0x7a0b, 0x5448, 0x8bda, 0x79e4,
      0x60e9, 0x901e, 0x9a8b, 0x6f84, 0x6a59, 0x627f, 0x584d, 0x67fd, 0x57d5, 0x94d6,
      0x564c, 0x94db, 0x9172, 0x88ce, 0x67a8, 0x86cf, 0x4e1e, 0x77a0, 0x5fb5}},
    {"chi", // L"吃尺迟池翅痴赤齿耻持斥侈弛驰炽匙踟坻茌墀饬媸豉褫敕哧瘛蚩啻鸱眵螭篪魑叱彳笞嗤傺"
     {0x5403, 0x5c3a, 0x8fdf, 0x6c60, 0x7fc5, 0x75f4, 0x8d64, 0x9f7f, 0x803b, 0x6301,
      0x65a5, 0x4f88, 0x5f1b, 0x9a70, 0x70bd, 0x5319, 0x8e1f, 0x577b, 0x830c, 0x5880,
      0x996c, 0x5ab8, 0x8c49, 0x892b, 0x6555, 0x54e7, 0x761b, 0x86a9, 0x557b, 0x9e31,
      0x7735, 0x87ad, 0x7bea, 0x9b51, 0x53f1, 0x5f73, 0x7b1e, 0x55e4, 0x50ba}},
    {"chong", // L"冲重虫充宠崇种艟忡舂铳憧茺"
     {0x51b2, 0x91cd, 0x866b, 0x5145, 0x5ba0, 0x5d07, 0x79cd, 0x825f, 0x5fe1, 0x8202, 0x94f3,
      0x61a7, 0x833a}},
    {"chou", // L"抽愁臭仇丑稠绸酬筹踌畴瞅惆俦帱瘳雠"
     {0x62bd, 0x6101, 0x81ed, 0x4ec7, 0x4e11, 0x7a20, 0x7ef8, 0x916c, 0x7b79, 0x8e0c, 0x7574,
      0x7785, 0x60c6, 0x4fe6, 0x5e31, 0x7633, 0x96e0}},
    {"chu", // L"出处初锄除触橱楚础储畜滁矗搐躇厨雏楮杵刍怵绌亍憷蹰黜蜍樗褚"
     {0x51fa, 0x5904, 0x521d, 0x9504, 0x9664, 0x89e6, 0x6a71, 0x695a, 0x7840, 0x50a8,
      0x755c, 0x6ec1, 0x77d7, 0x6410, 0x8e87, 0x53a8, 0x96cf, 0x696e, 0x6775, 0x520d,
      0x6035, 0x7ecc, 0x4e8d, 0x61b7, 0x8e70, 0x9edc, 0x870d, 0x6a17, 0x891a}},
    {"chuai", // L"揣膪嘬搋踹"
     {0x63e3, 0x81aa, 0x562c, 0x640b, 0x8e39}},
    {"chuan", // L"穿船传串川喘椽氚遄钏舡舛巛"
     {0x7a7f, 0x8239, 0x4f20, 0x4e32, 0x5ddd, 0x5598, 0x693d, 0x6c1a, 0x9044, 0x948f, 0x8221,
      0x821b, 0x5ddb}},
    {"chuang", // L"窗床闯创疮幢怆"
     {0x7a97, 0x5e8a, 0x95ef, 0x521b, 0x75ae, 0x5e62, 0x6006}},
    {"chui", // L"吹垂炊锤捶槌棰陲"
     {0x5439, 0x5782, 0x708a, 0x9524, 0x6376, 0x69cc, 0x68f0, 0x9672}},
    {"chun", // L"春唇纯蠢醇淳椿蝽莼鹑"
     {0x6625, 0x5507, 0x7eaf, 0x8822, 0x9187, 0x6df3, 0x693f, 0x877d, 0x83bc, 0x9e51}},
    {"chuo", // L"戳绰踔啜龊辍辶"
     {0x6233, 0x7ef0, 0x8e14, 0x555c, 0x9f8a, 0x8f8d, 0x8fb6}},
    {"ci", // L"次此词瓷慈雌磁辞刺茨伺疵赐差兹呲鹚祠糍粢茈"
     {0x6b21, 0x6b64, 0x8bcd, 0x74f7, 0x6148, 0x96cc, 0x78c1, 0x8f9e, 0x523a, 0x8328, 0x4f3a,
      0x75b5, 0x8d50, 0x5dee, 0x5179, 0x5472, 0x9e5a, 0x7960, 0x7ccd, 0x7ca2, 0x8308}},
    {"cong", // L"从丛葱匆聪囱琮枞淙璁骢苁"
     {0x4ece, 0x4e1b, 0x8471, 0x5306, 0x806a, 0x56f1, 0x742e, 0x679e, 0x6dd9, 0x7481, 0x9aa2,
      0x82c1}},
    {"cou", // L"凑楱辏腠"
     {0x51d1, 0x6971, 0x8f8f, 0x8160}},
    {"cu", // L"粗醋簇促徂猝蔟蹙酢殂蹴"
     {0x7c97, 0x918b, 0x7c07, 0x4fc3, 0x5f82, 0x731d, 0x851f, 0x8e59, 0x9162, 0x6b82, 0x8e74}},
    {"cuan", // L"窜蹿篡攒汆爨镩撺"
     {0x7a9c, 0x8e7f, 0x7be1, 0x6512, 0x6c46, 0x7228, 0x9569, 0x64ba}},
    {"cui", // L"催脆摧翠崔淬瘁粹璀啐悴萃毳榱隹"
     {0x50ac, 0x8106, 0x6467, 0x7fe0, 0x5d14, 0x6dec, 0x7601, 0x7cb9, 0x7480, 0x5550, 0x60b4,
      0x8403, 0x6bf3, 0x69b1, 0x96b9}},
    {"cun", // L"村寸存忖皴"
     {0x6751, 0x5bf8, 0x5b58, 0x5fd6, 0x76b4}},
    {"cuo", // L"错撮搓挫措磋嵯厝鹾脞痤蹉瘥锉矬躜"
     {0x9519, 0x64ae, 0x6413, 0x632b, 0x63aa, 0x78cb, 0x5d6f, 0x539d, 0x9e7e, 0x811e, 0x75e4,
      0x8e49, 0x7625, 0x9509, 0x77ec, 0x8e9c}},
    {"da", // L"大答达打搭瘩笪耷哒褡疸怛靼妲沓嗒鞑"
     {0x5927, 0x7b54, 0x8fbe, 0x6253, 0x642d, 0x7629, 0x7b2a, 0x8037, 0x54d2, 0x8921, 0x75b8,
      0x601b, 0x977c, 0x59b2, 0x6c93, 0x55d2, 0x9791}},
    {"dai", // L"带代呆戴待袋逮歹贷怠傣大殆呔玳迨岱甙黛骀绐埭"
     {0x5e26, 0x4ee3, 0x5446, 0x6234, 0x5f85, 0x888b, 0x902e, 0x6b79, 0x8d37, 0x6020, 0x50a3,
      0x5927, 0x6b86, 0x5454, 0x73b3, 0x8fe8, 0x5cb1, 0x7519, 0x9edb, 0x9a80, 0x7ed0, 0x57ed}},
    {"dan", // L"但单蛋担弹掸胆淡丹耽旦氮诞郸惮石疸澹瘅萏殚眈聃箪赕儋啖赡"
     {0x4f46, 0x5355, 0x86cb, 0x62c5, 0x5f39, 0x63b8, 0x80c6, 0x6de1, 0x4e39, 0x803d,
      0x65e6, 0x6c2e, 0x8bde, 0x90f8, 0x60ee, 0x77f3, 0x75b8, 0x6fb9, 0x7605, 0x840f,
      0x6b9a, 0x7708, 0x8043, 0x7baa, 0x8d55, 0x510b, 0x5556, 0x8d61}},
    {"dang", // L"当党挡档荡谠铛宕菪凼裆砀"
     {0x5f53, 0x515a, 0x6321, 0x6863, 0x8361, 0x8c20, 0x94db, 0x5b95, 0x83ea, 0x51fc, 0x88c6,
      0x7800}},
    {"dao", // L"到道倒刀岛盗稻捣悼导蹈祷帱纛忉焘氘叨刂"
     {0x5230, 0x9053, 0x5012, 0x5200, 0x5c9b, 0x76d7, 0x7a3b, 0x6363, 0x60bc, 0x5bfc, 0x8e48,
      0x7977, 0x5e31, 0x7e9b, 0x5fc9, 0x7118, 0x6c18, 0x53e8, 0x5202}},
    {"de", // L"的地得德锝"
     {0x7684, 0x5730, 0x5f97, 0x5fb7, 0x951d}},
    {"dei", // L"得"
     {0x5f97}},
    {"deng", // L"等灯邓登澄瞪凳蹬磴镫噔嶝戥簦"
     {0x7b49, 0x706f, 0x9093, 0x767b, 0x6f84, 0x77aa, 0x51f3, 0x8e6c, 0x78f4, 0x956b, 0x5654,
      0x5d9d, 0x6225, 0x7c26}},
    {"di", // L"地第底低敌抵滴帝递嫡弟缔堤的涤提笛迪狄翟蒂觌邸谛诋嘀柢骶羝氐棣睇娣荻碲镝坻籴砥"
     {0x5730, 0x7b2c, 0x5e95, 0x4f4e, 0x654c, 0x62b5, 0x6ef4, 0x5e1d, 0x9012, 0x5ae1,
      0x5f1f, 0x7f14, 0x5824, 0x7684, 0x6da4, 0x63d0, 0x7b1b, 0x8fea, 0x72c4, 0x7fdf,
      0x8482, 0x89cc, 0x90b8, 0x8c1b, 0x8bcb, 0x5600, 0x67e2, 0x9ab6, 0x7f9d, 0x6c10,
      0x68e3, 0x7747, 0x5a23, 0x837b, 0x78b2, 0x955d, 0x577b, 0x7c74, 0x7825}},
    {"dia", // L"嗲"
     {0x55f2}},
    {"dian", // L"点电店殿淀掂颠垫碘惦奠典佃靛滇甸踮钿坫阽癫簟玷巅癜"
     {0x70b9, 0x7535, 0x5e97, 0x6bbf, 0x6dc0, 0x6382, 0x98a0, 0x57ab, 0x7898,
      0x60e6, 0x5960, 0x5178, 0x4f43, 0x975b, 0x6ec7, 0x7538, 0x8e2e, 0x94bf,
      0x576b, 0x963d, 0x766b, 0x7c1f, 0x73b7, 0x5dc5, 0x765c}},
    {"diao", // L"掉钓叼吊雕调刁碉凋铞铫鲷貂"
     {0x6389, 0x9493, 0x53fc, 0x540a, 0x96d5, 0x8c03, 0x5201, 0x7889, 0x51cb, 0x94de, 0x94eb,
      0x9cb7, 0x8c82}},
    {"die", // L"爹跌叠碟蝶迭谍牒堞瓞揲蹀耋鲽垤喋"
     {0x7239, 0x8dcc, 0x53e0, 0x789f, 0x8776, 0x8fed, 0x8c0d, 0x7252, 0x581e, 0x74de, 0x63f2,
      0x8e40, 0x800b, 0x9cbd, 0x57a4, 0x558b}},
    {"ding", // L"顶定盯订叮丁钉鼎锭町玎铤腚碇疔仃耵酊啶"
     {0x9876, 0x5b9a, 0x76ef, 0x8ba2, 0x53ee, 0x4e01, 0x9489, 0x9f0e, 0x952d, 0x753a, 0x738e,
      0x94e4, 0x815a, 0x7887, 0x7594, 0x4ec3, 0x8035, 0x914a, 0x5576}},
    {"diu", // L"丢铥"
     {0x4e22, 0x94e5}},
    {"dong", // L"动东懂洞冻冬董栋侗恫峒鸫胨胴硐氡岽咚"
     {0x52a8, 0x4e1c, 0x61c2, 0x6d1e, 0x51bb, 0x51ac, 0x8463, 0x680b, 0x4f97, 0x606b, 0x5cd2,
      0x9e2b, 0x80e8, 0x80f4, 0x7850, 0x6c21, 0x5cbd, 0x549a}},
    {"dou", // L"都斗豆逗陡抖痘兜蚪窦篼蔸"
     {0x90fd, 0x6597, 0x8c46, 0x9017, 0x9661, 0x6296, 0x75d8, 0x515c, 0x86aa, 0x7aa6, 0x7bfc,
      0x8538}},
    {"du", // L"读度毒渡堵独肚镀赌睹杜督都犊妒蠹笃嘟渎椟牍黩髑芏"
     {0x8bfb, 0x5ea6, 0x6bd2, 0x6e21, 0x5835, 0x72ec, 0x809a, 0x9540,
      0x8d4c, 0x7779, 0x675c, 0x7763, 0x90fd, 0x728a, 0x5992, 0x8839,
      0x7b03, 0x561f, 0x6e0e, 0x691f, 0x724d, 0x9ee9, 0x9ad1, 0x828f}},
    {"duan", // L"段短断端锻缎椴煅簖"
     {0x6bb5, 0x77ed, 0x65ad, 0x7aef, 0x953b, 0x7f0e, 0x6934, 0x7145, 0x7c16}},
    {"dui", // L"对队堆兑碓怼憝"
     {0x5bf9, 0x961f, 0x5806, 0x5151, 0x7893, 0x603c, 0x619d}},
    {"dun", // L"吨顿蹲墩敦钝盾囤遁趸沌盹镦礅炖砘"
     {0x5428, 0x987f, 0x8e72, 0x58a9, 0x6566, 0x949d, 0x76fe, 0x56e4, 0x9041, 0x8db8, 0x6c8c,
      0x76f9, 0x9566, 0x7905, 0x7096, 0x7818}},
    {"duo", // L"多朵夺舵剁垛跺惰堕掇哆驮度躲踱沲咄铎裰哚缍"
     {0x591a, 0x6735, 0x593a, 0x8235, 0x5241, 0x579b, 0x8dfa, 0x60f0, 0x5815, 0x6387, 0x54c6,
      0x9a6e, 0x5ea6, 0x8eb2, 0x8e31, 0x6cb2, 0x5484, 0x94ce, 0x88f0, 0x54da, 0x7f0d}},
    {"e", // L"饿哦额鹅蛾扼俄讹阿遏峨娥恶厄鄂锇谔垩锷萼苊轭婀莪鳄颚腭愕呃噩鹗屙"
     {0x997f, 0x54e6, 0x989d, 0x9e45, 0x86fe, 0x627c, 0x4fc4, 0x8bb9, 0x963f, 0x904f, 0x5ce8,
      0x5a25, 0x6076, 0x5384, 0x9102, 0x9507, 0x8c14, 0x57a9, 0x9537, 0x843c, 0x82ca, 0x8f6d,
      0x5a40, 0x83aa, 0x9cc4, 0x989a, 0x816d, 0x6115, 0x5443, 0x5669, 0x9e57, 0x5c59}},
    {"ei", // L"诶"
     {0x8bf6}},
    {"en", // L"恩摁蒽嗯"
     {0x6069, 0x6441, 0x84bd, 0x55ef}},
    {"er", // L"而二耳儿饵尔贰洱珥鲕鸸迩铒"
     {0x800c, 0x4e8c, 0x8033, 0x513f, 0x9975, 0x5c14, 0x8d30, 0x6d31, 0x73e5, 0x9c95, 0x9e38,
      0x8fe9, 0x94d2}},
    {"fa", // L"发法罚伐乏筏阀珐垡砝"
     {0x53d1, 0x6cd5, 0x7f5a, 0x4f10, 0x4e4f, 0x7b4f, 0x9600, 0x73d0, 0x57a1, 0x781d}},
    {"fan", // L"反饭翻番犯凡帆返泛繁烦贩范樊藩矾钒燔蘩畈蕃蹯梵幡"
     {0x53cd, 0x996d, 0x7ffb, 0x756a, 0x72af, 0x51e1, 0x5e06, 0x8fd4,
      0x6cdb, 0x7e41, 0x70e6, 0x8d29, 0x8303, 0x6a0a, 0x85e9, 0x77fe,
      0x9492, 0x71d4, 0x8629, 0x7548, 0x8543, 0x8e6f, 0x68b5, 0x5e61}},
    {"fang", // L"放房防纺芳方访仿坊妨肪钫邡枋舫鲂匚"
     {0x653e, 0x623f, 0x9632, 0x7eba, 0x82b3, 0x65b9, 0x8bbf, 0x4eff, 0x574a, 0x59a8, 0x80aa,
      0x94ab, 0x90a1, 0x678b, 0x822b, 0x9c82, 0x531a}},
    {"fei", // L"非飞肥费肺废匪吠沸菲诽啡篚蜚腓扉妃斐狒芾悱镄霏翡榧淝鲱绯痱砩"
     {0x975e, 0x98de, 0x80a5, 0x8d39, 0x80ba, 0x5e9f, 0x532a, 0x5420, 0x6cb8, 0x83f2,
      0x8bfd, 0x5561, 0x7bda, 0x871a, 0x8153, 0x6249, 0x5983, 0x6590, 0x72d2, 0x82be,
      0x60b1, 0x9544, 0x970f, 0x7fe1, 0x69a7, 0x6ddd, 0x9cb1, 0x7eef, 0x75f1, 0x7829}},
    {"fen", // L"分份芬粉坟奋愤纷忿粪酚焚吩氛汾棼瀵鲼玢偾鼢贲"
     {0x5206, 0x4efd, 0x82ac, 0x7c89, 0x575f, 0x594b, 0x6124, 0x7eb7, 0x5fff, 0x7caa, 0x915a,
      0x711a, 0x5429, 0x6c1b, 0x6c7e, 0x68fc, 0x7035, 0x9cbc, 0x73a2, 0x507e, 0x9f22, 0x8d32}},
    {"feng", // L"风封逢缝蜂丰枫疯冯奉讽凤峰锋烽砜俸酆葑沣唪"
     {0x98ce, 0x5c01, 0x9022, 0x7f1d, 0x8702, 0x4e30, 0x67ab, 0x75af, 0x51af, 0x5949, 0x8bbd,
      0x51e4, 0x5cf0, 0x950b, 0x70fd, 0x781c, 0x4ff8, 0x9146, 0x8451, 0x6ca3, 0x552a}},
    {"fo", // L"佛"
     {0x4f5b}},
    {"fou", // L"否缶"
     {0x5426, 0x7f36}},
    {"fu", // L"副幅扶浮富福负伏付复服附俯斧赴缚拂夫父符孵敷赋辅府腐腹妇抚覆辐肤氟佛俘傅讣弗涪袱甫釜脯腑阜咐黼砩苻趺跗蚨芾鲋幞茯滏蜉拊菔蝠鳆蝮绂绋赙罘稃匐麸凫桴莩孚馥驸怫祓呋郛芙艴黻哺阝"
     {0x526f, 0x5e45, 0x6276, 0x6d6e, 0x5bcc, 0x798f, 0x8d1f, 0x4f0f, 0x4ed8, 0x590d, 0x670d,
      0x9644, 0x4fef, 0x65a7, 0x8d74, 0x7f1a, 0x62c2, 0x592b, 0x7236, 0x7b26, 0x5b75, 0x6577,
      0x8d4b, 0x8f85, 0x5e9c, 0x8150, 0x8179, 0x5987, 0x629a, 0x8986, 0x8f90, 0x80a4, 0x6c1f,
      0x4f5b, 0x4fd8, 0x5085, 0x8ba3, 0x5f17, 0x6daa, 0x88b1, 0x752b, 0x91dc, 0x812f, 0x8151,
      0x961c, 0x5490, 0x9efc, 0x7829, 0x82fb, 0x8dba, 0x8dd7, 0x86a8, 0x82be, 0x9c8b, 0x5e5e,
      0x832f, 0x6ecf, 0x8709, 0x62ca, 0x83d4, 0x8760, 0x9cc6, 0x876e, 0x7ec2, 0x7ecb, 0x8d59,
      0x7f58, 0x7a03, 0x5310, 0x9eb8, 0x51eb, 0x6874, 0x83a9, 0x5b5a, 0x99a5, 0x9a78, 0x602b,
      0x7953, 0x544b, 0x90db, 0x8299, 0x8274, 0x9efb, 0x54fa, 0x961d}},
    {"ga", // L"噶夹嘎咖钆伽旮尬尕尜"
     {0x5676, 0x5939, 0x560e, 0x5496, 0x9486, 0x4f3d, 0x65ee, 0x5c2c, 0x5c15, 0x5c1c}},
    {"gai", // L"该改盖概钙芥溉戤垓丐陔赅胲"
     {0x8be5, 0x6539, 0x76d6, 0x6982, 0x9499, 0x82a5, 0x6e89, 0x6224, 0x5793, 0x4e10, 0x9654,
      0x8d45, 0x80f2}},
    {"gan", // L"赶干感敢竿甘肝柑杆赣秆旰酐矸疳泔苷擀绀橄澉淦尴坩"
     {0x8d76, 0x5e72, 0x611f, 0x6562, 0x7aff, 0x7518, 0x809d, 0x67d1,
      0x6746, 0x8d63, 0x79c6, 0x65f0, 0x9150, 0x77f8, 0x75b3, 0x6cd4,
      0x82f7, 0x64c0, 0x7ec0, 0x6a44, 0x6f89, 0x6de6, 0x5c34, 0x5769}},
    {"gang", // L"刚钢纲港缸岗杠冈肛扛筻罡戆"
     {0x521a, 0x94a2, 0x7eb2, 0x6e2f, 0x7f38, 0x5c97, 0x6760, 0x5188, 0x809b, 0x625b, 0x7b7b,
      0x7f61, 0x6206}},
    {"gao", // L"高搞告稿膏篙羔糕镐皋郜诰杲缟睾槔锆槁藁"
     {0x9ad8, 0x641e, 0x544a, 0x7a3f, 0x818f, 0x7bd9, 0x7f94, 0x7cd5, 0x9550, 0x768b, 0x90dc,
      0x8bf0, 0x6772, 0x7f1f, 0x777e, 0x69d4, 0x9506, 0x69c1, 0x85c1}},
    {"ge", // L"个各歌割哥搁格阁隔革咯胳葛蛤戈鸽疙盖合铬骼袼塥虼圪镉仡舸鬲嗝膈搿纥哿铪"
     {0x4e2a, 0x5404, 0x6b4c, 0x5272, 0x54e5, 0x6401, 0x683c, 0x9601, 0x9694,
      0x9769, 0x54af, 0x80f3, 0x845b, 0x86e4, 0x6208, 0x9e3d, 0x7599, 0x76d6,
      0x5408, 0x94ec, 0x9abc, 0x88bc, 0x5865, 0x867c, 0x572a, 0x9549, 0x4ee1,
      0x8238, 0x9b32, 0x55dd, 0x8188, 0x643f, 0x7ea5, 0x54ff, 0x94ea}},
    {"gei", // L"给"
     {0x7ed9}},
    {"gen", // L"跟根哏茛亘艮"
     {0x8ddf, 0x6839, 0x54cf, 0x831b, 0x4e98, 0x826e}},
    {"geng", // L"更耕颈梗耿庚羹埂赓鲠哽绠"
     {0x66f4, 0x8015, 0x9888, 0x6897, 0x803f, 0x5e9a, 0x7fb9, 0x57c2, 0x8d53, 0x9ca0, 0x54fd,
      0x7ee0}},
    {"gong", // L"工公功共弓攻宫供恭拱贡躬巩汞龚肱觥珙蚣廾"
     {0x5de5, 0x516c, 0x529f, 0x5171, 0x5f13, 0x653b, 0x5bab, 0x4f9b, 0x606d, 0x62f1,
      0x8d21, 0x8eac, 0x5de9, 0x6c5e, 0x9f9a, 0x80b1, 0x89e5, 0x73d9, 0x86a3, 0x5efe}},
    {"gou", // L"够沟狗钩勾购构苟垢岣彀枸鞲觏缑笱诟遘媾篝佝"
     {0x591f, 0x6c9f, 0x72d7, 0x94a9, 0x52fe, 0x8d2d, 0x6784, 0x82df, 0x57a2, 0x5ca3, 0x5f40,
      0x67b8, 0x97b2, 0x89cf, 0x7f11, 0x7b31, 0x8bdf, 0x9058, 0x5abe, 0x7bdd, 0x4f5d}},
    {"gu", // L"古股鼓谷故孤箍姑顾固雇估咕骨辜沽蛊贾菇梏鸪汩轱崮菰鹄鹘钴臌酤鲴诂牯瞽毂锢牿痼觚蛄罟嘏"
     {0x53e4, 0x80a1, 0x9f13, 0x8c37, 0x6545, 0x5b64, 0x7b8d, 0x59d1, 0x987e, 0x56fa, 0x96c7,
      0x4f30, 0x5495, 0x9aa8, 0x8f9c, 0x6cbd, 0x86ca, 0x8d3e, 0x83c7, 0x688f, 0x9e2a, 0x6c69,
      0x8f71, 0x5d2e, 0x83f0, 0x9e44, 0x9e58, 0x94b4, 0x81cc, 0x9164, 0x9cb4, 0x8bc2, 0x726f,
      0x77bd, 0x6bc2, 0x9522, 0x727f, 0x75fc, 0x89da, 0x86c4, 0x7f5f, 0x560f}},
    {"gua", // L"挂刮瓜寡剐褂卦呱胍鸹栝诖"
     {0x6302, 0x522e, 0x74dc, 0x5be1, 0x5250, 0x8902, 0x5366, 0x5471, 0x80cd, 0x9e39, 0x681d,
      0x8bd6}},
    {"guai", // L"怪拐乖掴"
     {0x602a, 0x62d0, 0x4e56, 0x63b4}},
    {"guan", // L"关管官观馆惯罐灌冠贯棺纶盥莞掼涫鳏鹳倌"
     {0x5173, 0x7ba1, 0x5b98, 0x89c2, 0x9986, 0x60ef, 0x7f50, 0x704c, 0x51a0, 0x8d2f, 0x68fa,
      0x7eb6, 0x76e5, 0x839e, 0x63bc, 0x6dab, 0x9ccf, 0x9e73, 0x500c}},
    {"guang", // L"光广逛桄犷咣胱"
     {0x5149, 0x5e7f, 0x901b, 0x6844, 0x72b7, 0x54a3, 0x80f1}},
    {"gui", // L"归贵鬼跪轨规硅桂柜龟诡闺瑰圭刽癸炔庋宄桧刿鳜鲑皈匦妫晷簋炅"
     {0x5f52, 0x8d35, 0x9b3c, 0x8dea, 0x8f68, 0x89c4, 0x7845, 0x6842, 0x67dc, 0x9f9f,
      0x8be1, 0x95fa, 0x7470, 0x572d, 0x523d, 0x7678, 0x7094, 0x5e8b, 0x5b84, 0x6867,
      0x523f, 0x9cdc, 0x9c91, 0x7688, 0x5326, 0x59ab, 0x6677, 0x7c0b, 0x7085}},
    {"gun", // L"滚棍辊鲧衮磙绲"
     {0x6eda, 0x68cd, 0x8f8a, 0x9ca7, 0x886e, 0x78d9, 0x7ef2}},
    {"guo", // L"过国果裹锅郭涡埚椁聒馘猓崞掴帼呙虢蜾蝈锞"
     {0x8fc7, 0x56fd, 0x679c, 0x88f9, 0x9505, 0x90ed, 0x6da1, 0x57da, 0x6901, 0x8052,
      0x9998, 0x7313, 0x5d1e, 0x63b4, 0x5e3c, 0x5459, 0x8662, 0x873e, 0x8748, 0x951e}},
    {"ha", // L"哈蛤铪"
     {0x54c8, 0x86e4, 0x94ea}},
    {"hai", // L"还海害咳氦孩骇咳骸亥嗨醢胲"
     {0x8fd8, 0x6d77, 0x5bb3, 0x54b3, 0x6c26, 0x5b69, 0x9a87, 0x54b3, 0x9ab8, 0x4ea5, 0x55e8,
      0x91a2, 0x80f2}},
    {"han", // L"喊含汗寒汉旱酣韩焊涵函憨翰罕撼捍憾悍邯邗菡撖瀚顸蚶焓颔晗鼾"
     {0x558a, 0x542b, 0x6c57, 0x5bd2, 0x6c49, 0x65f1, 0x9163, 0x97e9, 0x710a, 0x6db5,
      0x51fd, 0x61a8, 0x7ff0, 0x7f55, 0x64bc, 0x634d, 0x61be, 0x608d, 0x90af, 0x9097,
      0x83e1, 0x6496, 0x701a, 0x9878, 0x86b6, 0x7113, 0x9894, 0x6657, 0x9f3e}},
    {"hang", // L"行巷航夯杭吭颃沆绗"
     {0x884c, 0x5df7, 0x822a, 0x592f, 0x676d, 0x542d, 0x9883, 0x6c86, 0x7ed7}},
    {"hao", // L"好号浩嚎壕郝毫豪耗貉镐昊颢灏嚆蚝嗥皓蒿濠薅"
     {0x597d, 0x53f7, 0x6d69, 0x568e, 0x58d5, 0x90dd, 0x6beb, 0x8c6a, 0x8017, 0x8c89, 0x9550,
      0x660a, 0x98a2, 0x704f, 0x5686, 0x869d, 0x55e5, 0x7693, 0x84bf, 0x6fe0, 0x8585}},
    {"he", // L"和喝合河禾核何呵荷贺赫褐盒鹤菏貉阂涸吓嗬劾盍翮阖颌壑诃纥曷蚵"
     {0x548c, 0x559d, 0x5408, 0x6cb3, 0x79be, 0x6838, 0x4f55, 0x5475, 0x8377, 0x8d3a,
      0x8d6b, 0x8910, 0x76d2, 0x9e64, 0x83cf, 0x8c89, 0x9602, 0x6db8, 0x5413, 0x55ec,
      0x52be, 0x76cd, 0x7fee, 0x9616, 0x988c, 0x58d1, 0x8bc3, 0x7ea5, 0x66f7, 0x86b5}},
    {"hei", // L"黑嘿"
     {0x9ed1, 0x563f}},
    {"hen", // L"很狠恨痕"
     {0x5f88, 0x72e0, 0x6068, 0x75d5}},
    {"heng", // L"横恒哼衡亨桁珩蘅"
     {0x6a2a, 0x6052, 0x54fc, 0x8861, 0x4ea8, 0x6841, 0x73e9, 0x8605}},
    {"hong", // L"红轰哄虹洪宏烘鸿弘讧訇蕻闳薨黉荭泓"
     {0x7ea2, 0x8f70, 0x54c4, 0x8679, 0x6d2a, 0x5b8f, 0x70d8, 0x9e3f, 0x5f18, 0x8ba7, 0x8a07,
      0x857b, 0x95f3, 0x85a8, 0x9ec9, 0x836d, 0x6cd3}},
    {"hou", // L"后厚吼喉侯候猴鲎篌堠後逅糇骺瘊"
     {0x540e, 0x539a, 0x543c, 0x5589, 0x4faf, 0x5019, 0x7334, 0x9c8e, 0x7bcc, 0x5820, 0x5f8c,
      0x9005, 0x7cc7, 0x9aba, 0x760a}},
    {"hu", // L"湖户呼虎壶互胡护糊弧忽狐蝴葫沪乎核瑚唬鹕冱怙鹱笏戽扈鹘浒祜醐琥囫烀轷瓠煳斛鹄猢惚岵滹觳唿槲虍"
     {0x6e56, 0x6237, 0x547c, 0x864e, 0x58f6, 0x4e92, 0x80e1, 0x62a4, 0x7cca, 0x5f27,
      0x5ffd, 0x72d0, 0x8774, 0x846b, 0x6caa, 0x4e4e, 0x6838, 0x745a, 0x552c, 0x9e55,
      0x51b1, 0x6019, 0x9e71, 0x7b0f, 0x623d, 0x6248, 0x9e58, 0x6d52, 0x795c, 0x9190,
      0x7425, 0x56eb, 0x70c0, 0x8f77, 0x74e0, 0x7173, 0x659b, 0x9e44, 0x7322, 0x60da,
      0x5cb5, 0x6ef9, 0x89f3, 0x553f, 0x69f2, 0x864d}},
    {"hua", // L"话花化画华划滑哗猾铧桦骅砉"
     {0x8bdd, 0x82b1, 0x5316, 0x753b, 0x534e, 0x5212, 0x6ed1, 0x54d7, 0x733e, 0x94e7, 0x6866,
      0x9a85, 0x7809}},
    {"huai", // L"坏怀淮槐徊踝"
     {0x574f, 0x6000, 0x6dee, 0x69d0, 0x5f8a, 0x8e1d}},
    {"huan", // L"换还唤环患缓欢幻宦涣焕豢桓痪漶獾擐逭鲩郇鬟寰奂锾圜洹萑缳浣垸"
     {0x6362, 0x8fd8, 0x5524, 0x73af, 0x60a3, 0x7f13, 0x6b22, 0x5e7b, 0x5ba6, 0x6da3,
      0x7115, 0x8c62, 0x6853, 0x75ea, 0x6f36, 0x737e, 0x64d0, 0x902d, 0x9ca9, 0x90c7,
      0x9b1f, 0x5bf0, 0x5942, 0x953e, 0x571c, 0x6d39, 0x8411, 0x7f33, 0x6d63, 0x57b8}},
    {"huang", // L"黄慌晃荒簧凰皇谎惶蝗磺恍煌幌隍肓潢篁徨鳇遑癀湟蟥璜"
     {0x9ec4, 0x614c, 0x6643, 0x8352, 0x7c27, 0x51f0, 0x7687, 0x8c0e, 0x60f6,
      0x8757, 0x78fa, 0x604d, 0x714c, 0x5e4c, 0x968d, 0x8093, 0x6f62, 0x7bc1,
      0x5fa8, 0x9cc7, 0x9051, 0x7640, 0x6e5f, 0x87e5, 0x749c}},
    {"hui", // L"回会灰绘挥汇辉毁悔惠晦徽恢秽慧贿蛔讳卉烩诲彗浍蕙喙恚哕晖隳麾诙蟪茴洄咴虺荟缋桧"
     {0x56de, 0x4f1a, 0x7070, 0x7ed8, 0x6325, 0x6c47, 0x8f89, 0x6bc1, 0x6094, 0x60e0,
      0x6666, 0x5fbd, 0x6062, 0x79fd, 0x6167, 0x8d3f, 0x86d4, 0x8bb3, 0x5349, 0x70e9,
      0x8bf2, 0x5f57, 0x6d4d, 0x8559, 0x5599, 0x605a, 0x54d5, 0x6656, 0x96b3, 0x9ebe,
      0x8bd9, 0x87ea, 0x8334, 0x6d04, 0x54b4, 0x867a, 0x835f, 0x7f0b, 0x6867}},
    {"hun", // L"混昏荤浑婚魂阍珲馄溷诨"
     {0x6df7, 0x660f, 0x8364, 0x6d51, 0x5a5a, 0x9b42, 0x960d, 0x73f2, 0x9984, 0x6eb7, 0x8be8}},
    {"huo", // L"或活火伙货和获祸豁霍惑嚯镬耠劐藿攉锪蠖钬夥"
     {0x6216, 0x6d3b, 0x706b, 0x4f19, 0x8d27, 0x548c, 0x83b7, 0x7978, 0x8c41, 0x970d, 0x60d1,
      0x56af, 0x956c, 0x8020, 0x5290, 0x85ff, 0x6509, 0x952a, 0x8816, 0x94ac, 0x5925}},
    {"ji", // L"几及急既即机鸡积记级极计挤己季寄纪系基激吉脊际汲肌嫉姬绩缉饥迹棘蓟技冀辑伎祭剂悸济籍寂奇忌妓继集给击圾箕讥畸稽疾墼洎鲚屐齑戟鲫嵇矶稷戢虮笈暨笄剞叽蒺跻嵴掎跽霁唧畿荠瘠玑羁丌偈芨佶赍楫髻咭蕺觊麂骥殛岌亟犄乩芰哜彐萁藉"
     {0x51e0, 0x53ca, 0x6025, 0x65e2, 0x5373, 0x673a, 0x9e21, 0x79ef, 0x8bb0, 0x7ea7, 0x6781,
      0x8ba1, 0x6324, 0x5df1, 0x5b63, 0x5bc4, 0x7eaa, 0x7cfb, 0x57fa, 0x6fc0, 0x5409, 0x810a,
      0x9645, 0x6c72, 0x808c, 0x5ac9, 0x59ec, 0x7ee9, 0x7f09, 0x9965, 0x8ff9, 0x68d8, 0x84df,
      0x6280, 0x5180, 0x8f91, 0x4f0e, 0x796d, 0x5242, 0x60b8, 0x6d4e, 0x7c4d, 0x5bc2, 0x5947,
      0x5fcc, 0x5993, 0x7ee7, 0x96c6, 0x7ed9, 0x51fb, 0x573e, 0x7b95, 0x8ba5, 0x7578, 0x7a3d,
      0x75be, 0x58bc, 0x6d0e, 0x9c9a, 0x5c50, 0x9f51, 0x621f, 0x9cab, 0x5d47, 0x77f6, 0x7a37,
      0x6222, 0x866e, 0x7b08, 0x66a8, 0x7b04, 0x525e, 0x53fd, 0x84ba, 0x8dfb, 0x5d74, 0x638e,
      0x8dfd, 0x9701, 0x5527, 0x757f, 0x8360, 0x7620, 0x7391, 0x7f81, 0x4e0c, 0x5048, 0x82a8,
      0x4f76, 0x8d4d, 0x696b, 0x9afb, 0x54ad, 0x857a, 0x89ca, 0x9e82, 0x9aa5, 0x6b9b, 0x5c8c,
      0x4e9f, 0x7284, 0x4e69, 0x82b0, 0x54dc, 0x5f50, 0x8401, 0x85c9}},
    {"jia", // L"家加假价架甲佳夹嘉驾嫁枷荚颊钾稼茄贾铗葭迦戛浃镓痂恝岬跏嘏伽胛笳珈瘕郏袈蛱袷铪"
     {0x5bb6, 0x52a0, 0x5047, 0x4ef7, 0x67b6, 0x7532, 0x4f73, 0x5939, 0x5609, 0x9a7e,
      0x5ac1, 0x67b7, 0x835a, 0x988a, 0x94be, 0x7a3c, 0x8304, 0x8d3e, 0x94d7, 0x846d,
      0x8fe6, 0x621b, 0x6d43, 0x9553, 0x75c2, 0x605d, 0x5cac, 0x8dcf, 0x560f, 0x4f3d,
      0x80db, 0x7b33, 0x73c8, 0x7615, 0x90cf, 0x8888, 0x86f1, 0x88b7, 0x94ea}},
    {"jian", // L"见件减尖间键贱肩兼建检箭煎简剪歼监坚奸健艰荐剑渐溅涧鉴践捡柬笺俭碱硷拣舰槛缄茧饯翦鞯戋谏牮枧腱趼缣搛戬毽菅鲣笕谫楗囝蹇裥踺睑謇鹣蒹僭锏湔犍谮"
     {0x89c1, 0x4ef6, 0x51cf, 0x5c16, 0x95f4, 0x952e, 0x8d31, 0x80a9, 0x517c, 0x5efa,
      0x68c0, 0x7bad, 0x714e, 0x7b80, 0x526a, 0x6b7c, 0x76d1, 0x575a, 0x5978, 0x5065,
      0x8270, 0x8350, 0x5251, 0x6e10, 0x6e85, 0x6da7, 0x9274, 0x8df5, 0x6361, 0x67ec,
      0x7b3a, 0x4fed, 0x78b1, 0x7877, 0x62e3, 0x8230, 0x69db, 0x7f04, 0x8327, 0x996f,
      0x7fe6, 0x97af, 0x620b, 0x8c0f, 0x726e, 0x67a7, 0x8171, 0x8dbc, 0x7f23, 0x641b,
      0x622c, 0x6bfd, 0x83c5, 0x9ca3, 0x7b15, 0x8c2b, 0x6957, 0x56dd, 0x8e47, 0x88e5,
      0x8e3a, 0x7751, 0x8b07, 0x9e63, 0x84b9, 0x50ed, 0x950f, 0x6e54, 0x728d, 0x8c2e}},
    {"jiang", // L"将讲江奖降浆僵姜酱蒋疆匠强桨虹豇礓缰犟耩绛茳糨洚"
     {0x5c06, 0x8bb2, 0x6c5f, 0x5956, 0x964d, 0x6d46, 0x50f5, 0x59dc,
      0x9171, 0x848b, 0x7586, 0x5320, 0x5f3a, 0x6868, 0x8679, 0x8c47,
      0x7913, 0x7f30, 0x729f, 0x8029, 0x7edb, 0x8333, 0x7ce8, 0x6d1a}},
    {"jiao", // L"叫脚交角教较缴觉焦胶娇绞校搅骄狡浇矫郊嚼蕉轿窖椒礁饺铰酵侥剿徼艽僬蛟敫峤跤姣皎茭鹪噍醮佼鲛挢"
     {0x53eb, 0x811a, 0x4ea4, 0x89d2, 0x6559, 0x8f83, 0x7f34, 0x89c9, 0x7126, 0x80f6,
      0x5a07, 0x7ede, 0x6821, 0x6405, 0x9a84, 0x72e1, 0x6d47, 0x77eb, 0x90ca, 0x56bc,
      0x8549, 0x8f7f, 0x7a96, 0x6912, 0x7901, 0x997a, 0x94f0, 0x9175, 0x4fa5, 0x527f,
      0x5fbc, 0x827d, 0x50ec, 0x86df, 0x656b, 0x5ce4, 0x8de4, 0x59e3, 0x768e, 0x832d,
      0x9e6a, 0x564d, 0x91ae, 0x4f7c, 0x9c9b, 0x6322}},
    {"jie", // L"接节街借皆截解界结届姐揭戒介阶劫芥竭洁疥藉秸桔杰捷诫睫偈桀喈拮骱羯蚧嗟颉鲒婕碣讦孑疖诘卩锴"
     {0x63a5, 0x8282, 0x8857, 0x501f, 0x7686, 0x622a, 0x89e3, 0x754c, 0x7ed3,
      0x5c4a, 0x59d0, 0x63ed, 0x6212, 0x4ecb, 0x9636, 0x52ab, 0x82a5, 0x7aed,
      0x6d01, 0x75a5, 0x85c9, 0x79f8, 0x6854, 0x6770, 0x6377, 0x8beb, 0x776b,
      0x5048, 0x6840, 0x5588, 0x62ee, 0x9ab1, 0x7faf, 0x86a7, 0x55df, 0x9889,
      0x9c92, 0x5a55, 0x78a3, 0x8ba6, 0x5b51, 0x7596, 0x8bd8, 0x5369, 0x9534}},
    {"jin", // L"进近今仅紧金斤尽劲禁浸锦晋筋津谨巾襟烬靳廑瑾馑槿衿堇荩矜噤缙卺妗赆觐钅"
     {0x8fdb, 0x8fd1, 0x4eca, 0x4ec5, 0x7d27, 0x91d1, 0x65a4, 0x5c3d, 0x52b2,
      0x7981, 0x6d78, 0x9526, 0x664b, 0x7b4b, 0x6d25, 0x8c28, 0x5dfe, 0x895f,
      0x70ec, 0x9773, 0x5ed1, 0x747e, 0x9991, 0x69ff, 0x887f, 0x5807, 0x8369,
      0x77dc, 0x5664, 0x7f19, 0x537a, 0x5997, 0x8d46, 0x89d0, 0x9485}},
    {"jing", // L"竟静井惊经镜京净敬精景警竞境径荆晶鲸粳颈兢茎睛劲痉靖肼獍阱腈弪刭憬婧胫菁儆旌迳靓泾陉"
     {0x7adf, 0x9759, 0x4e95, 0x60ca, 0x7ecf, 0x955c, 0x4eac, 0x51c0, 0x656c, 0x7cbe, 0x666f,
      0x8b66, 0x7ade, 0x5883, 0x5f84, 0x8346, 0x6676, 0x9cb8, 0x7cb3, 0x9888, 0x5162, 0x830e,
      0x775b, 0x52b2, 0x75c9, 0x9756, 0x80bc, 0x734d, 0x9631, 0x8148, 0x5f2a, 0x522d, 0x61ac,
      0x5a67, 0x80eb, 0x83c1, 0x5106, 0x65cc, 0x8ff3, 0x9753, 0x6cfe, 0x9649}},
    {"jiong", // L"窘炯扃迥冂"
     {0x7a98, 0x70af, 0x6243, 0x8fe5, 0x5182}},
    {"jiu", // L"就九酒旧久揪救纠舅究韭厩臼玖灸咎疚赳鹫僦柩桕鬏鸠阄啾"
     {0x5c31, 0x4e5d, 0x9152, 0x65e7, 0x4e45, 0x63ea, 0x6551, 0x7ea0, 0x8205,
      0x7a76, 0x97ed, 0x53a9, 0x81fc, 0x7396, 0x7078, 0x548e, 0x759a, 0x8d73,
      0x9e6b, 0x50e6, 0x67e9, 0x6855, 0x9b0f, 0x9e20, 0x9604, 0x557e}},
    {"ju", // L"句举巨局具距锯剧居聚拘菊矩沮拒惧鞠狙驹据柜俱车咀疽踞炬倨醵裾屦犋苴窭飓锔椐苣琚掬榘龃趄莒雎遽橘踽榉鞫钜讵枸瞿蘧"
     {0x53e5, 0x4e3e, 0x5de8, 0x5c40, 0x5177, 0x8ddd, 0x952f, 0x5267, 0x5c45, 0x805a, 0x62d8,
      0x83ca, 0x77e9, 0x6cae, 0x62d2, 0x60e7, 0x97a0, 0x72d9, 0x9a79, 0x636e, 0x67dc, 0x4ff1,
      0x8f66, 0x5480, 0x75bd, 0x8e1e, 0x70ac, 0x5028, 0x91b5, 0x88fe, 0x5c66, 0x728b, 0x82f4,
      0x7aad, 0x98d3, 0x9514, 0x6910, 0x82e3, 0x741a, 0x63ac, 0x6998, 0x9f83, 0x8d84, 0x8392,
      0x96ce, 0x907d, 0x6a58, 0x8e3d, 0x6989, 0x97ab, 0x949c, 0x8bb5, 0x67b8, 0x77bf, 0x8627}},
    {"juan", // L"卷圈倦鹃捐娟眷绢鄄锩蠲镌狷桊涓隽"
     {0x5377, 0x5708, 0x5026, 0x9e43, 0x6350, 0x5a1f, 0x7737, 0x7ee2, 0x9104, 0x9529, 0x8832,
      0x954c, 0x72f7, 0x684a, 0x6d93, 0x96bd}},
    {"jue", // L"决绝觉角爵掘诀撅倔抉攫嚼脚桷橛觖劂爝矍镢獗珏崛蕨噘谲蹶孓厥阙"
     {0x51b3, 0x7edd, 0x89c9, 0x89d2, 0x7235, 0x6398, 0x8bc0, 0x6485, 0x5014, 0x6289,
      0x652b, 0x56bc, 0x811a, 0x6877, 0x6a5b, 0x89d6, 0x5282, 0x721d, 0x77cd, 0x9562,
      0x7357, 0x73cf, 0x5d1b, 0x8568, 0x5658, 0x8c32, 0x8e76, 0x5b53, 0x53a5, 0x9619}},
    {"jun", // L"军君均菌俊峻龟竣骏钧浚郡筠麇皲捃"
     {0x519b, 0x541b, 0x5747, 0x83cc, 0x4fca, 0x5cfb, 0x9f9f, 0x7ae3, 0x9a8f, 0x94a7, 0x6d5a,
      0x90e1, 0x7b60, 0x9e87, 0x76b2, 0x6343}},
    {"ka", // L"卡喀咯咖胩咔佧"
     {0x5361, 0x5580, 0x54af, 0x5496, 0x80e9, 0x5494, 0x4f67}},
    {"kai", // L"开揩凯慨楷垲剀锎铠锴忾恺蒈"
     {0x5f00, 0x63e9, 0x51ef, 0x6168, 0x6977, 0x57b2, 0x5240, 0x950e, 0x94e0, 0x9534, 0x5ffe,
      0x607a, 0x8488}},
    {"kan", // L"看砍堪刊坎槛勘龛戡侃瞰莰阚凵"
     {0x770b, 0x780d, 0x582a, 0x520a, 0x574e, 0x69db, 0x52d8, 0x9f9b, 0x6221, 0x4f83, 0x77b0,
      0x83b0, 0x961a, 0x51f5}},
    {"kang", // L"抗炕扛糠康慷亢钪闶伉"
     {0x6297, 0x7095, 0x625b, 0x7ce0, 0x5eb7, 0x6177, 0x4ea2, 0x94aa, 0x95f6, 0x4f09}},
    {"kao", // L"靠考烤拷栲犒尻铐"
     {0x9760, 0x8003, 0x70e4, 0x62f7, 0x6832, 0x7292, 0x5c3b, 0x94d0}},
    {"ke", // L"可克棵科颗刻课客壳渴苛柯磕咳坷呵恪岢蝌缂蚵轲窠钶氪颏瞌锞稞珂髁疴嗑溘骒铪"
     {0x53ef, 0x514b, 0x68f5, 0x79d1, 0x9897, 0x523b, 0x8bfe, 0x5ba2, 0x58f3,
      0x6e34, 0x82db, 0x67ef, 0x78d5, 0x54b3, 0x5777, 0x5475, 0x606a, 0x5ca2,
      0x874c, 0x7f02, 0x86b5, 0x8f72, 0x7aa0, 0x94b6, 0x6c2a, 0x988f, 0x778c,
      0x951e, 0x7a1e, 0x73c2, 0x9ac1, 0x75b4, 0x55d1, 0x6e98, 0x9a92, 0x94ea}},
    {"ken", // L"肯啃恳垦裉"
     {0x80af, 0x5543, 0x6073, 0x57a6, 0x88c9}},
    {"keng", // L"坑吭铿胫铒"
     {0x5751, 0x542d, 0x94ff, 0x80eb, 0x94d2}},
    {"kong", // L"空孔控恐倥崆箜"
     {0x7a7a, 0x5b54, 0x63a7, 0x6050, 0x5025, 0x5d06, 0x7b9c}},
    {"kou", // L"口扣抠寇蔻芤眍筘叩"
     {0x53e3, 0x6263, 0x62a0, 0x5bc7, 0x853b, 0x82a4, 0x770d, 0x7b58, 0x53e9}},
    {"ku", // L"哭库苦枯裤窟酷刳骷喾堀绔"
     {0x54ed, 0x5e93, 0x82e6, 0x67af, 0x88e4, 0x7a9f, 0x9177, 0x5233, 0x9ab7, 0x55be, 0x5800,
      0x7ed4}},
    {"kua", // L"跨垮挎夸胯侉锞"
     {0x8de8, 0x57ae, 0x630e, 0x5938, 0x80ef, 0x4f89, 0x951e}},
    {"kuai", // L"快块筷会侩哙蒯郐狯脍"
     {0x5feb, 0x5757, 0x7b77, 0x4f1a, 0x4fa9, 0x54d9, 0x84af, 0x90d0, 0x72ef, 0x810d}},
    {"kuan", // L"宽款髋"
     {0x5bbd, 0x6b3e, 0x9acb}},
    {"kuang", // L"矿筐狂框况旷匡眶诳邝纩夼诓圹贶哐"
     {0x77ff, 0x7b50, 0x72c2, 0x6846, 0x51b5, 0x65f7, 0x5321, 0x7736, 0x8bf3, 0x909d, 0x7ea9,
      0x593c, 0x8bd3, 0x5739, 0x8d36, 0x54d0}},
    {"kui", // L"亏愧奎窥溃葵魁馈盔傀岿匮愦揆睽跬聩篑喹逵暌蒉悝喟馗蝰隗夔"
     {0x4e8f, 0x6127, 0x594e, 0x7aa5, 0x6e83, 0x8475, 0x9b41, 0x9988, 0x76d4, 0x5080,
      0x5cbf, 0x532e, 0x6126, 0x63c6, 0x777d, 0x8dec, 0x8069, 0x7bd1, 0x55b9, 0x9035,
      0x668c, 0x8489, 0x609d, 0x559f, 0x9997, 0x8770, 0x9697, 0x5914}},
    {"kun", // L"捆困昆坤鲲锟髡琨醌阃悃顽"
     {0x6346, 0x56f0, 0x6606, 0x5764, 0x9cb2, 0x951f, 0x9ae1, 0x7428, 0x918c, 0x9603, 0x6083,
      0x987d}},
    {"kuo", // L"阔扩括廓蛞"
     {0x9614, 0x6269, 0x62ec, 0x5ed3, 0x86de}},
    {"la", // L"拉啦辣蜡腊喇垃落瘌邋砬剌旯"
     {0x62c9, 0x5566, 0x8fa3, 0x8721, 0x814a, 0x5587, 0x5783, 0x843d, 0x760c, 0x908b, 0x782c,
      0x524c, 0x65ef}},
    {"lai", // L"来赖莱濑赉崃涞铼籁徕癞睐"
     {0x6765, 0x8d56, 0x83b1, 0x6fd1, 0x8d49, 0x5d03, 0x6d9e, 0x94fc, 0x7c41, 0x5f95, 0x765e,
      0x7750}},
    {"lan", // L"蓝兰烂拦篮懒栏揽缆滥阑谰婪澜览榄岚褴镧斓罱漤"
     {0x84dd, 0x5170, 0x70c2, 0x62e6, 0x7bee, 0x61d2, 0x680f, 0x63fd, 0x7f06, 0x6ee5, 0x9611,
      0x8c30, 0x5a6a, 0x6f9c, 0x89c8, 0x6984, 0x5c9a, 0x8934, 0x9567, 0x6593, 0x7f71, 0x6f24}},
    {"lang", // L"浪狼廊郎朗榔琅稂螂莨啷锒阆蒗"
     {0x6d6a, 0x72fc, 0x5eca, 0x90ce, 0x6717, 0x6994, 0x7405, 0x7a02, 0x8782, 0x83a8, 0x5577,
      0x9512, 0x9606, 0x8497}},
    {"lao", // L"老捞牢劳烙涝落姥酪络佬耢铹醪铑唠栳崂痨"
     {0x8001, 0x635e, 0x7262, 0x52b3, 0x70d9, 0x6d9d, 0x843d, 0x59e5, 0x916a, 0x7edc, 0x4f6c,
      0x8022, 0x94f9, 0x91aa, 0x94d1, 0x5520, 0x6833, 0x5d02, 0x75e8}},
    {"le", // L"了乐勒鳓仂叻泐"
     {0x4e86, 0x4e50, 0x52d2, 0x9cd3, 0x4ec2, 0x53fb, 0x6cd0}},
    {"lei", // L"类累泪雷垒勒擂蕾肋镭儡磊缧诔耒酹羸嫘檑嘞"
     {0x7c7b, 0x7d2f, 0x6cea, 0x96f7, 0x5792, 0x52d2, 0x64c2, 0x857e, 0x808b, 0x956d,
      0x5121, 0x78ca, 0x7f27, 0x8bd4, 0x8012, 0x9179, 0x7fb8, 0x5ad8, 0x6a91, 0x561e}},
    {"leng", // L"冷棱楞愣塄"
     {0x51b7, 0x68f1, 0x695e, 0x6123, 0x5844}},
    {"li", // L"里离力立李例哩理利梨厘礼历丽吏砾漓莉傈荔俐痢狸粒沥隶栗璃鲤厉励犁黎篱郦鹂笠坜苈鳢缡跞蜊锂澧粝蓠枥蠡鬲呖砺嫠篥疠疬猁藜溧鲡戾栎唳醴轹詈骊罹逦俪喱雳黧莅俚蛎娌砬"
     {0x91cc, 0x79bb, 0x529b, 0x7acb, 0x674e, 0x4f8b, 0x54e9, 0x7406, 0x5229, 0x68a8,
      0x5398, 0x793c, 0x5386, 0x4e3d, 0x540f, 0x783e, 0x6f13, 0x8389, 0x5088, 0x8354,
      0x4fd0, 0x75e2, 0x72f8, 0x7c92, 0x6ca5, 0x96b6, 0x6817, 0x7483, 0x9ca4, 0x5389,
      0x52b1, 0x7281, 0x9ece, 0x7bf1, 0x90e6, 0x9e42, 0x7b20, 0x575c, 0x82c8, 0x9ce2,
      0x7f21, 0x8dde, 0x870a, 0x9502, 0x6fa7, 0x7c9d, 0x84e0, 0x67a5, 0x8821, 0x9b32,
      0x5456, 0x783a, 0x5ae0, 0x7be5, 0x75a0, 0x75ac, 0x7301, 0x85dc, 0x6ea7, 0x9ca1,
      0x623e, 0x680e, 0x5533, 0x91b4, 0x8f79, 0x8a48, 0x9a8a, 0x7f79, 0x9026, 0x4fea,
      0x55b1, 0x96f3, 0x9ee7, 0x8385, 0x4fda, 0x86ce, 0x5a0c, 0x782c}},
    {"lia", // L"俩"
     {0x4fe9}},
    {"lian", // L"连联练莲恋脸炼链敛怜廉帘镰涟蠊琏殓蔹鲢奁潋臁裢濂裣楝"
     {0x8fde, 0x8054, 0x7ec3, 0x83b2, 0x604b, 0x8138, 0x70bc, 0x94fe, 0x655b,
      0x601c, 0x5ec9, 0x5e18, 0x9570, 0x6d9f, 0x880a, 0x740f, 0x6b93, 0x8539,
      0x9ca2, 0x5941, 0x6f4b, 0x81c1, 0x88e2, 0x6fc2, 0x88e3, 0x695d}},
    {"liang", // L"两亮辆凉粮梁量良晾谅俩粱墚踉椋魉莨"
     {0x4e24, 0x4eae, 0x8f86, 0x51c9, 0x7cae, 0x6881, 0x91cf, 0x826f, 0x667e, 0x8c05, 0x4fe9,
      0x7cb1, 0x589a, 0x8e09, 0x690b, 0x9b49, 0x83a8}},
    {"liao", // L"了料撩聊撂疗廖燎辽僚寥镣潦钌蓼尥寮缭獠鹩嘹"
     {0x4e86, 0x6599, 0x64a9, 0x804a, 0x6482, 0x7597, 0x5ed6, 0x71ce, 0x8fbd, 0x50da, 0x5be5,
      0x9563, 0x6f66, 0x948c, 0x84fc, 0x5c25, 0x5bee, 0x7f2d, 0x7360, 0x9e69, 0x5639}},
    {"lie", // L"列裂猎劣烈咧埒捩鬣趔躐冽洌"
     {0x5217, 0x88c2, 0x730e, 0x52a3, 0x70c8, 0x54a7, 0x57d2, 0x6369, 0x9b23, 0x8d94, 0x8e90,
      0x51bd, 0x6d0c}},
    {"lin", // L"林临淋邻磷鳞赁吝拎琳霖凛遴嶙蔺粼麟躏辚廪懔瞵檩膦啉"
     {0x6797, 0x4e34, 0x6dcb, 0x90bb, 0x78f7, 0x9cde, 0x8d41, 0x541d, 0x62ce,
      0x7433, 0x9716, 0x51db, 0x9074, 0x5d99, 0x853a, 0x7cbc, 0x9e9f, 0x8e8f,
      0x8f9a, 0x5eea, 0x61d4, 0x77b5, 0x6aa9, 0x81a6, 0x5549}},
    {"ling", // L"另令领零铃玲灵岭龄凌陵菱伶羚棱翎蛉苓绫瓴酃呤泠棂柃鲮聆囹"
     {0x53e6, 0x4ee4, 0x9886, 0x96f6, 0x94c3, 0x73b2, 0x7075, 0x5cad, 0x9f84, 0x51cc,
      0x9675, 0x83f1, 0x4f36, 0x7f9a, 0x68f1, 0x7fce, 0x86c9, 0x82d3, 0x7eeb, 0x74f4,
      0x9143, 0x5464, 0x6ce0, 0x68c2, 0x67c3, 0x9cae, 0x8046, 0x56f9}},
    {"liu", // L"六流留刘柳溜硫瘤榴琉馏碌陆绺锍鎏镏浏骝旒鹨熘遛"
     {0x516d, 0x6d41, 0x7559, 0x5218, 0x67f3, 0x6e9c, 0x786b, 0x7624,
      0x69b4, 0x7409, 0x998f, 0x788c, 0x9646, 0x7efa, 0x950d, 0x938f,
      0x954f, 0x6d4f, 0x9a9d, 0x65d2, 0x9e68, 0x7198, 0x905b}},
    {"lo", // L"咯"
     {0x54af}},
    {"long", // L"龙拢笼聋隆垄弄咙窿陇垅胧珑茏泷栊癃砻"
     {0x9f99, 0x62e2, 0x7b3c, 0x804b, 0x9686, 0x5784, 0x5f04, 0x5499, 0x7abf, 0x9647, 0x5785,
      0x80e7, 0x73d1, 0x830f, 0x6cf7, 0x680a, 0x7643, 0x783b}},
    {"lou", // L"楼搂漏陋露娄篓偻蝼镂蒌耧髅喽瘘嵝"
     {0x697c, 0x6402, 0x6f0f, 0x964b, 0x9732, 0x5a04, 0x7bd3, 0x507b, 0x877c, 0x9542, 0x848c,
      0x8027, 0x9ac5, 0x55bd, 0x7618, 0x5d5d}},
    {"lu", // L"路露录鹿陆炉卢鲁卤芦颅庐碌掳绿虏赂戮潞禄麓六鲈栌渌逯泸轳氇簏橹辂垆胪噜镥辘漉撸璐鸬鹭舻"
     {0x8def, 0x9732, 0x5f55, 0x9e7f, 0x9646, 0x7089, 0x5362, 0x9c81, 0x5364, 0x82a6, 0x9885,
      0x5e90, 0x788c, 0x63b3, 0x7eff, 0x864f, 0x8d42, 0x622e, 0x6f5e, 0x7984, 0x9e93, 0x516d,
      0x9c88, 0x680c, 0x6e0c, 0x902f, 0x6cf8, 0x8f73, 0x6c07, 0x7c0f, 0x6a79, 0x8f82, 0x5786,
      0x80ea, 0x565c, 0x9565, 0x8f98, 0x6f09, 0x64b8, 0x7490, 0x9e2c, 0x9e6d, 0x823b}},
    {"luan", // L"乱卵滦峦孪挛栾銮脔娈鸾"
     {0x4e71, 0x5375, 0x6ee6, 0x5ce6, 0x5b6a, 0x631b, 0x683e, 0x92ae, 0x8114, 0x5a08, 0x9e3e}},
    {"lue", // L"略掠锊"
     {0x7565, 0x63a0, 0x950a}},
    {"lun", // L"论轮抡伦沦仑纶囵"
     {0x8bba, 0x8f6e, 0x62a1, 0x4f26, 0x6ca6, 0x4ed1, 0x7eb6, 0x56f5}},
    {"luo", // L"落罗锣裸骡烙箩螺萝洛骆逻络咯荦漯蠃雒倮硌椤捋脶瘰摞泺珞镙猡铬"
     {0x843d, 0x7f57, 0x9523, 0x88f8, 0x9aa1, 0x70d9, 0x7ba9, 0x87ba, 0x841d, 0x6d1b,
      0x9a86, 0x903b, 0x7edc, 0x54af, 0x8366, 0x6f2f, 0x8803, 0x96d2, 0x502e, 0x784c,
      0x6924, 0x634b, 0x8136, 0x7630, 0x645e, 0x6cfa, 0x73de, 0x9559, 0x7321, 0x94ec}},
    {"lv", // L"绿率铝驴旅屡滤吕律氯缕侣虑履偻膂榈闾捋褛稆"
     {0x7eff, 0x7387, 0x94dd, 0x9a74, 0x65c5, 0x5c61, 0x6ee4, 0x5415, 0x5f8b, 0x6c2f, 0x7f15,
      0x4fa3, 0x8651, 0x5c65, 0x507b, 0x8182, 0x6988, 0x95fe, 0x634b, 0x891b, 0x7a06}},
    {"lve", // L"略掠锊"
     {0x7565, 0x63a0, 0x950a}},
    {"m", // L"呒"
     {0x5452}},
    {"ma", // L"吗妈马嘛麻骂抹码玛蚂摩唛蟆犸嬷杩"
     {0x5417, 0x5988, 0x9a6c, 0x561b, 0x9ebb, 0x9a82, 0x62b9, 0x7801, 0x739b, 0x8682, 0x6469,
      0x551b, 0x87c6, 0x72b8, 0x5b37, 0x6769}},
    {"mai", // L"买卖迈埋麦脉劢霾荬"
     {0x4e70, 0x5356, 0x8fc8, 0x57cb, 0x9ea6, 0x8109, 0x52a2, 0x973e, 0x836c}},
    {"man", // L"满慢瞒漫蛮蔓曼馒埋谩幔鳗墁螨镘颟鞔缦熳"
     {0x6ee1, 0x6162, 0x7792, 0x6f2b, 0x86ee, 0x8513, 0x66fc, 0x9992, 0x57cb, 0x8c29, 0x5e54,
      0x9cd7, 0x5881, 0x87a8, 0x9558, 0x989f, 0x9794, 0x7f26, 0x71b3}},
    {"mang", // L"忙芒盲莽茫氓硭邙蟒漭"
     {0x5fd9, 0x8292, 0x76f2, 0x83bd, 0x832b, 0x6c13, 0x786d, 0x9099, 0x87d2, 0x6f2d}},
    {"mao", // L"毛冒帽猫矛卯貌茂贸铆锚茅耄茆瑁蝥髦懋昴牦瞀峁袤蟊旄泖"
     {0x6bdb, 0x5192, 0x5e3d, 0x732b, 0x77db, 0x536f, 0x8c8c, 0x8302, 0x8d38,
      0x94c6, 0x951a, 0x8305, 0x8004, 0x8306, 0x7441, 0x8765, 0x9ae6, 0x61cb,
      0x6634, 0x7266, 0x7780, 0x5cc1, 0x88a4, 0x87ca, 0x65c4, 0x6cd6}},
    {"me", // L"么"
     {0x4e48}},
    {"mei", // L"没每煤镁美酶妹枚霉玫眉梅寐昧媒媚嵋猸袂湄浼鹛莓魅镅楣"
     {0x6ca1, 0x6bcf, 0x7164, 0x9541, 0x7f8e, 0x9176, 0x59b9, 0x679a, 0x9709,
      0x73ab, 0x7709, 0x6885, 0x5bd0, 0x6627, 0x5a92, 0x5a9a, 0x5d4b, 0x7338,
      0x8882, 0x6e44, 0x6d7c, 0x9e5b, 0x8393, 0x9b45, 0x9545, 0x6963}},
    {"men", // L"门们闷懑扪钔焖"
     {0x95e8, 0x4eec, 0x95f7, 0x61d1, 0x626a, 0x9494, 0x7116}},
    {"meng", // L"猛梦蒙锰孟盟檬萌礞蜢勐懵甍蠓虻朦艋艨瞢"
     {0x731b, 0x68a6, 0x8499, 0x9530, 0x5b5f, 0x76df, 0x6aac, 0x840c, 0x791e, 0x8722, 0x52d0,
      0x61f5, 0x750d, 0x8813, 0x867b, 0x6726, 0x824b, 0x8268, 0x77a2}},
    {"mi", // L"米密迷眯蜜谜觅秘弥幂靡糜泌醚蘼縻咪汨麋祢猕弭谧芈脒宓敉嘧糸冖"
     {0x7c73, 0x5bc6, 0x8ff7, 0x772f, 0x871c, 0x8c1c, 0x89c5, 0x79d8, 0x5f25, 0x5e42,
      0x9761, 0x7cdc, 0x6ccc, 0x919a, 0x863c, 0x7e3b, 0x54aa, 0x6c68, 0x9e8b, 0x7962,
      0x7315, 0x5f2d, 0x8c27, 0x8288, 0x8112, 0x5b93, 0x6549, 0x5627, 0x7cf8, 0x5196}},
    {"mian", // L"面棉免绵眠缅勉冕娩腼湎眄沔渑宀"
     {0x9762, 0x68c9, 0x514d, 0x7ef5, 0x7720, 0x7f05, 0x52c9, 0x5195, 0x5a29, 0x817c, 0x6e4e,
      0x7704, 0x6c94, 0x6e11, 0x5b80}},
    {"miao", // L"秒苗庙妙描瞄藐渺眇缪缈淼喵杪鹋邈"
     {0x79d2, 0x82d7, 0x5e99, 0x5999, 0x63cf, 0x7784, 0x85d0, 0x6e3a, 0x7707, 0x7f2a, 0x7f08,
      0x6dfc, 0x55b5, 0x676a, 0x9e4b, 0x9088}},
    {"mie", // L"灭蔑咩篾蠛乜"
     {0x706d, 0x8511, 0x54a9, 0x7bfe, 0x881b, 0x4e5c}},
    {"min", // L"民抿敏闽皿悯珉愍缗闵玟苠泯黾鳘岷"
     {0x6c11, 0x62bf, 0x654f, 0x95fd, 0x76bf, 0x60af, 0x73c9, 0x610d, 0x7f17, 0x95f5, 0x739f,
      0x82e0, 0x6cef, 0x9efe, 0x9cd8, 0x5cb7}},
    {"ming", // L"名明命鸣铭螟冥瞑暝茗溟酩"
     {0x540d, 0x660e, 0x547d, 0x9e23, 0x94ed, 0x879f, 0x51a5, 0x7791, 0x669d, 0x8317, 0x6e9f,
      0x9169}},
    {"miu", // L"谬缪"
     {0x8c2c, 0x7f2a}},
    {"mo", // L"摸磨抹末膜墨没莫默魔模摩摹漠陌蘑脉沫万寞秣瘼殁镆嫫谟蓦貊貘麽茉馍耱"
     {0x6478, 0x78e8, 0x62b9, 0x672b, 0x819c, 0x58a8, 0x6ca1, 0x83ab, 0x9ed8, 0x9b54, 0x6a21,
      0x6469, 0x6479, 0x6f20, 0x964c, 0x8611, 0x8109, 0x6cab, 0x4e07, 0x5bde, 0x79e3, 0x763c,
      0x6b81, 0x9546, 0x5aeb, 0x8c1f, 0x84e6, 0x8c8a, 0x8c98, 0x9ebd, 0x8309, 0x998d, 0x8031}},
    {"mou", // L"某谋牟眸蛑鍪侔缪哞"
     {0x67d0, 0x8c0b, 0x725f, 0x7738, 0x86d1, 0x936a, 0x4f94, 0x7f2a, 0x54de}},
    {"mu", // L"木母亩幕目墓牧牟模穆暮牡拇募慕睦姆钼毪坶沐仫苜"
     {0x6728, 0x6bcd, 0x4ea9, 0x5e55, 0x76ee, 0x5893, 0x7267, 0x725f,
      0x6a21, 0x7a46, 0x66ae, 0x7261, 0x62c7, 0x52df, 0x6155, 0x7766,
      0x59c6, 0x94bc, 0x6bea, 0x5776, 0x6c90, 0x4eeb, 0x82dc}},
    {"na", // L"那拿哪纳钠娜呐衲捺镎肭"
     {0x90a3, 0x62ff, 0x54ea, 0x7eb3, 0x94a0, 0x5a1c, 0x5450, 0x8872, 0x637a, 0x954e, 0x80ad}},
    {"nai", // L"乃耐奶奈氖萘艿柰鼐佴"
     {0x4e43, 0x8010, 0x5976, 0x5948, 0x6c16, 0x8418, 0x827f, 0x67f0, 0x9f10, 0x4f74}},
    {"nan", // L"难南男赧囡蝻楠喃腩"
     {0x96be, 0x5357, 0x7537, 0x8d67, 0x56e1, 0x877b, 0x6960, 0x5583, 0x8169}},
    {"nang", // L"囊馕曩囔攮"
     {0x56ca, 0x9995, 0x66e9, 0x56d4, 0x652e}},
    {"nao", // L"闹脑恼挠淖孬铙瑙垴呶蛲猱硇"
     {0x95f9, 0x8111, 0x607c, 0x6320, 0x6dd6, 0x5b6c, 0x94d9, 0x7459, 0x57b4, 0x5476, 0x86f2,
      0x7331, 0x7847}},
    {"ne", // L"呢哪讷"
     {0x5462, 0x54ea, 0x8bb7}},
    {"nei", // L"内馁"
     {0x5185, 0x9981}},
    {"nen", // L"嫩恁"
     {0x5ae9, 0x6041}},
    {"neng", // L"能"
     {0x80fd}},
    {"ni", // L"你泥拟腻逆呢溺倪尼匿妮霓铌昵坭祢猊伲怩鲵睨旎慝"
     {0x4f60, 0x6ce5, 0x62df, 0x817b, 0x9006, 0x5462, 0x6eba, 0x502a,
      0x5c3c, 0x533f, 0x59ae, 0x9713, 0x94cc, 0x6635, 0x576d, 0x7962,
      0x730a, 0x4f32, 0x6029, 0x9cb5, 0x7768, 0x65ce, 0x615d}},
    {"nian", // L"年念捻撵拈碾蔫廿黏辇鲇鲶埝"
     {0x5e74, 0x5ff5, 0x637b, 0x64b5, 0x62c8, 0x78be, 0x852b, 0x5eff, 0x9ecf, 0x8f87, 0x9c87,
      0x9cb6, 0x57dd}},
    {"niang", // L"娘酿"
     {0x5a18, 0x917f}},
    {"niao", // L"鸟尿袅茑脲嬲"
     {0x9e1f, 0x5c3f, 0x8885, 0x8311, 0x8132, 0x5b32}},
    {"nie", // L"捏镍聂孽涅镊啮陧蘖嗫臬蹑颞乜"
     {0x634f, 0x954d, 0x8042, 0x5b7d, 0x6d85, 0x954a, 0x556e, 0x9667, 0x8616, 0x55eb, 0x81ec,
      0x8e51, 0x989e, 0x4e5c}},
    {"nin", // L"您"
     {0x60a8}},
    {"ning", // L"拧凝宁柠狞泞佞甯咛聍"
     {0x62e7, 0x51dd, 0x5b81, 0x67e0, 0x72de, 0x6cde, 0x4f5e, 0x752f, 0x549b, 0x804d}},
    {"niu", // L"牛扭纽钮拗妞狃忸"
     {0x725b, 0x626d, 0x7ebd, 0x94ae, 0x62d7, 0x599e, 0x72c3, 0x5ff8}},
    {"nong", // L"弄浓农脓哝侬"
     {0x5f04, 0x6d53, 0x519c, 0x8113, 0x54dd, 0x4fac}},
    {"nou", // L"耨"
     {0x8028}},
    {"nu", // L"怒努奴孥胬驽弩"
     {0x6012, 0x52aa, 0x5974, 0x5b65, 0x80ec, 0x9a7d, 0x5f29}},
    {"nuan", // L"暖"
     {0x6696}},
    {"nue", // L"虐疟"
     {0x8650, 0x759f}},
    {"nuo", // L"挪诺懦糯娜喏傩锘搦"
     {0x632a, 0x8bfa, 0x61e6, 0x7cef, 0x5a1c, 0x558f, 0x50a9, 0x9518, 0x6426}},
    {"nv", // L"女衄钕恧"
     {0x5973, 0x8844, 0x9495, 0x6067}},
    {"nve", // L"虐疟"
     {0x8650, 0x759f}},
    {"o", // L"哦喔噢"
     {0x54e6, 0x5594, 0x5662}},
    {"ou", // L"偶呕欧藕鸥区沤殴怄瓯讴耦"
     {0x5076, 0x5455, 0x6b27, 0x85d5, 0x9e25, 0x533a, 0x6ca4, 0x6bb4, 0x6004, 0x74ef, 0x8bb4,
      0x8026}},
    {"pa", // L"怕爬趴啪耙扒帕琶筢杷葩"
     {0x6015, 0x722c, 0x8db4, 0x556a, 0x8019, 0x6252, 0x5e15, 0x7436, 0x7b62, 0x6777, 0x8469}},
    {"pai", // L"派排拍牌迫徘湃哌俳蒎"
     {0x6d3e, 0x6392, 0x62cd, 0x724c, 0x8feb, 0x5f98, 0x6e43, 0x54cc, 0x4ff3, 0x848e}},
    {"pan", // L"盘盼判攀畔潘叛磐番胖襻蟠袢泮拚爿蹒"
     {0x76d8, 0x76fc, 0x5224, 0x6500, 0x7554, 0x6f58, 0x53db, 0x78d0, 0x756a, 0x80d6, 0x897b,
      0x87e0, 0x88a2, 0x6cee, 0x62da, 0x723f, 0x8e52}},
    {"pang", // L"旁胖耪庞乓膀磅滂彷逄螃镑"
     {0x65c1, 0x80d6, 0x802a, 0x5e9e, 0x4e53, 0x8180, 0x78c5, 0x6ec2, 0x5f77, 0x9004, 0x8783,
      0x9551}},
    {"pao", // L"跑抛炮泡刨袍咆狍匏庖疱脬"
     {0x8dd1, 0x629b, 0x70ae, 0x6ce1, 0x5228, 0x888d, 0x5486, 0x72cd, 0x530f, 0x5e96, 0x75b1,
      0x812c}},
    {"pei", // L"陪配赔呸胚佩培沛裴旆锫帔醅霈辔"
     {0x966a, 0x914d, 0x8d54, 0x5478, 0x80da, 0x4f69, 0x57f9, 0x6c9b, 0x88f4, 0x65c6, 0x952b,
      0x5e14, 0x9185, 0x9708, 0x8f94}},
    {"pen", // L"喷盆湓"
     {0x55b7, 0x76c6, 0x6e53}},
    {"peng", // L"碰捧棚砰蓬朋彭鹏烹硼膨抨澎篷怦堋蟛嘭"
     {0x78b0, 0x6367, 0x68da, 0x7830, 0x84ec, 0x670b, 0x5f6d, 0x9e4f, 0x70f9, 0x787c, 0x81a8,
      0x62a8, 0x6f8e, 0x7bf7, 0x6026, 0x580b, 0x87db, 0x562d}},
    {"pi", // L"批皮披匹劈辟坯屁脾僻疲痞霹琵毗啤譬砒否貔丕圮媲癖仳擗郫甓枇睥蜱鼙邳陂铍庀罴埤纰陴淠噼蚍裨疋芘"
     {0x6279, 0x76ae, 0x62ab, 0x5339, 0x5288, 0x8f9f, 0x576f, 0x5c41, 0x813e, 0x50fb,
      0x75b2, 0x75de, 0x9739, 0x7435, 0x6bd7, 0x5564, 0x8b6c, 0x7812, 0x5426, 0x8c94,
      0x4e15, 0x572e, 0x5ab2, 0x7656, 0x4ef3, 0x64d7, 0x90eb, 0x7513, 0x6787, 0x7765,
      0x8731, 0x9f19, 0x90b3, 0x9642, 0x94cd, 0x5e80, 0x7f74, 0x57e4, 0x7eb0, 0x9674,
      0x6de0, 0x567c, 0x868d, 0x88e8, 0x758b, 0x8298}},
    {"pian", // L"片篇骗偏便扁翩缏犏骈胼蹁谝"
     {0x7247, 0x7bc7, 0x9a97, 0x504f, 0x4fbf, 0x6241, 0x7fe9, 0x7f0f, 0x728f, 0x9a88, 0x80fc,
      0x8e41, 0x8c1d}},
    {"piao", // L"票飘漂瓢朴螵嫖瞟殍缥嘌骠剽"
     {0x7968, 0x98d8, 0x6f02, 0x74e2, 0x6734, 0x87b5, 0x5ad6, 0x779f, 0x6b8d, 0x7f25, 0x560c,
      0x9aa0, 0x527d}},
    {"pie", // L"瞥撇氕苤"
     {0x77a5, 0x6487, 0x6c15, 0x82e4}},
    {"pin", // L"品贫聘拼频嫔榀姘牝颦"
     {0x54c1, 0x8d2b, 0x8058, 0x62fc, 0x9891, 0x5ad4, 0x6980, 0x59d8, 0x725d, 0x98a6}},
    {"ping", // L"平凭瓶评屏乒萍苹坪冯娉鲆枰俜"
     {0x5e73, 0x51ed, 0x74f6, 0x8bc4, 0x5c4f, 0x4e52, 0x840d, 0x82f9, 0x576a, 0x51af, 0x5a09,
      0x9c86, 0x67b0, 0x4fdc}},
    {"po", // L"破坡颇婆泼迫泊魄朴繁粕笸皤钋陂鄱攴叵珀钷"
     {0x7834, 0x5761, 0x9887, 0x5a46, 0x6cfc, 0x8feb, 0x6cca, 0x9b44, 0x6734, 0x7e41,
      0x7c95, 0x7b38, 0x76a4, 0x948b, 0x9642, 0x9131, 0x6534, 0x53f5, 0x73c0, 0x94b7}},
    {"pou", // L"剖掊裒"
     {0x5256, 0x638a, 0x88d2}},
    {"pu", // L"扑铺谱脯仆蒲葡朴菩曝莆瀑埔圃浦堡普暴镨噗匍溥濮氆蹼璞镤"
     {0x6251, 0x94fa, 0x8c31, 0x812f, 0x4ec6, 0x84b2, 0x8461, 0x6734, 0x83e9,
      0x66dd, 0x8386, 0x7011, 0x57d4, 0x5703, 0x6d66, 0x5821, 0x666e, 0x66b4,
      0x9568, 0x5657, 0x530d, 0x6ea5, 0x6fee, 0x6c06, 0x8e7c, 0x749e, 0x9564}},
    {"qi", // L"起其七气期齐器妻骑汽棋奇欺漆启戚柒岂砌弃泣祁凄企乞契歧祈栖畦脐崎稽迄缉沏讫旗祺颀骐屺岐蹊蕲桤憩芪荠萋芑汔亟鳍俟槭嘁蛴綦亓欹琪麒琦蜞圻杞葺碛淇耆绮綮"
     {0x8d77, 0x5176, 0x4e03, 0x6c14, 0x671f, 0x9f50, 0x5668, 0x59bb, 0x9a91, 0x6c7d, 0x68cb,
      0x5947, 0x6b3a, 0x6f06, 0x542f, 0x621a, 0x67d2, 0x5c82, 0x780c, 0x5f03, 0x6ce3, 0x7941,
      0x51c4, 0x4f01, 0x4e5e, 0x5951, 0x6b67, 0x7948, 0x6816, 0x7566, 0x8110, 0x5d0e, 0x7a3d,
      0x8fc4, 0x7f09, 0x6c8f, 0x8bab, 0x65d7, 0x797a, 0x9880, 0x9a90, 0x5c7a, 0x5c90, 0x8e4a,
      0x8572, 0x6864, 0x61a9, 0x82aa, 0x8360, 0x840b, 0x8291, 0x6c54, 0x4e9f, 0x9ccd, 0x4fdf,
      0x69ed, 0x5601, 0x86f4, 0x7da6, 0x4e93, 0x6b39, 0x742a, 0x9e92, 0x7426, 0x871e, 0x573b,
      0x675e, 0x847a, 0x789b, 0x6dc7, 0x8006, 0x7eee, 0x7dae}},
    {"qia", // L"恰卡掐洽髂袷葜"
     {0x6070, 0x5361, 0x6390, 0x6d3d, 0x9ac2, 0x88b7, 0x845c}},
    {"qian", // L"前钱千牵浅签欠铅嵌钎迁钳乾谴谦潜歉纤扦遣黔堑仟岍钤褰箝掮搴倩慊悭愆虔芡荨缱佥芊阡肷茜椠犍骞羟赶"
     {0x524d, 0x94b1, 0x5343, 0x7275, 0x6d45, 0x7b7e, 0x6b20, 0x94c5, 0x5d4c, 0x948e,
      0x8fc1, 0x94b3, 0x4e7e, 0x8c34, 0x8c26, 0x6f5c, 0x6b49, 0x7ea4, 0x6266, 0x9063,
      0x9ed4, 0x5811, 0x4edf, 0x5c8d, 0x94a4, 0x8930, 0x7b9d, 0x63ae, 0x6434, 0x5029,
      0x614a, 0x60ad, 0x6106, 0x8654, 0x82a1, 0x8368, 0x7f31, 0x4f65, 0x828a, 0x9621,
      0x80b7, 0x831c, 0x6920, 0x728d, 0x9a9e, 0x7f9f, 0x8d76}},
    {"qiang", // L"强枪墙抢腔呛羌蔷蜣跄戗襁戕炝镪锵羟樯嫱"
     {0x5f3a, 0x67aa, 0x5899, 0x62a2, 0x8154, 0x545b, 0x7f8c, 0x8537, 0x8723, 0x8dc4, 0x6217,
      0x8941, 0x6215, 0x709d, 0x956a, 0x9535, 0x7f9f, 0x6a2f, 0x5af1}},
    {"qiao", // L"桥瞧敲巧翘锹壳鞘撬悄俏窍雀乔侨峭橇樵荞跷硗憔谯鞒愀缲诮劁峤搞铫"
     {0x6865, 0x77a7, 0x6572, 0x5de7, 0x7fd8, 0x9539, 0x58f3, 0x9798, 0x64ac, 0x6084, 0x4fcf,
      0x7a8d, 0x96c0, 0x4e54, 0x4fa8, 0x5ced, 0x6a47, 0x6a35, 0x835e, 0x8df7, 0x7857, 0x6194,
      0x8c2f, 0x9792, 0x6100, 0x7f32, 0x8bee, 0x5281, 0x5ce4, 0x641e, 0x94eb}},
    {"qie", // L"切且怯窃茄郄趄惬锲妾箧慊伽挈"
     {0x5207, 0x4e14, 0x602f, 0x7a83, 0x8304, 0x90c4, 0x8d84, 0x60ec, 0x9532, 0x59be, 0x7ba7,
      0x614a, 0x4f3d, 0x6308}},
    {"qin", // L"亲琴侵勤擒寝秦芹沁禽钦吣覃矜衾芩廑嗪螓噙揿檎锓"
     {0x4eb2, 0x7434, 0x4fb5, 0x52e4, 0x64d2, 0x5bdd, 0x79e6, 0x82b9,
      0x6c81, 0x79bd, 0x94a6, 0x5423, 0x8983, 0x77dc, 0x887e, 0x82a9,
      0x5ed1, 0x55ea, 0x8793, 0x5659, 0x63ff, 0x6a8e, 0x9513}},
    {"qing", // L"请轻清青情晴氢倾庆擎顷亲卿氰圊謦檠箐苘蜻黥罄鲭磬綮"
     {0x8bf7, 0x8f7b, 0x6e05, 0x9752, 0x60c5, 0x6674, 0x6c22, 0x503e, 0x5e86,
      0x64ce, 0x9877, 0x4eb2, 0x537f, 0x6c30, 0x570a, 0x8b26, 0x6aa0, 0x7b90,
      0x82d8, 0x873b, 0x9ee5, 0x7f44, 0x9cad, 0x78ec, 0x7dae}},
    {"qiong", // L"穷琼跫穹邛蛩茕銎筇"
     {0x7a77, 0x743c, 0x8deb, 0x7a79, 0x909b, 0x86e9, 0x8315, 0x928e, 0x7b47}},
    {"qiu", // L"求球秋丘泅仇邱囚酋龟楸蚯裘糗蝤巯逑俅虬赇鳅犰湫遒"
     {0x6c42, 0x7403, 0x79cb, 0x4e18, 0x6cc5, 0x4ec7, 0x90b1, 0x56da,
      0x914b, 0x9f9f, 0x6978, 0x86af, 0x88d8, 0x7cd7, 0x8764, 0x5def,
      0x9011, 0x4fc5, 0x866c, 0x8d47, 0x9cc5, 0x72b0, 0x6e6b, 0x9052}},
    {"qu", // L"去取区娶渠曲趋趣屈驱蛆躯龋戌蠼蘧祛蕖磲劬诎鸲阒麴癯衢黢璩氍觑蛐朐瞿岖苣"
     {0x53bb, 0x53d6, 0x533a, 0x5a36, 0x6e20, 0x66f2, 0x8d8b, 0x8da3, 0x5c48,
      0x9a71, 0x86c6, 0x8eaf, 0x9f8b, 0x620c, 0x883c, 0x8627, 0x795b, 0x8556,
      0x78f2, 0x52ac, 0x8bce, 0x9e32, 0x9612, 0x9eb4, 0x766f, 0x8862, 0x9ee2,
      0x74a9, 0x6c0d, 0x89d1, 0x86d0, 0x6710, 0x77bf, 0x5c96, 0x82e3}},
    {"quan", // L"全权劝圈拳犬泉券颧痊醛铨筌绻诠辁畎鬈悛蜷荃犭"
     {0x5168, 0x6743, 0x529d, 0x5708, 0x62f3, 0x72ac, 0x6cc9, 0x5238, 0x98a7, 0x75ca, 0x919b,
      0x94e8, 0x7b4c, 0x7efb, 0x8be0, 0x8f81, 0x754e, 0x9b08, 0x609b, 0x8737, 0x8343, 0x72ad}},
    {"que", // L"却缺确雀瘸鹊炔榷阙阕悫"
     {0x5374, 0x7f3a, 0x786e, 0x96c0, 0x7638, 0x9e4a, 0x7094, 0x69b7, 0x9619, 0x9615, 0x60ab}},
    {"qun", // L"群裙麇逡"
     {0x7fa4, 0x88d9, 0x9e87, 0x9021}},
    {"ran", // L"染燃然冉髯苒蚺"
     {0x67d3, 0x71c3, 0x7136, 0x5189, 0x9aef, 0x82d2, 0x86ba}},
    {"rang", // L"让嚷瓤攘壤穰禳"
     {0x8ba9, 0x56b7, 0x74e4, 0x6518, 0x58e4, 0x7a70, 0x79b3}},
    {"rao", // L"饶绕扰荛桡娆"
     {0x9976, 0x7ed5, 0x6270, 0x835b, 0x6861, 0x5a06}},
    {"re", // L"热惹喏"
     {0x70ed, 0x60f9, 0x558f}},
    {"ren", // L"人任忍认刃仁韧妊纫壬饪轫仞荏葚衽稔亻"
     {0x4eba, 0x4efb, 0x5fcd, 0x8ba4, 0x5203, 0x4ec1, 0x97e7, 0x598a, 0x7eab, 0x58ec, 0x996a,
      0x8f6b, 0x4ede, 0x834f, 0x845a, 0x887d, 0x7a14, 0x4ebb}},
    {"reng", // L"仍扔"
     {0x4ecd, 0x6254}},
    {"ri", // L"日"
     {0x65e5}},
    {"rong", // L"容绒融溶熔荣戎蓉冗茸榕狨嵘肜蝾"
     {0x5bb9, 0x7ed2, 0x878d, 0x6eb6, 0x7194, 0x8363, 0x620e, 0x84c9, 0x5197, 0x8338, 0x6995,
      0x72e8, 0x5d58, 0x809c, 0x877e}},
    {"rou", // L"肉揉柔糅蹂鞣"
     {0x8089, 0x63c9, 0x67d4, 0x7cc5, 0x8e42, 0x97a3}},
    {"ru", // L"如入汝儒茹乳褥辱蠕孺蓐襦铷嚅缛濡薷颥溽洳"
     {0x5982, 0x5165, 0x6c5d, 0x5112, 0x8339, 0x4e73, 0x8925, 0x8fb1, 0x8815, 0x5b7a,
      0x84d0, 0x8966, 0x94f7, 0x5685, 0x7f1b, 0x6fe1, 0x85b7, 0x98a5, 0x6ebd, 0x6d33}},
    {"ruan", // L"软阮朊"
     {0x8f6f, 0x962e, 0x670a}},
    {"rui", // L"瑞蕊锐睿芮蚋枘蕤"
     {0x745e, 0x854a, 0x9510, 0x777f, 0x82ae, 0x868b, 0x6798, 0x8564}},
    {"run", // L"润闰"
     {0x6da6, 0x95f0}},
    {"ruo", // L"若弱箬偌"
     {0x82e5, 0x5f31, 0x7bac, 0x504c}},
    {"sa", // L"撒洒萨仨卅飒脎"
     {0x6492, 0x6d12, 0x8428, 0x4ee8, 0x5345, 0x98d2, 0x810e}},
    {"sai", // L"塞腮鳃赛噻"
     {0x585e, 0x816e, 0x9cc3, 0x8d5b, 0x567b}},
    {"san", // L"三散伞叁馓糁毵"
     {0x4e09, 0x6563, 0x4f1e, 0x53c1, 0x9993, 0x7cc1, 0x6bf5}},
    {"sang", // L"桑丧嗓颡磉搡"
     {0x6851, 0x4e27, 0x55d3, 0x98a1, 0x78c9, 0x6421}},
    {"sao", // L"扫嫂搔骚埽鳋臊缫瘙"
     {0x626b, 0x5ac2, 0x6414, 0x9a9a, 0x57fd, 0x9ccb, 0x81ca, 0x7f2b, 0x7619}},
    {"se", // L"色涩瑟塞啬铯穑"
     {0x8272, 0x6da9, 0x745f, 0x585e, 0x556c, 0x94ef, 0x7a51}},
    {"sen", // L"森"
     {0x68ee}},
    {"seng", // L"僧"
     {0x50e7}},
    {"sha", // L"杀沙啥纱傻砂刹莎厦煞杉唼鲨霎铩痧裟歃"
     {0x6740, 0x6c99, 0x5565, 0x7eb1, 0x50bb, 0x7802, 0x5239, 0x838e, 0x53a6, 0x715e, 0x6749,
      0x553c, 0x9ca8, 0x970e, 0x94e9, 0x75e7, 0x88df, 0x6b43}},
    {"shai", // L"晒筛色"
     {0x6652, 0x7b5b, 0x8272}},
    {"shan", // L"山闪衫善扇杉删煽单珊掺赡栅苫膳陕汕擅缮嬗蟮芟禅跚鄯潸鳝姗剡骟疝膻讪钐舢埏彡髟"
     {0x5c71, 0x95ea, 0x886b, 0x5584, 0x6247, 0x6749, 0x5220, 0x717d, 0x5355, 0x73ca,
      0x63ba, 0x8d61, 0x6805, 0x82eb, 0x81b3, 0x9655, 0x6c55, 0x64c5, 0x7f2e, 0x5b17,
      0x87ee, 0x829f, 0x7985, 0x8dda, 0x912f, 0x6f78, 0x9cdd, 0x59d7, 0x5261, 0x9a9f,
      0x759d, 0x81bb, 0x8baa, 0x9490, 0x8222, 0x57cf, 0x5f61, 0x9adf}},
    {"shang", // L"上伤尚商赏晌墒裳熵觞绱殇垧"
     {0x4e0a, 0x4f24, 0x5c1a, 0x5546, 0x8d4f, 0x664c, 0x5892, 0x88f3, 0x71b5, 0x89de, 0x7ef1,
      0x6b87, 0x57a7}},
    {"shao", // L"少烧捎哨勺梢稍邵韶绍芍鞘苕劭潲艄蛸筲"
     {0x5c11, 0x70e7, 0x634e, 0x54e8, 0x52fa, 0x68a2, 0x7a0d, 0x90b5, 0x97f6, 0x7ecd, 0x828d,
      0x9798, 0x82d5, 0x52ad, 0x6f72, 0x8244, 0x86f8, 0x7b72}},
    {"she", // L"社射蛇设舌摄舍折涉赊赦慑奢歙厍畲猞麝滠佘揲"
     {0x793e, 0x5c04, 0x86c7, 0x8bbe, 0x820c, 0x6444, 0x820d, 0x6298, 0x6d89, 0x8d4a, 0x8d66,
      0x6151, 0x5962, 0x6b59, 0x538d, 0x7572, 0x731e, 0x9e9d, 0x6ee0, 0x4f58, 0x63f2}},
    {"shei", // L"谁"
     {0x8c01}},
    {"shen", // L"身伸深婶神甚渗肾审申沈绅呻参砷什娠慎葚莘诜谂矧椹渖蜃哂胂"
     {0x8eab, 0x4f38, 0x6df1, 0x5a76, 0x795e, 0x751a, 0x6e17, 0x80be, 0x5ba1, 0x7533,
      0x6c88, 0x7ec5, 0x547b, 0x53c2, 0x7837, 0x4ec0, 0x5a20, 0x614e, 0x845a, 0x8398,
      0x8bdc, 0x8c02, 0x77e7, 0x6939, 0x6e16, 0x8703, 0x54c2, 0x80c2}},
    {"sheng", // L"声省剩生升绳胜盛圣甥牲乘晟渑眚笙嵊"
     {0x58f0, 0x7701, 0x5269, 0x751f, 0x5347, 0x7ef3, 0x80dc, 0x76db, 0x5723, 0x7525, 0x7272,
      0x4e58, 0x665f, 0x6e11, 0x771a, 0x7b19, 0x5d4a}},
    {"shi", // L"是使十时事室市石师试史式识虱矢拾屎驶始似示士世柿匙拭誓逝势什殖峙嗜噬失适仕侍释饰氏狮食恃蚀视实施湿诗尸豕莳埘铈舐鲥鲺贳轼蓍筮炻谥弑酾螫礻铊饣"
     {0x662f, 0x4f7f, 0x5341, 0x65f6, 0x4e8b, 0x5ba4, 0x5e02, 0x77f3, 0x5e08, 0x8bd5,
      0x53f2, 0x5f0f, 0x8bc6, 0x8671, 0x77e2, 0x62fe, 0x5c4e, 0x9a76, 0x59cb, 0x4f3c,
      0x793a, 0x58eb, 0x4e16, 0x67ff, 0x5319, 0x62ed, 0x8a93, 0x901d, 0x52bf, 0x4ec0,
      0x6b96, 0x5cd9, 0x55dc, 0x566c, 0x5931, 0x9002, 0x4ed5, 0x4f8d, 0x91ca, 0x9970,
      0x6c0f, 0x72ee, 0x98df, 0x6043, 0x8680, 0x89c6, 0x5b9e, 0x65bd, 0x6e7f, 0x8bd7,
      0x5c38, 0x8c55, 0x83b3, 0x57d8, 0x94c8, 0x8210, 0x9ca5, 0x9cba, 0x8d33, 0x8f7c,
      0x84cd, 0x7b6e, 0x70bb, 0x8c25, 0x5f11, 0x917e, 0x87ab, 0x793b, 0x94ca, 0x9963}},
    {"shou", // L"手受收首守瘦授兽售寿艏狩绶扌"
     {0x624b, 0x53d7, 0x6536, 0x9996, 0x5b88, 0x7626, 0x6388, 0x517d, 0x552e, 0x5bff, 0x824f,
      0x72e9, 0x7ef6, 0x624c}},
    {"shu", // L"书树数熟输梳叔属束术述蜀黍鼠淑赎孰蔬疏戍竖墅庶薯漱恕枢暑殊抒曙署舒姝摅秫纾沭毹腧塾菽殳澍倏疋镯"
     {0x4e66, 0x6811, 0x6570, 0x719f, 0x8f93, 0x68b3, 0x53d4, 0x5c5e, 0x675f, 0x672f,
      0x8ff0, 0x8700, 0x9ecd, 0x9f20, 0x6dd1, 0x8d4e, 0x5b70, 0x852c, 0x758f, 0x620d,
      0x7ad6, 0x5885, 0x5eb6, 0x85af, 0x6f31, 0x6055, 0x67a2, 0x6691, 0x6b8a, 0x6292,
      0x66d9, 0x7f72, 0x8212, 0x59dd, 0x6445, 0x79eb, 0x7ebe, 0x6cad, 0x6bf9, 0x8167,
      0x587e, 0x83fd, 0x6bb3, 0x6f8d, 0x500f, 0x758b, 0x956f}},
    {"shua", // L"刷耍唰"
     {0x5237, 0x800d, 0x5530}},
    {"shuai", // L"摔甩率帅衰蟀"
     {0x6454, 0x7529, 0x7387, 0x5e05, 0x8870, 0x87c0}},
    {"shuan", // L"栓拴闩涮"
     {0x6813, 0x62f4, 0x95e9, 0x6dae}},
    {"shuang", // L"双霜爽泷孀"
     {0x53cc, 0x971c, 0x723d, 0x6cf7, 0x5b40}},
    {"shui", // L"水睡税说氵"
     {0x6c34, 0x7761, 0x7a0e, 0x8bf4, 0x6c35}},
    {"shun", // L"顺吮瞬舜"
     {0x987a, 0x542e, 0x77ac, 0x821c}},
    {"shuo", // L"说数硕烁朔搠妁槊蒴铄"
     {0x8bf4, 0x6570, 0x7855, 0x70c1, 0x6714, 0x6420, 0x5981, 0x69ca, 0x84b4, 0x94c4}},
    {"si", // L"四死丝撕似私嘶思寺司斯伺肆饲嗣巳耜驷兕蛳厮汜锶泗笥咝鸶姒厶缌祀澌俟徙"
     {0x56db, 0x6b7b, 0x4e1d, 0x6495, 0x4f3c, 0x79c1, 0x5636, 0x601d, 0x5bfa,
      0x53f8, 0x65af, 0x4f3a, 0x8086, 0x9972, 0x55e3, 0x5df3, 0x801c, 0x9a77,
      0x5155, 0x86f3, 0x53ae, 0x6c5c, 0x9536, 0x6cd7, 0x7b25, 0x549d, 0x9e36,
      0x59d2, 0x53b6, 0x7f0c, 0x7940, 0x6f8c, 0x4fdf, 0x5f99}},
    {"song", // L"送松耸宋颂诵怂讼竦菘淞悚嵩凇崧忪"
     {0x9001, 0x677e, 0x8038, 0x5b8b, 0x9882, 0x8bf5, 0x6002, 0x8bbc, 0x7ae6, 0x83d8, 0x6dde,
      0x609a, 0x5d69, 0x51c7, 0x5d27, 0x5fea}},
    {"sou", // L"艘搜擞嗽嗾嗖飕叟薮锼馊瞍溲螋"
     {0x8258, 0x641c, 0x64de, 0x55fd, 0x55fe, 0x55d6, 0x98d5, 0x53df, 0x85ae, 0x953c, 0x998a,
      0x778d, 0x6eb2, 0x878b}},
    {"su", // L"素速诉塑宿俗苏肃粟酥缩溯僳愫簌觫稣夙嗉谡蔌涑"
     {0x7d20, 0x901f, 0x8bc9, 0x5851, 0x5bbf, 0x4fd7, 0x82cf, 0x8083, 0x7c9f, 0x9165, 0x7f29,
      0x6eaf, 0x50f3, 0x612b, 0x7c0c, 0x89eb, 0x7a23, 0x5919, 0x55c9, 0x8c21, 0x850c, 0x6d91}},
    {"suan", // L"酸算蒜狻"
     {0x9178, 0x7b97, 0x849c, 0x72fb}},
    {"sui", // L"岁随碎虽穗遂尿隋髓绥隧祟眭谇濉邃燧荽睢"
     {0x5c81, 0x968f, 0x788e, 0x867d, 0x7a57, 0x9042, 0x5c3f, 0x968b, 0x9ad3, 0x7ee5, 0x96a7,
      0x795f, 0x772d, 0x8c07, 0x6fc9, 0x9083, 0x71e7, 0x837d, 0x7762}},
    {"sun", // L"孙损笋榫荪飧狲隼"
     {0x5b59, 0x635f, 0x7b0b, 0x69ab, 0x836a, 0x98e7, 0x72f2, 0x96bc}},
    {"suo", // L"所缩锁琐索梭蓑莎唆挲睃嗍唢桫嗦娑羧"
     {0x6240, 0x7f29, 0x9501, 0x7410, 0x7d22, 0x68ad, 0x84d1, 0x838e, 0x5506, 0x6332, 0x7743,
      0x55cd, 0x5522, 0x686b, 0x55e6, 0x5a11, 0x7fa7}},
    {"ta", // L"他她它踏塔塌拓獭挞蹋溻趿鳎沓榻漯遢铊闼"
     {0x4ed6, 0x5979, 0x5b83, 0x8e0f, 0x5854, 0x584c, 0x62d3, 0x736d, 0x631e, 0x8e4b, 0x6ebb,
      0x8dbf, 0x9cce, 0x6c93, 0x69bb, 0x6f2f, 0x9062, 0x94ca, 0x95fc}},
    {"tai", // L"太抬台态胎苔泰酞汰炱肽跆鲐钛薹邰骀"
     {0x592a, 0x62ac, 0x53f0, 0x6001, 0x80ce, 0x82d4, 0x6cf0, 0x915e, 0x6c70, 0x70b1, 0x80bd,
      0x8dc6, 0x9c90, 0x949b, 0x85b9, 0x90b0, 0x9a80}},
    {"tan", // L"谈叹探滩弹碳摊潭贪坛痰毯坦炭瘫谭坍檀袒钽郯镡锬覃澹昙忐赕"
     {0x8c08, 0x53f9, 0x63a2, 0x6ee9, 0x5f39, 0x78b3, 0x644a, 0x6f6d, 0x8d2a, 0x575b,
      0x75f0, 0x6bef, 0x5766, 0x70ad, 0x762b, 0x8c2d, 0x574d, 0x6a80, 0x8892, 0x94bd,
      0x90ef, 0x9561, 0x952c, 0x8983, 0x6fb9, 0x6619, 0x5fd0, 0x8d55}},
    {"tang", // L"躺趟堂糖汤塘烫倘淌唐搪棠膛螳樘羰醣瑭镗傥饧溏耥帑铴螗铛"
     {0x8eba, 0x8d9f, 0x5802, 0x7cd6, 0x6c64, 0x5858, 0x70eb, 0x5018, 0x6dcc,
      0x5510, 0x642a, 0x68e0, 0x819b, 0x87b3, 0x6a18, 0x7fb0, 0x91a3, 0x746d,
      0x9557, 0x50a5, 0x9967, 0x6e8f, 0x8025, 0x5e11, 0x94f4, 0x8797, 0x94db}},
    {"tao", // L"套掏逃桃讨淘涛滔陶绦萄鼗洮焘啕饕韬叨"
     {0x5957, 0x638f, 0x9003, 0x6843, 0x8ba8, 0x6dd8, 0x6d9b, 0x6ed4, 0x9676, 0x7ee6, 0x8404,
      0x9f17, 0x6d2e, 0x7118, 0x5555, 0x9955, 0x97ec, 0x53e8}},
    {"te", // L"特铽忑忒"
     {0x7279, 0x94fd, 0x5fd1, 0x5fd2}},
    {"teng", // L"疼腾藤誊滕"
     {0x75bc, 0x817e, 0x85e4, 0x8a8a, 0x6ed5}},
    {"ti", // L"提替体题踢蹄剃剔梯锑啼涕嚏惕屉醍鹈绨缇倜裼逖荑悌"
     {0x63d0, 0x66ff, 0x4f53, 0x9898, 0x8e22, 0x8e44, 0x5243, 0x5254,
      0x68af, 0x9511, 0x557c, 0x6d95, 0x568f, 0x60d5, 0x5c49, 0x918d,
      0x9e48, 0x7ee8, 0x7f07, 0x501c, 0x88fc, 0x9016, 0x8351, 0x608c}},
    {"tian", // L"天田添填甜舔恬腆掭钿阗忝殄畋锘"
     {0x5929, 0x7530, 0x6dfb, 0x586b, 0x751c, 0x8214, 0x606c, 0x8146, 0x63ad, 0x94bf, 0x9617,
      0x5fdd, 0x6b84, 0x754b, 0x9518}},
    {"tiao", // L"条跳挑调迢眺龆笤祧蜩髫佻窕鲦苕粜铫"
     {0x6761, 0x8df3, 0x6311, 0x8c03, 0x8fe2, 0x773a, 0x9f86, 0x7b24, 0x7967, 0x8729, 0x9aeb,
      0x4f7b, 0x7a95, 0x9ca6, 0x82d5, 0x7c9c, 0x94eb}},
    {"tie", // L"铁贴帖萜餮锇"
     {0x94c1, 0x8d34, 0x5e16, 0x841c, 0x992e, 0x9507}},
    {"ting", // L"听停挺厅亭艇庭廷烃汀莛铤葶婷蜓梃霆"
     {0x542c, 0x505c, 0x633a, 0x5385, 0x4ead, 0x8247, 0x5ead, 0x5ef7, 0x70c3, 0x6c40, 0x839b,
      0x94e4, 0x8476, 0x5a77, 0x8713, 0x6883, 0x9706}},
    {"tong", // L"同通痛铜桶筒捅统童彤桐瞳酮潼茼仝砼峒恸佟嗵垌僮"
     {0x540c, 0x901a, 0x75db, 0x94dc, 0x6876, 0x7b52, 0x6345, 0x7edf,
      0x7ae5, 0x5f64, 0x6850, 0x77b3, 0x916e, 0x6f7c, 0x833c, 0x4edd,
      0x783c, 0x5cd2, 0x6078, 0x4f5f, 0x55f5, 0x578c, 0x50ee}},
    {"tou", // L"头偷透投钭骰亠"
     {0x5934, 0x5077, 0x900f, 0x6295, 0x94ad, 0x9ab0, 0x4ea0}},
    {"tu", // L"土图兔涂吐秃突徒凸途屠酴荼钍菟堍"
     {0x571f, 0x56fe, 0x5154, 0x6d82, 0x5410, 0x79c3, 0x7a81, 0x5f92, 0x51f8, 0x9014, 0x5c60,
      0x9174, 0x837c, 0x948d, 0x83df, 0x580d}},
    {"tuan", // L"团湍疃抟彖"
     {0x56e2, 0x6e4d, 0x7583, 0x629f, 0x5f56}},
    {"tui", // L"腿推退褪颓蜕煺"
     {0x817f, 0x63a8, 0x9000, 0x892a, 0x9893, 0x8715, 0x717a}},
    {"tun", // L"吞屯褪臀囤氽饨豚暾"
     {0x541e, 0x5c6f, 0x892a, 0x81c0, 0x56e4, 0x6c3d, 0x9968, 0x8c5a, 0x66be}},
    {"tuo", // L"拖脱托妥驮拓驼椭唾鸵陀橐柝跎乇坨佗庹酡柁鼍沱箨砣说铊"
     {0x62d6, 0x8131, 0x6258, 0x59a5, 0x9a6e, 0x62d3, 0x9a7c, 0x692d, 0x553e,
      0x9e35, 0x9640, 0x6a50, 0x67dd, 0x8dce, 0x4e47, 0x5768, 0x4f57, 0x5eb9,
      0x9161, 0x67c1, 0x9f0d, 0x6cb1, 0x7ba8, 0x7823, 0x8bf4, 0x94ca}},
    {"wa", // L"挖瓦蛙哇娃洼袜佤娲腽"
     {0x6316, 0x74e6, 0x86d9, 0x54c7, 0x5a03, 0x6d3c, 0x889c, 0x4f64, 0x5a32, 0x817d}},
    {"wai", // L"外歪崴"
     {0x5916, 0x6b6a, 0x5d34}},
    {"wan", // L"完万晚碗玩弯挽湾丸腕宛婉烷顽豌惋皖蔓莞脘蜿绾芄琬纨剜畹菀"
     {0x5b8c, 0x4e07, 0x665a, 0x7897, 0x73a9, 0x5f2f, 0x633d, 0x6e7e, 0x4e38, 0x8155,
      0x5b9b, 0x5a49, 0x70f7, 0x987d, 0x8c4c, 0x60cb, 0x7696, 0x8513, 0x839e, 0x8118,
      0x873f, 0x7efe, 0x8284, 0x742c, 0x7ea8, 0x525c, 0x7579, 0x83c0}},
    {"wang", // L"望忘王往网亡枉旺汪妄辋魍惘罔尢"
     {0x671b, 0x5fd8, 0x738b, 0x5f80, 0x7f51, 0x4ea1, 0x6789, 0x65fa, 0x6c6a, 0x5984, 0x8f8b,
      0x9b4d, 0x60d8, 0x7f54, 0x5c22}},
    {"wei", // L"为位未围喂胃微味尾伪威伟卫危违委魏唯维畏惟韦巍蔚谓尉潍纬慰桅萎苇渭葳帏艉鲔娓逶闱隈沩玮涠帷崴隗诿洧偎猥猬嵬軎韪炜煨圩薇痿囗"
     {0x4e3a, 0x4f4d, 0x672a, 0x56f4, 0x5582, 0x80c3, 0x5fae, 0x5473, 0x5c3e, 0x4f2a, 0x5a01,
      0x4f1f, 0x536b, 0x5371, 0x8fdd, 0x59d4, 0x9b4f, 0x552f, 0x7ef4, 0x754f, 0x60df, 0x97e6,
      0x5dcd, 0x851a, 0x8c13, 0x5c09, 0x6f4d, 0x7eac, 0x6170, 0x6845, 0x840e, 0x82c7, 0x6e2d,
      0x8473, 0x5e0f, 0x8249, 0x9c94, 0x5a13, 0x9036, 0x95f1, 0x9688, 0x6ca9, 0x73ae, 0x6da0,
      0x5e37, 0x5d34, 0x9697, 0x8bff, 0x6d27, 0x504e, 0x7325, 0x732c, 0x5d6c, 0x8ece, 0x97ea,
      0x709c, 0x7168, 0x5729, 0x8587, 0x75ff, 0x56d7}},
    {"wen", // L"问文闻稳温吻蚊纹瘟紊汶阌刎雯璺"
     {0x95ee, 0x6587, 0x95fb, 0x7a33, 0x6e29, 0x543b, 0x868a, 0x7eb9, 0x761f, 0x7d0a, 0x6c76,
      0x960c, 0x520e, 0x96ef, 0x74ba}},
    {"weng", // L"翁嗡瓮蕹蓊"
     {0x7fc1, 0x55e1, 0x74ee, 0x8579, 0x84ca}},
    {"wo", // L"我握窝卧挝沃蜗涡斡倭幄龌肟莴喔渥硪"
     {0x6211, 0x63e1, 0x7a9d, 0x5367, 0x631d, 0x6c83, 0x8717, 0x6da1, 0x65a1, 0x502d, 0x5e44,
      0x9f8c, 0x809f, 0x83b4, 0x5594, 0x6e25, 0x786a}},
    {"wu", // L"无五屋物舞雾误捂污悟勿钨武戊务呜伍吴午吾侮乌毋恶诬芜巫晤梧坞妩蜈牾寤兀怃阢邬唔忤骛於鋈仵杌鹜婺迕痦芴焐庑鹉鼯浯圬"
     {0x65e0, 0x4e94, 0x5c4b, 0x7269, 0x821e, 0x96fe, 0x8bef, 0x6342, 0x6c61, 0x609f,
      0x52ff, 0x94a8, 0x6b66, 0x620a, 0x52a1, 0x545c, 0x4f0d, 0x5434, 0x5348, 0x543e,
      0x4fae, 0x4e4c, 0x6bcb, 0x6076, 0x8bec, 0x829c, 0x5deb, 0x6664, 0x68a7, 0x575e,
      0x59a9, 0x8708, 0x727e, 0x5be4, 0x5140, 0x6003, 0x9622, 0x90ac, 0x5514, 0x5fe4,
      0x9a9b, 0x65bc, 0x92c8, 0x4ef5, 0x674c, 0x9e5c, 0x5a7a, 0x8fd5, 0x75e6, 0x82b4,
      0x7110, 0x5e91, 0x9e49, 0x9f2f, 0x6d6f, 0x572c}},
    {"xi", // L"西洗细吸戏系喜席稀溪熄锡膝息袭惜习嘻夕悉矽熙希檄牺晰昔媳硒铣烯析隙汐犀蜥奚浠葸饩屣玺嬉禊兮翕穸禧僖淅蓰舾蹊醯郗欷皙蟋羲茜徙隰唏曦螅歙樨阋粞熹觋菥鼷裼舄"
     {0x897f, 0x6d17, 0x7ec6, 0x5438, 0x620f, 0x7cfb, 0x559c, 0x5e2d, 0x7a00, 0x6eaa, 0x7184,
      0x9521, 0x819d, 0x606f, 0x88ad, 0x60dc, 0x4e60, 0x563b, 0x5915, 0x6089, 0x77fd, 0x7199,
      0x5e0c, 0x6a84, 0x727a, 0x6670, 0x6614, 0x5ab3, 0x7852, 0x94e3, 0x70ef, 0x6790, 0x9699,
      0x6c50, 0x7280, 0x8725, 0x595a, 0x6d60, 0x8478, 0x9969, 0x5c63, 0x73ba, 0x5b09, 0x798a,
      0x516e, 0x7fd5, 0x7a78, 0x79a7, 0x50d6, 0x6dc5, 0x84f0, 0x823e, 0x8e4a, 0x91af, 0x90d7,
      0x6b37, 0x7699, 0x87cb, 0x7fb2, 0x831c, 0x5f99, 0x96b0, 0x550f, 0x66e6, 0x8785, 0x6b59,
      0x6a28, 0x960b, 0x7c9e, 0x71b9, 0x89cb, 0x83e5, 0x9f37, 0x88fc, 0x8204}},
    {"xia", // L"下吓夏峡虾瞎霞狭匣侠辖厦暇狎柙呷黠硖罅遐瑕"
     {0x4e0b, 0x5413, 0x590f, 0x5ce1, 0x867e, 0x778e, 0x971e, 0x72ed, 0x5323, 0x4fa0, 0x8f96,
      0x53a6, 0x6687, 0x72ce, 0x67d9, 0x5477, 0x9ee0, 0x7856, 0x7f45, 0x9050, 0x7455}},
    {"xian", // L"先线县现显掀闲献嫌陷险鲜弦衔馅限咸锨仙腺贤纤宪舷涎羡铣苋藓岘痫莶籼娴蚬猃祆冼燹跣跹酰暹氙鹇筅霰洗"
     {0x5148, 0x7ebf, 0x53bf, 0x73b0, 0x663e, 0x6380, 0x95f2, 0x732e, 0x5acc, 0x9677,
      0x9669, 0x9c9c, 0x5f26, 0x8854, 0x9985, 0x9650, 0x54b8, 0x9528, 0x4ed9, 0x817a,
      0x8d24, 0x7ea4, 0x5baa, 0x8237, 0x6d8e, 0x7fa1, 0x94e3, 0x82cb, 0x85d3, 0x5c98,
      0x75eb, 0x83b6, 0x7c7c, 0x5a34, 0x86ac, 0x7303, 0x7946, 0x51bc, 0x71f9, 0x8de3,
      0x8df9, 0x9170, 0x66b9, 0x6c19, 0x9e47, 0x7b45, 0x9730, 0x6d17}},
    {"xiang", // L"想向象项响香乡相像箱巷享镶厢降翔祥橡详湘襄飨鲞骧蟓庠芗饷缃葙"
     {0x60f3, 0x5411, 0x8c61, 0x9879, 0x54cd, 0x9999, 0x4e61, 0x76f8, 0x50cf, 0x7bb1,
      0x5df7, 0x4eab, 0x9576, 0x53a2, 0x964d, 0x7fd4, 0x7965, 0x6a61, 0x8be6, 0x6e58,
      0x8944, 0x98e8, 0x9c9e, 0x9aa7, 0x87d3, 0x5ea0, 0x8297, 0x9977, 0x7f03, 0x8459}},
    {"xiao", // L"小笑消削销萧效宵晓肖孝硝淆啸霄哮嚣校魈蛸骁枵哓筱潇逍枭绡箫"
     {0x5c0f, 0x7b11, 0x6d88, 0x524a, 0x9500, 0x8427, 0x6548, 0x5bb5, 0x6653, 0x8096,
      0x5b5d, 0x785d, 0x6dc6, 0x5578, 0x9704, 0x54ee, 0x56a3, 0x6821, 0x9b48, 0x86f8,
      0x9a81, 0x67b5, 0x54d3, 0x7b71, 0x6f47, 0x900d, 0x67ad, 0x7ee1, 0x7bab}},
    {"xie", // L"写些鞋歇斜血谢卸挟屑蟹泻懈泄楔邪协械谐蝎携胁解叶绁颉缬獬榭廨撷偕瀣渫亵榍邂薤躞燮勰骱鲑"
     {0x5199, 0x4e9b, 0x978b, 0x6b47, 0x659c, 0x8840, 0x8c22, 0x5378, 0x631f, 0x5c51, 0x87f9,
      0x6cfb, 0x61c8, 0x6cc4, 0x6954, 0x90aa, 0x534f, 0x68b0, 0x8c10, 0x874e, 0x643a, 0x80c1,
      0x89e3, 0x53f6, 0x7ec1, 0x9889, 0x7f2c, 0x736c, 0x69ad, 0x5ee8, 0x64b7, 0x5055, 0x7023,
      0x6e2b, 0x4eb5, 0x698d, 0x9082, 0x85a4, 0x8e9e, 0x71ee, 0x52f0, 0x9ab1, 0x9c91}},
    {"xin", // L"新心欣信芯薪锌辛衅忻歆囟莘镡馨鑫昕忄"
     {0x65b0, 0x5fc3, 0x6b23, 0x4fe1, 0x82af, 0x85aa, 0x950c, 0x8f9b, 0x8845, 0x5ffb, 0x6b46,
      0x56df, 0x8398, 0x9561, 0x99a8, 0x946b, 0x6615, 0x5fc4}},
    {"xing", // L"性行型形星醒姓腥刑杏兴幸邢猩惺省硎悻荥陉擤荇研饧"
     {0x6027, 0x884c, 0x578b, 0x5f62, 0x661f, 0x9192, 0x59d3, 0x8165,
      0x5211, 0x674f, 0x5174, 0x5e78, 0x90a2, 0x7329, 0x60fa, 0x7701,
      0x784e, 0x60bb, 0x8365, 0x9649, 0x64e4, 0x8347, 0x7814, 0x9967}},
    {"xiong", // L"胸雄凶兄熊汹匈芎"
     {0x80f8, 0x96c4, 0x51f6, 0x5144, 0x718a, 0x6c79, 0x5308, 0x828e}},
    {"xiu", // L"修锈绣休羞宿嗅袖秀朽臭溴貅馐髹鸺咻庥岫"
     {0x4fee, 0x9508, 0x7ee3, 0x4f11, 0x7f9e, 0x5bbf, 0x55c5, 0x8896, 0x79c0, 0x673d, 0x81ed,
      0x6eb4, 0x8c85, 0x9990, 0x9af9, 0x9e3a, 0x54bb, 0x5ea5, 0x5cab}},
    {"xu", // L"许须需虚嘘蓄续序叙畜絮婿戌徐旭绪吁酗恤墟糈勖栩浒蓿顼圩洫胥醑诩溆煦盱"
     {0x8bb8, 0x987b, 0x9700, 0x865a, 0x5618, 0x84c4, 0x7eed, 0x5e8f, 0x53d9,
      0x755c, 0x7d6e, 0x5a7f, 0x620c, 0x5f90, 0x65ed, 0x7eea, 0x5401, 0x9157,
      0x6064, 0x589f, 0x7cc8, 0x52d6, 0x6829, 0x6d52, 0x84ff, 0x987c, 0x5729,
      0x6d2b, 0x80e5, 0x9191, 0x8be9, 0x6e86, 0x7166, 0x76f1}},
    {"xuan", // L"选悬旋玄宣喧轩绚眩癣券暄楦儇渲漩泫铉璇煊碹镟炫揎萱谖"
     {0x9009, 0x60ac, 0x65cb, 0x7384, 0x5ba3, 0x55a7, 0x8f69, 0x7eda, 0x7729,
      0x7663, 0x5238, 0x6684, 0x6966, 0x5107, 0x6e32, 0x6f29, 0x6ceb, 0x94c9,
      0x7487, 0x714a, 0x78b9, 0x955f, 0x70ab, 0x63ce, 0x8431, 0x8c16}},
    {"xue", // L"学雪血靴穴削薛踅噱鳕泶谑"
     {0x5b66, 0x96ea, 0x8840, 0x9774, 0x7a74, 0x524a, 0x859b, 0x8e05, 0x5671, 0x9cd5, 0x6cf6,
      0x8c11}},
    {"xun", // L"寻讯熏训循殉旬巡迅驯汛逊勋询浚巽鲟浔埙恂獯醺洵郇峋蕈薰荀窨曛徇荨"
     {0x5bfb, 0x8baf, 0x718f, 0x8bad, 0x5faa, 0x6b89, 0x65ec, 0x5de1, 0x8fc5, 0x9a6f, 0x6c5b,
      0x900a, 0x52cb, 0x8be2, 0x6d5a, 0x5dfd, 0x9c9f, 0x6d54, 0x57d9, 0x6042, 0x736f, 0x91ba,
      0x6d35, 0x90c7, 0x5ccb, 0x8548, 0x85b0, 0x8340, 0x7aa8, 0x66db, 0x5f87, 0x8368}},
    {"ya", // L"呀压牙押芽鸭轧崖哑亚涯丫雅衙鸦讶蚜垭疋砑琊桠睚娅痖岈氩伢迓揠"
     {0x5440, 0x538b, 0x7259, 0x62bc, 0x82bd, 0x9e2d, 0x8f67, 0x5d16, 0x54d1, 0x4e9a,
      0x6daf, 0x4e2b, 0x96c5, 0x8859, 0x9e26, 0x8bb6, 0x869c, 0x57ad, 0x758b, 0x7811,
      0x740a, 0x6860, 0x775a, 0x5a05, 0x75d6, 0x5c88, 0x6c29, 0x4f22, 0x8fd3, 0x63e0}},
    {"yan", // L"眼烟沿盐言演严咽淹炎掩厌宴岩研延堰验艳殷阉砚雁唁彦焰蜒衍谚燕颜阎铅焉奄芫厣阏菸魇琰滟焱赝筵腌兖剡餍恹罨檐湮偃谳胭晏闫俨郾酽鄢妍鼹崦阽嫣涎讠"
     {0x773c, 0x70df, 0x6cbf, 0x76d0, 0x8a00, 0x6f14, 0x4e25, 0x54bd, 0x6df9, 0x708e,
      0x63a9, 0x538c, 0x5bb4, 0x5ca9, 0x7814, 0x5ef6, 0x5830, 0x9a8c, 0x8273, 0x6bb7,
      0x9609, 0x781a, 0x96c1, 0x5501, 0x5f66, 0x7130, 0x8712, 0x884d, 0x8c1a, 0x71d5,
      0x989c, 0x960e, 0x94c5, 0x7109, 0x5944, 0x82ab, 0x53a3, 0x960f, 0x83f8, 0x9b47,
      0x7430, 0x6edf, 0x7131, 0x8d5d, 0x7b75, 0x814c, 0x5156, 0x5261, 0x990d, 0x6079,
      0x7f68, 0x6a90, 0x6e6e, 0x5043, 0x8c33, 0x80ed, 0x664f, 0x95eb, 0x4fe8, 0x90fe,
      0x917d, 0x9122, 0x598d, 0x9f39, 0x5d26, 0x963d, 0x5ae3, 0x6d8e, 0x8ba0}},
    {"yang", // L"样养羊洋仰扬秧氧痒杨漾阳殃央鸯佯疡炀恙徉鞅泱蛘烊怏"
     {0x6837, 0x517b, 0x7f8a, 0x6d0b, 0x4ef0, 0x626c, 0x79e7, 0x6c27, 0x75d2,
      0x6768, 0x6f3e, 0x9633, 0x6b83, 0x592e, 0x9e2f, 0x4f6f, 0x75a1, 0x7080,
      0x6059, 0x5f89, 0x9785, 0x6cf1, 0x86d8, 0x70ca, 0x600f}},
    {"yao", // L"要摇药咬腰窑舀邀妖谣遥姚瑶耀尧钥侥疟珧夭鳐鹞轺爻吆铫幺崾肴曜徭杳窈啮繇"
     {0x8981, 0x6447, 0x836f, 0x54ac, 0x8170, 0x7a91, 0x8200, 0x9080, 0x5996,
      0x8c23, 0x9065, 0x59da, 0x7476, 0x8000, 0x5c27, 0x94a5, 0x4fa5, 0x759f,
      0x73e7, 0x592d, 0x9cd0, 0x9e5e, 0x8f7a, 0x723b, 0x5406, 0x94eb, 0x5e7a,
      0x5d3e, 0x80b4, 0x66dc, 0x5fad, 0x6773, 0x7a88, 0x556e, 0x7e47}},
    {"ye", // L"也夜业野叶爷页液掖腋冶噎耶咽曳椰邪谒邺晔烨揶铘靥"
     {0x4e5f, 0x591c, 0x4e1a, 0x91ce, 0x53f6, 0x7237, 0x9875, 0x6db2,
      0x6396, 0x814b, 0x51b6, 0x564e, 0x8036, 0x54bd, 0x66f3, 0x6930,
      0x90aa, 0x8c12, 0x90ba, 0x6654, 0x70e8, 0x63f6, 0x94d8, 0x9765}},
    {"yi", // L"一以已亿衣移依易医乙仪亦椅益倚姨翼译伊遗艾胰疑沂宜异彝壹蚁谊揖铱矣翌艺抑绎邑屹尾役臆逸肄疫颐裔意毅忆义夷溢诣议怿痍镒癔怡驿旖熠酏翊欹峄圯殪咦懿噫劓诒饴漪佚咿瘗猗眙羿弈苡荑佾贻钇缢迤刈悒黟翳弋奕蜴埸挹嶷薏呓轶镱舣奇硪衤铊"
     {0x4e00, 0x4ee5, 0x5df2, 0x4ebf, 0x8863, 0x79fb, 0x4f9d, 0x6613, 0x533b, 0x4e59, 0x4eea,
      0x4ea6, 0x6905, 0x76ca, 0x501a, 0x59e8, 0x7ffc, 0x8bd1, 0x4f0a, 0x9057, 0x827e, 0x80f0,
      0x7591, 0x6c82, 0x5b9c, 0x5f02, 0x5f5d, 0x58f9, 0x8681, 0x8c0a, 0x63d6, 0x94f1, 0x77e3,
      0x7fcc, 0x827a, 0x6291, 0x7ece, 0x9091, 0x5c79, 0x5c3e, 0x5f79, 0x81c6, 0x9038, 0x8084,
      0x75ab, 0x9890, 0x88d4, 0x610f, 0x6bc5, 0x5fc6, 0x4e49, 0x5937, 0x6ea2, 0x8be3, 0x8bae,
      0x603f, 0x75cd, 0x9552, 0x7654, 0x6021, 0x9a7f, 0x65d6, 0x71a0, 0x914f, 0x7fca, 0x6b39,
      0x5cc4, 0x572f, 0x6baa, 0x54a6, 0x61ff, 0x566b, 0x5293, 0x8bd2, 0x9974, 0x6f2a, 0x4f5a,
      0x54bf, 0x7617, 0x7317, 0x7719, 0x7fbf, 0x5f08, 0x82e1, 0x8351, 0x4f7e, 0x8d3b, 0x9487,
      0x7f22, 0x8fe4, 0x5208, 0x6092, 0x9edf, 0x7ff3, 0x5f0b, 0x5955, 0x8734, 0x57f8, 0x6339,
      0x5db7, 0x858f, 0x5453, 0x8f76, 0x9571, 0x8223, 0x5947, 0x786a, 0x8864, 0x94ca}},
    {"yin", // L"因引印银音饮阴隐荫吟尹寅茵淫殷姻堙鄞喑夤胤龈吲狺垠霪蚓氤铟窨瘾洇茚廴"
     {0x56e0, 0x5f15, 0x5370, 0x94f6, 0x97f3, 0x996e, 0x9634, 0x9690, 0x836b,
      0x541f, 0x5c39, 0x5bc5, 0x8335, 0x6deb, 0x6bb7, 0x59fb, 0x5819, 0x911e,
      0x5591, 0x5924, 0x80e4, 0x9f88, 0x5432, 0x72fa, 0x57a0, 0x972a, 0x8693,
      0x6c24, 0x94df, 0x7aa8, 0x763e, 0x6d07, 0x831a, 0x5ef4}},
    {"ying", // L"应硬影营迎映蝇赢鹰英颖莹盈婴樱缨荧萤萦楹蓥瘿茔鹦媵莺璎郢嘤撄瑛滢潆嬴罂瀛膺荥颍"
     {0x5e94, 0x786c, 0x5f71, 0x8425, 0x8fce, 0x6620, 0x8747, 0x8d62, 0x9e70, 0x82f1,
      0x9896, 0x83b9, 0x76c8, 0x5a74, 0x6a31, 0x7f28, 0x8367, 0x8424, 0x8426, 0x6979,
      0x84e5, 0x763f, 0x8314, 0x9e66, 0x5ab5, 0x83ba, 0x748e, 0x90e2, 0x5624, 0x6484,
      0x745b, 0x6ee2, 0x6f46, 0x5b34, 0x7f42, 0x701b, 0x81ba, 0x8365, 0x988d}},
    {"yo", // L"哟育唷"
     {0x54df, 0x80b2, 0x5537}},
    {"yong", // L"用涌永拥蛹勇雍咏泳佣踊痈庸臃恿壅慵俑墉鳙邕喁甬饔镛"
     {0x7528, 0x6d8c, 0x6c38, 0x62e5, 0x86f9, 0x52c7, 0x96cd, 0x548f, 0x6cf3,
      0x4f63, 0x8e0a, 0x75c8, 0x5eb8, 0x81c3, 0x607f, 0x58c5, 0x6175, 0x4fd1,
      0x5889, 0x9cd9, 0x9095, 0x5581, 0x752c, 0x9954, 0x955b}},
    {"you", // L"有又由右油游幼优友铀忧尤犹诱悠邮酉佑釉幽疣攸蚰莠鱿卣黝莸猷蚴宥牖囿柚蝣莜鼬铕蝤繇呦侑尢"
     {0x6709, 0x53c8, 0x7531, 0x53f3, 0x6cb9, 0x6e38, 0x5e7c, 0x4f18, 0x53cb, 0x94c0, 0x5fe7,
      0x5c24, 0x72b9, 0x8bf1, 0x60a0, 0x90ae, 0x9149, 0x4f51, 0x91c9, 0x5e7d, 0x75a3, 0x6538,
      0x86b0, 0x83a0, 0x9c7f, 0x5363, 0x9edd, 0x83b8, 0x7337, 0x86b4, 0x5ba5, 0x7256, 0x56ff,
      0x67da, 0x8763, 0x839c, 0x9f2c, 0x94d5, 0x8764, 0x7e47, 0x5466, 0x4f91, 0x5c22}},
    {"yu", // L"与于欲鱼雨余遇语愈狱玉渔予誉育愚羽虞娱淤舆屿禹宇迂俞逾域芋郁吁盂喻峪御愉渝尉榆隅浴寓裕预豫驭蔚妪嵛雩馀阈窬鹆妤揄窳觎臾舁龉蓣煜钰谀纡於竽瑜禺聿欤俣伛圄鹬庾昱萸瘐谕鬻圉瘀熨饫毓燠腴狳菀蜮蝓吾"
     {0x4e0e, 0x4e8e, 0x6b32, 0x9c7c, 0x96e8, 0x4f59, 0x9047, 0x8bed, 0x6108, 0x72f1, 0x7389,
      0x6e14, 0x4e88, 0x8a89, 0x80b2, 0x611a, 0x7fbd, 0x865e, 0x5a31, 0x6de4, 0x8206, 0x5c7f,
      0x79b9, 0x5b87, 0x8fc2, 0x4fde, 0x903e, 0x57df, 0x828b, 0x90c1, 0x5401, 0x76c2, 0x55bb,
      0x5cea, 0x5fa1, 0x6109, 0x6e1d, 0x5c09, 0x6986, 0x9685, 0x6d74, 0x5bd3, 0x88d5, 0x9884,
      0x8c6b, 0x9a6d, 0x851a, 0x59aa, 0x5d5b, 0x96e9, 0x9980, 0x9608, 0x7aac, 0x9e46, 0x59a4,
      0x63c4, 0x7ab3, 0x89ce, 0x81fe, 0x8201, 0x9f89, 0x84e3, 0x715c, 0x94b0, 0x8c00, 0x7ea1,
      0x65bc, 0x7afd, 0x745c, 0x79ba, 0x807f, 0x6b24, 0x4fe3, 0x4f1b, 0x5704, 0x9e6c, 0x5ebe,
      0x6631, 0x8438, 0x7610, 0x8c15, 0x9b3b, 0x5709, 0x7600, 0x71a8, 0x996b, 0x6bd3, 0x71e0,
      0x8174, 0x72f3, 0x83c0, 0x872e, 0x8753, 0x543e}},
    {"yuan", // L"远员元院圆原愿园援猿怨冤源缘袁渊苑垣鸳辕圜鼋橼媛爰眢鸢掾芫沅瑗螈箢塬"
     {0x8fdc, 0x5458, 0x5143, 0x9662, 0x5706, 0x539f, 0x613f, 0x56ed, 0x63f4,
      0x733f, 0x6028, 0x51a4, 0x6e90, 0x7f18, 0x8881, 0x6e0a, 0x82d1, 0x57a3,
      0x9e33, 0x8f95, 0x571c, 0x9f0b, 0x6a7c, 0x5a9b, 0x7230, 0x7722, 0x9e22,
      0x63be, 0x82ab, 0x6c85, 0x7457, 0x8788, 0x7ba2, 0x586c}},
    {"yue", // L"月越约跃阅乐岳悦曰说粤钥瀹钺刖龠栎樾哕"
     {0x6708, 0x8d8a, 0x7ea6, 0x8dc3, 0x9605, 0x4e50, 0x5cb3, 0x60a6, 0x66f0, 0x8bf4, 0x7ca4,
      0x94a5, 0x7039, 0x94ba, 0x5216, 0x9fa0, 0x680e, 0x6a3e, 0x54d5}},
    {"yun", // L"云运晕允匀韵陨孕耘蕴酝郧员氲恽愠郓芸筠韫昀狁殒纭熨"
     {0x4e91, 0x8fd0, 0x6655, 0x5141, 0x5300, 0x97f5, 0x9668, 0x5b55, 0x8018,
      0x8574, 0x915d, 0x90e7, 0x5458, 0x6c32, 0x607d, 0x6120, 0x90d3, 0x82b8,
      0x7b60, 0x97eb, 0x6600, 0x72c1, 0x6b92, 0x7ead, 0x71a8}},
    {"za", // L"杂砸咋匝扎咂拶"
     {0x6742, 0x7838, 0x548b, 0x531d, 0x624e, 0x5482, 0x62f6}},
    {"zai", // L"在再灾载栽宰哉甾崽"
     {0x5728, 0x518d, 0x707e, 0x8f7d, 0x683d, 0x5bb0, 0x54c9, 0x753e, 0x5d3d}},
    {"zan", // L"咱暂攒赞簪趱糌瓒拶昝錾"
     {0x54b1, 0x6682, 0x6512, 0x8d5e, 0x7c2a, 0x8db1, 0x7ccc, 0x74d2, 0x62f6, 0x661d, 0x933e}},
    {"zang", // L"脏葬赃藏臧驵"
     {0x810f, 0x846c, 0x8d43, 0x85cf, 0x81e7, 0x9a75}},
    {"zao", // L"早造遭糟灶燥枣凿躁藻皂噪澡蚤唣"
     {0x65e9, 0x9020, 0x906d, 0x7cdf, 0x7076, 0x71e5, 0x67a3, 0x51ff, 0x8e81, 0x85fb, 0x7682,
      0x566a, 0x6fa1, 0x86a4, 0x5523}},
    {"ze", // L"则责择泽咋箦舴帻迮啧仄昃笮赜"
     {0x5219, 0x8d23, 0x62e9, 0x6cfd, 0x548b, 0x7ba6, 0x8234, 0x5e3b, 0x8fee, 0x5567, 0x4ec4,
      0x6603, 0x7b2e, 0x8d5c}},
    {"zei", // L"贼"
     {0x8d3c}},
    {"zen", // L"怎谮"
     {0x600e, 0x8c2e}},
    {"zeng", // L"增赠憎曾缯罾甑锃"
     {0x589e, 0x8d60, 0x618e, 0x66fe, 0x7f2f, 0x7f7e, 0x7511, 0x9503}},
    {"zha", // L"扎炸渣闸眨榨乍轧诈铡札查栅咋喳砟痄吒哳楂蚱揸喋柞咤齄龃"
     {0x624e, 0x70b8, 0x6e23, 0x95f8, 0x7728, 0x69a8, 0x4e4d, 0x8f67, 0x8bc8,
      0x94e1, 0x672d, 0x67e5, 0x6805, 0x548b, 0x55b3, 0x781f, 0x75c4, 0x5412,
      0x54f3, 0x6942, 0x86b1, 0x63f8, 0x558b, 0x67de, 0x54a4, 0x9f44, 0x9f83}},
    {"zhai", // L"摘窄债斋寨择翟宅砦瘵"
     {0x6458, 0x7a84, 0x503a, 0x658b, 0x5be8, 0x62e9, 0x7fdf, 0x5b85, 0x7826, 0x7635}},
    {"zhan", // L"站占战盏沾粘毡展栈詹颤蘸湛绽斩辗崭瞻谵搌旃骣"
     {0x7ad9, 0x5360, 0x6218, 0x76cf, 0x6cbe, 0x7c98, 0x6be1, 0x5c55, 0x6808, 0x8a79, 0x98a4,
      0x8638, 0x6e5b, 0x7efd, 0x65a9, 0x8f97, 0x5d2d, 0x77bb, 0x8c35, 0x640c, 0x65c3, 0x9aa3}},
    {"zhang", // L"张章长帐仗丈掌涨账樟杖彰漳胀瘴障仉嫜幛鄣璋嶂獐蟑"
     {0x5f20, 0x7ae0, 0x957f, 0x5e10, 0x4ed7, 0x4e08, 0x638c, 0x6da8,
      0x8d26, 0x6a1f, 0x6756, 0x5f70, 0x6f33, 0x80c0, 0x7634, 0x969c,
      0x4ec9, 0x5adc, 0x5e5b, 0x9123, 0x748b, 0x5d82, 0x7350, 0x87d1}},
    {"zhao", // L"找着照招罩爪兆朝昭沼肇召赵棹啁钊笊诏"
     {0x627e, 0x7740, 0x7167, 0x62db, 0x7f69, 0x722a, 0x5146, 0x671d, 0x662d, 0x6cbc, 0x8087,
      0x53ec, 0x8d75, 0x68f9, 0x5541, 0x948a, 0x7b0a, 0x8bcf}},
    {"zhe", // L"着这者折遮蛰哲蔗锗辙浙柘辄赭摺鹧磔褶蜇谪"
     {0x7740, 0x8fd9, 0x8005, 0x6298, 0x906e, 0x86f0, 0x54f2, 0x8517, 0x9517, 0x8f99,
      0x6d59, 0x67d8, 0x8f84, 0x8d6d, 0x647a, 0x9e67, 0x78d4, 0x8936, 0x8707, 0x8c2a}},
    {"zhen", // L"真阵镇针震枕振斟珍疹诊甄砧臻贞侦缜蓁祯箴轸榛稹赈朕鸩胗浈桢畛圳椹溱"
     {0x771f, 0x9635, 0x9547, 0x9488, 0x9707, 0x6795, 0x632f, 0x659f, 0x73cd, 0x75b9, 0x8bca,
      0x7504, 0x7827, 0x81fb, 0x8d1e, 0x4fa6, 0x7f1c, 0x84c1, 0x796f, 0x7bb4, 0x8f78, 0x699b,
      0x7a39, 0x8d48, 0x6715, 0x9e29, 0x80d7, 0x6d48, 0x6862, 0x755b, 0x5733, 0x6939, 0x6eb1}},
    {"zheng", // L"正整睁争挣征怔证症郑拯蒸狰政峥钲铮筝诤徵鲭"
     {0x6b63, 0x6574, 0x7741, 0x4e89, 0x6323, 0x5f81, 0x6014, 0x8bc1, 0x75c7, 0x90d1, 0x62ef,
      0x84b8, 0x72f0, 0x653f, 0x5ce5, 0x94b2, 0x94ee, 0x7b5d, 0x8be4, 0x5fb5, 0x9cad}},
    {"zhi", // L"只之直知制指纸支芝枝稚吱蜘质肢脂汁炙织职痔植抵殖执值侄址滞止趾治旨窒志挚掷至致置帜识峙智秩帙摭黹桎枳轵忮祉蛭膣觯郅栀彘芷祗咫鸷絷踬胝骘轾痣陟踯雉埴贽卮酯豸跖栉夂徵"
     {0x53ea, 0x4e4b, 0x76f4, 0x77e5, 0x5236, 0x6307, 0x7eb8, 0x652f, 0x829d, 0x679d, 0x7a1a,
      0x5431, 0x8718, 0x8d28, 0x80a2, 0x8102, 0x6c41, 0x7099, 0x7ec7, 0x804c, 0x75d4, 0x690d,
      0x62b5, 0x6b96, 0x6267, 0x503c, 0x4f84, 0x5740, 0x6ede, 0x6b62, 0x8dbe, 0x6cbb, 0x65e8,
      0x7a92, 0x5fd7, 0x631a, 0x63b7, 0x81f3, 0x81f4, 0x7f6e, 0x5e1c, 0x8bc6, 0x5cd9, 0x667a,
      0x79e9, 0x5e19, 0x646d, 0x9ef9, 0x684e, 0x67b3, 0x8f75, 0x5fee, 0x7949, 0x86ed, 0x81a3,
      0x89ef, 0x90c5, 0x6800, 0x5f58, 0x82b7, 0x7957, 0x54ab, 0x9e37, 0x7d77, 0x8e2c, 0x80dd,
      0x9a98, 0x8f7e, 0x75e3, 0x965f, 0x8e2f, 0x96c9, 0x57f4, 0x8d3d, 0x536e, 0x916f, 0x8c78,
      0x8dd6, 0x6809, 0x5902, 0x5fb5}},
    {"zhong", // L"中重种钟肿众终盅忠仲衷踵舯螽锺冢忪"
     {0x4e2d, 0x91cd, 0x79cd, 0x949f, 0x80bf, 0x4f17, 0x7ec8, 0x76c5, 0x5fe0, 0x4ef2, 0x8877,
      0x8e35, 0x822f, 0x87bd, 0x953a, 0x51a2, 0x5fea}},
    {"zhou", // L"周洲皱粥州轴舟昼骤宙诌肘帚咒繇胄纣荮啁碡绉籀妯酎"
     {0x5468, 0x6d32, 0x76b1, 0x7ca5, 0x5dde, 0x8f74, 0x821f, 0x663c,
      0x9aa4, 0x5b99, 0x8bcc, 0x8098, 0x5e1a, 0x5492, 0x7e47, 0x80c4,
      0x7ea3, 0x836e, 0x5541, 0x78a1, 0x7ec9, 0x7c40, 0x59af, 0x914e}},
    {"zhu", // L"住主猪竹株煮筑著贮铸嘱拄注祝驻属术珠瞩蛛朱柱诸诛逐助烛蛀潴洙伫瘃翥茱苎橥舳杼箸炷侏铢疰渚褚躅麈邾槠竺丶"
     {0x4f4f, 0x4e3b, 0x732a, 0x7af9, 0x682a, 0x716e, 0x7b51, 0x8457, 0x8d2e, 0x94f8, 0x5631,
      0x62c4, 0x6ce8, 0x795d, 0x9a7b, 0x5c5e, 0x672f, 0x73e0, 0x77a9, 0x86db, 0x6731, 0x67f1,
      0x8bf8, 0x8bdb, 0x9010, 0x52a9, 0x70db, 0x86c0, 0x6f74, 0x6d19, 0x4f2b, 0x7603, 0x7fe5,
      0x8331, 0x82ce, 0x6a65, 0x8233, 0x677c, 0x7bb8, 0x70b7, 0x4f8f, 0x94e2, 0x75b0, 0x6e1a,
      0x891a, 0x8e85, 0x9e88, 0x90be, 0x69e0, 0x7afa, 0x4e36}},
    {"zhua", // L"抓爪挝"
     {0x6293, 0x722a, 0x631d}},
    {"zhuai", // L"拽转"
     {0x62fd, 0x8f6c}},
    {"zhuan", // L"转专砖赚传撰篆颛馔啭沌"
     {0x8f6c, 0x4e13, 0x7816, 0x8d5a, 0x4f20, 0x64b0, 0x7bc6, 0x989b, 0x9994, 0x556d, 0x6c8c}},
    {"zhuang", // L"装撞庄壮桩状幢妆奘戆"
     {0x88c5, 0x649e, 0x5e84, 0x58ee, 0x6869, 0x72b6, 0x5e62, 0x5986, 0x5958, 0x6206}},
    {"zhui", // L"追坠缀锥赘椎骓惴缒隹"
     {0x8ffd, 0x5760, 0x7f00, 0x9525, 0x8d58, 0x690e, 0x9a93, 0x60f4, 0x7f12, 0x96b9}},
    {"zhun", // L"准谆肫窀饨"
     {0x51c6, 0x8c06, 0x80ab, 0x7a80, 0x9968}},
    {"zhuo", // L"捉桌着啄拙灼浊卓琢茁酌擢焯濯诼浞涿倬镯禚斫淖"
     {0x6349, 0x684c, 0x7740, 0x5544, 0x62d9, 0x707c, 0x6d4a, 0x5353, 0x7422, 0x8301, 0x914c,
      0x64e2, 0x712f, 0x6fef, 0x8bfc, 0x6d5e, 0x6dbf, 0x502c, 0x956f, 0x799a, 0x65ab, 0x6dd6}},
    {"zi", // L"字自子紫籽资姿吱滓仔兹咨孜渍滋淄笫粢龇秭恣谘趑缁梓鲻锱孳耔觜髭赀茈訾嵫眦姊辎"
     {0x5b57, 0x81ea, 0x5b50, 0x7d2b, 0x7c7d, 0x8d44, 0x59ff, 0x5431, 0x6ed3, 0x4ed4,
      0x5179, 0x54a8, 0x5b5c, 0x6e0d, 0x6ecb, 0x6dc4, 0x7b2b, 0x7ca2, 0x9f87, 0x79ed,
      0x6063, 0x8c18, 0x8d91, 0x7f01, 0x6893, 0x9cbb, 0x9531, 0x5b73, 0x8014, 0x89dc,
      0x9aed, 0x8d40, 0x8308, 0x8a3e, 0x5d6b, 0x7726, 0x59ca, 0x8f8e}},
    {"zong", // L"总纵宗棕综踪鬃偬粽枞腙"
     {0x603b, 0x7eb5, 0x5b97, 0x68d5, 0x7efc, 0x8e2a, 0x9b03, 0x506c, 0x7cbd, 0x679e, 0x8159}},
    {"zou", // L"走揍奏邹鲰鄹陬驺诹"
     {0x8d70, 0x63cd, 0x594f, 0x90b9, 0x9cb0, 0x9139, 0x966c, 0x9a7a, 0x8bf9}},
    {"zu", // L"组族足阻租祖诅菹镞卒俎"
     {0x7ec4, 0x65cf, 0x8db3, 0x963b, 0x79df, 0x7956, 0x8bc5, 0x83f9, 0x955e, 0x5352, 0x4fce}},
    {"zuan", // L"钻纂缵躜攥"
     {0x94bb, 0x7e82, 0x7f35, 0x8e9c, 0x6525}},
    {"zui", // L"最嘴醉罪觜蕞"
     {0x6700, 0x5634, 0x9189, 0x7f6a, 0x89dc, 0x855e}},
    {"zun", // L"尊遵鳟撙樽"
     {0x5c0a, 0x9075, 0x9cdf, 0x6499, 0x6a3d}},
    {"zuo", // L"做作坐左座昨琢撮佐嘬酢唑祚胙怍阼柞砟"
     {0x505a, 0x4f5c, 0x5750, 0x5de6, 0x5ea7, 0x6628, 0x7422, 0x64ae, 0x4f50, 0x562c, 0x9162,
      0x5511, 0x795a, 0x80d9, 0x600d, 0x963c, 0x67de, 0x781f}},
};

CInputCodingTableBasePY::CInputCodingTableBasePY()
{
  m_codechars = "abcdefghijklmnopqrstuvwxyz";
}

std::vector<std::wstring> CInputCodingTableBasePY::GetResponse(int)
{
  return m_words;
}

bool CInputCodingTableBasePY::GetWordListPage(const std::string& strCode, bool isFirstPage)
{
  if (!isFirstPage)
    return false;

  m_words.clear();
  auto finder = codemap.find(strCode);
  if (finder != codemap.end())
  {
    for (unsigned int i = 0; i < finder->second.size(); i++)
    {
      m_words.push_back(finder->second.substr(i, 1));
    }
  }
  CGUIMessage msg(GUI_MSG_CODINGTABLE_LOOKUP_COMPLETED, 0, 0, 0);
  msg.SetStringParam(strCode);
  CServiceBroker::GetGUI()->GetWindowManager().SendThreadMessage(
      msg, CServiceBroker::GetGUI()->GetWindowManager().GetActiveWindowOrDialog());
  return true;
}
