/* Hey EMACS -*- linux-c -*- */
/* $Id: keys83p.c 2385 2006-05-26 07:44:30Z roms $ */

/*  libticalcs - Ti Calculator library, a part of the TiLP project
 *  Copyright (C) 1999-2007  Romain Livin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "ticalcs.h"
#include "keys86.h"

/*
  Conversion of an ASCII code into a TI key
  This table is very incomplete. It contains most of ASCII chars only.
*/
extern const CalcKey TI86_KEYS[] =
{
/* 0x00 */
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"Enter", {"Enter", KEY86_Enter}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
/* 0x10 */
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"ESC", {"Exit", KEY86_Exit}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
/* 0x20 */
  {" ", {"Space", KEY86_Space}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"!", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"\"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"#", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"$", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"%", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"&", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"'", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"(", {"LParen", KEY86_LParen}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {")", {"RParen", KEY86_RParen}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"*", {"Mul", KEY86_Mul}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"+", {"Add", KEY86_Add}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {",", {"Comma", KEY86_Comma}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"-", {"Sub", KEY86_Sub}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {".", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"/", {"Div", KEY86_Div}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
/* 0x30 */
  {"0", {"0", KEY86_0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"1", {"1", KEY86_1}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"2", {"2", KEY86_2}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"3", {"3", KEY86_3}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"4", {"4", KEY86_4}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"5", {"5", KEY86_5}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"6", {"6", KEY86_6}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"7", {"7", KEY86_7}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"8", {"8", KEY86_8}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"9", {"9", KEY86_9}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {":", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {";", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"<", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"=", {"=", KEY86_Equal}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {">", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"?", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
/* 0x40 */
  {"@", {"@", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"A", {"A", KEY86_CapA}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"B", {"B", KEY86_CapB}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"C", {"C", KEY86_CapC}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"D", {"D", KEY86_CapD}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"E", {"E", KEY86_CapE}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"F", {"F", KEY86_CapF}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"G", {"G", KEY86_CapG}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"H", {"H", KEY86_CapH}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"I", {"I", KEY86_CapI}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"J", {"J", KEY86_CapJ}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"K", {"K", KEY86_CapK}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"L", {"L", KEY86_CapL}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"M", {"M", KEY86_CapM}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"N", {"N", KEY86_CapN}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"O", {"O", KEY86_CapO}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
/* 0x50 */
  {"P", {"P", KEY86_CapP}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"Q", {"Q", KEY86_CapQ}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"R", {"R", KEY86_CapR}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"S", {"S", KEY86_CapS}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"T", {"T", KEY86_CapT}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"U", {"U", KEY86_CapU}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"V", {"V", KEY86_CapV}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"W", {"W", KEY86_CapW}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"X", {"X", KEY86_CapX}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"Y", {"Y", KEY86_CapY}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"Z", {"Z", KEY86_CapZ}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"[", {"LBrack", KEY86_LBrack}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"\\", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"]", {"RBrack", KEY86_RBrack}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"^", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"_", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
/* 0x60 */
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"a", {"a", KEY86_a}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"b", {"b", KEY86_b}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"c", {"c", KEY86_c}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"d", {"d", KEY86_d}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"e", {"e", KEY86_e}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"f", {"f", KEY86_f}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"g", {"g", KEY86_g}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"h", {"h", KEY86_h}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"i", {"i", KEY86_i}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"j", {"j", KEY86_j}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"k", {"k", KEY86_k}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"l", {"l", KEY86_l}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"m", {"m", KEY86_m}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"n", {"n", KEY86_n}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"o", {"o", KEY86_o}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
/* 0x70 */
  {"p", {"p", KEY86_p}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"q", {"q", KEY86_q}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"r", {"r", KEY86_r}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"s", {"s", KEY86_s}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"t", {"t", KEY86_t}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"u", {"u", KEY86_u}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"v", {"v", KEY86_v}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"w", {"w", KEY86_w}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"x", {"x", KEY86_x}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"y", {"y", KEY86_y}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"z", {"z", KEY86_z}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"{", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"|", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"}", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"~", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
/* 0x80 */
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"\173", {"Ans", KEY86_Ans}, {"\173", 173}, {"ANS", 4372}, {"", 8365}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
/* 0x90 */
};
