"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import meshtastic.protobuf.device_ui_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Config(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class DeviceConfig(google.protobuf.message.Message):
        """
        Configuration
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Role:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _RoleEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Config.DeviceConfig._Role.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            CLIENT: Config.DeviceConfig._Role.ValueType  # 0
            """
            Description: App connected or stand alone messaging device.
            Technical Details: Default Role
            """
            CLIENT_MUTE: Config.DeviceConfig._Role.ValueType  # 1
            """
             Description: Device that does not forward packets from other devices.
            """
            ROUTER: Config.DeviceConfig._Role.ValueType  # 2
            """
            Description: Infrastructure node for extending network coverage by relaying messages. Visible in Nodes list.
            Technical Details: Mesh packets will prefer to be routed over this node. This node will not be used by client apps.
              The wifi radio and the oled screen will be put to sleep.
              This mode may still potentially have higher power usage due to it's preference in message rebroadcasting on the mesh.
            """
            ROUTER_CLIENT: Config.DeviceConfig._Role.ValueType  # 3
            """
            Description: Combination of both ROUTER and CLIENT. Not for mobile devices.
            Deprecated in v2.3.15 because improper usage is impacting public meshes: Use ROUTER or CLIENT instead.
            """
            REPEATER: Config.DeviceConfig._Role.ValueType  # 4
            """
            Description: Infrastructure node for extending network coverage by relaying messages with minimal overhead. Not visible in Nodes list.
            Technical Details: Mesh packets will simply be rebroadcasted over this node. Nodes configured with this role will not originate NodeInfo, Position, Telemetry
              or any other packet type. They will simply rebroadcast any mesh packets on the same frequency, channel num, spread factor, and coding rate.
            Deprecated in v2.7.11 because it creates "holes" in the mesh rebroadcast chain.
            """
            TRACKER: Config.DeviceConfig._Role.ValueType  # 5
            """
            Description: Broadcasts GPS position packets as priority.
            Technical Details: Position Mesh packets will be prioritized higher and sent more frequently by default.
              When used in conjunction with power.is_power_saving = true, nodes will wake up,
              send position, and then sleep for position.position_broadcast_secs seconds.
            """
            SENSOR: Config.DeviceConfig._Role.ValueType  # 6
            """
            Description: Broadcasts telemetry packets as priority.
            Technical Details: Telemetry Mesh packets will be prioritized higher and sent more frequently by default.
              When used in conjunction with power.is_power_saving = true, nodes will wake up,
              send environment telemetry, and then sleep for telemetry.environment_update_interval seconds.
            """
            TAK: Config.DeviceConfig._Role.ValueType  # 7
            """
            Description: Optimized for ATAK system communication and reduces routine broadcasts.
            Technical Details: Used for nodes dedicated for connection to an ATAK EUD.
               Turns off many of the routine broadcasts to favor CoT packet stream
               from the Meshtastic ATAK plugin -> IMeshService -> Node
            """
            CLIENT_HIDDEN: Config.DeviceConfig._Role.ValueType  # 8
            """
            Description: Device that only broadcasts as needed for stealth or power savings.
            Technical Details: Used for nodes that "only speak when spoken to"
               Turns all of the routine broadcasts but allows for ad-hoc communication
               Still rebroadcasts, but with local only rebroadcast mode (known meshes only)
               Can be used for clandestine operation or to dramatically reduce airtime / power consumption
            """
            LOST_AND_FOUND: Config.DeviceConfig._Role.ValueType  # 9
            """
            Description: Broadcasts location as message to default channel regularly for to assist with device recovery.
            Technical Details: Used to automatically send a text message to the mesh
               with the current position of the device on a frequent interval:
               "I'm lost! Position: lat / long"
            """
            TAK_TRACKER: Config.DeviceConfig._Role.ValueType  # 10
            """
            Description: Enables automatic TAK PLI broadcasts and reduces routine broadcasts.
            Technical Details: Turns off many of the routine broadcasts to favor ATAK CoT packet stream
               and automatic TAK PLI (position location information) broadcasts.
               Uses position module configuration to determine TAK PLI broadcast interval.
            """
            ROUTER_LATE: Config.DeviceConfig._Role.ValueType  # 11
            """
            Description: Will always rebroadcast packets, but will do so after all other modes.
            Technical Details: Used for router nodes that are intended to provide additional coverage
               in areas not already covered by other routers, or to bridge around problematic terrain,
               but should not be given priority over other routers in order to avoid unnecessaraily
               consuming hops.
            """
            CLIENT_BASE: Config.DeviceConfig._Role.ValueType  # 12
            """
            Description: Treats packets from or to favorited nodes as ROUTER, and all other packets as CLIENT.
            Technical Details: Used for stronger attic/roof nodes to distribute messages more widely
               from weaker, indoor, or less-well-positioned nodes. Recommended for users with multiple nodes
               where one CLIENT_BASE acts as a more powerful base station, such as an attic/roof node.
            """

        class Role(_Role, metaclass=_RoleEnumTypeWrapper):
            """
            Defines the device's role on the Mesh network
            """

        CLIENT: Config.DeviceConfig.Role.ValueType  # 0
        """
        Description: App connected or stand alone messaging device.
        Technical Details: Default Role
        """
        CLIENT_MUTE: Config.DeviceConfig.Role.ValueType  # 1
        """
         Description: Device that does not forward packets from other devices.
        """
        ROUTER: Config.DeviceConfig.Role.ValueType  # 2
        """
        Description: Infrastructure node for extending network coverage by relaying messages. Visible in Nodes list.
        Technical Details: Mesh packets will prefer to be routed over this node. This node will not be used by client apps.
          The wifi radio and the oled screen will be put to sleep.
          This mode may still potentially have higher power usage due to it's preference in message rebroadcasting on the mesh.
        """
        ROUTER_CLIENT: Config.DeviceConfig.Role.ValueType  # 3
        """
        Description: Combination of both ROUTER and CLIENT. Not for mobile devices.
        Deprecated in v2.3.15 because improper usage is impacting public meshes: Use ROUTER or CLIENT instead.
        """
        REPEATER: Config.DeviceConfig.Role.ValueType  # 4
        """
        Description: Infrastructure node for extending network coverage by relaying messages with minimal overhead. Not visible in Nodes list.
        Technical Details: Mesh packets will simply be rebroadcasted over this node. Nodes configured with this role will not originate NodeInfo, Position, Telemetry
          or any other packet type. They will simply rebroadcast any mesh packets on the same frequency, channel num, spread factor, and coding rate.
        Deprecated in v2.7.11 because it creates "holes" in the mesh rebroadcast chain.
        """
        TRACKER: Config.DeviceConfig.Role.ValueType  # 5
        """
        Description: Broadcasts GPS position packets as priority.
        Technical Details: Position Mesh packets will be prioritized higher and sent more frequently by default.
          When used in conjunction with power.is_power_saving = true, nodes will wake up,
          send position, and then sleep for position.position_broadcast_secs seconds.
        """
        SENSOR: Config.DeviceConfig.Role.ValueType  # 6
        """
        Description: Broadcasts telemetry packets as priority.
        Technical Details: Telemetry Mesh packets will be prioritized higher and sent more frequently by default.
          When used in conjunction with power.is_power_saving = true, nodes will wake up,
          send environment telemetry, and then sleep for telemetry.environment_update_interval seconds.
        """
        TAK: Config.DeviceConfig.Role.ValueType  # 7
        """
        Description: Optimized for ATAK system communication and reduces routine broadcasts.
        Technical Details: Used for nodes dedicated for connection to an ATAK EUD.
           Turns off many of the routine broadcasts to favor CoT packet stream
           from the Meshtastic ATAK plugin -> IMeshService -> Node
        """
        CLIENT_HIDDEN: Config.DeviceConfig.Role.ValueType  # 8
        """
        Description: Device that only broadcasts as needed for stealth or power savings.
        Technical Details: Used for nodes that "only speak when spoken to"
           Turns all of the routine broadcasts but allows for ad-hoc communication
           Still rebroadcasts, but with local only rebroadcast mode (known meshes only)
           Can be used for clandestine operation or to dramatically reduce airtime / power consumption
        """
        LOST_AND_FOUND: Config.DeviceConfig.Role.ValueType  # 9
        """
        Description: Broadcasts location as message to default channel regularly for to assist with device recovery.
        Technical Details: Used to automatically send a text message to the mesh
           with the current position of the device on a frequent interval:
           "I'm lost! Position: lat / long"
        """
        TAK_TRACKER: Config.DeviceConfig.Role.ValueType  # 10
        """
        Description: Enables automatic TAK PLI broadcasts and reduces routine broadcasts.
        Technical Details: Turns off many of the routine broadcasts to favor ATAK CoT packet stream
           and automatic TAK PLI (position location information) broadcasts.
           Uses position module configuration to determine TAK PLI broadcast interval.
        """
        ROUTER_LATE: Config.DeviceConfig.Role.ValueType  # 11
        """
        Description: Will always rebroadcast packets, but will do so after all other modes.
        Technical Details: Used for router nodes that are intended to provide additional coverage
           in areas not already covered by other routers, or to bridge around problematic terrain,
           but should not be given priority over other routers in order to avoid unnecessaraily
           consuming hops.
        """
        CLIENT_BASE: Config.DeviceConfig.Role.ValueType  # 12
        """
        Description: Treats packets from or to favorited nodes as ROUTER, and all other packets as CLIENT.
        Technical Details: Used for stronger attic/roof nodes to distribute messages more widely
           from weaker, indoor, or less-well-positioned nodes. Recommended for users with multiple nodes
           where one CLIENT_BASE acts as a more powerful base station, such as an attic/roof node.
        """

        class _RebroadcastMode:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _RebroadcastModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Config.DeviceConfig._RebroadcastMode.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            ALL: Config.DeviceConfig._RebroadcastMode.ValueType  # 0
            """
            Default behavior.
            Rebroadcast any observed message, if it was on our private channel or from another mesh with the same lora params.
            """
            ALL_SKIP_DECODING: Config.DeviceConfig._RebroadcastMode.ValueType  # 1
            """
            Same as behavior as ALL but skips packet decoding and simply rebroadcasts them.
            Only available in Repeater role. Setting this on any other roles will result in ALL behavior.
            """
            LOCAL_ONLY: Config.DeviceConfig._RebroadcastMode.ValueType  # 2
            """
            Ignores observed messages from foreign meshes that are open or those which it cannot decrypt.
            Only rebroadcasts message on the nodes local primary / secondary channels.
            """
            KNOWN_ONLY: Config.DeviceConfig._RebroadcastMode.ValueType  # 3
            """
            Ignores observed messages from foreign meshes like LOCAL_ONLY,
            but takes it step further by also ignoring messages from nodenums not in the node's known list (NodeDB)
            """
            NONE: Config.DeviceConfig._RebroadcastMode.ValueType  # 4
            """
            Only permitted for SENSOR, TRACKER and TAK_TRACKER roles, this will inhibit all rebroadcasts, not unlike CLIENT_MUTE role.
            """
            CORE_PORTNUMS_ONLY: Config.DeviceConfig._RebroadcastMode.ValueType  # 5
            """
            Ignores packets from non-standard portnums such as: TAK, RangeTest, PaxCounter, etc.
            Only rebroadcasts packets with standard portnums: NodeInfo, Text, Position, Telemetry, and Routing.
            """

        class RebroadcastMode(_RebroadcastMode, metaclass=_RebroadcastModeEnumTypeWrapper):
            """
            Defines the device's behavior for how messages are rebroadcast
            """

        ALL: Config.DeviceConfig.RebroadcastMode.ValueType  # 0
        """
        Default behavior.
        Rebroadcast any observed message, if it was on our private channel or from another mesh with the same lora params.
        """
        ALL_SKIP_DECODING: Config.DeviceConfig.RebroadcastMode.ValueType  # 1
        """
        Same as behavior as ALL but skips packet decoding and simply rebroadcasts them.
        Only available in Repeater role. Setting this on any other roles will result in ALL behavior.
        """
        LOCAL_ONLY: Config.DeviceConfig.RebroadcastMode.ValueType  # 2
        """
        Ignores observed messages from foreign meshes that are open or those which it cannot decrypt.
        Only rebroadcasts message on the nodes local primary / secondary channels.
        """
        KNOWN_ONLY: Config.DeviceConfig.RebroadcastMode.ValueType  # 3
        """
        Ignores observed messages from foreign meshes like LOCAL_ONLY,
        but takes it step further by also ignoring messages from nodenums not in the node's known list (NodeDB)
        """
        NONE: Config.DeviceConfig.RebroadcastMode.ValueType  # 4
        """
        Only permitted for SENSOR, TRACKER and TAK_TRACKER roles, this will inhibit all rebroadcasts, not unlike CLIENT_MUTE role.
        """
        CORE_PORTNUMS_ONLY: Config.DeviceConfig.RebroadcastMode.ValueType  # 5
        """
        Ignores packets from non-standard portnums such as: TAK, RangeTest, PaxCounter, etc.
        Only rebroadcasts packets with standard portnums: NodeInfo, Text, Position, Telemetry, and Routing.
        """

        class _BuzzerMode:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _BuzzerModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Config.DeviceConfig._BuzzerMode.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            ALL_ENABLED: Config.DeviceConfig._BuzzerMode.ValueType  # 0
            """
            Default behavior.
            Buzzer is enabled for all audio feedback including button presses and alerts.
            """
            DISABLED: Config.DeviceConfig._BuzzerMode.ValueType  # 1
            """
            Disabled.
            All buzzer audio feedback is disabled.
            """
            NOTIFICATIONS_ONLY: Config.DeviceConfig._BuzzerMode.ValueType  # 2
            """
            Notifications Only.
            Buzzer is enabled only for notifications and alerts, but not for button presses.
            External notification config determines the specifics of the notification behavior.
            """
            SYSTEM_ONLY: Config.DeviceConfig._BuzzerMode.ValueType  # 3
            """
            Non-notification system buzzer tones only.
            Buzzer is enabled only for non-notification tones such as button presses, startup, shutdown, but not for alerts.
            """
            DIRECT_MSG_ONLY: Config.DeviceConfig._BuzzerMode.ValueType  # 4
            """
            Direct Message notifications only.
            Buzzer is enabled only for direct messages and alerts, but not for button presses.
            External notification config determines the specifics of the notification behavior.
            """

        class BuzzerMode(_BuzzerMode, metaclass=_BuzzerModeEnumTypeWrapper):
            """
            Defines buzzer behavior for audio feedback
            """

        ALL_ENABLED: Config.DeviceConfig.BuzzerMode.ValueType  # 0
        """
        Default behavior.
        Buzzer is enabled for all audio feedback including button presses and alerts.
        """
        DISABLED: Config.DeviceConfig.BuzzerMode.ValueType  # 1
        """
        Disabled.
        All buzzer audio feedback is disabled.
        """
        NOTIFICATIONS_ONLY: Config.DeviceConfig.BuzzerMode.ValueType  # 2
        """
        Notifications Only.
        Buzzer is enabled only for notifications and alerts, but not for button presses.
        External notification config determines the specifics of the notification behavior.
        """
        SYSTEM_ONLY: Config.DeviceConfig.BuzzerMode.ValueType  # 3
        """
        Non-notification system buzzer tones only.
        Buzzer is enabled only for non-notification tones such as button presses, startup, shutdown, but not for alerts.
        """
        DIRECT_MSG_ONLY: Config.DeviceConfig.BuzzerMode.ValueType  # 4
        """
        Direct Message notifications only.
        Buzzer is enabled only for direct messages and alerts, but not for button presses.
        External notification config determines the specifics of the notification behavior.
        """

        ROLE_FIELD_NUMBER: builtins.int
        SERIAL_ENABLED_FIELD_NUMBER: builtins.int
        BUTTON_GPIO_FIELD_NUMBER: builtins.int
        BUZZER_GPIO_FIELD_NUMBER: builtins.int
        REBROADCAST_MODE_FIELD_NUMBER: builtins.int
        NODE_INFO_BROADCAST_SECS_FIELD_NUMBER: builtins.int
        DOUBLE_TAP_AS_BUTTON_PRESS_FIELD_NUMBER: builtins.int
        IS_MANAGED_FIELD_NUMBER: builtins.int
        DISABLE_TRIPLE_CLICK_FIELD_NUMBER: builtins.int
        TZDEF_FIELD_NUMBER: builtins.int
        LED_HEARTBEAT_DISABLED_FIELD_NUMBER: builtins.int
        BUZZER_MODE_FIELD_NUMBER: builtins.int
        role: global___Config.DeviceConfig.Role.ValueType
        """
        Sets the role of node
        """
        serial_enabled: builtins.bool
        """
        Disabling this will disable the SerialConsole by not initilizing the StreamAPI
        Moved to SecurityConfig
        """
        button_gpio: builtins.int
        """
        For boards without a hard wired button, this is the pin number that will be used
        Boards that have more than one button can swap the function with this one. defaults to BUTTON_PIN if defined.
        """
        buzzer_gpio: builtins.int
        """
        For boards without a PWM buzzer, this is the pin number that will be used
        Defaults to PIN_BUZZER if defined.
        """
        rebroadcast_mode: global___Config.DeviceConfig.RebroadcastMode.ValueType
        """
        Sets the role of node
        """
        node_info_broadcast_secs: builtins.int
        """
        Send our nodeinfo this often
        Defaults to 900 Seconds (15 minutes)
        """
        double_tap_as_button_press: builtins.bool
        """
        Treat double tap interrupt on supported accelerometers as a button press if set to true
        """
        is_managed: builtins.bool
        """
        If true, device is considered to be "managed" by a mesh administrator
        Clients should then limit available configuration and administrative options inside the user interface
        Moved to SecurityConfig
        """
        disable_triple_click: builtins.bool
        """
        Disables the triple-press of user button to enable or disable GPS
        """
        tzdef: builtins.str
        """
        POSIX Timezone definition string from https://github.com/nayarsystems/posix_tz_db/blob/master/zones.csv.
        """
        led_heartbeat_disabled: builtins.bool
        """
        If true, disable the default blinking LED (LED_PIN) behavior on the device
        """
        buzzer_mode: global___Config.DeviceConfig.BuzzerMode.ValueType
        """
        Controls buzzer behavior for audio feedback
        Defaults to ENABLED
        """
        def __init__(
            self,
            *,
            role: global___Config.DeviceConfig.Role.ValueType = ...,
            serial_enabled: builtins.bool = ...,
            button_gpio: builtins.int = ...,
            buzzer_gpio: builtins.int = ...,
            rebroadcast_mode: global___Config.DeviceConfig.RebroadcastMode.ValueType = ...,
            node_info_broadcast_secs: builtins.int = ...,
            double_tap_as_button_press: builtins.bool = ...,
            is_managed: builtins.bool = ...,
            disable_triple_click: builtins.bool = ...,
            tzdef: builtins.str = ...,
            led_heartbeat_disabled: builtins.bool = ...,
            buzzer_mode: global___Config.DeviceConfig.BuzzerMode.ValueType = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["button_gpio", b"button_gpio", "buzzer_gpio", b"buzzer_gpio", "buzzer_mode", b"buzzer_mode", "disable_triple_click", b"disable_triple_click", "double_tap_as_button_press", b"double_tap_as_button_press", "is_managed", b"is_managed", "led_heartbeat_disabled", b"led_heartbeat_disabled", "node_info_broadcast_secs", b"node_info_broadcast_secs", "rebroadcast_mode", b"rebroadcast_mode", "role", b"role", "serial_enabled", b"serial_enabled", "tzdef", b"tzdef"]) -> None: ...

    @typing.final
    class PositionConfig(google.protobuf.message.Message):
        """
        Position Config
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _PositionFlags:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _PositionFlagsEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Config.PositionConfig._PositionFlags.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            UNSET: Config.PositionConfig._PositionFlags.ValueType  # 0
            """
            Required for compilation
            """
            ALTITUDE: Config.PositionConfig._PositionFlags.ValueType  # 1
            """
            Include an altitude value (if available)
            """
            ALTITUDE_MSL: Config.PositionConfig._PositionFlags.ValueType  # 2
            """
            Altitude value is MSL
            """
            GEOIDAL_SEPARATION: Config.PositionConfig._PositionFlags.ValueType  # 4
            """
            Include geoidal separation
            """
            DOP: Config.PositionConfig._PositionFlags.ValueType  # 8
            """
            Include the DOP value ; PDOP used by default, see below
            """
            HVDOP: Config.PositionConfig._PositionFlags.ValueType  # 16
            """
            If POS_DOP set, send separate HDOP / VDOP values instead of PDOP
            """
            SATINVIEW: Config.PositionConfig._PositionFlags.ValueType  # 32
            """
            Include number of "satellites in view"
            """
            SEQ_NO: Config.PositionConfig._PositionFlags.ValueType  # 64
            """
            Include a sequence number incremented per packet
            """
            TIMESTAMP: Config.PositionConfig._PositionFlags.ValueType  # 128
            """
            Include positional timestamp (from GPS solution)
            """
            HEADING: Config.PositionConfig._PositionFlags.ValueType  # 256
            """
            Include positional heading
            Intended for use with vehicle not walking speeds
            walking speeds are likely to be error prone like the compass
            """
            SPEED: Config.PositionConfig._PositionFlags.ValueType  # 512
            """
            Include positional speed
            Intended for use with vehicle not walking speeds
            walking speeds are likely to be error prone like the compass
            """

        class PositionFlags(_PositionFlags, metaclass=_PositionFlagsEnumTypeWrapper):
            """
            Bit field of boolean configuration options, indicating which optional
            fields to include when assembling POSITION messages.
            Longitude, latitude, altitude, speed, heading, and DOP
            are always included (also time if GPS-synced)
            NOTE: the more fields are included, the larger the message will be -
              leading to longer airtime and a higher risk of packet loss
            """

        UNSET: Config.PositionConfig.PositionFlags.ValueType  # 0
        """
        Required for compilation
        """
        ALTITUDE: Config.PositionConfig.PositionFlags.ValueType  # 1
        """
        Include an altitude value (if available)
        """
        ALTITUDE_MSL: Config.PositionConfig.PositionFlags.ValueType  # 2
        """
        Altitude value is MSL
        """
        GEOIDAL_SEPARATION: Config.PositionConfig.PositionFlags.ValueType  # 4
        """
        Include geoidal separation
        """
        DOP: Config.PositionConfig.PositionFlags.ValueType  # 8
        """
        Include the DOP value ; PDOP used by default, see below
        """
        HVDOP: Config.PositionConfig.PositionFlags.ValueType  # 16
        """
        If POS_DOP set, send separate HDOP / VDOP values instead of PDOP
        """
        SATINVIEW: Config.PositionConfig.PositionFlags.ValueType  # 32
        """
        Include number of "satellites in view"
        """
        SEQ_NO: Config.PositionConfig.PositionFlags.ValueType  # 64
        """
        Include a sequence number incremented per packet
        """
        TIMESTAMP: Config.PositionConfig.PositionFlags.ValueType  # 128
        """
        Include positional timestamp (from GPS solution)
        """
        HEADING: Config.PositionConfig.PositionFlags.ValueType  # 256
        """
        Include positional heading
        Intended for use with vehicle not walking speeds
        walking speeds are likely to be error prone like the compass
        """
        SPEED: Config.PositionConfig.PositionFlags.ValueType  # 512
        """
        Include positional speed
        Intended for use with vehicle not walking speeds
        walking speeds are likely to be error prone like the compass
        """

        class _GpsMode:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _GpsModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Config.PositionConfig._GpsMode.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            DISABLED: Config.PositionConfig._GpsMode.ValueType  # 0
            """
            GPS is present but disabled
            """
            ENABLED: Config.PositionConfig._GpsMode.ValueType  # 1
            """
            GPS is present and enabled
            """
            NOT_PRESENT: Config.PositionConfig._GpsMode.ValueType  # 2
            """
            GPS is not present on the device
            """

        class GpsMode(_GpsMode, metaclass=_GpsModeEnumTypeWrapper): ...
        DISABLED: Config.PositionConfig.GpsMode.ValueType  # 0
        """
        GPS is present but disabled
        """
        ENABLED: Config.PositionConfig.GpsMode.ValueType  # 1
        """
        GPS is present and enabled
        """
        NOT_PRESENT: Config.PositionConfig.GpsMode.ValueType  # 2
        """
        GPS is not present on the device
        """

        POSITION_BROADCAST_SECS_FIELD_NUMBER: builtins.int
        POSITION_BROADCAST_SMART_ENABLED_FIELD_NUMBER: builtins.int
        FIXED_POSITION_FIELD_NUMBER: builtins.int
        GPS_ENABLED_FIELD_NUMBER: builtins.int
        GPS_UPDATE_INTERVAL_FIELD_NUMBER: builtins.int
        GPS_ATTEMPT_TIME_FIELD_NUMBER: builtins.int
        POSITION_FLAGS_FIELD_NUMBER: builtins.int
        RX_GPIO_FIELD_NUMBER: builtins.int
        TX_GPIO_FIELD_NUMBER: builtins.int
        BROADCAST_SMART_MINIMUM_DISTANCE_FIELD_NUMBER: builtins.int
        BROADCAST_SMART_MINIMUM_INTERVAL_SECS_FIELD_NUMBER: builtins.int
        GPS_EN_GPIO_FIELD_NUMBER: builtins.int
        GPS_MODE_FIELD_NUMBER: builtins.int
        position_broadcast_secs: builtins.int
        """
        We should send our position this often (but only if it has changed significantly)
        Defaults to 15 minutes
        """
        position_broadcast_smart_enabled: builtins.bool
        """
        Adaptive position braoadcast, which is now the default.
        """
        fixed_position: builtins.bool
        """
        If set, this node is at a fixed position.
        We will generate GPS position updates at the regular interval, but use whatever the last lat/lon/alt we have for the node.
        The lat/lon/alt can be set by an internal GPS or with the help of the app.
        """
        gps_enabled: builtins.bool
        """
        Is GPS enabled for this node?
        """
        gps_update_interval: builtins.int
        """
        How often should we try to get GPS position (in seconds)
        or zero for the default of once every 30 seconds
        or a very large value (maxint) to update only once at boot.
        """
        gps_attempt_time: builtins.int
        """
        Deprecated in favor of using smart / regular broadcast intervals as implicit attempt time
        """
        position_flags: builtins.int
        """
        Bit field of boolean configuration options for POSITION messages
        (bitwise OR of PositionFlags)
        """
        rx_gpio: builtins.int
        """
        (Re)define GPS_RX_PIN for your board.
        """
        tx_gpio: builtins.int
        """
        (Re)define GPS_TX_PIN for your board.
        """
        broadcast_smart_minimum_distance: builtins.int
        """
        The minimum distance in meters traveled (since the last send) before we can send a position to the mesh if position_broadcast_smart_enabled
        """
        broadcast_smart_minimum_interval_secs: builtins.int
        """
        The minimum number of seconds (since the last send) before we can send a position to the mesh if position_broadcast_smart_enabled
        """
        gps_en_gpio: builtins.int
        """
        (Re)define PIN_GPS_EN for your board.
        """
        gps_mode: global___Config.PositionConfig.GpsMode.ValueType
        """
        Set where GPS is enabled, disabled, or not present
        """
        def __init__(
            self,
            *,
            position_broadcast_secs: builtins.int = ...,
            position_broadcast_smart_enabled: builtins.bool = ...,
            fixed_position: builtins.bool = ...,
            gps_enabled: builtins.bool = ...,
            gps_update_interval: builtins.int = ...,
            gps_attempt_time: builtins.int = ...,
            position_flags: builtins.int = ...,
            rx_gpio: builtins.int = ...,
            tx_gpio: builtins.int = ...,
            broadcast_smart_minimum_distance: builtins.int = ...,
            broadcast_smart_minimum_interval_secs: builtins.int = ...,
            gps_en_gpio: builtins.int = ...,
            gps_mode: global___Config.PositionConfig.GpsMode.ValueType = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["broadcast_smart_minimum_distance", b"broadcast_smart_minimum_distance", "broadcast_smart_minimum_interval_secs", b"broadcast_smart_minimum_interval_secs", "fixed_position", b"fixed_position", "gps_attempt_time", b"gps_attempt_time", "gps_en_gpio", b"gps_en_gpio", "gps_enabled", b"gps_enabled", "gps_mode", b"gps_mode", "gps_update_interval", b"gps_update_interval", "position_broadcast_secs", b"position_broadcast_secs", "position_broadcast_smart_enabled", b"position_broadcast_smart_enabled", "position_flags", b"position_flags", "rx_gpio", b"rx_gpio", "tx_gpio", b"tx_gpio"]) -> None: ...

    @typing.final
    class PowerConfig(google.protobuf.message.Message):
        """
        Power Config\\
        See [Power Config](/docs/settings/config/power) for additional power config details.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        IS_POWER_SAVING_FIELD_NUMBER: builtins.int
        ON_BATTERY_SHUTDOWN_AFTER_SECS_FIELD_NUMBER: builtins.int
        ADC_MULTIPLIER_OVERRIDE_FIELD_NUMBER: builtins.int
        WAIT_BLUETOOTH_SECS_FIELD_NUMBER: builtins.int
        SDS_SECS_FIELD_NUMBER: builtins.int
        LS_SECS_FIELD_NUMBER: builtins.int
        MIN_WAKE_SECS_FIELD_NUMBER: builtins.int
        DEVICE_BATTERY_INA_ADDRESS_FIELD_NUMBER: builtins.int
        POWERMON_ENABLES_FIELD_NUMBER: builtins.int
        is_power_saving: builtins.bool
        """
        Description: Will sleep everything as much as possible, for the tracker and sensor role this will also include the lora radio.
        Don't use this setting if you want to use your device with the phone apps or are using a device without a user button.
        Technical Details: Works for ESP32 devices and NRF52 devices in the Sensor or Tracker roles
        """
        on_battery_shutdown_after_secs: builtins.int
        """
         Description: If non-zero, the device will fully power off this many seconds after external power is removed.
        """
        adc_multiplier_override: builtins.float
        """
        Ratio of voltage divider for battery pin eg. 3.20 (R1=100k, R2=220k)
        Overrides the ADC_MULTIPLIER defined in variant for battery voltage calculation.
        https://meshtastic.org/docs/configuration/radio/power/#adc-multiplier-override
        Should be set to floating point value between 2 and 6
        """
        wait_bluetooth_secs: builtins.int
        """
         Description: The number of seconds for to wait before turning off BLE in No Bluetooth states
         Technical Details: ESP32 Only 0 for default of 1 minute
        """
        sds_secs: builtins.int
        """
        Super Deep Sleep Seconds
        While in Light Sleep if mesh_sds_timeout_secs is exceeded we will lower into super deep sleep
        for this value (default 1 year) or a button press
        0 for default of one year
        """
        ls_secs: builtins.int
        """
        Description: In light sleep the CPU is suspended, LoRa radio is on, BLE is off an GPS is on
        Technical Details: ESP32 Only 0 for default of 300
        """
        min_wake_secs: builtins.int
        """
        Description: While in light sleep when we receive packets on the LoRa radio we will wake and handle them and stay awake in no BLE mode for this value
        Technical Details: ESP32 Only 0 for default of 10 seconds
        """
        device_battery_ina_address: builtins.int
        """
        I2C address of INA_2XX to use for reading device battery voltage
        """
        powermon_enables: builtins.int
        """
        If non-zero, we want powermon log outputs.  With the particular (bitfield) sources enabled.
        Note: we picked an ID of 32 so that lower more efficient IDs can be used for more frequently used options.
        """
        def __init__(
            self,
            *,
            is_power_saving: builtins.bool = ...,
            on_battery_shutdown_after_secs: builtins.int = ...,
            adc_multiplier_override: builtins.float = ...,
            wait_bluetooth_secs: builtins.int = ...,
            sds_secs: builtins.int = ...,
            ls_secs: builtins.int = ...,
            min_wake_secs: builtins.int = ...,
            device_battery_ina_address: builtins.int = ...,
            powermon_enables: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["adc_multiplier_override", b"adc_multiplier_override", "device_battery_ina_address", b"device_battery_ina_address", "is_power_saving", b"is_power_saving", "ls_secs", b"ls_secs", "min_wake_secs", b"min_wake_secs", "on_battery_shutdown_after_secs", b"on_battery_shutdown_after_secs", "powermon_enables", b"powermon_enables", "sds_secs", b"sds_secs", "wait_bluetooth_secs", b"wait_bluetooth_secs"]) -> None: ...

    @typing.final
    class NetworkConfig(google.protobuf.message.Message):
        """
        Network Config
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _AddressMode:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _AddressModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Config.NetworkConfig._AddressMode.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            DHCP: Config.NetworkConfig._AddressMode.ValueType  # 0
            """
            obtain ip address via DHCP
            """
            STATIC: Config.NetworkConfig._AddressMode.ValueType  # 1
            """
            use static ip address
            """

        class AddressMode(_AddressMode, metaclass=_AddressModeEnumTypeWrapper): ...
        DHCP: Config.NetworkConfig.AddressMode.ValueType  # 0
        """
        obtain ip address via DHCP
        """
        STATIC: Config.NetworkConfig.AddressMode.ValueType  # 1
        """
        use static ip address
        """

        class _ProtocolFlags:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _ProtocolFlagsEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Config.NetworkConfig._ProtocolFlags.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            NO_BROADCAST: Config.NetworkConfig._ProtocolFlags.ValueType  # 0
            """
            Do not broadcast packets over any network protocol
            """
            UDP_BROADCAST: Config.NetworkConfig._ProtocolFlags.ValueType  # 1
            """
            Enable broadcasting packets via UDP over the local network
            """

        class ProtocolFlags(_ProtocolFlags, metaclass=_ProtocolFlagsEnumTypeWrapper):
            """
            Available flags auxiliary network protocols
            """

        NO_BROADCAST: Config.NetworkConfig.ProtocolFlags.ValueType  # 0
        """
        Do not broadcast packets over any network protocol
        """
        UDP_BROADCAST: Config.NetworkConfig.ProtocolFlags.ValueType  # 1
        """
        Enable broadcasting packets via UDP over the local network
        """

        @typing.final
        class IpV4Config(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            IP_FIELD_NUMBER: builtins.int
            GATEWAY_FIELD_NUMBER: builtins.int
            SUBNET_FIELD_NUMBER: builtins.int
            DNS_FIELD_NUMBER: builtins.int
            ip: builtins.int
            """
            Static IP address
            """
            gateway: builtins.int
            """
            Static gateway address
            """
            subnet: builtins.int
            """
            Static subnet mask
            """
            dns: builtins.int
            """
            Static DNS server address
            """
            def __init__(
                self,
                *,
                ip: builtins.int = ...,
                gateway: builtins.int = ...,
                subnet: builtins.int = ...,
                dns: builtins.int = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing.Literal["dns", b"dns", "gateway", b"gateway", "ip", b"ip", "subnet", b"subnet"]) -> None: ...

        WIFI_ENABLED_FIELD_NUMBER: builtins.int
        WIFI_SSID_FIELD_NUMBER: builtins.int
        WIFI_PSK_FIELD_NUMBER: builtins.int
        NTP_SERVER_FIELD_NUMBER: builtins.int
        ETH_ENABLED_FIELD_NUMBER: builtins.int
        ADDRESS_MODE_FIELD_NUMBER: builtins.int
        IPV4_CONFIG_FIELD_NUMBER: builtins.int
        RSYSLOG_SERVER_FIELD_NUMBER: builtins.int
        ENABLED_PROTOCOLS_FIELD_NUMBER: builtins.int
        IPV6_ENABLED_FIELD_NUMBER: builtins.int
        wifi_enabled: builtins.bool
        """
        Enable WiFi (disables Bluetooth)
        """
        wifi_ssid: builtins.str
        """
        If set, this node will try to join the specified wifi network and
        acquire an address via DHCP
        """
        wifi_psk: builtins.str
        """
        If set, will be use to authenticate to the named wifi
        """
        ntp_server: builtins.str
        """
        NTP server to use if WiFi is conneced, defaults to `meshtastic.pool.ntp.org`
        """
        eth_enabled: builtins.bool
        """
        Enable Ethernet
        """
        address_mode: global___Config.NetworkConfig.AddressMode.ValueType
        """
        acquire an address via DHCP or assign static
        """
        rsyslog_server: builtins.str
        """
        rsyslog Server and Port
        """
        enabled_protocols: builtins.int
        """
        Flags for enabling/disabling network protocols
        """
        ipv6_enabled: builtins.bool
        """
        Enable/Disable ipv6 support
        """
        @property
        def ipv4_config(self) -> global___Config.NetworkConfig.IpV4Config:
            """
            struct to keep static address
            """

        def __init__(
            self,
            *,
            wifi_enabled: builtins.bool = ...,
            wifi_ssid: builtins.str = ...,
            wifi_psk: builtins.str = ...,
            ntp_server: builtins.str = ...,
            eth_enabled: builtins.bool = ...,
            address_mode: global___Config.NetworkConfig.AddressMode.ValueType = ...,
            ipv4_config: global___Config.NetworkConfig.IpV4Config | None = ...,
            rsyslog_server: builtins.str = ...,
            enabled_protocols: builtins.int = ...,
            ipv6_enabled: builtins.bool = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["ipv4_config", b"ipv4_config"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["address_mode", b"address_mode", "enabled_protocols", b"enabled_protocols", "eth_enabled", b"eth_enabled", "ipv4_config", b"ipv4_config", "ipv6_enabled", b"ipv6_enabled", "ntp_server", b"ntp_server", "rsyslog_server", b"rsyslog_server", "wifi_enabled", b"wifi_enabled", "wifi_psk", b"wifi_psk", "wifi_ssid", b"wifi_ssid"]) -> None: ...

    @typing.final
    class DisplayConfig(google.protobuf.message.Message):
        """
        Display Config
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _DeprecatedGpsCoordinateFormat:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _DeprecatedGpsCoordinateFormatEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Config.DisplayConfig._DeprecatedGpsCoordinateFormat.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            UNUSED: Config.DisplayConfig._DeprecatedGpsCoordinateFormat.ValueType  # 0

        class DeprecatedGpsCoordinateFormat(_DeprecatedGpsCoordinateFormat, metaclass=_DeprecatedGpsCoordinateFormatEnumTypeWrapper):
            """
            Deprecated in 2.7.4: Unused
            """

        UNUSED: Config.DisplayConfig.DeprecatedGpsCoordinateFormat.ValueType  # 0

        class _DisplayUnits:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _DisplayUnitsEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Config.DisplayConfig._DisplayUnits.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            METRIC: Config.DisplayConfig._DisplayUnits.ValueType  # 0
            """
            Metric (Default)
            """
            IMPERIAL: Config.DisplayConfig._DisplayUnits.ValueType  # 1
            """
            Imperial
            """

        class DisplayUnits(_DisplayUnits, metaclass=_DisplayUnitsEnumTypeWrapper):
            """
            Unit display preference
            """

        METRIC: Config.DisplayConfig.DisplayUnits.ValueType  # 0
        """
        Metric (Default)
        """
        IMPERIAL: Config.DisplayConfig.DisplayUnits.ValueType  # 1
        """
        Imperial
        """

        class _OledType:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _OledTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Config.DisplayConfig._OledType.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            OLED_AUTO: Config.DisplayConfig._OledType.ValueType  # 0
            """
            Default / Autodetect
            """
            OLED_SSD1306: Config.DisplayConfig._OledType.ValueType  # 1
            """
            Default / Autodetect
            """
            OLED_SH1106: Config.DisplayConfig._OledType.ValueType  # 2
            """
            Default / Autodetect
            """
            OLED_SH1107: Config.DisplayConfig._OledType.ValueType  # 3
            """
            Can not be auto detected but set by proto. Used for 128x64 screens
            """
            OLED_SH1107_128_128: Config.DisplayConfig._OledType.ValueType  # 4
            """
            Can not be auto detected but set by proto. Used for 128x128 screens
            """

        class OledType(_OledType, metaclass=_OledTypeEnumTypeWrapper):
            """
            Override OLED outo detect with this if it fails.
            """

        OLED_AUTO: Config.DisplayConfig.OledType.ValueType  # 0
        """
        Default / Autodetect
        """
        OLED_SSD1306: Config.DisplayConfig.OledType.ValueType  # 1
        """
        Default / Autodetect
        """
        OLED_SH1106: Config.DisplayConfig.OledType.ValueType  # 2
        """
        Default / Autodetect
        """
        OLED_SH1107: Config.DisplayConfig.OledType.ValueType  # 3
        """
        Can not be auto detected but set by proto. Used for 128x64 screens
        """
        OLED_SH1107_128_128: Config.DisplayConfig.OledType.ValueType  # 4
        """
        Can not be auto detected but set by proto. Used for 128x128 screens
        """

        class _DisplayMode:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _DisplayModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Config.DisplayConfig._DisplayMode.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            DEFAULT: Config.DisplayConfig._DisplayMode.ValueType  # 0
            """
            Default. The old style for the 128x64 OLED screen
            """
            TWOCOLOR: Config.DisplayConfig._DisplayMode.ValueType  # 1
            """
            Rearrange display elements to cater for bicolor OLED displays
            """
            INVERTED: Config.DisplayConfig._DisplayMode.ValueType  # 2
            """
            Same as TwoColor, but with inverted top bar. Not so good for Epaper displays
            """
            COLOR: Config.DisplayConfig._DisplayMode.ValueType  # 3
            """
            TFT Full Color Displays (not implemented yet)
            """

        class DisplayMode(_DisplayMode, metaclass=_DisplayModeEnumTypeWrapper): ...
        DEFAULT: Config.DisplayConfig.DisplayMode.ValueType  # 0
        """
        Default. The old style for the 128x64 OLED screen
        """
        TWOCOLOR: Config.DisplayConfig.DisplayMode.ValueType  # 1
        """
        Rearrange display elements to cater for bicolor OLED displays
        """
        INVERTED: Config.DisplayConfig.DisplayMode.ValueType  # 2
        """
        Same as TwoColor, but with inverted top bar. Not so good for Epaper displays
        """
        COLOR: Config.DisplayConfig.DisplayMode.ValueType  # 3
        """
        TFT Full Color Displays (not implemented yet)
        """

        class _CompassOrientation:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _CompassOrientationEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Config.DisplayConfig._CompassOrientation.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            DEGREES_0: Config.DisplayConfig._CompassOrientation.ValueType  # 0
            """
            The compass and the display are in the same orientation.
            """
            DEGREES_90: Config.DisplayConfig._CompassOrientation.ValueType  # 1
            """
            Rotate the compass by 90 degrees.
            """
            DEGREES_180: Config.DisplayConfig._CompassOrientation.ValueType  # 2
            """
            Rotate the compass by 180 degrees.
            """
            DEGREES_270: Config.DisplayConfig._CompassOrientation.ValueType  # 3
            """
            Rotate the compass by 270 degrees.
            """
            DEGREES_0_INVERTED: Config.DisplayConfig._CompassOrientation.ValueType  # 4
            """
            Don't rotate the compass, but invert the result.
            """
            DEGREES_90_INVERTED: Config.DisplayConfig._CompassOrientation.ValueType  # 5
            """
            Rotate the compass by 90 degrees and invert.
            """
            DEGREES_180_INVERTED: Config.DisplayConfig._CompassOrientation.ValueType  # 6
            """
            Rotate the compass by 180 degrees and invert.
            """
            DEGREES_270_INVERTED: Config.DisplayConfig._CompassOrientation.ValueType  # 7
            """
            Rotate the compass by 270 degrees and invert.
            """

        class CompassOrientation(_CompassOrientation, metaclass=_CompassOrientationEnumTypeWrapper): ...
        DEGREES_0: Config.DisplayConfig.CompassOrientation.ValueType  # 0
        """
        The compass and the display are in the same orientation.
        """
        DEGREES_90: Config.DisplayConfig.CompassOrientation.ValueType  # 1
        """
        Rotate the compass by 90 degrees.
        """
        DEGREES_180: Config.DisplayConfig.CompassOrientation.ValueType  # 2
        """
        Rotate the compass by 180 degrees.
        """
        DEGREES_270: Config.DisplayConfig.CompassOrientation.ValueType  # 3
        """
        Rotate the compass by 270 degrees.
        """
        DEGREES_0_INVERTED: Config.DisplayConfig.CompassOrientation.ValueType  # 4
        """
        Don't rotate the compass, but invert the result.
        """
        DEGREES_90_INVERTED: Config.DisplayConfig.CompassOrientation.ValueType  # 5
        """
        Rotate the compass by 90 degrees and invert.
        """
        DEGREES_180_INVERTED: Config.DisplayConfig.CompassOrientation.ValueType  # 6
        """
        Rotate the compass by 180 degrees and invert.
        """
        DEGREES_270_INVERTED: Config.DisplayConfig.CompassOrientation.ValueType  # 7
        """
        Rotate the compass by 270 degrees and invert.
        """

        SCREEN_ON_SECS_FIELD_NUMBER: builtins.int
        GPS_FORMAT_FIELD_NUMBER: builtins.int
        AUTO_SCREEN_CAROUSEL_SECS_FIELD_NUMBER: builtins.int
        COMPASS_NORTH_TOP_FIELD_NUMBER: builtins.int
        FLIP_SCREEN_FIELD_NUMBER: builtins.int
        UNITS_FIELD_NUMBER: builtins.int
        OLED_FIELD_NUMBER: builtins.int
        DISPLAYMODE_FIELD_NUMBER: builtins.int
        HEADING_BOLD_FIELD_NUMBER: builtins.int
        WAKE_ON_TAP_OR_MOTION_FIELD_NUMBER: builtins.int
        COMPASS_ORIENTATION_FIELD_NUMBER: builtins.int
        USE_12H_CLOCK_FIELD_NUMBER: builtins.int
        USE_LONG_NODE_NAME_FIELD_NUMBER: builtins.int
        screen_on_secs: builtins.int
        """
        Number of seconds the screen stays on after pressing the user button or receiving a message
        0 for default of one minute MAXUINT for always on
        """
        gps_format: global___Config.DisplayConfig.DeprecatedGpsCoordinateFormat.ValueType
        """
        Deprecated in 2.7.4: Unused
        How the GPS coordinates are formatted on the OLED screen.
        """
        auto_screen_carousel_secs: builtins.int
        """
        Automatically toggles to the next page on the screen like a carousel, based the specified interval in seconds.
        Potentially useful for devices without user buttons.
        """
        compass_north_top: builtins.bool
        """
        If this is set, the displayed compass will always point north. if unset, the old behaviour
        (top of display is heading direction) is used.
        """
        flip_screen: builtins.bool
        """
        Flip screen vertically, for cases that mount the screen upside down
        """
        units: global___Config.DisplayConfig.DisplayUnits.ValueType
        """
        Perferred display units
        """
        oled: global___Config.DisplayConfig.OledType.ValueType
        """
        Override auto-detect in screen
        """
        displaymode: global___Config.DisplayConfig.DisplayMode.ValueType
        """
        Display Mode
        """
        heading_bold: builtins.bool
        """
        Print first line in pseudo-bold? FALSE is original style, TRUE is bold
        """
        wake_on_tap_or_motion: builtins.bool
        """
        Should we wake the screen up on accelerometer detected motion or tap
        """
        compass_orientation: global___Config.DisplayConfig.CompassOrientation.ValueType
        """
        Indicates how to rotate or invert the compass output to accurate display on the display.
        """
        use_12h_clock: builtins.bool
        """
        If false (default), the device will display the time in 24-hour format on screen.
        If true, the device will display the time in 12-hour format on screen.
        """
        use_long_node_name: builtins.bool
        """
        If false (default), the device will use short names for various display screens.
        If true, node names will show in long format
        """
        def __init__(
            self,
            *,
            screen_on_secs: builtins.int = ...,
            gps_format: global___Config.DisplayConfig.DeprecatedGpsCoordinateFormat.ValueType = ...,
            auto_screen_carousel_secs: builtins.int = ...,
            compass_north_top: builtins.bool = ...,
            flip_screen: builtins.bool = ...,
            units: global___Config.DisplayConfig.DisplayUnits.ValueType = ...,
            oled: global___Config.DisplayConfig.OledType.ValueType = ...,
            displaymode: global___Config.DisplayConfig.DisplayMode.ValueType = ...,
            heading_bold: builtins.bool = ...,
            wake_on_tap_or_motion: builtins.bool = ...,
            compass_orientation: global___Config.DisplayConfig.CompassOrientation.ValueType = ...,
            use_12h_clock: builtins.bool = ...,
            use_long_node_name: builtins.bool = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["auto_screen_carousel_secs", b"auto_screen_carousel_secs", "compass_north_top", b"compass_north_top", "compass_orientation", b"compass_orientation", "displaymode", b"displaymode", "flip_screen", b"flip_screen", "gps_format", b"gps_format", "heading_bold", b"heading_bold", "oled", b"oled", "screen_on_secs", b"screen_on_secs", "units", b"units", "use_12h_clock", b"use_12h_clock", "use_long_node_name", b"use_long_node_name", "wake_on_tap_or_motion", b"wake_on_tap_or_motion"]) -> None: ...

    @typing.final
    class LoRaConfig(google.protobuf.message.Message):
        """
        Lora Config
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _RegionCode:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _RegionCodeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Config.LoRaConfig._RegionCode.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            UNSET: Config.LoRaConfig._RegionCode.ValueType  # 0
            """
            Region is not set
            """
            US: Config.LoRaConfig._RegionCode.ValueType  # 1
            """
            United States
            """
            EU_433: Config.LoRaConfig._RegionCode.ValueType  # 2
            """
            European Union 433mhz
            """
            EU_868: Config.LoRaConfig._RegionCode.ValueType  # 3
            """
            European Union 868mhz
            """
            CN: Config.LoRaConfig._RegionCode.ValueType  # 4
            """
            China
            """
            JP: Config.LoRaConfig._RegionCode.ValueType  # 5
            """
            Japan
            """
            ANZ: Config.LoRaConfig._RegionCode.ValueType  # 6
            """
            Australia / New Zealand
            """
            KR: Config.LoRaConfig._RegionCode.ValueType  # 7
            """
            Korea
            """
            TW: Config.LoRaConfig._RegionCode.ValueType  # 8
            """
            Taiwan
            """
            RU: Config.LoRaConfig._RegionCode.ValueType  # 9
            """
            Russia
            """
            IN: Config.LoRaConfig._RegionCode.ValueType  # 10
            """
            India
            """
            NZ_865: Config.LoRaConfig._RegionCode.ValueType  # 11
            """
            New Zealand 865mhz
            """
            TH: Config.LoRaConfig._RegionCode.ValueType  # 12
            """
            Thailand
            """
            LORA_24: Config.LoRaConfig._RegionCode.ValueType  # 13
            """
            WLAN Band
            """
            UA_433: Config.LoRaConfig._RegionCode.ValueType  # 14
            """
            Ukraine 433mhz
            """
            UA_868: Config.LoRaConfig._RegionCode.ValueType  # 15
            """
            Ukraine 868mhz
            """
            MY_433: Config.LoRaConfig._RegionCode.ValueType  # 16
            """
            Malaysia 433mhz
            """
            MY_919: Config.LoRaConfig._RegionCode.ValueType  # 17
            """
            Malaysia 919mhz
            """
            SG_923: Config.LoRaConfig._RegionCode.ValueType  # 18
            """
            Singapore 923mhz
            """
            PH_433: Config.LoRaConfig._RegionCode.ValueType  # 19
            """
            Philippines 433mhz
            """
            PH_868: Config.LoRaConfig._RegionCode.ValueType  # 20
            """
            Philippines 868mhz
            """
            PH_915: Config.LoRaConfig._RegionCode.ValueType  # 21
            """
            Philippines 915mhz
            """
            ANZ_433: Config.LoRaConfig._RegionCode.ValueType  # 22
            """
            Australia / New Zealand 433MHz
            """
            KZ_433: Config.LoRaConfig._RegionCode.ValueType  # 23
            """
            Kazakhstan 433MHz
            """
            KZ_863: Config.LoRaConfig._RegionCode.ValueType  # 24
            """
            Kazakhstan 863MHz
            """
            NP_865: Config.LoRaConfig._RegionCode.ValueType  # 25
            """
            Nepal 865MHz
            """
            BR_902: Config.LoRaConfig._RegionCode.ValueType  # 26
            """
            Brazil 902MHz
            """

        class RegionCode(_RegionCode, metaclass=_RegionCodeEnumTypeWrapper): ...
        UNSET: Config.LoRaConfig.RegionCode.ValueType  # 0
        """
        Region is not set
        """
        US: Config.LoRaConfig.RegionCode.ValueType  # 1
        """
        United States
        """
        EU_433: Config.LoRaConfig.RegionCode.ValueType  # 2
        """
        European Union 433mhz
        """
        EU_868: Config.LoRaConfig.RegionCode.ValueType  # 3
        """
        European Union 868mhz
        """
        CN: Config.LoRaConfig.RegionCode.ValueType  # 4
        """
        China
        """
        JP: Config.LoRaConfig.RegionCode.ValueType  # 5
        """
        Japan
        """
        ANZ: Config.LoRaConfig.RegionCode.ValueType  # 6
        """
        Australia / New Zealand
        """
        KR: Config.LoRaConfig.RegionCode.ValueType  # 7
        """
        Korea
        """
        TW: Config.LoRaConfig.RegionCode.ValueType  # 8
        """
        Taiwan
        """
        RU: Config.LoRaConfig.RegionCode.ValueType  # 9
        """
        Russia
        """
        IN: Config.LoRaConfig.RegionCode.ValueType  # 10
        """
        India
        """
        NZ_865: Config.LoRaConfig.RegionCode.ValueType  # 11
        """
        New Zealand 865mhz
        """
        TH: Config.LoRaConfig.RegionCode.ValueType  # 12
        """
        Thailand
        """
        LORA_24: Config.LoRaConfig.RegionCode.ValueType  # 13
        """
        WLAN Band
        """
        UA_433: Config.LoRaConfig.RegionCode.ValueType  # 14
        """
        Ukraine 433mhz
        """
        UA_868: Config.LoRaConfig.RegionCode.ValueType  # 15
        """
        Ukraine 868mhz
        """
        MY_433: Config.LoRaConfig.RegionCode.ValueType  # 16
        """
        Malaysia 433mhz
        """
        MY_919: Config.LoRaConfig.RegionCode.ValueType  # 17
        """
        Malaysia 919mhz
        """
        SG_923: Config.LoRaConfig.RegionCode.ValueType  # 18
        """
        Singapore 923mhz
        """
        PH_433: Config.LoRaConfig.RegionCode.ValueType  # 19
        """
        Philippines 433mhz
        """
        PH_868: Config.LoRaConfig.RegionCode.ValueType  # 20
        """
        Philippines 868mhz
        """
        PH_915: Config.LoRaConfig.RegionCode.ValueType  # 21
        """
        Philippines 915mhz
        """
        ANZ_433: Config.LoRaConfig.RegionCode.ValueType  # 22
        """
        Australia / New Zealand 433MHz
        """
        KZ_433: Config.LoRaConfig.RegionCode.ValueType  # 23
        """
        Kazakhstan 433MHz
        """
        KZ_863: Config.LoRaConfig.RegionCode.ValueType  # 24
        """
        Kazakhstan 863MHz
        """
        NP_865: Config.LoRaConfig.RegionCode.ValueType  # 25
        """
        Nepal 865MHz
        """
        BR_902: Config.LoRaConfig.RegionCode.ValueType  # 26
        """
        Brazil 902MHz
        """

        class _ModemPreset:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _ModemPresetEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Config.LoRaConfig._ModemPreset.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            LONG_FAST: Config.LoRaConfig._ModemPreset.ValueType  # 0
            """
            Long Range - Fast
            """
            LONG_SLOW: Config.LoRaConfig._ModemPreset.ValueType  # 1
            """
            Long Range - Slow
            """
            VERY_LONG_SLOW: Config.LoRaConfig._ModemPreset.ValueType  # 2
            """
            Very Long Range - Slow
            Deprecated in 2.5: Works only with txco and is unusably slow
            """
            MEDIUM_SLOW: Config.LoRaConfig._ModemPreset.ValueType  # 3
            """
            Medium Range - Slow
            """
            MEDIUM_FAST: Config.LoRaConfig._ModemPreset.ValueType  # 4
            """
            Medium Range - Fast
            """
            SHORT_SLOW: Config.LoRaConfig._ModemPreset.ValueType  # 5
            """
            Short Range - Slow
            """
            SHORT_FAST: Config.LoRaConfig._ModemPreset.ValueType  # 6
            """
            Short Range - Fast
            """
            LONG_MODERATE: Config.LoRaConfig._ModemPreset.ValueType  # 7
            """
            Long Range - Moderately Fast
            """
            SHORT_TURBO: Config.LoRaConfig._ModemPreset.ValueType  # 8
            """
            Short Range - Turbo
            This is the fastest preset and the only one with 500kHz bandwidth.
            It is not legal to use in all regions due to this wider bandwidth.
            """

        class ModemPreset(_ModemPreset, metaclass=_ModemPresetEnumTypeWrapper):
            """
            Standard predefined channel settings
            Note: these mappings must match ModemPreset Choice in the device code.
            """

        LONG_FAST: Config.LoRaConfig.ModemPreset.ValueType  # 0
        """
        Long Range - Fast
        """
        LONG_SLOW: Config.LoRaConfig.ModemPreset.ValueType  # 1
        """
        Long Range - Slow
        """
        VERY_LONG_SLOW: Config.LoRaConfig.ModemPreset.ValueType  # 2
        """
        Very Long Range - Slow
        Deprecated in 2.5: Works only with txco and is unusably slow
        """
        MEDIUM_SLOW: Config.LoRaConfig.ModemPreset.ValueType  # 3
        """
        Medium Range - Slow
        """
        MEDIUM_FAST: Config.LoRaConfig.ModemPreset.ValueType  # 4
        """
        Medium Range - Fast
        """
        SHORT_SLOW: Config.LoRaConfig.ModemPreset.ValueType  # 5
        """
        Short Range - Slow
        """
        SHORT_FAST: Config.LoRaConfig.ModemPreset.ValueType  # 6
        """
        Short Range - Fast
        """
        LONG_MODERATE: Config.LoRaConfig.ModemPreset.ValueType  # 7
        """
        Long Range - Moderately Fast
        """
        SHORT_TURBO: Config.LoRaConfig.ModemPreset.ValueType  # 8
        """
        Short Range - Turbo
        This is the fastest preset and the only one with 500kHz bandwidth.
        It is not legal to use in all regions due to this wider bandwidth.
        """

        USE_PRESET_FIELD_NUMBER: builtins.int
        MODEM_PRESET_FIELD_NUMBER: builtins.int
        BANDWIDTH_FIELD_NUMBER: builtins.int
        SPREAD_FACTOR_FIELD_NUMBER: builtins.int
        CODING_RATE_FIELD_NUMBER: builtins.int
        FREQUENCY_OFFSET_FIELD_NUMBER: builtins.int
        REGION_FIELD_NUMBER: builtins.int
        HOP_LIMIT_FIELD_NUMBER: builtins.int
        TX_ENABLED_FIELD_NUMBER: builtins.int
        TX_POWER_FIELD_NUMBER: builtins.int
        CHANNEL_NUM_FIELD_NUMBER: builtins.int
        OVERRIDE_DUTY_CYCLE_FIELD_NUMBER: builtins.int
        SX126X_RX_BOOSTED_GAIN_FIELD_NUMBER: builtins.int
        OVERRIDE_FREQUENCY_FIELD_NUMBER: builtins.int
        PA_FAN_DISABLED_FIELD_NUMBER: builtins.int
        IGNORE_INCOMING_FIELD_NUMBER: builtins.int
        IGNORE_MQTT_FIELD_NUMBER: builtins.int
        CONFIG_OK_TO_MQTT_FIELD_NUMBER: builtins.int
        use_preset: builtins.bool
        """
        When enabled, the `modem_preset` fields will be adhered to, else the `bandwidth`/`spread_factor`/`coding_rate`
        will be taked from their respective manually defined fields
        """
        modem_preset: global___Config.LoRaConfig.ModemPreset.ValueType
        """
        Either modem_config or bandwidth/spreading/coding will be specified - NOT BOTH.
        As a heuristic: If bandwidth is specified, do not use modem_config.
        Because protobufs take ZERO space when the value is zero this works out nicely.
        This value is replaced by bandwidth/spread_factor/coding_rate.
        If you'd like to experiment with other options add them to MeshRadio.cpp in the device code.
        """
        bandwidth: builtins.int
        """
        Bandwidth in MHz
        Certain bandwidth numbers are 'special' and will be converted to the
        appropriate floating point value: 31 -> 31.25MHz
        """
        spread_factor: builtins.int
        """
        A number from 7 to 12.
        Indicates number of chirps per symbol as 1<<spread_factor.
        """
        coding_rate: builtins.int
        """
        The denominator of the coding rate.
        ie for 4/5, the value is 5. 4/8 the value is 8.
        """
        frequency_offset: builtins.float
        """
        This parameter is for advanced users with advanced test equipment, we do not recommend most users use it.
        A frequency offset that is added to to the calculated band center frequency.
        Used to correct for crystal calibration errors.
        """
        region: global___Config.LoRaConfig.RegionCode.ValueType
        """
        The region code for the radio (US, CN, EU433, etc...)
        """
        hop_limit: builtins.int
        """
        Maximum number of hops. This can't be greater than 7.
        Default of 3
        Attempting to set a value > 7 results in the default
        """
        tx_enabled: builtins.bool
        """
        Disable TX from the LoRa radio. Useful for hot-swapping antennas and other tests.
        Defaults to false
        """
        tx_power: builtins.int
        """
        If zero, then use default max legal continuous power (ie. something that won't
        burn out the radio hardware)
        In most cases you should use zero here.
        Units are in dBm.
        """
        channel_num: builtins.int
        """
        This controls the actual hardware frequency the radio transmits on.
        Most users should never need to be exposed to this field/concept.
        A channel number between 1 and NUM_CHANNELS (whatever the max is in the current region).
        If ZERO then the rule is "use the old channel name hash based
        algorithm to derive the channel number")
        If using the hash algorithm the channel number will be: hash(channel_name) %
        NUM_CHANNELS (Where num channels depends on the regulatory region).
        """
        override_duty_cycle: builtins.bool
        """
        If true, duty cycle limits will be exceeded and thus you're possibly not following
        the local regulations if you're not a HAM.
        Has no effect if the duty cycle of the used region is 100%.
        """
        sx126x_rx_boosted_gain: builtins.bool
        """
        If true, sets RX boosted gain mode on SX126X based radios
        """
        override_frequency: builtins.float
        """
        This parameter is for advanced users and licensed HAM radio operators.
        Ignore Channel Calculation and use this frequency instead. The frequency_offset
        will still be applied. This will allow you to use out-of-band frequencies.
        Please respect your local laws and regulations. If you are a HAM, make sure you
        enable HAM mode and turn off encryption.
        """
        pa_fan_disabled: builtins.bool
        """
        If true, disable the build-in PA FAN using pin define in RF95_FAN_EN.
        """
        ignore_mqtt: builtins.bool
        """
        If true, the device will not process any packets received via LoRa that passed via MQTT anywhere on the path towards it.
        """
        config_ok_to_mqtt: builtins.bool
        """
        Sets the ok_to_mqtt bit on outgoing packets
        """
        @property
        def ignore_incoming(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
            """
            For testing it is useful sometimes to force a node to never listen to
            particular other nodes (simulating radio out of range). All nodenums listed
            in ignore_incoming will have packets they send dropped on receive (by router.cpp)
            """

        def __init__(
            self,
            *,
            use_preset: builtins.bool = ...,
            modem_preset: global___Config.LoRaConfig.ModemPreset.ValueType = ...,
            bandwidth: builtins.int = ...,
            spread_factor: builtins.int = ...,
            coding_rate: builtins.int = ...,
            frequency_offset: builtins.float = ...,
            region: global___Config.LoRaConfig.RegionCode.ValueType = ...,
            hop_limit: builtins.int = ...,
            tx_enabled: builtins.bool = ...,
            tx_power: builtins.int = ...,
            channel_num: builtins.int = ...,
            override_duty_cycle: builtins.bool = ...,
            sx126x_rx_boosted_gain: builtins.bool = ...,
            override_frequency: builtins.float = ...,
            pa_fan_disabled: builtins.bool = ...,
            ignore_incoming: collections.abc.Iterable[builtins.int] | None = ...,
            ignore_mqtt: builtins.bool = ...,
            config_ok_to_mqtt: builtins.bool = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["bandwidth", b"bandwidth", "channel_num", b"channel_num", "coding_rate", b"coding_rate", "config_ok_to_mqtt", b"config_ok_to_mqtt", "frequency_offset", b"frequency_offset", "hop_limit", b"hop_limit", "ignore_incoming", b"ignore_incoming", "ignore_mqtt", b"ignore_mqtt", "modem_preset", b"modem_preset", "override_duty_cycle", b"override_duty_cycle", "override_frequency", b"override_frequency", "pa_fan_disabled", b"pa_fan_disabled", "region", b"region", "spread_factor", b"spread_factor", "sx126x_rx_boosted_gain", b"sx126x_rx_boosted_gain", "tx_enabled", b"tx_enabled", "tx_power", b"tx_power", "use_preset", b"use_preset"]) -> None: ...

    @typing.final
    class BluetoothConfig(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _PairingMode:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _PairingModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Config.BluetoothConfig._PairingMode.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            RANDOM_PIN: Config.BluetoothConfig._PairingMode.ValueType  # 0
            """
            Device generates a random PIN that will be shown on the screen of the device for pairing
            """
            FIXED_PIN: Config.BluetoothConfig._PairingMode.ValueType  # 1
            """
            Device requires a specified fixed PIN for pairing
            """
            NO_PIN: Config.BluetoothConfig._PairingMode.ValueType  # 2
            """
            Device requires no PIN for pairing
            """

        class PairingMode(_PairingMode, metaclass=_PairingModeEnumTypeWrapper): ...
        RANDOM_PIN: Config.BluetoothConfig.PairingMode.ValueType  # 0
        """
        Device generates a random PIN that will be shown on the screen of the device for pairing
        """
        FIXED_PIN: Config.BluetoothConfig.PairingMode.ValueType  # 1
        """
        Device requires a specified fixed PIN for pairing
        """
        NO_PIN: Config.BluetoothConfig.PairingMode.ValueType  # 2
        """
        Device requires no PIN for pairing
        """

        ENABLED_FIELD_NUMBER: builtins.int
        MODE_FIELD_NUMBER: builtins.int
        FIXED_PIN_FIELD_NUMBER: builtins.int
        enabled: builtins.bool
        """
        Enable Bluetooth on the device
        """
        mode: global___Config.BluetoothConfig.PairingMode.ValueType
        """
        Determines the pairing strategy for the device
        """
        fixed_pin: builtins.int
        """
        Specified PIN for PairingMode.FixedPin
        """
        def __init__(
            self,
            *,
            enabled: builtins.bool = ...,
            mode: global___Config.BluetoothConfig.PairingMode.ValueType = ...,
            fixed_pin: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["enabled", b"enabled", "fixed_pin", b"fixed_pin", "mode", b"mode"]) -> None: ...

    @typing.final
    class SecurityConfig(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        PUBLIC_KEY_FIELD_NUMBER: builtins.int
        PRIVATE_KEY_FIELD_NUMBER: builtins.int
        ADMIN_KEY_FIELD_NUMBER: builtins.int
        IS_MANAGED_FIELD_NUMBER: builtins.int
        SERIAL_ENABLED_FIELD_NUMBER: builtins.int
        DEBUG_LOG_API_ENABLED_FIELD_NUMBER: builtins.int
        ADMIN_CHANNEL_ENABLED_FIELD_NUMBER: builtins.int
        public_key: builtins.bytes
        """
        The public key of the user's device.
        Sent out to other nodes on the mesh to allow them to compute a shared secret key.
        """
        private_key: builtins.bytes
        """
        The private key of the device.
        Used to create a shared key with a remote device.
        """
        is_managed: builtins.bool
        """
        If true, device is considered to be "managed" by a mesh administrator via admin messages
        Device is managed by a mesh administrator.
        """
        serial_enabled: builtins.bool
        """
        Serial Console over the Stream API."
        """
        debug_log_api_enabled: builtins.bool
        """
        By default we turn off logging as soon as an API client connects (to keep shared serial link quiet).
        Output live debug logging over serial or bluetooth is set to true.
        """
        admin_channel_enabled: builtins.bool
        """
        Allow incoming device control over the insecure legacy admin channel.
        """
        @property
        def admin_key(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bytes]:
            """
            The public key authorized to send admin messages to this node.
            """

        def __init__(
            self,
            *,
            public_key: builtins.bytes = ...,
            private_key: builtins.bytes = ...,
            admin_key: collections.abc.Iterable[builtins.bytes] | None = ...,
            is_managed: builtins.bool = ...,
            serial_enabled: builtins.bool = ...,
            debug_log_api_enabled: builtins.bool = ...,
            admin_channel_enabled: builtins.bool = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["admin_channel_enabled", b"admin_channel_enabled", "admin_key", b"admin_key", "debug_log_api_enabled", b"debug_log_api_enabled", "is_managed", b"is_managed", "private_key", b"private_key", "public_key", b"public_key", "serial_enabled", b"serial_enabled"]) -> None: ...

    @typing.final
    class SessionkeyConfig(google.protobuf.message.Message):
        """
        Blank config request, strictly for getting the session key
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        def __init__(
            self,
        ) -> None: ...

    DEVICE_FIELD_NUMBER: builtins.int
    POSITION_FIELD_NUMBER: builtins.int
    POWER_FIELD_NUMBER: builtins.int
    NETWORK_FIELD_NUMBER: builtins.int
    DISPLAY_FIELD_NUMBER: builtins.int
    LORA_FIELD_NUMBER: builtins.int
    BLUETOOTH_FIELD_NUMBER: builtins.int
    SECURITY_FIELD_NUMBER: builtins.int
    SESSIONKEY_FIELD_NUMBER: builtins.int
    DEVICE_UI_FIELD_NUMBER: builtins.int
    @property
    def device(self) -> global___Config.DeviceConfig: ...
    @property
    def position(self) -> global___Config.PositionConfig: ...
    @property
    def power(self) -> global___Config.PowerConfig: ...
    @property
    def network(self) -> global___Config.NetworkConfig: ...
    @property
    def display(self) -> global___Config.DisplayConfig: ...
    @property
    def lora(self) -> global___Config.LoRaConfig: ...
    @property
    def bluetooth(self) -> global___Config.BluetoothConfig: ...
    @property
    def security(self) -> global___Config.SecurityConfig: ...
    @property
    def sessionkey(self) -> global___Config.SessionkeyConfig: ...
    @property
    def device_ui(self) -> meshtastic.protobuf.device_ui_pb2.DeviceUIConfig: ...
    def __init__(
        self,
        *,
        device: global___Config.DeviceConfig | None = ...,
        position: global___Config.PositionConfig | None = ...,
        power: global___Config.PowerConfig | None = ...,
        network: global___Config.NetworkConfig | None = ...,
        display: global___Config.DisplayConfig | None = ...,
        lora: global___Config.LoRaConfig | None = ...,
        bluetooth: global___Config.BluetoothConfig | None = ...,
        security: global___Config.SecurityConfig | None = ...,
        sessionkey: global___Config.SessionkeyConfig | None = ...,
        device_ui: meshtastic.protobuf.device_ui_pb2.DeviceUIConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["bluetooth", b"bluetooth", "device", b"device", "device_ui", b"device_ui", "display", b"display", "lora", b"lora", "network", b"network", "payload_variant", b"payload_variant", "position", b"position", "power", b"power", "security", b"security", "sessionkey", b"sessionkey"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["bluetooth", b"bluetooth", "device", b"device", "device_ui", b"device_ui", "display", b"display", "lora", b"lora", "network", b"network", "payload_variant", b"payload_variant", "position", b"position", "power", b"power", "security", b"security", "sessionkey", b"sessionkey"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["payload_variant", b"payload_variant"]) -> typing.Literal["device", "position", "power", "network", "display", "lora", "bluetooth", "security", "sessionkey", "device_ui"] | None: ...

global___Config = Config
