/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.exceptions.ResourceCloseFailureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;

public abstract class BaseStreamIterator
implements RawIterator<AnyValue[], ProcedureException>,
Resource {
    private final Iterator<?> out;
    private Stream<?> stream;
    private final ResourceTracker resourceTracker;
    private final ProcedureSignature signature;

    public BaseStreamIterator(Stream<?> stream, ResourceTracker resourceTracker, ProcedureSignature signature) {
        this.out = stream.iterator();
        this.stream = stream;
        this.resourceTracker = resourceTracker;
        this.signature = signature;
        resourceTracker.registerCloseableResource(stream);
    }

    public abstract AnyValue[] map(Object var1);

    public boolean hasNext() throws ProcedureException {
        try {
            boolean hasNext = this.out.hasNext();
            if (!hasNext) {
                this.close();
            }
            return hasNext;
        }
        catch (Throwable throwable) {
            throw this.closeAndCreateProcedureException(throwable);
        }
    }

    public AnyValue[] next() throws ProcedureException {
        try {
            Object record = this.out.next();
            return this.map(record);
        }
        catch (Throwable throwable) {
            throw this.closeAndCreateProcedureException(throwable);
        }
    }

    public void close() {
        if (this.stream != null) {
            Stream<?> resourceToClose = this.stream;
            this.stream = null;
            IOUtils.close(ResourceCloseFailureException::new, (AutoCloseable[])new AutoCloseable[]{() -> this.resourceTracker.unregisterCloseableResource(resourceToClose), resourceToClose});
        }
    }

    private ProcedureException closeAndCreateProcedureException(Throwable t) {
        ProcedureException procedureException = this.newProcedureException(t);
        try {
            this.close();
        }
        catch (Exception exceptionDuringClose) {
            try {
                procedureException.addSuppressed((Throwable)exceptionDuringClose);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return procedureException;
    }

    private ProcedureException newProcedureException(Throwable throwable) {
        if (throwable instanceof Status.HasStatus) {
            return new ProcedureException(((Status.HasStatus)throwable).status(), throwable, throwable.getMessage(), new Object[0]);
        }
        Throwable cause = ExceptionUtils.getRootCause((Throwable)throwable);
        return new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, throwable, "Failed to invoke procedure `%s`: %s", new Object[]{this.signature.name(), "Caused by: " + (cause != null ? cause : throwable)});
    }
}

