/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import java.lang.reflect.Array;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.neo4j.function.Predicates;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public class RecordDataAssembler<RECORD extends AbstractBaseRecord> {
    private final Supplier<RECORD> factory;
    private final Class<RECORD> klass;
    private final Predicate<RECORD> filter;
    private final RecordLoad loadMode;

    public RecordDataAssembler(Supplier<RECORD> factory, boolean forScan) {
        this(factory, Predicates.alwaysTrue(), forScan);
    }

    public RecordDataAssembler(Supplier<RECORD> factory, Predicate<RECORD> filter, boolean forScan) {
        this.factory = factory;
        this.filter = filter;
        this.klass = ((AbstractBaseRecord)factory.get()).getClass();
        this.loadMode = forScan ? RecordLoad.LENIENT_CHECK : RecordLoad.CHECK;
    }

    public RECORD[] newBatchObject(int batchSize) {
        Object array = Array.newInstance(this.klass, batchSize);
        for (int i = 0; i < batchSize; ++i) {
            Array.set(array, i, this.factory.get());
        }
        return (AbstractBaseRecord[])array;
    }

    public boolean append(RecordStore<RECORD> store, PageCursor cursor, RECORD[] array, long id, int index) {
        RECORD record = array[index];
        store.getRecordByCursor(id, record, this.loadMode, cursor);
        return ((AbstractBaseRecord)record).inUse() && this.filter.test(record);
    }

    public RECORD[] cutOffAt(RECORD[] array, int length) {
        for (int i = length; i < array.length; ++i) {
            ((AbstractBaseRecord)array[i]).clear();
        }
        return array;
    }
}

