/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.LocalDate;
import java.util.Arrays;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.TemporalArray;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;

public final class DateArray
extends TemporalArray<LocalDate> {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(DateArray.class);
    private final LocalDate[] value;

    DateArray(LocalDate[] value) {
        assert (value != null);
        this.value = value;
    }

    protected LocalDate[] value() {
        return this.value;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapDateArray(this);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(LocalDate[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        DateArray.writeTo(writer, ValueWriter.ArrayType.DATE, this.value);
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.DATE_ARRAY;
    }

    @Override
    protected int unsafeCompareTo(Value otherValue) {
        return this.compareToNonPrimitiveArray((DateArray)otherValue);
    }

    @Override
    public String getTypeName() {
        return "DateArray";
    }

    @Override
    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.sizeOfObjectArray(HeapEstimator.LOCAL_DATE_SIZE, this.value.length);
    }

    @Override
    public boolean hasCompatibleType(AnyValue value) {
        return value instanceof DateValue;
    }

    @Override
    public ArrayValue copyWithAppended(AnyValue added) {
        assert (this.hasCompatibleType(added)) : "Incompatible types";
        LocalDate[] newArray = Arrays.copyOf(this.value, this.value.length + 1);
        newArray[this.value.length] = ((DateValue)added).temporal();
        return new DateArray(newArray);
    }

    @Override
    public ArrayValue copyWithPrepended(AnyValue prepended) {
        assert (this.hasCompatibleType(prepended)) : "Incompatible types";
        LocalDate[] newArray = new LocalDate[this.value.length + 1];
        System.arraycopy(this.value, 0, newArray, 1, this.value.length);
        newArray[0] = ((DateValue)prepended).temporal();
        return new DateArray(newArray);
    }
}

