/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.ZonedDateTime;
import java.util.Arrays;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.TemporalArray;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;

public final class DateTimeArray
extends TemporalArray<ZonedDateTime> {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(DateTimeArray.class);
    private final ZonedDateTime[] value;

    DateTimeArray(ZonedDateTime[] value) {
        assert (value != null);
        this.value = value;
    }

    protected ZonedDateTime[] value() {
        return this.value;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapDateTimeArray(this);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(ZonedDateTime[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        DateTimeArray.writeTo(writer, ValueWriter.ArrayType.ZONED_DATE_TIME, this.value);
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.ZONED_DATE_TIME_ARRAY;
    }

    @Override
    protected int unsafeCompareTo(Value otherValue) {
        return this.compareToNonPrimitiveArray((DateTimeArray)otherValue);
    }

    @Override
    public String getTypeName() {
        return "DateTimeArray";
    }

    @Override
    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.sizeOfObjectArray(HeapEstimator.ZONED_DATE_TIME_SIZE, this.value.length);
    }

    @Override
    public boolean hasCompatibleType(AnyValue value) {
        return value instanceof DateTimeValue;
    }

    @Override
    public ArrayValue copyWithAppended(AnyValue added) {
        assert (this.hasCompatibleType(added)) : "Incompatible types";
        ZonedDateTime[] newArray = Arrays.copyOf(this.value, this.value.length + 1);
        newArray[this.value.length] = ((DateTimeValue)added).temporal();
        return new DateTimeArray(newArray);
    }

    @Override
    public ArrayValue copyWithPrepended(AnyValue prepended) {
        assert (this.hasCompatibleType(prepended)) : "Incompatible types";
        ZonedDateTime[] newArray = new ZonedDateTime[this.value.length + 1];
        System.arraycopy(this.value, 0, newArray, 1, this.value.length);
        newArray[0] = ((DateTimeValue)prepended).temporal();
        return new DateTimeArray(newArray);
    }
}

