/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.packstream;

import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.StructType;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.packstream.Neo4jPackV2;
import org.neo4j.bolt.packstream.PackInput;
import org.neo4j.bolt.packstream.PackOutput;
import org.neo4j.bolt.packstream.PackStream;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DateTimeValue;

public class Neo4jPackV3
extends Neo4jPackV2 {
    public static final long VERSION = 3L;
    public static final byte DATE_TIME_WITH_ZONE_OFFSET_UTC = 73;
    public static final int DATE_TIME_WITH_ZONE_OFFSET_UTC_SIZE = 3;
    public static final byte DATE_TIME_WITH_ZONE_NAME_UTC = 105;
    public static final int DATE_TIME_WITH_ZONE_NAME_UTC_SIZE = 3;

    @Override
    public Neo4jPack.Packer newPacker(PackOutput output) {
        return new PackerV3(output);
    }

    @Override
    public Neo4jPack.Unpacker newUnpacker(PackInput input) {
        return new UnpackerV3(input);
    }

    @Override
    public long version() {
        return 3L;
    }

    private static class UnpackerV3
    extends Neo4jPackV2.UnpackerV2 {
        UnpackerV3(PackInput input) {
            super(input);
        }

        @Override
        protected AnyValue unpackStruct(char signature, long size) throws IOException {
            try {
                switch (signature) {
                    case 'X': {
                        UnpackerV3.ensureCorrectStructSize(StructType.POINT_2D, 3, size);
                        return this.unpackPoint2D();
                    }
                    case 'Y': {
                        UnpackerV3.ensureCorrectStructSize(StructType.POINT_3D, 4, size);
                        return this.unpackPoint3D();
                    }
                    case 'E': {
                        UnpackerV3.ensureCorrectStructSize(StructType.DURATION, 4, size);
                        return this.unpackDuration();
                    }
                    case 'D': {
                        UnpackerV3.ensureCorrectStructSize(StructType.DATE, 1, size);
                        return this.unpackDate();
                    }
                    case 't': {
                        UnpackerV3.ensureCorrectStructSize(StructType.LOCAL_TIME, 1, size);
                        return this.unpackLocalTime();
                    }
                    case 'T': {
                        UnpackerV3.ensureCorrectStructSize(StructType.TIME, 2, size);
                        return this.unpackTime();
                    }
                    case 'd': {
                        UnpackerV3.ensureCorrectStructSize(StructType.LOCAL_DATE_TIME, 2, size);
                        return this.unpackLocalDateTime();
                    }
                    case 'I': {
                        UnpackerV3.ensureCorrectStructSize(StructType.DATE_TIME_WITH_ZONE_OFFSET_UTC, 3, size);
                        return this.unpackDateTimeWithZoneOffset();
                    }
                    case 'i': {
                        UnpackerV3.ensureCorrectStructSize(StructType.DATE_TIME_WITH_ZONE_NAME_UTC, 3, size);
                        return this.unpackDateTimeWithZoneName();
                    }
                    case 'F': {
                        throw new BoltIOException((Status)Status.Statement.TypeError, String.format("Unable to unpack struct: %s when UTC DateTime has been negotiated.", (byte)70));
                    }
                    case 'f': {
                        throw new BoltIOException((Status)Status.Statement.TypeError, String.format("Unable to unpack struct: %s when UTC DateTime has been negotiated.", (byte)102));
                    }
                }
                return super.unpackStruct(signature, size);
            }
            catch (BoltIOException | PackStream.PackStreamException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                StructType type = StructType.valueOf(signature);
                if (type != null) {
                    throw new BoltIOException((Status)Status.Statement.TypeError, String.format("Unable to construct %s value: `%s`", type.description(), ex.getMessage()), ex);
                }
                throw ex;
            }
        }

        @Override
        protected DateTimeValue unpackDateTimeWithZoneOffset() throws IOException {
            long epochSecond = this.unpackLong();
            long nanos = this.unpackLong();
            long offsetSeconds = this.unpackLong();
            ZoneOffset offset = ZoneOffset.ofTotalSeconds((int)offsetSeconds);
            Instant instant = Instant.ofEpochSecond(epochSecond, nanos);
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, offset);
            return DateTimeValue.datetime((OffsetDateTime)OffsetDateTime.of(localDateTime, offset));
        }

        @Override
        protected DateTimeValue unpackDateTimeWithZoneName() throws IOException {
            long epochSecond = this.unpackLong();
            long nanos = this.unpackLong();
            String zoneName = this.unpackString();
            Instant instant = Instant.ofEpochSecond(epochSecond, nanos);
            ZoneId zoneId = ZoneId.of(zoneName);
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zoneId);
            return DateTimeValue.datetime((ZonedDateTime)ZonedDateTime.of(localDateTime, zoneId));
        }
    }

    private static class PackerV3
    extends Neo4jPackV2.PackerV2 {
        PackerV3(PackOutput output) {
            super(output);
        }

        @Override
        public void writeDateTime(ZonedDateTime zonedDateTime) throws IOException {
            Objects.requireNonNull(zonedDateTime, "dateTime cannot be null");
            Instant instant = zonedDateTime.toInstant();
            long epochSeconds = instant.getEpochSecond();
            int epochNano = zonedDateTime.getNano();
            ZoneId zone = zonedDateTime.getZone();
            if (zone instanceof ZoneOffset) {
                int offsetSeconds = ((ZoneOffset)zone).getTotalSeconds();
                this.packStructHeader(3, (byte)73);
                this.pack(epochSeconds);
                this.pack(epochNano);
                this.pack(offsetSeconds);
                return;
            }
            this.packStructHeader(3, (byte)105);
            this.pack(epochSeconds);
            this.pack(epochNano);
            this.pack(zone.getId());
        }
    }
}

