/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.logging.Level;
import org.neo4j.values.storable.DurationValue;

public final class DriverSettings {
    private final Boolean sslEnforced;
    private final Duration connectionTimeout;
    private final Duration connectionMaxLifetime;
    private final Duration connectionPoolAcquisitionTimeout;
    private final Duration connectionPoolIdleTest;
    private final Integer connectionPoolMaxSize;
    private final Level loggingLevel;

    private DriverSettings(Boolean sslEnforced, Duration connectionTimeout, Duration connectionMaxLifetime, Duration connectionPoolAcquisitionTimeout, Duration connectionPoolIdleTest, Integer connectionPoolMaxSize, Level loggingLevel) {
        this.sslEnforced = sslEnforced;
        this.connectionTimeout = connectionTimeout;
        this.connectionMaxLifetime = connectionMaxLifetime;
        this.connectionPoolAcquisitionTimeout = connectionPoolAcquisitionTimeout;
        this.connectionPoolIdleTest = connectionPoolIdleTest;
        this.connectionPoolMaxSize = connectionPoolMaxSize;
        this.loggingLevel = loggingLevel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Boolean> isSslEnforced() {
        return Optional.ofNullable(this.sslEnforced);
    }

    public Optional<Duration> connectionTimeout() {
        return Optional.ofNullable(this.connectionTimeout);
    }

    public Optional<Duration> connectionMaxLifetime() {
        return Optional.ofNullable(this.connectionMaxLifetime);
    }

    public Optional<Duration> connectionPoolAcquisitionTimeout() {
        return Optional.ofNullable(this.connectionPoolAcquisitionTimeout);
    }

    public Optional<Duration> connectionPoolIdleTest() {
        return Optional.ofNullable(this.connectionPoolIdleTest);
    }

    public Optional<Integer> connectionPoolMaxSize() {
        return Optional.ofNullable(this.connectionPoolMaxSize);
    }

    public Optional<Level> loggingLevel() {
        return Optional.ofNullable(this.loggingLevel);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DriverSettings that = (DriverSettings)o;
        return Objects.equals(this.sslEnforced, that.sslEnforced) && Objects.equals(this.connectionTimeout, that.connectionTimeout) && Objects.equals(this.connectionMaxLifetime, that.connectionMaxLifetime) && Objects.equals(this.connectionPoolAcquisitionTimeout, that.connectionPoolAcquisitionTimeout) && Objects.equals(this.connectionPoolIdleTest, that.connectionPoolIdleTest) && Objects.equals(this.connectionPoolMaxSize, that.connectionPoolMaxSize) && this.loggingLevel == that.loggingLevel;
    }

    public int hashCode() {
        return Objects.hash(this.sslEnforced, this.connectionTimeout, this.connectionMaxLifetime, this.connectionPoolAcquisitionTimeout, this.connectionPoolIdleTest, this.connectionPoolMaxSize, this.loggingLevel);
    }

    static class Builder {
        private Boolean sslEnabled;
        private Duration connectionTimeout;
        private Duration connectionMaxLifetime;
        private Duration connectionPoolAcquisitionTimeout;
        private Duration connectionPoolIdleTest;
        private Integer connectionPoolMaxSize;
        private Level loggingLevel;

        private Builder() {
        }

        Builder withSSlEnforced(boolean sslEnforced) {
            this.sslEnabled = sslEnforced;
            return this;
        }

        Builder withConnectionTimeout(DurationValue connectionTimeout) {
            this.connectionTimeout = this.convertDurationValue(connectionTimeout, Keys.CONNECTION_TIMEOUT.toString());
            return this;
        }

        Builder withConnectionMaxLifeTime(DurationValue connectionMaxLifetime) {
            this.connectionMaxLifetime = this.convertDurationValue(connectionMaxLifetime, Keys.CONNECTION_MAX_LIFETIME.toString());
            return this;
        }

        Builder withConnectionPoolAcquisitionTimeout(DurationValue connectionPoolAcquisitionTimeout) {
            this.connectionPoolAcquisitionTimeout = this.convertDurationValue(connectionPoolAcquisitionTimeout, Keys.CONNECTION_POOL_ACQUISITION_TIMEOUT.toString());
            return this;
        }

        Builder withConnectionPoolIdleTest(DurationValue connectionPoolIdleTest) {
            this.connectionPoolIdleTest = this.convertDurationValue(connectionPoolIdleTest, Keys.CONNECTION_POOL_IDLE_TEST.toString());
            return this;
        }

        Builder withConnectionPoolMaxSize(int connectionPoolMaxSize) {
            this.connectionPoolMaxSize = connectionPoolMaxSize;
            return this;
        }

        Builder withLoggingLevel(Level loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        DriverSettings build() {
            return new DriverSettings(this.sslEnabled, this.connectionTimeout, this.connectionMaxLifetime, this.connectionPoolAcquisitionTimeout, this.connectionPoolIdleTest, this.connectionPoolMaxSize, this.loggingLevel);
        }

        private Duration convertDurationValue(DurationValue durationValue, String durationName) {
            if (durationValue.compareTo(DurationValue.duration((Duration)Duration.ofHours(24L))) > 0) {
                throw new IllegalStateException(String.format("Driver setting %s is a duration of %s. This is greater than the max of 24 hours! Please reduce it.", durationName, durationValue.prettyPrint()));
            }
            long seconds = durationValue.get((TemporalUnit)ChronoUnit.SECONDS);
            return Duration.ofSeconds(seconds);
        }
    }

    static enum Keys {
        SSL_ENFORCED,
        CONNECTION_TIMEOUT,
        CONNECTION_MAX_LIFETIME,
        CONNECTION_POOL_ACQUISITION_TIMEOUT,
        CONNECTION_POOL_IDLE_TEST,
        CONNECTION_POOL_MAX_SIZE,
        LOGGING_LEVEL;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

