/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.collection;

import java.util.Iterator;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;

public abstract class NestingIterator<T, U>
extends PrefetchingIterator<T> {
    private final Iterator<U> source;
    private Iterator<T> currentNestedIterator;

    public NestingIterator(Iterator<U> source) {
        this.source = source;
    }

    protected abstract Iterator<T> createNestedIterator(U var1);

    @Override
    protected T fetchNextOrNull() {
        if (this.currentNestedIterator == null || !this.currentNestedIterator.hasNext()) {
            while (this.source.hasNext()) {
                U currentSurfaceItem = this.source.next();
                this.currentNestedIterator = this.createNestedIterator(currentSurfaceItem);
                if (!this.currentNestedIterator.hasNext()) continue;
                break;
            }
        }
        return this.currentNestedIterator != null && this.currentNestedIterator.hasNext() ? (T)this.currentNestedIterator.next() : null;
    }
}

