/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.layout.recordstorage;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.io.layout.CommonDatabaseFile;
import org.neo4j.io.layout.DatabaseFile;

public enum RecordDatabaseFile implements DatabaseFile
{
    NODE_STORE("neostore.nodestore.db"),
    NODE_LABEL_STORE("neostore.nodestore.db.labels"),
    PROPERTY_STORE("neostore.propertystore.db"),
    PROPERTY_ARRAY_STORE("neostore.propertystore.db.arrays"),
    PROPERTY_STRING_STORE("neostore.propertystore.db.strings"),
    PROPERTY_KEY_TOKEN_STORE("neostore.propertystore.db.index"),
    PROPERTY_KEY_TOKEN_NAMES_STORE("neostore.propertystore.db.index.keys"),
    RELATIONSHIP_STORE("neostore.relationshipstore.db"),
    RELATIONSHIP_GROUP_STORE("neostore.relationshipgroupstore.db"),
    RELATIONSHIP_TYPE_TOKEN_STORE("neostore.relationshiptypestore.db"),
    RELATIONSHIP_TYPE_TOKEN_NAMES_STORE("neostore.relationshiptypestore.db.names"),
    LABEL_TOKEN_STORE("neostore.labeltokenstore.db"),
    LABEL_TOKEN_NAMES_STORE("neostore.labeltokenstore.db.names"),
    SCHEMA_STORE("neostore.schemastore.db"),
    COUNTS_STORE("neostore.counts.db", false),
    RELATIONSHIP_GROUP_DEGREES_STORE("neostore.relationshipgroupstore.degrees.db", false);

    private final String name;
    private final boolean hasIdFile;

    private RecordDatabaseFile(String name) {
        this(name, true);
    }

    private RecordDatabaseFile(String name, boolean hasIdFile) {
        this.name = name;
        this.hasIdFile = hasIdFile;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasIdFile() {
        return this.hasIdFile;
    }

    public static Optional<DatabaseFile> fileOf(String name) {
        DatabaseFile[] databaseFiles;
        Objects.requireNonNull(name);
        for (DatabaseFile databaseFile : databaseFiles = RecordDatabaseFile.allValues()) {
            if (!databaseFile.getName().equals(name)) continue;
            return Optional.of(databaseFile);
        }
        return Optional.empty();
    }

    public static DatabaseFile[] allValues() {
        return (DatabaseFile[])ArrayUtils.addAll((Object[])((DatabaseFile[])ArrayUtils.addAll((Object[])new DatabaseFile[0], (Object[])CommonDatabaseFile.values())), (Object[])RecordDatabaseFile.values());
    }
}

