/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ast.factory;

import java.util.List;
import org.neo4j.cypher.internal.ast.factory.ConstraintType;
import org.neo4j.cypher.internal.ast.factory.CreateIndexTypes;
import org.neo4j.cypher.internal.ast.factory.ShowCommandFilterTypes;

public interface ASTExceptionFactory {
    public static final String invalidDropCommand = "Unsupported drop constraint command: Please delete the constraint by name instead";
    public static final String invalidCatalogStatement = "CATALOG is not allowed for this statement";

    public Exception syntaxException(String var1, List<String> var2, Exception var3, int var4, int var5, int var6);

    public Exception syntaxException(Exception var1, int var2, int var3, int var4);

    public static String relationshipPattternNotAllowed(ConstraintType type) {
        return String.format("'%s' does not allow relationship patterns", type.description());
    }

    public static String onlySinglePropertyAllowed(ConstraintType type) {
        return String.format("'%s' does not allow multiple properties", type.description());
    }

    public static String invalidShowFilterType(String command, ShowCommandFilterTypes got) {
        return String.format("Filter type %s is not defined for show %s command.", got.description(), command);
    }

    public static String invalidCreateIndexType(CreateIndexTypes got) {
        return String.format("Index type %s is not defined for create index command.", got.description());
    }

    public static String invalidDotsInRemoteAliasName(String name) {
        return String.format("'.' is not a valid character in the remote alias name '%s'. Remote alias names using '.' must be quoted with backticks e.g. `remote.alias`.", name);
    }
}

