/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.cardinality;

import java.io.Serializable;
import org.neo4j.cypher.internal.compiler.planner.logical.PlannerDefaults$;
import org.neo4j.cypher.internal.compiler.planner.logical.cardinality.ExpressionSelectivityCalculator;
import org.neo4j.cypher.internal.compiler.planner.logical.cardinality.SelectivityCombiner;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.InequalityRangeSeekable;
import org.neo4j.cypher.internal.planner.spi.GraphStatistics;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor;
import org.neo4j.cypher.internal.util.Selectivity;
import org.neo4j.cypher.internal.util.Selectivity$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class ExpressionSelectivityCalculator$
implements scala.Serializable {
    public static ExpressionSelectivityCalculator$ MODULE$;

    static {
        new ExpressionSelectivityCalculator$();
    }

    public Selectivity indexSelectivityForSubstringSargable(int stringLength, IndexDescriptor.IndexType indexType) {
        Selectivity selectivity;
        if (stringLength == 0) {
            IndexDescriptor.IndexType indexType2 = indexType;
            Selectivity selectivity2 = IndexDescriptor.IndexType$.Text$.MODULE$.equals(indexType2) ? Selectivity$.MODULE$.ONE() : PlannerDefaults$.MODULE$.DEFAULT_TYPE_SELECTIVITY();
            selectivity = selectivity2;
        } else {
            selectivity = Selectivity$.MODULE$.apply(PlannerDefaults$.MODULE$.DEFAULT_RANGE_SEEK_FACTOR() / (double)stringLength);
        }
        return selectivity;
    }

    public Selectivity indexSelectivityForSubstringSargable(Option<String> maybeString, IndexDescriptor.IndexType indexType) {
        return this.indexSelectivityForSubstringSargable(this.getStringLength(maybeString), indexType);
    }

    public IndexDescriptor.IndexType indexSelectivityForSubstringSargable$default$2() {
        return IndexDescriptor.IndexType$.Btree$.MODULE$;
    }

    public int getStringLength(Option<String> maybeString) {
        int n;
        Option<String> option = maybeString;
        if (option instanceof Some) {
            Some some = (Some)option;
            String n2 = (String)some.value();
            n = n2.length();
        } else if (None$.MODULE$.equals(option)) {
            n = PlannerDefaults$.MODULE$.DEFAULT_STRING_LENGTH();
        } else {
            throw new MatchError(option);
        }
        return n;
    }

    public Selectivity getPropertyPredicateRangeSelectivity(InequalityRangeSeekable seekable, Selectivity propEqValueSelectivity) {
        Selectivity pNeq = propEqValueSelectivity.negate();
        double pNeqRange = pNeq.factor() * PlannerDefaults$.MODULE$.DEFAULT_RANGE_SEEK_FACTOR() / (double)Math.min(seekable.expr().inequalities().size(), 2);
        Selectivity pRange = Selectivity$.MODULE$.apply(seekable.hasEquality() ? propEqValueSelectivity.factor() + pNeqRange : pNeqRange);
        return Selectivity$.MODULE$.apply(package$.MODULE$.max(propEqValueSelectivity.factor(), pRange.factor()));
    }

    public Selectivity indexSelectivityWithSizeHint(Option<Object> sizeHint, Function1<Object, Selectivity> selectivityCalculator) {
        Selectivity selectivity;
        int n = BoxesRunTime.unboxToInt((Object)sizeHint.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> (int)PlannerDefaults$.MODULE$.DEFAULT_LIST_CARDINALITY().amount()));
        switch (n) {
            case 0: {
                selectivity = Selectivity$.MODULE$.ZERO();
                break;
            }
            default: {
                selectivity = (Selectivity)selectivityCalculator.apply((Object)BoxesRunTime.boxToInteger((int)n));
                break;
            }
        }
        return selectivity;
    }

    public ExpressionSelectivityCalculator apply(GraphStatistics stats, SelectivityCombiner combiner, boolean planningTextIndexesEnabled) {
        return new ExpressionSelectivityCalculator(stats, combiner, planningTextIndexesEnabled);
    }

    public Option<Tuple3<GraphStatistics, SelectivityCombiner, Object>> unapply(ExpressionSelectivityCalculator x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.stats(), (Object)x$0.combiner(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.planningTextIndexesEnabled())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ExpressionSelectivityCalculator$() {
        MODULE$ = this;
    }
}

