/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrderCapability;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.IndexValueCapability;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.AbstractLuceneIndexProvider;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.monitoring.Monitors;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.ValueCategory;

public class LuceneIndexProvider
extends AbstractLuceneIndexProvider {
    public static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor("lucene", "2.0");
    public static final IndexCapability CAPABILITY = new LuceneIndexCapability();

    public LuceneIndexProvider(FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory, IndexDirectoryStructure.Factory directoryStructureFactory, Monitors monitors, Config config, DatabaseReadOnlyChecker readOnlyChecker) {
        super(IndexType.BTREE, DESCRIPTOR, fileSystem, directoryFactory, directoryStructureFactory, monitors, config, readOnlyChecker);
    }

    @Override
    public IndexDescriptor completeConfiguration(IndexDescriptor index) {
        return index.getCapability().equals(IndexCapability.NO_CAPABILITY) ? index.withIndexCapability(CAPABILITY) : index;
    }

    public static class LuceneIndexCapability
    implements IndexCapability {
        public IndexOrderCapability orderCapability(ValueCategory ... valueCategories) {
            return IndexOrderCapability.NONE;
        }

        public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
            return IndexValueCapability.NO;
        }

        public boolean areValueCategoriesAccepted(ValueCategory ... valueCategories) {
            Preconditions.requireNonEmpty((Object[])valueCategories);
            Preconditions.requireNoNullElements((Object[])valueCategories);
            return valueCategories.length == 1 && valueCategories[0] == ValueCategory.TEXT;
        }

        public boolean isQuerySupported(IndexQuery.IndexQueryType queryType, ValueCategory valueCategory) {
            return queryType != IndexQuery.IndexQueryType.FULLTEXT_SEARCH && queryType != IndexQuery.IndexQueryType.TOKEN_LOOKUP && this.areValueCategoriesAccepted(valueCategory);
        }

        public double getCostMultiplier(IndexQuery.IndexQueryType ... queryTypes) {
            return 1.0;
        }

        public boolean supportPartitionedScan(IndexQuery ... queries) {
            Preconditions.requireNonEmpty((Object[])queries);
            Preconditions.requireNoNullElements((Object[])queries);
            return false;
        }
    }
}

