/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.IOException;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.checker.DebugContext;
import org.neo4j.consistency.checker.NodeBasedMemoryLimiter;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.internal.SchemaIndexExtensionLoader;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.store.DirectStoreAccess;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.counts.CountsStorage;
import org.neo4j.counts.CountsStore;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.counts.GBPTreeCountsStore;
import org.neo4j.internal.counts.GBPTreeRelationshipGroupDegreesStore;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.helpers.Strings;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.os.OsBeanUtil;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.extension.DatabaseExtensions;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMapFactory;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.logging.DuplicatingLog;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.logging.log4j.LogConfig;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MachineMemory;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.time.Clocks;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.ReadOnlyTokenCreator;
import org.neo4j.token.TokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;

public class ConsistencyCheckService {
    private static final String CONSISTENCY_TOKEN_READER_TAG = "consistencyTokenReader";
    private final Date timestamp;

    public ConsistencyCheckService() {
        this(new Date());
    }

    public ConsistencyCheckService(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Deprecated
    public Result runFullConsistencyCheck(DatabaseLayout databaseLayout, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, boolean verbose) throws ConsistencyCheckIncompleteException {
        return this.runFullConsistencyCheck(databaseLayout, tuningConfiguration, progressFactory, logProvider, verbose, ConsistencyFlags.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runFullConsistencyCheck(DatabaseLayout databaseLayout, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, boolean verbose, ConsistencyFlags consistencyFlags) throws ConsistencyCheckIncompleteException {
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        try {
            Result result = this.runFullConsistencyCheck(databaseLayout, config, progressFactory, logProvider, (FileSystemAbstraction)fileSystem, verbose, consistencyFlags);
            return result;
        }
        finally {
            try {
                fileSystem.close();
            }
            catch (IOException e) {
                Log log = logProvider.getLog(this.getClass());
                log.error("Failure during shutdown of file system", (Throwable)e);
            }
        }
    }

    public Result runFullConsistencyCheck(DatabaseLayout databaseLayout, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, boolean verbose, ConsistencyFlags consistencyFlags) throws ConsistencyCheckIncompleteException {
        return this.runFullConsistencyCheck(databaseLayout, config, progressFactory, logProvider, fileSystem, verbose, ConsistencyCheckService.defaultReportDir(config), consistencyFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runFullConsistencyCheck(DatabaseLayout databaseLayout, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, boolean verbose, Path reportDir, ConsistencyFlags consistencyFlags) throws ConsistencyCheckIncompleteException {
        Log log = logProvider.getLog(this.getClass());
        config = this.tweakConfigForOptimalOffHeapMemory(databaseLayout, config, logProvider, fileSystem);
        JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
        PageCacheTracer pageCacheTracer = PageCacheTracer.NULL;
        EmptyMemoryTracker memoryTracker = EmptyMemoryTracker.INSTANCE;
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, config, pageCacheTracer, logProvider.getLog(PageCache.class), jobScheduler, Clocks.nanoClock(), new MemoryPools(((Boolean)config.get(GraphDatabaseSettings.memory_tracking)).booleanValue()), pageCacheConfig -> pageCacheConfig.faultLockStriping(2048));
        PageCache pageCache = pageCacheFactory.getOrCreatePageCache();
        try {
            Result result = this.runFullConsistencyCheck(databaseLayout, config, progressFactory, logProvider, fileSystem, pageCache, verbose, reportDir, consistencyFlags, pageCacheTracer, (MemoryTracker)memoryTracker);
            return result;
        }
        finally {
            try {
                pageCache.close();
            }
            catch (Exception e) {
                log.error("Failure during shutdown of the page cache", (Throwable)e);
            }
            try {
                jobScheduler.close();
            }
            catch (Exception e) {
                log.error("Failure during shutdown of the job scheduler", (Throwable)e);
            }
        }
    }

    private Config tweakConfigForOptimalOffHeapMemory(DatabaseLayout databaseLayout, Config config, LogProvider logProvider, FileSystemAbstraction fileSystem) throws ConsistencyCheckIncompleteException {
        long availablePhysicalMemory = OsBeanUtil.getTotalPhysicalMemory();
        if (availablePhysicalMemory != -1L) {
            availablePhysicalMemory = (long)((double)availablePhysicalMemory * (Double)config.get(GraphDatabaseInternalSettings.consistency_check_memory_limit_factor));
            long optimalOffHeapMemory = this.calculateOptimalOffHeapMemoryForChecker(fileSystem, databaseLayout, config);
            long heapMemory = Runtime.getRuntime().maxMemory();
            Long pageCacheMemory = config.get(GraphDatabaseSettings.pagecache_memory) != null ? Long.valueOf(ByteUnit.parse((String)((String)config.get(GraphDatabaseSettings.pagecache_memory)))) : null;
            long availableOffHeapMemory = availablePhysicalMemory - heapMemory - (pageCacheMemory = Long.valueOf(pageCacheMemory != null ? pageCacheMemory : ConfiguringPageCacheFactory.defaultHeuristicPageCacheMemory((MachineMemory)MachineMemory.DEFAULT)));
            if (availableOffHeapMemory < optimalOffHeapMemory) {
                long newPageCacheMemory = Long.max((long)((double)pageCacheMemory.longValue() * 0.2), availablePhysicalMemory - optimalOffHeapMemory - heapMemory);
                config = Config.newBuilder().fromConfig(config).set(GraphDatabaseSettings.pagecache_memory, (Object)String.valueOf(newPageCacheMemory)).build();
                logProvider.getLog(ConsistencyCheckService.class).info("%s setting was tweaked from %s down to %s for better overall performance of the consistency checker", new Object[]{GraphDatabaseSettings.pagecache_memory.name(), ByteUnit.bytesToString((long)pageCacheMemory), ByteUnit.bytesToString((long)newPageCacheMemory)});
            }
        }
        return config;
    }

    /*
     * Exception decompiling
     */
    private long calculateOptimalOffHeapMemoryForChecker(FileSystemAbstraction fileSystem, DatabaseLayout layout, Config config) throws ConsistencyCheckIncompleteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Result runFullConsistencyCheck(DatabaseLayout databaseLayout, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, boolean verbose, ConsistencyFlags consistencyFlags, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) throws ConsistencyCheckIncompleteException {
        return this.runFullConsistencyCheck(databaseLayout, config, progressFactory, logProvider, fileSystem, pageCache, verbose, ConsistencyCheckService.defaultReportDir(config), consistencyFlags, pageCacheTracer, memoryTracker);
    }

    public Result runFullConsistencyCheck(DatabaseLayout databaseLayout, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, final boolean verbose, Path reportDir, ConsistencyFlags consistencyFlags, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) throws ConsistencyCheckIncompleteException {
        DebugContext debugContext = new DebugContext(){

            @Override
            public boolean debugEnabled() {
                return verbose;
            }

            @Override
            public void debug(String message) {
                System.out.println(message);
            }
        };
        return this.runFullConsistencyCheck(databaseLayout, config, progressFactory, logProvider, fileSystem, pageCache, debugContext, reportDir, consistencyFlags, pageCacheTracer, memoryTracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runFullConsistencyCheck(DatabaseLayout layout, Config config, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, DebugContext debugContext, Path reportDir, ConsistencyFlags consistencyFlags, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) throws ConsistencyCheckIncompleteException {
        ConsistencySummaryStatistics summary;
        RecordDatabaseLayout databaseLayout = RecordDatabaseLayout.convert((DatabaseLayout)layout);
        ConsistencyCheckService.assertRecovered((DatabaseLayout)databaseLayout, config, fileSystem, memoryTracker);
        Log outLog = logProvider.getLog(this.getClass());
        config.set(GraphDatabaseSettings.pagecache_warmup_enabled, (Object)false);
        LifeSupport life = new LifeSupport();
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory(fileSystem, RecoveryCleanupWorkCollector.immediate(), databaseLayout.getDatabaseName());
        DatabaseReadOnlyChecker readOnlyChecker = DatabaseReadOnlyChecker.readOnly();
        StoreFactory factory = new StoreFactory((DatabaseLayout)databaseLayout, config, (IdGeneratorFactory)idGeneratorFactory, pageCache, fileSystem, logProvider, pageCacheTracer, readOnlyChecker);
        Path reportFile = this.chooseReportPath(reportDir);
        Log4jLogProvider reportLogProvider = new Log4jLogProvider(LogConfig.createBuilder((FileSystemAbstraction)fileSystem, (Path)reportFile, (Level)Level.INFO).createOnDemand().withCategory(false).build());
        Log reportLog = reportLogProvider.getLog(this.getClass());
        DuplicatingLog log = new DuplicatingLog(outLog, reportLog);
        Monitors monitors = new Monitors();
        JobScheduler jobScheduler = (JobScheduler)life.add((Lifecycle)JobSchedulerFactory.createInitialisedScheduler());
        TokenHolders tokenHolders = new TokenHolders((TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "PropertyKey"), (TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "Label"), (TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "RelationshipType"));
        RecoveryCleanupWorkCollector workCollector = RecoveryCleanupWorkCollector.ignore();
        DatabaseExtensions extensions = (DatabaseExtensions)life.add((Lifecycle)SchemaIndexExtensionLoader.instantiateExtensions((DatabaseLayout)databaseLayout, fileSystem, config, (LogService)new SimpleLogService(logProvider), pageCache, jobScheduler, workCollector, DbmsInfo.TOOL, monitors, tokenHolders, pageCacheTracer, readOnlyChecker));
        StaticIndexProviderMap indexes = (StaticIndexProviderMap)life.add((Lifecycle)StaticIndexProviderMapFactory.create((LifeSupport)life, (Config)config, (PageCache)pageCache, (FileSystemAbstraction)fileSystem, (LogService)new SimpleLogService(logProvider), (Monitors)monitors, (DatabaseReadOnlyChecker)readOnlyChecker, (DbmsInfo)DbmsInfo.TOOL, (RecoveryCleanupWorkCollector)workCollector, (PageCacheTracer)pageCacheTracer, (DatabaseLayout)databaseLayout, (TokenHolders)tokenHolders, (JobScheduler)jobScheduler, (DependencyResolver)extensions));
        try (NeoStores neoStores = factory.openAllNeoStores();){
            long lastCommittedTransactionId = neoStores.getMetaDataStore().getLastCommittedTransactionId();
            CountsStoreManager countsStoreManager = (CountsStoreManager)life.add((Lifecycle)new CountsStoreManager(pageCache, fileSystem, databaseLayout, pageCacheTracer, memoryTracker, logProvider, lastCommittedTransactionId));
            RelationshipGroupDegreesStoreManager groupDegreesStoreManager = (RelationshipGroupDegreesStoreManager)life.add((Lifecycle)new RelationshipGroupDegreesStoreManager(pageCache, fileSystem, databaseLayout, pageCacheTracer, memoryTracker, logProvider, lastCommittedTransactionId));
            try (CursorContext cursorContext = new CursorContext(pageCacheTracer.createPageCursorTracer(CONSISTENCY_TOKEN_READER_TAG));
                 CachedStoreCursors storeCursors = new CachedStoreCursors(neoStores, cursorContext);){
                tokenHolders.setInitialTokens(StoreTokens.allReadableTokens((NeoStores)neoStores), (StoreCursors)storeCursors);
            }
            life.start();
            IndexStatisticsStore indexStatisticsStore = new IndexStatisticsStore(pageCache, (DatabaseLayout)databaseLayout, workCollector, readOnlyChecker, pageCacheTracer);
            life.add((Lifecycle)indexStatisticsStore);
            int numberOfThreads = ConsistencyCheckService.defaultConsistencyCheckThreadsNumber();
            DirectStoreAccess stores = new DirectStoreAccess(neoStores, (IndexProviderMap)indexes, tokenHolders, indexStatisticsStore, (IdGeneratorFactory)idGeneratorFactory);
            double memoryLimitLeewayFactor = (Double)config.get(GraphDatabaseInternalSettings.consistency_check_memory_limit_factor);
            FullCheck check = new FullCheck(progressFactory, numberOfThreads, consistencyFlags, config, debugContext, NodeBasedMemoryLimiter.defaultWithLeeway(memoryLimitLeewayFactor));
            summary = check.execute(pageCache, stores, countsStoreManager, groupDegreesStoreManager, null, pageCacheTracer, memoryTracker, (Log)log);
        }
        finally {
            life.shutdown();
            reportLogProvider.close();
        }
        if (!summary.isConsistent()) {
            log.warn("See '%s' for a detailed consistency report.", new Object[]{reportFile});
            return Result.failure(reportFile, summary);
        }
        return Result.success(reportFile, summary);
    }

    private static void assertRecovered(DatabaseLayout databaseLayout, Config config, FileSystemAbstraction fileSystem, MemoryTracker memoryTracker) throws ConsistencyCheckIncompleteException {
        try {
            if (Recovery.isRecoveryRequired((FileSystemAbstraction)fileSystem, (DatabaseLayout)databaseLayout, (Config)config, (MemoryTracker)memoryTracker)) {
                throw new IllegalStateException(Strings.joinAsLines((String[])new String[]{"Active logical log detected, this might be a source of inconsistencies.", "Please recover database.", "To perform recovery please start database in single mode and perform clean shutdown."}));
            }
        }
        catch (Exception e) {
            throw new ConsistencyCheckIncompleteException(e);
        }
    }

    private Path chooseReportPath(Path reportDir) {
        return reportDir.resolve(ConsistencyCheckService.defaultLogFileName(this.timestamp));
    }

    private static Path defaultReportDir(Config tuningConfiguration) {
        return (Path)tuningConfiguration.get(GraphDatabaseSettings.logs_directory);
    }

    private static String defaultLogFileName(Date date) {
        return String.format("inconsistencies-%s.report", new SimpleDateFormat("yyyy-MM-dd.HH.mm.ss").format(date));
    }

    public static int defaultConsistencyCheckThreadsNumber() {
        return Runtime.getRuntime().availableProcessors();
    }

    private static class RelationshipGroupDegreesStoreManager
    extends CountsStorageManager<RelationshipGroupDegreesStore> {
        private final LogProvider logProvider;

        RelationshipGroupDegreesStoreManager(PageCache pageCache, FileSystemAbstraction fileSystem, RecordDatabaseLayout databaseLayout, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker, LogProvider logProvider, long lastCommittedTxId) {
            super(pageCache, fileSystem, databaseLayout, pageCacheTracer, memoryTracker, lastCommittedTxId);
            this.logProvider = logProvider;
        }

        @Override
        protected RelationshipGroupDegreesStore open() throws IOException {
            return new GBPTreeRelationshipGroupDegreesStore(this.pageCache, this.databaseLayout.relationshipGroupDegreesStore(), this.fileSystem, RecoveryCleanupWorkCollector.ignore(), (GBPTreeRelationshipGroupDegreesStore.DegreesRebuilder)new RebuildPreventingDegreesInitializer(this.lastCommittedTxId), DatabaseReadOnlyChecker.readOnly(), this.pageCacheTracer, GBPTreeCountsStore.NO_MONITOR, this.databaseLayout.getDatabaseName(), 100, this.logProvider);
        }
    }

    private static class CountsStoreManager
    extends CountsStorageManager<CountsStore> {
        private final LogProvider logProvider;

        CountsStoreManager(PageCache pageCache, FileSystemAbstraction fileSystem, RecordDatabaseLayout databaseLayout, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker, LogProvider logProvider, long lastCommittedTxId) {
            super(pageCache, fileSystem, databaseLayout, pageCacheTracer, memoryTracker, lastCommittedTxId);
            this.logProvider = logProvider;
        }

        @Override
        protected CountsStore open() throws IOException {
            return new GBPTreeCountsStore(this.pageCache, this.databaseLayout.countStore(), this.fileSystem, RecoveryCleanupWorkCollector.ignore(), (CountsBuilder)new RebuildPreventingCountsInitializer(this.lastCommittedTxId), DatabaseReadOnlyChecker.readOnly(), this.pageCacheTracer, GBPTreeCountsStore.NO_MONITOR, this.databaseLayout.getDatabaseName(), 100, this.logProvider);
        }
    }

    private static abstract class CountsStorageManager<T extends CountsStorage>
    extends LifecycleAdapter
    implements ThrowingSupplier<T, IOException> {
        protected final PageCache pageCache;
        protected final FileSystemAbstraction fileSystem;
        protected final RecordDatabaseLayout databaseLayout;
        protected final PageCacheTracer pageCacheTracer;
        protected final MemoryTracker memoryTracker;
        protected final long lastCommittedTxId;
        private T store;

        CountsStorageManager(PageCache pageCache, FileSystemAbstraction fileSystem, RecordDatabaseLayout databaseLayout, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker, long lastCommittedTxId) {
            this.pageCache = pageCache;
            this.fileSystem = fileSystem;
            this.databaseLayout = databaseLayout;
            this.pageCacheTracer = pageCacheTracer;
            this.memoryTracker = memoryTracker;
            this.lastCommittedTxId = lastCommittedTxId;
        }

        public T get() throws IOException {
            this.store = this.open();
            this.store.start(CursorContext.NULL, StoreCursors.NULL, this.memoryTracker);
            return this.store;
        }

        protected abstract T open() throws IOException;

        public void shutdown() {
            if (this.store != null) {
                this.store.close();
            }
        }
    }

    private static class RebuildPreventingDegreesInitializer
    implements GBPTreeRelationshipGroupDegreesStore.DegreesRebuilder {
        private final long lastCommittedTxId;

        RebuildPreventingDegreesInitializer(long lastCommittedTxId) {
            this.lastCommittedTxId = lastCommittedTxId;
        }

        public void rebuild(RelationshipGroupDegreesStore.Updater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
            throw new UnsupportedOperationException("Relationship group degrees store needed rebuild, consistency checker will instead report broken or missing store");
        }

        public long lastCommittedTxId() {
            return this.lastCommittedTxId;
        }
    }

    private static class RebuildPreventingCountsInitializer
    implements CountsBuilder {
        private final long lastCommittedTxId;

        RebuildPreventingCountsInitializer(long lastCommittedTxId) {
            this.lastCommittedTxId = lastCommittedTxId;
        }

        public void initialize(CountsAccessor.Updater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
            throw new UnsupportedOperationException("Counts store needed rebuild, consistency checker will instead report broken or missing counts store");
        }

        public long lastCommittedTxId() {
            return this.lastCommittedTxId;
        }
    }

    public static class Result {
        private final boolean successful;
        private final Path reportFile;
        private final ConsistencySummaryStatistics summary;

        public static Result failure(Path reportFile, ConsistencySummaryStatistics summary) {
            return new Result(false, reportFile, summary);
        }

        public static Result success(Path reportFile, ConsistencySummaryStatistics summary) {
            return new Result(true, reportFile, summary);
        }

        private Result(boolean successful, Path reportFile, ConsistencySummaryStatistics summary) {
            this.successful = successful;
            this.reportFile = reportFile;
            this.summary = summary;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public Path reportFile() {
            return this.reportFile;
        }

        public ConsistencySummaryStatistics summary() {
            return this.summary;
        }
    }
}

