/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public enum NodeLink {
    SOURCE{

        @Override
        public void setPrevRel(RelationshipRecord record, long other) {
            record.setFirstPrevRel(other);
        }

        @Override
        public void setNextRel(RelationshipRecord record, long other) {
            record.setFirstNextRel(other);
        }

        @Override
        public long getPrevRel(RelationshipRecord relationship) {
            return relationship.getFirstPrevRel();
        }

        @Override
        public long getNextRel(RelationshipRecord relationship) {
            return relationship.getFirstNextRel();
        }

        @Override
        public void setNode(RelationshipRecord relationship, long nodeId) {
            relationship.setFirstNode(nodeId);
        }
    }
    ,
    TARGET{

        @Override
        public void setPrevRel(RelationshipRecord record, long other) {
            record.setSecondPrevRel(other);
        }

        @Override
        public void setNextRel(RelationshipRecord record, long other) {
            record.setSecondNextRel(other);
        }

        @Override
        public long getPrevRel(RelationshipRecord relationship) {
            return relationship.getSecondPrevRel();
        }

        @Override
        public long getNextRel(RelationshipRecord relationship) {
            return relationship.getSecondNextRel();
        }

        @Override
        public void setNode(RelationshipRecord relationship, long nodeId) {
            relationship.setSecondNode(nodeId);
        }
    };


    public static NodeLink select(RelationshipRecord record, long node) {
        if (record.getFirstNode() == node) {
            return SOURCE;
        }
        if (record.getSecondNode() == node) {
            return TARGET;
        }
        return null;
    }

    public abstract void setPrevRel(RelationshipRecord var1, long var2);

    public abstract void setNextRel(RelationshipRecord var1, long var2);

    public abstract long getPrevRel(RelationshipRecord var1);

    public abstract long getNextRel(RelationshipRecord var1);

    public abstract void setNode(RelationshipRecord var1, long var2);
}

