/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.io.PrintWriter;
import java.util.concurrent.Callable;
import org.neo4j.server.startup.BootFailureException;
import org.neo4j.server.startup.Bootloader;
import org.neo4j.server.startup.BootloaderContext;
import org.neo4j.server.startup.VerboseCommand;
import picocli.CommandLine;

@CommandLine.Command(sortOptions=false)
abstract class BootloaderCommand {
    protected final BootloaderContext ctx;

    BootloaderCommand(BootloaderContext ctx) {
        this.ctx = ctx;
    }

    protected static CommandLine addDefaultOptions(CommandLine command, BootloaderContext ctx) {
        return command.setCaseInsensitiveEnumValuesAllowed(true).setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new ExceptionHandler(ctx)).setOut(new PrintWriter(ctx.out, true)).setErr(new PrintWriter(ctx.err, true));
    }

    private static class ExceptionHandler
    implements CommandLine.IExecutionExceptionHandler {
        private final BootloaderContext ctx;

        ExceptionHandler(BootloaderContext ctx) {
            this.ctx = ctx;
        }

        public int handleExecutionException(Exception exception, CommandLine commandLine, CommandLine.ParseResult parseResult) {
            if (commandLine.getCommand() instanceof VerboseCommand && !((VerboseCommand)commandLine.getCommand()).verbose()) {
                this.ctx.err.println(exception.getMessage());
                this.ctx.err.println("Run with '--verbose' for a more detailed error message.");
            } else {
                exception.printStackTrace(this.ctx.err);
            }
            if (exception instanceof BootFailureException) {
                BootFailureException failure = (BootFailureException)exception;
                return failure.getExitCode();
            }
            return commandLine.getCommandSpec().exitCodeOnExecutionException();
        }
    }

    protected static abstract class BootCommand
    extends BaseCommand {
        @CommandLine.Mixin
        protected StartOptions startOptions;

        protected BootCommand() {
        }

        static class StartOptions {
            @CommandLine.Option(names={"--expand-commands"}, description={"Allow command expansion in config value evaluation."})
            boolean expandCommands;

            StartOptions() {
            }
        }
    }

    protected static abstract class BaseCommand
    implements Callable<Integer>,
    VerboseCommand {
        @CommandLine.ParentCommand
        protected BootloaderCommand bootloader;
        @CommandLine.Option(names={"--verbose"}, description={"Prints additional information."})
        boolean verbose;

        protected BaseCommand() {
        }

        Bootloader getBootloader(boolean expandCommands) {
            this.bootloader.ctx.init(expandCommands, this.verbose, new String[0]);
            return new Bootloader(this.bootloader.ctx);
        }

        @Override
        public boolean verbose() {
            return this.verbose;
        }
    }
}

