/*
 * Decompiled with CFR 0.152.
 */
package ork;

import java.io.Serializable;
import java.util.Vector;

public class Account
implements Serializable {
    private String m_sHash;
    private String m_sUser;
    private String m_sPassword;
    private int m_nState = 0;
    private Vector m_oRoles;
    public static final int ACCOUNT_STATUS_LOCKED = 28000;
    public static final int ACCOUNT_STATUS_VALID = 0;
    public static final int ACCOUNT_STATUS_UNKNOWN = -1;

    public Account(String sUser, String sPass, String sHash, int nState) {
        this.m_sUser = sUser;
        this.m_sPassword = sPass;
        this.m_nState = nState;
        this.m_sHash = sHash;
    }

    public Account() {
    }

    public Object clone() {
        Account oA1 = new Account();
        oA1.m_sHash = this.m_sHash;
        oA1.m_sUser = this.m_sUser;
        oA1.m_sPassword = this.m_sPassword;
        oA1.m_nState = this.m_nState;
        oA1.m_oRoles = this.m_oRoles != null ? (Vector)this.m_oRoles.clone() : null;
        return oA1;
    }

    public int getState() {
        return this.m_nState;
    }

    public String getUsername() {
        return this.m_sUser;
    }

    public String getHash() {
        return this.m_sHash;
    }

    public String getPassword() {
        return this.m_sPassword;
    }

    public void setHash(String s) {
        this.m_sHash = s;
    }

    public void setState(int n) {
        this.m_nState = n;
    }

    public void setPassword(String s) {
        this.m_sPassword = s;
    }

    public Vector getRoles() {
        return this.m_oRoles;
    }

    public void setRoles(Vector v) {
        this.m_oRoles = v;
    }

    public String getRolesAsString() {
        String sRoles = "";
        if (this.m_oRoles == null) {
            return "";
        }
        int i = 0;
        while (i < this.m_oRoles.size()) {
            sRoles = String.valueOf(sRoles) + (String)this.m_oRoles.get(i);
            if (i + 1 < this.m_oRoles.size()) {
                sRoles = String.valueOf(sRoles) + ",";
            }
            ++i;
        }
        return sRoles;
    }

    public String getAsString() {
        String sAccount = String.valueOf(this.m_sUser) + "/" + this.m_sPassword;
        if (this.m_nState == 0) {
            sAccount = String.valueOf(sAccount) + " [ok]";
        } else if (this.m_nState == 28000) {
            sAccount = String.valueOf(sAccount) + " [locked]";
        }
        return sAccount;
    }
}

