/*
 * Decompiled with CFR 0.152.
 */
package ork;

import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Vector;
import ork.Account;

public class AccountList
extends Hashtable {
    private Hashtable m_oSIDEnum = new Hashtable();

    public void outputAsTxt() {
    }

    public void setAccountsEnumeratedForSID(String s) {
        if (this.m_oSIDEnum.get(s) == null) {
            this.m_oSIDEnum.put(s, new Integer(1));
        }
    }

    public boolean isAccountsEnumeratedForSID(String s) {
        return this.m_oSIDEnum.get(s) != null;
    }

    public Vector getAccountsForSID(String s) {
        return (Vector)this.get(s);
    }

    public Vector getAccountsWithStateForSID(int nState, String sSID) {
        Vector oVec = null;
        int i = 0;
        if (this.get(sSID) == null) {
            return null;
        }
        oVec = (Vector)((Vector)this.get(sSID)).clone();
        do {
            if (((Account)oVec.get(i)).getState() != nState) {
                oVec.remove(i);
                continue;
            }
            ++i;
        } while (i < oVec.size());
        return oVec;
    }

    public Vector getOpenAccountsForSID(String s) {
        return this.getAccountsWithStateForSID(0, s);
    }

    public Vector getUknownAccountsForSID(String s) {
        return this.getAccountsWithStateForSID(-1, s);
    }

    public Vector getLockedAccountsForSID(String s) {
        return this.getAccountsWithStateForSID(28000, s);
    }

    public Account getAccountWithRole(String sSID, String sRole) {
        Vector oAccVector = this.getOpenAccountsForSID(sSID);
        Vector oRoles = null;
        if (oAccVector == null) {
            return null;
        }
        int i = 0;
        while (i < oAccVector.size()) {
            Account oA = (Account)oAccVector.get(i);
            oRoles = oA.getRoles();
            if (oRoles == null) {
                return null;
            }
            int j = 0;
            while (j < oRoles.size()) {
                String sTmpRole = (String)oRoles.get(j);
                if (sTmpRole.equalsIgnoreCase(sRole)) {
                    return oA;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public Vector getAllAccountsForRole(String sSID, String sRole) {
        Vector oAccVector = this.getOpenAccountsForSID(sSID);
        Vector oRoles = null;
        Vector<Account> oTmp = new Vector<Account>();
        if (oAccVector == null) {
            return null;
        }
        int i = 0;
        while (i < oAccVector.size()) {
            Account oA = (Account)oAccVector.get(i);
            oRoles = oA.getRoles();
            if (oRoles != null) {
                int j = 0;
                while (j < oRoles.size()) {
                    String sTmpRole = (String)oRoles.get(j);
                    if (sTmpRole.equalsIgnoreCase(sRole)) {
                        oTmp.add(oA);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return oTmp;
    }

    public Account getAccountForUsername(String sUser, String sSID) {
        Vector oV = null;
        Account oA = null;
        oV = (Vector)this.get(sSID);
        if (oV == null) {
            return null;
        }
        int i = 0;
        while (i < oV.size()) {
            oA = (Account)oV.get(i);
            if (oA.getUsername().equalsIgnoreCase(sUser)) {
                return oA;
            }
            ++i;
        }
        return null;
    }

    private Account consolidateAccountInfo(Account oA1, Account oA2) {
        boolean nCounter = true;
        int nPos = -1;
        Account oA3 = (Account)oA1.clone();
        if (oA3.getPassword() == null) {
            oA3.setPassword(oA2.getPassword());
        }
        if (oA3.getHash() == null) {
            oA3.setHash(oA2.getHash());
        }
        if (oA3.getState() == -1) {
            oA3.setState(oA2.getState());
        }
        if (oA3.getRoles() != null || oA2.getRoles() != null) {
            LinkedHashSet oSet = new LinkedHashSet();
            if (oA3.getRoles() != null) {
                oSet.addAll(oA3.getRoles());
            }
            if (oA2.getRoles() != null) {
                oSet.addAll(oA2.getRoles());
            }
            oA3.setRoles(new Vector(oSet));
        }
        return oA3;
    }

    public void addAccountForSID(String sSID, Account oA) {
        Vector<Account> oV = null;
        Account oTmp = null;
        boolean bSet = true;
        oV = (Vector<Account>)this.get(sSID);
        if (oV == null) {
            oV = new Vector<Account>();
            this.put(sSID, oV);
        }
        int i = 0;
        while (i < oV.size()) {
            oTmp = (Account)oV.get(i);
            if (oA.getUsername().equalsIgnoreCase(oTmp.getUsername())) {
                oV.set(i, this.consolidateAccountInfo(oA, oTmp));
                bSet = false;
            }
            ++i;
        }
        if (bSet) {
            oV.add(oA);
        }
    }
}

