/*
 * Decompiled with CFR 0.152.
 */
package ork.plugins;

import cqure.repeng.ReportObject;
import cqure.repeng.ReportTree;
import ork.CommonValuesDB;
import ork.FileListLoader;
import ork.Logger;
import ork.OracleDBConnection;
import ork.SIDList;
import ork.ScannerConfig;
import ork.ServerResult;
import ork.plugins.PluginIface;

public class EnumerateSids
implements PluginIface {
    private CommonValuesDB m_oDB;
    private OracleDBConnection m_oOraDBConn;
    private ServerResult m_oRes = null;
    private Logger m_oLogger = new Logger();
    private ScannerConfig m_oConfig = null;
    private ReportTree m_oTree = null;
    private String m_sServer = null;
    private String m_sSID = null;
    private int m_nPort = -1;

    public void setCommonValuesDB(CommonValuesDB oDB) {
        this.m_oDB = oDB;
    }

    public void setLogger(Logger oLogger) {
        this.m_oLogger = oLogger;
    }

    public void setParameters(Object o) {
    }

    public void setConfig(ScannerConfig o) {
        this.m_oConfig = o;
    }

    public void setReportTree(ReportTree o) {
        this.m_oTree = o;
    }

    public EnumerateSids(ServerResult oRes) {
        this.m_oRes = oRes;
        this.m_sServer = oRes.getServer();
        this.m_nPort = oRes.getPort();
    }

    public int scan() {
        String sSID;
        SIDList oList = new SIDList(this.m_sServer, this.m_nPort);
        FileListLoader oF = null;
        OracleDBConnection oConn = null;
        if (oList.retrieveSids() != 0) {
            this.m_oLogger.log("[x] Failed to enumerate sids from host");
        }
        if (oList == null || oList.size() == 0) {
            this.m_oLogger.log("[-] Loading services/sids from service file");
            oF = new FileListLoader();
            oF.loadFromFile(this.m_oConfig.getConfigOption("ServiceFile"));
            int i = 0;
            while (i < oF.size()) {
                oConn = new OracleDBConnection(this.m_sServer, this.m_nPort, (String)oF.get(i));
                oConn.setUser("oscanner_test");
                oConn.setPassword("oscanner_test");
                if (oConn.login() == 1017) {
                    this.m_oLogger.debug("[i] Adding SID " + (String)oF.get(i));
                    oList.add(oF.get(i));
                } else {
                    this.m_oLogger.debug("[x] Removing SID " + (String)oF.get(i));
                }
                ++i;
            }
        }
        this.m_oRes.setSIDList(oList);
        oList.reset();
        while ((sSID = oList.getNextSID()) != null) {
            if (sSID.toLowerCase().indexOf("extproc") != -1 || this.m_oTree.addReportItem(this.m_sServer, new ReportObject(sSID))) continue;
            this.m_oLogger.log("[x] addReportItem failed");
        }
        return 0;
    }
}

