/*
 * Decompiled with CFR 0.152.
 */
package ork.plugins;

import cqure.repeng.ReportObject;
import cqure.repeng.ReportTree;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import ork.Account;
import ork.CommonValuesDB;
import ork.Logger;
import ork.OracleDBConnection;
import ork.PluginReport;
import ork.SIDList;
import ork.ScannerConfig;
import ork.ServerResult;
import ork.plugins.PluginHelper;
import ork.plugins.PluginIface;

public class GetDatabaseLinks
implements PluginIface {
    private CommonValuesDB m_oDB;
    private ServerResult m_oRes = null;
    private ReportTree m_oTree = null;
    private ScannerConfig m_oConfig = null;
    private Logger m_oLogger = new Logger();
    private String m_sServer = null;
    private String m_sSID = null;
    private int m_nPort = -1;

    public void setCommonValuesDB(CommonValuesDB oDB) {
        this.m_oDB = oDB;
    }

    public void setServerResult(ServerResult oRes) {
        this.m_oRes = oRes;
    }

    public void setLogger(Logger oLogger) {
        this.m_oLogger = oLogger;
    }

    public void setParameters(Object o) {
    }

    public void setConfig(ScannerConfig o) {
        this.m_oConfig = o;
    }

    public void setReportTree(ReportTree o) {
        this.m_oTree = o;
    }

    public GetDatabaseLinks(ServerResult oRes) {
        this.m_oRes = oRes;
        this.m_nPort = this.m_oRes.getPort();
        this.m_sServer = this.m_oRes.getServer();
    }

    public int scan() {
        String sSID;
        SIDList oSIDList = this.m_oRes.getSIDList();
        Connection oConn = null;
        Statement oStmt = null;
        ResultSet oRs = null;
        PluginHelper oHelper = new PluginHelper(this.m_oRes, this.m_oLogger);
        PluginReport oRep = null;
        String sDBLinks = "";
        String sSQL = "SELECT name, host, userid, password FROM sys.link$";
        this.m_oLogger.debug("[-] Getting database links");
        while ((sSID = oSIDList.getNextSID()) != null) {
            if (sDBLinks.length() > 0) {
                return 0;
            }
            Vector oAccounts = this.m_oRes.getAccountList().getAllAccountsForRole(sSID, "DBA");
            if (oAccounts == null) continue;
            OracleDBConnection oOraDB = new OracleDBConnection(this.m_sServer, this.m_nPort, sSID);
            ReportObject o = new ReportObject("Links");
            if (!this.m_oTree.addReportItem(String.valueOf(this.m_sServer) + "/" + sSID, o)) {
                this.m_oLogger.log("[x] Failed to add link object");
            }
            int i = 0;
            while (i < oAccounts.size()) {
                Account oA = (Account)oAccounts.get(i);
                oOraDB.setUser(oA.getUsername());
                oOraDB.setPassword(oA.getPassword());
                oOraDB.login();
                oConn = oOraDB.getConnection();
                if (oConn != null) {
                    try {
                        oStmt = oConn.createStatement();
                        oRs = oStmt.executeQuery(sSQL);
                        while (oRs != null && oRs.next()) {
                            o = new ReportObject(oRs.getString("name"));
                            o.addProperty("Host", oRs.getString("host"));
                            o.addProperty("User", oRs.getString("userid"));
                            o.addProperty("Password", oRs.getString("password"));
                            o.setSeverity(2001);
                            if (!this.m_oTree.addReportItem(String.valueOf(this.m_sServer) + "/" + sSID + "/Links", o)) {
                                this.m_oLogger.log("[x] Failed to add dblink to report");
                            }
                            sDBLinks = String.valueOf(sDBLinks) + "Name: " + oRs.getString("name") + ", ";
                            sDBLinks = String.valueOf(sDBLinks) + "Host: " + oRs.getString("host") + ", ";
                            sDBLinks = String.valueOf(sDBLinks) + "User: " + oRs.getString("userid") + ", ";
                            sDBLinks = String.valueOf(sDBLinks) + "Password: " + oRs.getString("password");
                            sDBLinks = String.valueOf(sDBLinks) + "\r\n";
                        }
                        if (oRs != null) {
                            oRs.close();
                        }
                        if (oStmt != null) {
                            oStmt.close();
                        }
                        oOraDB.close();
                        this.m_oLogger.debug("[-] Found database links");
                        break;
                    }
                    catch (SQLException e) {
                        this.m_oLogger.log("[x] Failed to enumerate database links");
                        return -1;
                    }
                }
                ++i;
            }
            if (sDBLinks.length() <= 0) continue;
            oRep = new PluginReport();
            oRep.setHeader("Database links");
            oRep.setSID(sSID);
            oRep.setHost(this.m_sServer);
            oRep.setBody(sDBLinks);
            this.m_oRes.getPluginReportList().add(oRep);
        }
        try {
            if (oConn != null) {
                oConn.close();
            }
        }
        catch (SQLException e) {
            this.m_oLogger.debug("[x] Failed to close database connection");
        }
        return 0;
    }
}

