/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.codehaus.plexus.archiver.zip.ZipEntry;
import org.codehaus.plexus.archiver.zip.ZipFile;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.attributes.SimpleResourceAttributes;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResourceWithAttributes;

public class ZipResource
extends AbstractPlexusIoResourceWithAttributes {
    private final ZipFile zipFile;
    private final ZipEntry entry;
    private PlexusIoResourceAttributes attributes;

    public ZipResource(ZipFile zipFile, ZipEntry entry) {
        this.zipFile = zipFile;
        this.entry = entry;
        boolean dir = entry.isDirectory();
        this.setName(entry.getName());
        this.setFile(!dir);
        this.setDirectory(dir);
        this.setExisting(true);
        this.setFile(!dir);
        long l = entry.getLastModificationTime();
        this.setLastModified(l == -1L ? 0L : l);
        this.setSize(dir ? -1L : entry.getSize());
    }

    public synchronized PlexusIoResourceAttributes getAttributes() {
        int mode = this.entry.getUnixMode();
        mode = (mode & 0x8000) == 32768 ? (mode &= 0xFFFF7FFF) : (mode &= 0xFFFFBFFF);
        if (this.attributes == null) {
            this.attributes = new SimpleResourceAttributes();
            this.attributes.setOctalMode(mode);
        }
        return this.attributes;
    }

    public synchronized void setAttributes(PlexusIoResourceAttributes attributes) {
        this.attributes = attributes;
    }

    public URL getURL() throws IOException {
        return null;
    }

    public InputStream getContents() throws IOException {
        return this.zipFile.getInputStream(this.entry);
    }
}

