#!/bin/sh
# Use this script to download or update all dependencies to their last
# developpement version.
# The dependencies will be located in a virtualenv, so you do not
# need to install them on your system at all.

# Use launch.sh to start poezio directly from here

cd "$(dirname "$0")"

command -v "uv" > /dev/null 2>&1 || {
    echo "uv executable not found"
    exit 1
}

echo 'Updating poezio'
git pull --ff-only origin main || {
    echo "The script failed to update poezio."
    exit 1
}

uv sync --all-groups --all-extras
uv pip install git+https://codeberg.org/poezio/slixmpp.git
