#ifndef PROXIMOTH_ERROR_H
#define PROXIMOTH_ERROR_H

#include <proximoth/proximoth.h>

extern char proximoth_error_buffer[256];


typedef enum proximoth_error_t {
    PROXIMOTH_SUCCESS = 0,
    PROXIMOTH_ERROR_INTERFACE_NOT_FOUND, 
    PROXIMOTH_ERROR_INTERFACE_NO_MONITOR, 
    PROXIMOTH_ERROR_INTERFACE_CANNOT_OPEN, 
    PROXIMOTH_ERROR_INTERFACE_CANNOT_GET_STATE,
    PROXIMOTH_ERROR_INTERFACE_CANNOT_GET_MODE,
    PROXIMOTH_ERROR_INTERFACE_CANNOT_GET_CHANNEL,
    PROXIMOTH_ERROR_INTERFACE_NOT_UP,
    PROXIMOTH_ERROR_INTERFACE_NOT_SPECIFIED, 
    PROXIMOTH_ERROR_INTERFACE_CANNOT_COMPILE_FILTER,
    PROXIMOTH_ERROR_INTERFACE_CANNOT_SET_FILTER,
    PROXIMOTH_ERROR_INTERFACE_CANNOT_SET_NONBLOCK,
    PROXIMOTH_ERROR_BSSID_MAC_INVALID,
    PROXIMOTH_ERROR_TARGET_MAC_INVALID, 
    PROXIMOTH_ERROR_FILE_CANNOT_CREATE,
    PROXIMOTH_ERROR_THREADS_CANNOT_START,
    PROXIMOTH_ERROR_THREADS_BAD_JOIN,
    PROXIMOTH_ERROR_OPTION_INVALID,
    PROXIMOTH_ERROR_OPTION_NEEDS_ARG, 
    PROXIMOTH_ERROR_ARGUMENT_INVALID,
    PROXIMOTH_ERROR_PROCESS_CHILD_BAD_KILL, 
    PROXIMOTH_ERROR_PCAP_FILE_CANNOT_CREATE, 
    PROXIMOTH_ERROR_SIGNAL_BAD_INIT,
    PROXIMOTH_ERROR_IOCTL,
    PROXIMOTH_ERROR_SEMAPHORE_CANNOT_INIT, 
    PROXIMOTH_ERROR_SOCKET_CANNOT_CREATE,
    PROXIMOTH_ERROR_INJECT,
    PROXIMOTH_ERROR_SNIFF,
    PROXIMOTH_ERROR_ATEXIT,
    PROXIMOTH_ERROR_LOCALE,
    PROXIMOTH_ERROR_LOCALTIME

}proximoth_error_t;

extern proximoth_error_t proximoth_error;


const char* proximoth_error_get_message(proximoth_error_t error_code);

#endif