"""
STIX 2.1 open vocabularies and enums
"""


ACCOUNT_TYPE_FACEBOOK = "facebook"
ACCOUNT_TYPE_LDAP = "ldap"
ACCOUNT_TYPE_NIS = "nis"
ACCOUNT_TYPE_OPENID = "openid"
ACCOUNT_TYPE_RADIUS = "radius"
ACCOUNT_TYPE_SKYPE = "skype"
ACCOUNT_TYPE_TACACS = "tacacs"
ACCOUNT_TYPE_TWITTER = "twitter"
ACCOUNT_TYPE_UNIX = "unix"
ACCOUNT_TYPE_WINDOWS_LOCAL = "windows-local"
ACCOUNT_TYPE_WINDOWS_DOMAIN = "windows-domain"


ACCOUNT_TYPE = [
    ACCOUNT_TYPE_FACEBOOK,
    ACCOUNT_TYPE_LDAP,
    ACCOUNT_TYPE_NIS,
    ACCOUNT_TYPE_OPENID,
    ACCOUNT_TYPE_RADIUS,
    ACCOUNT_TYPE_SKYPE,
    ACCOUNT_TYPE_TACACS,
    ACCOUNT_TYPE_TWITTER,
    ACCOUNT_TYPE_UNIX,
    ACCOUNT_TYPE_WINDOWS_LOCAL,
    ACCOUNT_TYPE_WINDOWS_DOMAIN,
]


ATTACK_MOTIVATION_ACCIDENTAL = "accidental"
ATTACK_MOTIVATION_COERCION = "coercion"
ATTACK_MOTIVATION_DOMINANCE = "dominance"
ATTACK_MOTIVATION_IDEOLOGY = "ideology"
ATTACK_MOTIVATION_NOTORIETY = "notoriety"
ATTACK_MOTIVATION_ORGANIZATIONAL_GAIN = "organizational-gain"
ATTACK_MOTIVATION_PERSONAL_GAIN = "personal-gain"
ATTACK_MOTIVATION_PERSONAL_SATISFACTION = "personal-satisfaction"
ATTACK_MOTIVATION_REVENGE = "revenge"
ATTACK_MOTIVATION_UNPREDICTABLE = "unpredictable"


ATTACK_MOTIVATION = [
    ATTACK_MOTIVATION_ACCIDENTAL,
    ATTACK_MOTIVATION_COERCION,
    ATTACK_MOTIVATION_DOMINANCE,
    ATTACK_MOTIVATION_IDEOLOGY,
    ATTACK_MOTIVATION_NOTORIETY,
    ATTACK_MOTIVATION_ORGANIZATIONAL_GAIN,
    ATTACK_MOTIVATION_PERSONAL_GAIN,
    ATTACK_MOTIVATION_PERSONAL_SATISFACTION,
    ATTACK_MOTIVATION_REVENGE,
    ATTACK_MOTIVATION_UNPREDICTABLE,
]


ATTACK_RESOURCE_LEVEL_INDIVIDUAL = "individual"
ATTACK_RESOURCE_LEVEL_CLUB = "club"
ATTACK_RESOURCE_LEVEL_CONTEST = "contest"
ATTACK_RESOURCE_LEVEL_TEAM = "team"
ATTACK_RESOURCE_LEVEL_ORGANIZATION = "organization"
ATTACK_RESOURCE_LEVEL_GOVERNMENT = "government"


ATTACK_RESOURCE_LEVEL = [
    ATTACK_RESOURCE_LEVEL_INDIVIDUAL,
    ATTACK_RESOURCE_LEVEL_CLUB,
    ATTACK_RESOURCE_LEVEL_CONTEST,
    ATTACK_RESOURCE_LEVEL_TEAM,
    ATTACK_RESOURCE_LEVEL_ORGANIZATION,
    ATTACK_RESOURCE_LEVEL_GOVERNMENT,
]


ENCRYPTION_ALGORITHM_AES_256_GCM = "AES-256-GCM"
ENCRYPTION_ALGORITHM_CHACHA20_POLY1305 = "ChaCha20-Poly1305"
ENCRYPTION_ALGORITHM_MIME_TYPE_INDICATED = "mime-type-indicated"


ENCRYPTION_ALGORITHM = [
    ENCRYPTION_ALGORITHM_AES_256_GCM,
    ENCRYPTION_ALGORITHM_CHACHA20_POLY1305,
    ENCRYPTION_ALGORITHM_MIME_TYPE_INDICATED,
]


EXTENSION_TYPE_NEW_SDO = "new-sdo"
EXTENSION_TYPE_NEW_SCO = "new-sco"
EXTENSION_TYPE_NEW_SRO = "new-sro"
EXTENSION_TYPE_PROPERTY_EXTENSION = "property-extension"
EXTENSION_TYPE_TOPLEVEL_PROPERTY_EXTENSION = "toplevel-property-extension"


EXTENSION_TYPE = [
    EXTENSION_TYPE_NEW_SDO,
    EXTENSION_TYPE_NEW_SCO,
    EXTENSION_TYPE_NEW_SRO,
    EXTENSION_TYPE_PROPERTY_EXTENSION,
    EXTENSION_TYPE_TOPLEVEL_PROPERTY_EXTENSION,
]


GROUPING_CONTEXT_SUSPICIOUS_ACTIVITY = "suspicious-activity"
GROUPING_CONTEXT_MALWARE_ANALYSIS = "malware-analysis"
GROUPING_CONTEXT_UNSPECIFIED = "unspecified"


GROUPING_CONTEXT = [
    GROUPING_CONTEXT_SUSPICIOUS_ACTIVITY,
    GROUPING_CONTEXT_MALWARE_ANALYSIS,
    GROUPING_CONTEXT_UNSPECIFIED,
]


HASHING_ALGORITHM_MD5 = "MD5"
HASHING_ALGORITHM_SHA_1 = "SHA-1"
HASHING_ALGORITHM_SHA_256 = "SHA-256"
HASHING_ALGORITHM_SHA_512 = "SHA-512"
HASHING_ALGORITHM_SHA3_256 = "SHA3-256"
HASHING_ALGORITHM_SHA3_512 = "SHA3-512"
HASHING_ALGORITHM_SSDEEP = "SSDEEP"
HASHING_ALGORITHM_TLSH = "TLSH"


HASHING_ALGORITHM = [
    HASHING_ALGORITHM_MD5,
    HASHING_ALGORITHM_SHA_1,
    HASHING_ALGORITHM_SHA_256,
    HASHING_ALGORITHM_SHA_512,
    HASHING_ALGORITHM_SHA3_256,
    HASHING_ALGORITHM_SHA3_512,
    HASHING_ALGORITHM_SSDEEP,
    HASHING_ALGORITHM_TLSH,
]


IDENTITY_CLASS_INDIVIDUAL = "individual"
IDENTITY_CLASS_GROUP = "group"
IDENTITY_CLASS_SYSTEM = "system"
IDENTITY_CLASS_ORGANIZATION = "organization"
IDENTITY_CLASS_CLASS = "class"
IDENTITY_CLASS_UNKNOWN = "unknown"


IDENTITY_CLASS = [
    IDENTITY_CLASS_INDIVIDUAL,
    IDENTITY_CLASS_GROUP,
    IDENTITY_CLASS_SYSTEM,
    IDENTITY_CLASS_ORGANIZATION,
    IDENTITY_CLASS_CLASS,
    IDENTITY_CLASS_UNKNOWN,
]


IMPLEMENTATION_LANGUAGE_APPLESCRIPT = "applescript"
IMPLEMENTATION_LANGUAGE_BASH = "bash"
IMPLEMENTATION_LANGUAGE_C = "c"
IMPLEMENTATION_LANGUAGE_CPLUSPLUS = "c++"
IMPLEMENTATION_LANGUAGE_CSHARP = "c#"
IMPLEMENTATION_LANGUAGE_GO = "go"
IMPLEMENTATION_LANGUAGE_JAVA = "java"
IMPLEMENTATION_LANGUAGE_JAVASCRIPT = "javascript"
IMPLEMENTATION_LANGUAGE_LUA = "lua"
IMPLEMENTATION_LANGUAGE_OBJECTIVE_C = "objective-c"
IMPLEMENTATION_LANGUAGE_PERL = "perl"
IMPLEMENTATION_LANGUAGE_PHP = "php"
IMPLEMENTATION_LANGUAGE_POWERSHELL = "powershell"
IMPLEMENTATION_LANGUAGE_PYTHON = "python"
IMPLEMENTATION_LANGUAGE_RUBY = "ruby"
IMPLEMENTATION_LANGUAGE_SCALA = "scala"
IMPLEMENTATION_LANGUAGE_SWIFT = "swift"
IMPLEMENTATION_LANGUAGE_TYPESCRIPT = "typescript"
IMPLEMENTATION_LANGUAGE_VISUAL_BASIC = "visual-basic"
IMPLEMENTATION_LANGUAGE_X86_32 = "x86-32"
IMPLEMENTATION_LANGUAGE_X86_64 = "x86-64"


IMPLEMENTATION_LANGUAGE = [
    IMPLEMENTATION_LANGUAGE_APPLESCRIPT,
    IMPLEMENTATION_LANGUAGE_BASH,
    IMPLEMENTATION_LANGUAGE_C,
    IMPLEMENTATION_LANGUAGE_CPLUSPLUS,
    IMPLEMENTATION_LANGUAGE_CSHARP,
    IMPLEMENTATION_LANGUAGE_GO,
    IMPLEMENTATION_LANGUAGE_JAVA,
    IMPLEMENTATION_LANGUAGE_JAVASCRIPT,
    IMPLEMENTATION_LANGUAGE_LUA,
    IMPLEMENTATION_LANGUAGE_OBJECTIVE_C,
    IMPLEMENTATION_LANGUAGE_PERL,
    IMPLEMENTATION_LANGUAGE_PHP,
    IMPLEMENTATION_LANGUAGE_POWERSHELL,
    IMPLEMENTATION_LANGUAGE_PYTHON,
    IMPLEMENTATION_LANGUAGE_RUBY,
    IMPLEMENTATION_LANGUAGE_SCALA,
    IMPLEMENTATION_LANGUAGE_SWIFT,
    IMPLEMENTATION_LANGUAGE_TYPESCRIPT,
    IMPLEMENTATION_LANGUAGE_VISUAL_BASIC,
    IMPLEMENTATION_LANGUAGE_X86_32,
    IMPLEMENTATION_LANGUAGE_X86_64,
]


INDICATOR_TYPE_ANOMALOUS_ACTIVITY = "anomalous-activity"
INDICATOR_TYPE_ANONYMIZATION = "anonymization"
INDICATOR_TYPE_BENIGN = "benign"
INDICATOR_TYPE_COMPROMISED = "compromised"
INDICATOR_TYPE_MALICIOUS_ACTIVITY = "malicious-activity"
INDICATOR_TYPE_ATTRIBUTION = "attribution"
INDICATOR_TYPE_UNKNOWN = "unknown"


INDICATOR_TYPE = [
    INDICATOR_TYPE_ANOMALOUS_ACTIVITY,
    INDICATOR_TYPE_ANONYMIZATION,
    INDICATOR_TYPE_BENIGN,
    INDICATOR_TYPE_COMPROMISED,
    INDICATOR_TYPE_MALICIOUS_ACTIVITY,
    INDICATOR_TYPE_ATTRIBUTION,
    INDICATOR_TYPE_UNKNOWN,
]


INDUSTRY_SECTOR_AGRICULTURE = "agriculture"
INDUSTRY_SECTOR_AEROSPACE = "aerospace"
INDUSTRY_SECTOR_AUTOMOTIVE = "automotive"
INDUSTRY_SECTOR_CHEMICAL = "chemical"
INDUSTRY_SECTOR_COMMERCIAL = "commercial"
INDUSTRY_SECTOR_COMMUNICATIONS = "communications"
INDUSTRY_SECTOR_CONSTRUCTION = "construction"
INDUSTRY_SECTOR_DEFENSE = "defense"
INDUSTRY_SECTOR_EDUCATION = "education"
INDUSTRY_SECTOR_ENERGY = "energy"
INDUSTRY_SECTOR_ENTERTAINMENT = "entertainment"
INDUSTRY_SECTOR_FINANCIAL_SERVICES = "financial-services"
INDUSTRY_SECTOR_GOVERNMENT = "government"
INDUSTRY_SECTOR_EMERGENCY_SERVICES = "emergency-services"
INDUSTRY_SECTOR_GOVERNMENT_NATIONAL = "government-national"
INDUSTRY_SECTOR_GOVERNMENT_REGIONAL = "government-regional"
INDUSTRY_SECTOR_GOVERNMENT_LOCAL = "government-local"
INDUSTRY_SECTOR_GOVERNMENT_PUBLIC_SERVICES = "government-public-services"
INDUSTRY_SECTOR_HEALTHCARE = "healthcare"
INDUSTRY_SECTOR_HOSPITALITY_LEISURE = "hospitality-leisure"
INDUSTRY_SECTOR_INFRASTRUCTURE = "infrastructure"
INDUSTRY_SECTOR_DAMS = "dams"
INDUSTRY_SECTOR_NUCLEAR = "nuclear"
INDUSTRY_SECTOR_WATER = "water"
INDUSTRY_SECTOR_INSURANCE = "insurance"
INDUSTRY_SECTOR_MANUFACTURING = "manufacturing"
INDUSTRY_SECTOR_MINING = "mining"
INDUSTRY_SECTOR_NON_PROFIT = "non-profit"
INDUSTRY_SECTOR_PHARMACEUTICALS = "pharmaceuticals"
INDUSTRY_SECTOR_RETAIL = "retail"
INDUSTRY_SECTOR_TECHNOLOGY = "technology"
INDUSTRY_SECTOR_TELECOMMUNICATIONS = "telecommunications"
INDUSTRY_SECTOR_TRANSPORTATION = "transportation"
INDUSTRY_SECTOR_UTILITIES = "utilities"


INDUSTRY_SECTOR = [
    INDUSTRY_SECTOR_AGRICULTURE,
    INDUSTRY_SECTOR_AEROSPACE,
    INDUSTRY_SECTOR_AUTOMOTIVE,
    INDUSTRY_SECTOR_CHEMICAL,
    INDUSTRY_SECTOR_COMMERCIAL,
    INDUSTRY_SECTOR_COMMUNICATIONS,
    INDUSTRY_SECTOR_CONSTRUCTION,
    INDUSTRY_SECTOR_DEFENSE,
    INDUSTRY_SECTOR_EDUCATION,
    INDUSTRY_SECTOR_ENERGY,
    INDUSTRY_SECTOR_ENTERTAINMENT,
    INDUSTRY_SECTOR_FINANCIAL_SERVICES,
    INDUSTRY_SECTOR_GOVERNMENT,
    INDUSTRY_SECTOR_EMERGENCY_SERVICES,
    INDUSTRY_SECTOR_GOVERNMENT_NATIONAL,
    INDUSTRY_SECTOR_GOVERNMENT_REGIONAL,
    INDUSTRY_SECTOR_GOVERNMENT_LOCAL,
    INDUSTRY_SECTOR_GOVERNMENT_PUBLIC_SERVICES,
    INDUSTRY_SECTOR_HEALTHCARE,
    INDUSTRY_SECTOR_HOSPITALITY_LEISURE,
    INDUSTRY_SECTOR_INFRASTRUCTURE,
    INDUSTRY_SECTOR_DAMS,
    INDUSTRY_SECTOR_NUCLEAR,
    INDUSTRY_SECTOR_WATER,
    INDUSTRY_SECTOR_INSURANCE,
    INDUSTRY_SECTOR_MANUFACTURING,
    INDUSTRY_SECTOR_MINING,
    INDUSTRY_SECTOR_NON_PROFIT,
    INDUSTRY_SECTOR_PHARMACEUTICALS,
    INDUSTRY_SECTOR_RETAIL,
    INDUSTRY_SECTOR_TECHNOLOGY,
    INDUSTRY_SECTOR_TELECOMMUNICATIONS,
    INDUSTRY_SECTOR_TRANSPORTATION,
    INDUSTRY_SECTOR_UTILITIES,
]


INFRASTRUCTURE_TYPE_AMPLIFICATION = "amplification"
INFRASTRUCTURE_TYPE_ANONYMIZATION = "anonymization"
INFRASTRUCTURE_TYPE_BOTNET = "botnet"
INFRASTRUCTURE_TYPE_COMMAND_AND_CONTROL = "command-and-control"
INFRASTRUCTURE_TYPE_CONTROL_SYSTEM = "control-system"
INFRASTRUCTURE_TYPE_EXFILTRATION = "exfiltration"
INFRASTRUCTURE_TYPE_FIREWALL = "firewall"
INFRASTRUCTURE_TYPE_HOSTING_MALWARE = "hosting-malware"
INFRASTRUCTURE_TYPE_HOSTING_TARGET_LISTS = "hosting-target-lists"
INFRASTRUCTURE_TYPE_PHISHING = "phishing"
INFRASTRUCTURE_TYPE_RECONNAISSANCE = "reconnaissance"
INFRASTRUCTURE_TYPE_ROUTERS_SWITCHES = "routers-switches"
INFRASTRUCTURE_TYPE_STAGING = "staging"
INFRASTRUCTURE_TYPE_WORKSTATION = "workstation"
INFRASTRUCTURE_TYPE_UNKNOWN = "unknown"


INFRASTRUCTURE_TYPE = [
    INFRASTRUCTURE_TYPE_AMPLIFICATION,
    INFRASTRUCTURE_TYPE_ANONYMIZATION,
    INFRASTRUCTURE_TYPE_BOTNET,
    INFRASTRUCTURE_TYPE_COMMAND_AND_CONTROL,
    INFRASTRUCTURE_TYPE_CONTROL_SYSTEM,
    INFRASTRUCTURE_TYPE_EXFILTRATION,
    INFRASTRUCTURE_TYPE_FIREWALL,
    INFRASTRUCTURE_TYPE_HOSTING_MALWARE,
    INFRASTRUCTURE_TYPE_HOSTING_TARGET_LISTS,
    INFRASTRUCTURE_TYPE_PHISHING,
    INFRASTRUCTURE_TYPE_RECONNAISSANCE,
    INFRASTRUCTURE_TYPE_ROUTERS_SWITCHES,
    INFRASTRUCTURE_TYPE_STAGING,
    INFRASTRUCTURE_TYPE_WORKSTATION,
    INFRASTRUCTURE_TYPE_UNKNOWN,
]


MALWARE_RESULT_MALICIOUS = "malicious"
MALWARE_RESULT_SUSPICIOUS = "suspicious"
MALWARE_RESULT_BENIGN = "benign"
MALWARE_RESULT_UNKNOWN = "unknown"


MALWARE_RESULT = [
    MALWARE_RESULT_MALICIOUS,
    MALWARE_RESULT_SUSPICIOUS,
    MALWARE_RESULT_BENIGN,
    MALWARE_RESULT_UNKNOWN,
]


MALWARE_CAPABILITIES_ACCESSES_REMOTE_MACHINES = "accesses-remote-machines"
MALWARE_CAPABILITIES_ANTI_DEBUGGING = "anti-debugging"
MALWARE_CAPABILITIES_ANTI_DISASSEMBLY = "anti-disassembly"
MALWARE_CAPABILITIES_ANTI_EMULATION = "anti-emulation"
MALWARE_CAPABILITIES_ANTI_MEMORY_FORENSICS = "anti-memory-forensics"
MALWARE_CAPABILITIES_ANTI_SANDBOX = "anti-sandbox"
MALWARE_CAPABILITIES_ANTI_VM = "anti-vm"
MALWARE_CAPABILITIES_CAPTURES_INPUT_PERIPHERALS = "captures-input-peripherals"
MALWARE_CAPABILITIES_CAPTURES_OUTPUT_PERIPHERALS = "captures-output-peripherals"
MALWARE_CAPABILITIES_CAPTURES_SYSTEM_STATE_DATA = "captures-system-state-data"
MALWARE_CAPABILITIES_CLEANS_TRACES_OF_INFECTION = "cleans-traces-of-infection"
MALWARE_CAPABILITIES_COMMITS_FRAUD = "commits-fraud"
MALWARE_CAPABILITIES_COMMUNICATES_WITH_C2 = "communicates-with-c2"
MALWARE_CAPABILITIES_COMPROMISES_DATA_AVAILABILITY = "compromises-data-availability"
MALWARE_CAPABILITIES_COMPROMISES_DATA_INTEGRITY = "compromises-data-integrity"
MALWARE_CAPABILITIES_COMPROMISES_SYSTEM_AVAILABILITY = "compromises-system-availability"
MALWARE_CAPABILITIES_CONTROLS_LOCAL_MACHINE = "controls-local-machine"
MALWARE_CAPABILITIES_DEGRADES_SECURITY_SOFTWARE = "degrades-security-software"
MALWARE_CAPABILITIES_DEGRADES_SYSTEM_UPDATES = "degrades-system-updates"
MALWARE_CAPABILITIES_DETERMINES_C2_SERVER = "determines-c2-server"
MALWARE_CAPABILITIES_EMAILS_SPAM = "emails-spam"
MALWARE_CAPABILITIES_ESCALATES_PRIVILEGES = "escalates-privileges"
MALWARE_CAPABILITIES_EVADES_AV = "evades-av"
MALWARE_CAPABILITIES_EXFILTRATES_DATA = "exfiltrates-data"
MALWARE_CAPABILITIES_FINGERPRINTS_HOST = "fingerprints-host"
MALWARE_CAPABILITIES_HIDES_ARTIFACTS = "hides-artifacts"
MALWARE_CAPABILITIES_HIDES_EXECUTING_CODE = "hides-executing-code"
MALWARE_CAPABILITIES_INFECTS_FILES = "infects-files"
MALWARE_CAPABILITIES_INFECTS_REMOTE_MACHINES = "infects-remote-machines"
MALWARE_CAPABILITIES_INSTALLS_OTHER_COMPONENTS = "installs-other-components"
MALWARE_CAPABILITIES_PERSISTS_AFTER_SYSTEM_REBOOT = "persists-after-system-reboot"
MALWARE_CAPABILITIES_PREVENTS_ARTIFACT_ACCESS = "prevents-artifact-access"
MALWARE_CAPABILITIES_PREVENTS_ARTIFACT_DELETION = "prevents-artifact-deletion"
MALWARE_CAPABILITIES_PROBES_NETWORK_ENVIRONMENT = "probes-network-environment"
MALWARE_CAPABILITIES_SELF_MODIFIES = "self-modifies"
MALWARE_CAPABILITIES_STEALS_AUTHENTICATION_CREDENTIALS = "steals-authentication-credentials"
MALWARE_CAPABILITIES_VIOLATES_SYSTEM_OPERATIONAL_INTEGRITY = "violates-system-operational-integrity"


MALWARE_CAPABILITIES = [
    MALWARE_CAPABILITIES_ACCESSES_REMOTE_MACHINES,
    MALWARE_CAPABILITIES_ANTI_DEBUGGING,
    MALWARE_CAPABILITIES_ANTI_DISASSEMBLY,
    MALWARE_CAPABILITIES_ANTI_EMULATION,
    MALWARE_CAPABILITIES_ANTI_MEMORY_FORENSICS,
    MALWARE_CAPABILITIES_ANTI_SANDBOX,
    MALWARE_CAPABILITIES_ANTI_VM,
    MALWARE_CAPABILITIES_CAPTURES_INPUT_PERIPHERALS,
    MALWARE_CAPABILITIES_CAPTURES_OUTPUT_PERIPHERALS,
    MALWARE_CAPABILITIES_CAPTURES_SYSTEM_STATE_DATA,
    MALWARE_CAPABILITIES_CLEANS_TRACES_OF_INFECTION,
    MALWARE_CAPABILITIES_COMMITS_FRAUD,
    MALWARE_CAPABILITIES_COMMUNICATES_WITH_C2,
    MALWARE_CAPABILITIES_COMPROMISES_DATA_AVAILABILITY,
    MALWARE_CAPABILITIES_COMPROMISES_DATA_INTEGRITY,
    MALWARE_CAPABILITIES_COMPROMISES_SYSTEM_AVAILABILITY,
    MALWARE_CAPABILITIES_CONTROLS_LOCAL_MACHINE,
    MALWARE_CAPABILITIES_DEGRADES_SECURITY_SOFTWARE,
    MALWARE_CAPABILITIES_DEGRADES_SYSTEM_UPDATES,
    MALWARE_CAPABILITIES_DETERMINES_C2_SERVER,
    MALWARE_CAPABILITIES_EMAILS_SPAM,
    MALWARE_CAPABILITIES_ESCALATES_PRIVILEGES,
    MALWARE_CAPABILITIES_EVADES_AV,
    MALWARE_CAPABILITIES_EXFILTRATES_DATA,
    MALWARE_CAPABILITIES_FINGERPRINTS_HOST,
    MALWARE_CAPABILITIES_HIDES_ARTIFACTS,
    MALWARE_CAPABILITIES_HIDES_EXECUTING_CODE,
    MALWARE_CAPABILITIES_INFECTS_FILES,
    MALWARE_CAPABILITIES_INFECTS_REMOTE_MACHINES,
    MALWARE_CAPABILITIES_INSTALLS_OTHER_COMPONENTS,
    MALWARE_CAPABILITIES_PERSISTS_AFTER_SYSTEM_REBOOT,
    MALWARE_CAPABILITIES_PREVENTS_ARTIFACT_ACCESS,
    MALWARE_CAPABILITIES_PREVENTS_ARTIFACT_DELETION,
    MALWARE_CAPABILITIES_PROBES_NETWORK_ENVIRONMENT,
    MALWARE_CAPABILITIES_SELF_MODIFIES,
    MALWARE_CAPABILITIES_STEALS_AUTHENTICATION_CREDENTIALS,
    MALWARE_CAPABILITIES_VIOLATES_SYSTEM_OPERATIONAL_INTEGRITY,
]


MALWARE_TYPE_ADWARE = "adware"
MALWARE_TYPE_BACKDOOR = "backdoor"
MALWARE_TYPE_BOT = "bot"
MALWARE_TYPE_BOOTKIT = "bootkit"
MALWARE_TYPE_DDOS = "ddos"
MALWARE_TYPE_DOWNLOADER = "downloader"
MALWARE_TYPE_DROPPER = "dropper"
MALWARE_TYPE_EXPLOIT_KIT = "exploit-kit"
MALWARE_TYPE_KEYLOGGER = "keylogger"
MALWARE_TYPE_RANSOMWARE = "ransomware"
MALWARE_TYPE_REMOTE_ACCESS_TROJAN = "remote-access-trojan"
MALWARE_TYPE_RESOURCE_EXPLOITATION = "resource-exploitation"
MALWARE_TYPE_ROGUE_SECURITY_SOFTWARE = "rogue-security-software"
MALWARE_TYPE_ROOTKIT = "rootkit"
MALWARE_TYPE_SCREEN_CAPTURE = "screen-capture"
MALWARE_TYPE_SPYWARE = "spyware"
MALWARE_TYPE_TROJAN = "trojan"
MALWARE_TYPE_UNKNOWN = "unknown"
MALWARE_TYPE_VIRUS = "virus"
MALWARE_TYPE_WEBSHELL = "webshell"
MALWARE_TYPE_WIPER = "wiper"
MALWARE_TYPE_WORM = "worm"


MALWARE_TYPE = [
    MALWARE_TYPE_ADWARE,
    MALWARE_TYPE_BACKDOOR,
    MALWARE_TYPE_BOT,
    MALWARE_TYPE_BOOTKIT,
    MALWARE_TYPE_DDOS,
    MALWARE_TYPE_DOWNLOADER,
    MALWARE_TYPE_DROPPER,
    MALWARE_TYPE_EXPLOIT_KIT,
    MALWARE_TYPE_KEYLOGGER,
    MALWARE_TYPE_RANSOMWARE,
    MALWARE_TYPE_REMOTE_ACCESS_TROJAN,
    MALWARE_TYPE_RESOURCE_EXPLOITATION,
    MALWARE_TYPE_ROGUE_SECURITY_SOFTWARE,
    MALWARE_TYPE_ROOTKIT,
    MALWARE_TYPE_SCREEN_CAPTURE,
    MALWARE_TYPE_SPYWARE,
    MALWARE_TYPE_TROJAN,
    MALWARE_TYPE_UNKNOWN,
    MALWARE_TYPE_VIRUS,
    MALWARE_TYPE_WEBSHELL,
    MALWARE_TYPE_WIPER,
    MALWARE_TYPE_WORM,
]


NETWORK_SOCKET_ADDRESS_FAMILY_AF_UNSPEC = "AF_UNSPEC"
NETWORK_SOCKET_ADDRESS_FAMILY_AF_INET = "AF_INET"
NETWORK_SOCKET_ADDRESS_FAMILY_AF_IPX = "AF_IPX"
NETWORK_SOCKET_ADDRESS_FAMILY_AF_APPLETALK = "AF_APPLETALK"
NETWORK_SOCKET_ADDRESS_FAMILY_AF_NETBIOS = "AF_NETBIOS"
NETWORK_SOCKET_ADDRESS_FAMILY_AF_INET6 = "AF_INET6"
NETWORK_SOCKET_ADDRESS_FAMILY_AF_IRDA = "AF_IRDA"
NETWORK_SOCKET_ADDRESS_FAMILY_AF_BTH = "AF_BTH"


NETWORK_SOCKET_ADDRESS_FAMILY = [
    NETWORK_SOCKET_ADDRESS_FAMILY_AF_UNSPEC,
    NETWORK_SOCKET_ADDRESS_FAMILY_AF_INET,
    NETWORK_SOCKET_ADDRESS_FAMILY_AF_IPX,
    NETWORK_SOCKET_ADDRESS_FAMILY_AF_APPLETALK,
    NETWORK_SOCKET_ADDRESS_FAMILY_AF_NETBIOS,
    NETWORK_SOCKET_ADDRESS_FAMILY_AF_INET6,
    NETWORK_SOCKET_ADDRESS_FAMILY_AF_IRDA,
    NETWORK_SOCKET_ADDRESS_FAMILY_AF_BTH,
]


NETWORK_SOCKET_TYPE_SOCK_STREAM = "SOCK_STREAM"
NETWORK_SOCKET_TYPE_SOCK_DGRAM = "SOCK_DGRAM"
NETWORK_SOCKET_TYPE_SOCK_RAW = "SOCK_RAW"
NETWORK_SOCKET_TYPE_SOCK_RDM = "SOCK_RDM"
NETWORK_SOCKET_TYPE_SOCK_SEQPACKET = "SOCK_SEQPACKET"


NETWORK_SOCKET_TYPE = [
    NETWORK_SOCKET_TYPE_SOCK_STREAM,
    NETWORK_SOCKET_TYPE_SOCK_DGRAM,
    NETWORK_SOCKET_TYPE_SOCK_RAW,
    NETWORK_SOCKET_TYPE_SOCK_RDM,
    NETWORK_SOCKET_TYPE_SOCK_SEQPACKET,
]


OPINION_STRONGLY_DISAGREE = "strongly-disagree"
OPINION_DISAGREE = "disagree"
OPINION_NEUTRAL = "neutral"
OPINION_AGREE = "agree"
OPINION_STRONGLY_AGREE = "strongly-agree"


OPINION = [
    OPINION_STRONGLY_DISAGREE,
    OPINION_DISAGREE,
    OPINION_NEUTRAL,
    OPINION_AGREE,
    OPINION_STRONGLY_AGREE,
]


PATTERN_TYPE_STIX = "stix"
PATTERN_TYPE_PCRE = "pcre"
PATTERN_TYPE_SIGMA = "sigma"
PATTERN_TYPE_SNORT = "snort"
PATTERN_TYPE_SURICATA = "suricata"
PATTERN_TYPE_YARA = "yara"


PATTERN_TYPE = [
    PATTERN_TYPE_STIX,
    PATTERN_TYPE_PCRE,
    PATTERN_TYPE_SIGMA,
    PATTERN_TYPE_SNORT,
    PATTERN_TYPE_SURICATA,
    PATTERN_TYPE_YARA,
]


PROCESSOR_ARCHITECTURE_ALPHA = "alpha"
PROCESSOR_ARCHITECTURE_ARM = "arm"
PROCESSOR_ARCHITECTURE_IA_64 = "ia-64"
PROCESSOR_ARCHITECTURE_MIPS = "mips"
PROCESSOR_ARCHITECTURE_POWERPC = "powerpc"
PROCESSOR_ARCHITECTURE_SPARC = "sparc"
PROCESSOR_ARCHITECTURE_X86 = "x86"
PROCESSOR_ARCHITECTURE_X86_64 = "x86-64"


PROCESSOR_ARCHITECTURE = [
    PROCESSOR_ARCHITECTURE_ALPHA,
    PROCESSOR_ARCHITECTURE_ARM,
    PROCESSOR_ARCHITECTURE_IA_64,
    PROCESSOR_ARCHITECTURE_MIPS,
    PROCESSOR_ARCHITECTURE_POWERPC,
    PROCESSOR_ARCHITECTURE_SPARC,
    PROCESSOR_ARCHITECTURE_X86,
    PROCESSOR_ARCHITECTURE_X86_64,
]


REGION_AFRICA = "africa"
REGION_EASTERN_AFRICA = "eastern-africa"
REGION_MIDDLE_AFRICA = "middle-africa"
REGION_NORTHERN_AFRICA = "northern-africa"
REGION_SOUTHERN_AFRICA = "southern-africa"
REGION_WESTERN_AFRICA = "western-africa"
REGION_AMERICAS = "americas"
REGION_LATIN_AMERICA_CARIBBEAN = "latin-america-caribbean"
REGION_SOUTH_AMERICA = "south-america"
REGION_CARIBBEAN = "caribbean"
REGION_CENTRAL_AMERICA = "central-america"
REGION_NORTHERN_AMERICA = "northern-america"
REGION_ASIA = "asia"
REGION_CENTRAL_ASIA = "central-asia"
REGION_EASTERN_ASIA = "eastern-asia"
REGION_SOUTHERN_ASIA = "southern-asia"
REGION_SOUTH_EASTERN_ASIA = "south-eastern-asia"
REGION_WESTERN_ASIA = "western-asia"
REGION_EUROPE = "europe"
REGION_EASTERN_EUROPE = "eastern-europe"
REGION_NORTHERN_EUROPE = "northern-europe"
REGION_SOUTHERN_EUROPE = "southern-europe"
REGION_WESTERN_EUROPE = "western-europe"
REGION_OCEANIA = "oceania"
REGION_ANTARCTICA = "antarctica"
REGION_AUSTRALIA_NEW_ZEALAND = "australia-new-zealand"
REGION_MELANESIA = "melanesia"
REGION_MICRONESIA = "micronesia"
REGION_POLYNESIA = "polynesia"


REGION = [
    REGION_AFRICA,
    REGION_EASTERN_AFRICA,
    REGION_MIDDLE_AFRICA,
    REGION_NORTHERN_AFRICA,
    REGION_SOUTHERN_AFRICA,
    REGION_WESTERN_AFRICA,
    REGION_AMERICAS,
    REGION_LATIN_AMERICA_CARIBBEAN,
    REGION_SOUTH_AMERICA,
    REGION_CARIBBEAN,
    REGION_CENTRAL_AMERICA,
    REGION_NORTHERN_AMERICA,
    REGION_ASIA,
    REGION_CENTRAL_ASIA,
    REGION_EASTERN_ASIA,
    REGION_SOUTHERN_ASIA,
    REGION_SOUTH_EASTERN_ASIA,
    REGION_WESTERN_ASIA,
    REGION_EUROPE,
    REGION_EASTERN_EUROPE,
    REGION_NORTHERN_EUROPE,
    REGION_SOUTHERN_EUROPE,
    REGION_WESTERN_EUROPE,
    REGION_OCEANIA,
    REGION_ANTARCTICA,
    REGION_AUSTRALIA_NEW_ZEALAND,
    REGION_MELANESIA,
    REGION_MICRONESIA,
    REGION_POLYNESIA,
]


REPORT_TYPE_ATTACK_PATTERN = "attack-pattern"
REPORT_TYPE_CAMPAIGN = "campaign"
REPORT_TYPE_IDENTITY = "identity"
REPORT_TYPE_INDICATOR = "indicator"
REPORT_TYPE_INTRUSION_SET = "intrusion-set"
REPORT_TYPE_MALWARE = "malware"
REPORT_TYPE_OBSERVED_DATA = "observed-data"
REPORT_TYPE_THREAT_ACTOR = "threat-actor"
REPORT_TYPE_THREAT_REPORT = "threat-report"
REPORT_TYPE_TOOL = "tool"
REPORT_TYPE_VULNERABILITY = "vulnerability"


REPORT_TYPE = [
    REPORT_TYPE_ATTACK_PATTERN,
    REPORT_TYPE_CAMPAIGN,
    REPORT_TYPE_IDENTITY,
    REPORT_TYPE_INDICATOR,
    REPORT_TYPE_INTRUSION_SET,
    REPORT_TYPE_MALWARE,
    REPORT_TYPE_OBSERVED_DATA,
    REPORT_TYPE_THREAT_ACTOR,
    REPORT_TYPE_THREAT_REPORT,
    REPORT_TYPE_TOOL,
    REPORT_TYPE_VULNERABILITY,
]


THREAT_ACTOR_TYPE_ACTIVIST = "activist"
THREAT_ACTOR_TYPE_COMPETITOR = "competitor"
THREAT_ACTOR_TYPE_CRIME_SYNDICATE = "crime-syndicate"
THREAT_ACTOR_TYPE_CRIMINAL = "criminal"
THREAT_ACTOR_TYPE_HACKER = "hacker"
THREAT_ACTOR_TYPE_INSIDER_ACCIDENTAL = "insider-accidental"
THREAT_ACTOR_TYPE_INSIDER_DISGRUNTLED = "insider-disgruntled"
THREAT_ACTOR_TYPE_NATION_STATE = "nation-state"
THREAT_ACTOR_TYPE_SENSATIONALIST = "sensationalist"
THREAT_ACTOR_TYPE_SPY = "spy"
THREAT_ACTOR_TYPE_TERRORIST = "terrorist"
THREAT_ACTOR_TYPE_UNKNOWN = "unknown"


THREAT_ACTOR_TYPE = [
    THREAT_ACTOR_TYPE_ACTIVIST,
    THREAT_ACTOR_TYPE_COMPETITOR,
    THREAT_ACTOR_TYPE_CRIME_SYNDICATE,
    THREAT_ACTOR_TYPE_CRIMINAL,
    THREAT_ACTOR_TYPE_HACKER,
    THREAT_ACTOR_TYPE_INSIDER_ACCIDENTAL,
    THREAT_ACTOR_TYPE_INSIDER_DISGRUNTLED,
    THREAT_ACTOR_TYPE_NATION_STATE,
    THREAT_ACTOR_TYPE_SENSATIONALIST,
    THREAT_ACTOR_TYPE_SPY,
    THREAT_ACTOR_TYPE_TERRORIST,
    THREAT_ACTOR_TYPE_UNKNOWN,
]


THREAT_ACTOR_ROLE_AGENT = "agent"
THREAT_ACTOR_ROLE_DIRECTOR = "director"
THREAT_ACTOR_ROLE_INDEPENDENT = "independent"
THREAT_ACTOR_ROLE_INFRASTRUCTURE_ARCHITECT = "infrastructure-architect"
THREAT_ACTOR_ROLE_INFRASTRUCTURE_OPERATOR = "infrastructure-operator"
THREAT_ACTOR_ROLE_MALWARE_AUTHOR = "malware-author"
THREAT_ACTOR_ROLE_SPONSOR = "sponsor"


THREAT_ACTOR_ROLE = [
    THREAT_ACTOR_ROLE_AGENT,
    THREAT_ACTOR_ROLE_DIRECTOR,
    THREAT_ACTOR_ROLE_INDEPENDENT,
    THREAT_ACTOR_ROLE_INFRASTRUCTURE_ARCHITECT,
    THREAT_ACTOR_ROLE_INFRASTRUCTURE_OPERATOR,
    THREAT_ACTOR_ROLE_MALWARE_AUTHOR,
    THREAT_ACTOR_ROLE_SPONSOR,
]


THREAT_ACTOR_SOPHISTICATION_NONE = "none"
THREAT_ACTOR_SOPHISTICATION_MINIMAL = "minimal"
THREAT_ACTOR_SOPHISTICATION_INTERMEDIATE = "intermediate"
THREAT_ACTOR_SOPHISTICATION_ADVANCED = "advanced"
THREAT_ACTOR_SOPHISTICATION_EXPERT = "expert"
THREAT_ACTOR_SOPHISTICATION_INNOVATOR = "innovator"
THREAT_ACTOR_SOPHISTICATION_STRATEGIC = "strategic"


THREAT_ACTOR_SOPHISTICATION = [
    THREAT_ACTOR_SOPHISTICATION_NONE,
    THREAT_ACTOR_SOPHISTICATION_MINIMAL,
    THREAT_ACTOR_SOPHISTICATION_INTERMEDIATE,
    THREAT_ACTOR_SOPHISTICATION_ADVANCED,
    THREAT_ACTOR_SOPHISTICATION_EXPERT,
    THREAT_ACTOR_SOPHISTICATION_INNOVATOR,
    THREAT_ACTOR_SOPHISTICATION_STRATEGIC,
]


TOOL_TYPE_DENIAL_OF_SERVICE = "denial-of-service"
TOOL_TYPE_EXPLOITATION = "exploitation"
TOOL_TYPE_INFORMATION_GATHERING = "information-gathering"
TOOL_TYPE_NETWORK_CAPTURE = "network-capture"
TOOL_TYPE_CREDENTIAL_EXPLOITATION = "credential-exploitation"
TOOL_TYPE_REMOTE_ACCESS = "remote-access"
TOOL_TYPE_VULNERABILITY_SCANNING = "vulnerability-scanning"
TOOL_TYPE_UNKNOWN = "unknown"


TOOL_TYPE = [
    TOOL_TYPE_DENIAL_OF_SERVICE,
    TOOL_TYPE_EXPLOITATION,
    TOOL_TYPE_INFORMATION_GATHERING,
    TOOL_TYPE_NETWORK_CAPTURE,
    TOOL_TYPE_CREDENTIAL_EXPLOITATION,
    TOOL_TYPE_REMOTE_ACCESS,
    TOOL_TYPE_VULNERABILITY_SCANNING,
    TOOL_TYPE_UNKNOWN,
]


WINDOWS_INTEGRITY_LEVEL_LOW = "low"
WINDOWS_INTEGRITY_LEVEL_MEDIUM = "medium"
WINDOWS_INTEGRITY_LEVEL_HIGH = "high"
WINDOWS_INTEGRITY_LEVEL_SYSTEM = "system"


WINDOWS_INTEGRITY_LEVEL = [
    WINDOWS_INTEGRITY_LEVEL_LOW,
    WINDOWS_INTEGRITY_LEVEL_MEDIUM,
    WINDOWS_INTEGRITY_LEVEL_HIGH,
    WINDOWS_INTEGRITY_LEVEL_SYSTEM,
]


WINDOWS_PEBINARY_TYPE_DLL = "dll"
WINDOWS_PEBINARY_TYPE_EXE = "exe"
WINDOWS_PEBINARY_TYPE_SYS = "sys"


WINDOWS_PEBINARY_TYPE = [
    WINDOWS_PEBINARY_TYPE_DLL,
    WINDOWS_PEBINARY_TYPE_EXE,
    WINDOWS_PEBINARY_TYPE_SYS,
]


WINDOWS_REGISTRY_DATATYPE_REG_NONE = "REG_NONE"
WINDOWS_REGISTRY_DATATYPE_REG_SZ = "REG_SZ"
WINDOWS_REGISTRY_DATATYPE_REG_EXPAND_SZ = "REG_EXPAND_SZ"
WINDOWS_REGISTRY_DATATYPE_REG_BINARY = "REG_BINARY"
WINDOWS_REGISTRY_DATATYPE_REG_DWORD = "REG_DWORD"
WINDOWS_REGISTRY_DATATYPE_REG_DWORD_BIG_ENDIAN = "REG_DWORD_BIG_ENDIAN"
WINDOWS_REGISTRY_DATATYPE_REG_DWORD_LITTLE_ENDIAN = "REG_DWORD_LITTLE_ENDIAN"
WINDOWS_REGISTRY_DATATYPE_REG_LINK = "REG_LINK"
WINDOWS_REGISTRY_DATATYPE_REG_MULTI_SZ = "REG_MULTI_SZ"
WINDOWS_REGISTRY_DATATYPE_REG_RESOURCE_LIST = "REG_RESOURCE_LIST"
WINDOWS_REGISTRY_DATATYPE_REG_FULL_RESOURCE_DESCRIPTION = "REG_FULL_RESOURCE_DESCRIPTION"
WINDOWS_REGISTRY_DATATYPE_REG_RESOURCE_REQUIREMENTS_LIST = "REG_RESOURCE_REQUIREMENTS_LIST"
WINDOWS_REGISTRY_DATATYPE_REG_QWORD = "REG_QWORD"
WINDOWS_REGISTRY_DATATYPE_REG_INVALID_TYPE = "REG_INVALID_TYPE"


WINDOWS_REGISTRY_DATATYPE = [
    WINDOWS_REGISTRY_DATATYPE_REG_NONE,
    WINDOWS_REGISTRY_DATATYPE_REG_SZ,
    WINDOWS_REGISTRY_DATATYPE_REG_EXPAND_SZ,
    WINDOWS_REGISTRY_DATATYPE_REG_BINARY,
    WINDOWS_REGISTRY_DATATYPE_REG_DWORD,
    WINDOWS_REGISTRY_DATATYPE_REG_DWORD_BIG_ENDIAN,
    WINDOWS_REGISTRY_DATATYPE_REG_DWORD_LITTLE_ENDIAN,
    WINDOWS_REGISTRY_DATATYPE_REG_LINK,
    WINDOWS_REGISTRY_DATATYPE_REG_MULTI_SZ,
    WINDOWS_REGISTRY_DATATYPE_REG_RESOURCE_LIST,
    WINDOWS_REGISTRY_DATATYPE_REG_FULL_RESOURCE_DESCRIPTION,
    WINDOWS_REGISTRY_DATATYPE_REG_RESOURCE_REQUIREMENTS_LIST,
    WINDOWS_REGISTRY_DATATYPE_REG_QWORD,
    WINDOWS_REGISTRY_DATATYPE_REG_INVALID_TYPE,
]


WINDOWS_SERVICE_START_TYPE_SERVICE_AUTO_START = "SERVICE_AUTO_START"
WINDOWS_SERVICE_START_TYPE_SERVICE_BOOT_START = "SERVICE_BOOT_START"
WINDOWS_SERVICE_START_TYPE_SERVICE_DEMAND_START = "SERVICE_DEMAND_START"
WINDOWS_SERVICE_START_TYPE_SERVICE_DISABLED = "SERVICE_DISABLED"
WINDOWS_SERVICE_START_TYPE_SERVICE_SYSTEM_ALERT = "SERVICE_SYSTEM_ALERT"


WINDOWS_SERVICE_START_TYPE = [
    WINDOWS_SERVICE_START_TYPE_SERVICE_AUTO_START,
    WINDOWS_SERVICE_START_TYPE_SERVICE_BOOT_START,
    WINDOWS_SERVICE_START_TYPE_SERVICE_DEMAND_START,
    WINDOWS_SERVICE_START_TYPE_SERVICE_DISABLED,
    WINDOWS_SERVICE_START_TYPE_SERVICE_SYSTEM_ALERT,
]


WINDOWS_SERVICE_TYPE_SERVICE_KERNEL_DRIVER = "SERVICE_KERNEL_DRIVER"
WINDOWS_SERVICE_TYPE_SERVICE_FILE_SYSTEM_DRIVER = "SERVICE_FILE_SYSTEM_DRIVER"
WINDOWS_SERVICE_TYPE_SERVICE_WIN32_OWN_PROCESS = "SERVICE_WIN32_OWN_PROCESS"
WINDOWS_SERVICE_TYPE_SERVICE_WIN32_SHARE_PROCESS = "SERVICE_WIN32_SHARE_PROCESS"


WINDOWS_SERVICE_TYPE = [
    WINDOWS_SERVICE_TYPE_SERVICE_KERNEL_DRIVER,
    WINDOWS_SERVICE_TYPE_SERVICE_FILE_SYSTEM_DRIVER,
    WINDOWS_SERVICE_TYPE_SERVICE_WIN32_OWN_PROCESS,
    WINDOWS_SERVICE_TYPE_SERVICE_WIN32_SHARE_PROCESS,
]


WINDOWS_SERVICE_STATUS_SERVICE_CONTINUE_PENDING = "SERVICE_CONTINUE_PENDING"
WINDOWS_SERVICE_STATUS_SERVICE_PAUSE_PENDING = "SERVICE_PAUSE_PENDING"
WINDOWS_SERVICE_STATUS_SERVICE_PAUSED = "SERVICE_PAUSED"
WINDOWS_SERVICE_STATUS_SERVICE_RUNNING = "SERVICE_RUNNING"
WINDOWS_SERVICE_STATUS_SERVICE_START_PENDING = "SERVICE_START_PENDING"
WINDOWS_SERVICE_STATUS_SERVICE_STOP_PENDING = "SERVICE_STOP_PENDING"
WINDOWS_SERVICE_STATUS_SERVICE_STOPPED = "SERVICE_STOPPED"


WINDOWS_SERVICE_STATUS = [
    WINDOWS_SERVICE_STATUS_SERVICE_CONTINUE_PENDING,
    WINDOWS_SERVICE_STATUS_SERVICE_PAUSE_PENDING,
    WINDOWS_SERVICE_STATUS_SERVICE_PAUSED,
    WINDOWS_SERVICE_STATUS_SERVICE_RUNNING,
    WINDOWS_SERVICE_STATUS_SERVICE_START_PENDING,
    WINDOWS_SERVICE_STATUS_SERVICE_STOP_PENDING,
    WINDOWS_SERVICE_STATUS_SERVICE_STOPPED,
]
