---
title: Projects
---

## At the DLR

### Current Projects

- [ReTraSON](https://www.dlr.de/en/ts/research-transfer/projects/retrason)
   Infrastructure Transformation in Lower Saxony (German)

- [SHOW](https://www.uitp.org/projects/show/)
shows the integration of fleets of automated vehicles in public transport, demand-responsive transport (DRT), Mobility a Service (MaaS) and Logistics as a Service (LaaS) schemes

- [Spurplan](https://www.dlr.de/en/ts/research-transfer/projects/sumo-trackplan-5-deadlock-processing-for-large-scale-scenarios)
SUMO is being expanded and improved in various areas for modeling rail traffic

- [VMo4Orte](https://www.dlr.de/en/research-and-transfer/projects-and-missions/vmo4orte-connected-mobility-for-liveable-places)
Development of solution modules that can be used to contribute to the transformation of the transport system

- [MoCKiii](https://www.dlr.de/en/ts/research-transfer/projects/mockiii)
Creation of a dash board with which the city of Cologne can easily detect the current traffic situation, changes in mobility behavior and the traffic situation in order to then be able to initiate suitable countermeasures

- [KoKoVi](https://www.dlr.de/en/research-and-transfer/projects-and-missions/kokovi)
Transport as a cooperative and networked system

- [TAPAS](https://github.com/DLR-VF/TAPAS)
Model for data on the future development of passenger transport demand in urban areas


### Past Projects

- [ITS for Asia](https://www.dlr.de/en/ts/research-transfer/projects/itsforasia)
Monitoring intersections to identify accident spots

- [Digitaler Knoten 4.0](https://www.dlr.de/en/ts/research-transfer/projects/digitaler-knoten-4-0)
Investigation of networked, efficient and safe organization of mixed traffic situations

- [UrMo Digital](http://web.archive.org/web/20240424063206/https://verkehrsforschung.dlr.de/de/projekte/urmo-digital)
Investigation of mobility and logistics concepts under the influence of digitalization

- [Local Traffic Safety Analyzer (LTSA)](https://www.dlr.de/en/ts/research-transfer/projects/ltsa)
In terms of infrastructure, it recognizes and analyzes the road and provides movement lines (trajectories) as well as messages describing the situation for road users

- [DATAMOST](https://www.dlr.de/en/vf/research-and-transfer/projects/datamost)
Data and Model-based Solutions for the Transformation of Mobility

- [DIGEST](https://www.dlr.de/en/ts/research-transfer/projects/digest)
Digital twin of the road transport system

- [ALFRIED](https://www.dlr.de/en/ts/research-transfer/projects/alfried)
Automatisiertes und vernetztes Fahren in der Logistik am Testfeld Friedrichshafen

- [Spurplan-4](https://www.dlr.de/en/ts/research-transfer/projects/spurplan-4)
Simulation of regional rail traffic for regular operations, disrupted operations and planning interventions

- [VM50City](https://www.dlr.de/en/ts/research-transfer/projects/vm50kcity)
Examination of established categories of measures for potential and feasibility for small and medium-sized cities

- [eUVM](https://www.dlr.de/en/ts/research-transfer/projects/euvm)
Testing and implementing suitable measures to reduce traffic-related emissions

- [AutomoVer](https://www.dlr.de/en/fk/research-and-transfer/research-services/market-simulation-vector21/vector21-projects)
Development of guidance for decision-makers
- [MAVEN](http://www.maven-its.eu/) Managing Automated Vehicles
  Enhances Network
- [TransAID](https://ec.europa.eu/inea/en/horizon-2020/projects/H2020-Transport/Automated-Road-Transport/TransAID)
  new hierarchical traffic management procedures to allow the smooth
  integration of automated vehicles in traffic systems
- [VITAL](https://www.dlr.de/en/ts/research-transfer/projects/vital):
  innovative traffic light control with V2X Communication.
- [VABENE](https://www.dlr.de/en/ts/research-transfer/projects/vabene). SUMO simulates and predicts
  large-scale traffic for disaster and public event management
- [I.MoVe](http://web.archive.org/web/20240722035725/https://verkehrsforschung.dlr.de/de/projekte/imove)
  developing additional car following models
- [Urban Mobility](https://web.archive.org/web/20180329070141/http://www.urmo.info/) Intermodal routing and
  modeling of transfer between vehicles in SUMO
- [Mobility Inside](https://www.mobility-inside.de/) Using SUMO's
  intermodal routing engine
- [HubChain (german)](http://komob.de/projekte/hub-chain/) simulating
  autonomous public transport in rural areas
- [VEU](https://web.archive.org/web/20220802080754/https://verkehrsforschung.dlr.de/de/projekte/veu). In this project, SUMO is used to
  simulated the traffic of Berlin
- [COLOMBO](http://web.archive.org/web/20240722054138/https://verkehrsforschung.dlr.de/en/projects/colombo) Cooperative Self-Organizing
  System for low Carbon Mobility at low Penetration Rates
- [AMITRAN](https://web.archive.org/web/20180815190303/https://www.amitran.eu/)
CO2 Assessment Methodology for ICT in Transport
- [MODUM](https://web.archive.org/web/20180831121624/https://modum-project.eu/)
Addresses the environmental footprint in the transport sector by developing a new approach for pro-active demand-responsive management of traffic
- [iTetris](https://www.ict-itetris.eu/) An Integrated Wireless and
  Traffic Platform for Real-Time Road Traffic Management Solutions
- [Delphi](https://elib.dlr.de/62187/): a joint web decision support application for real time traffic situation analysis and prognosis, information exchange and cooperation
- [ORINOKO](https://web.archive.org/web/20220710041841/https://www.nuernberg.de/imperia/md/verkehrsplanung/dokumente/orinoko_final_internet.pdf): improvements on mobility in the
  city of Nürnberg
- TrafficOnline: traffic flow estimation using cellular phones
- [Soccer2006](https://web.archive.org/web/20150705081516/https://www.dlr.de/desktopdefault.aspx/tabid-1296):
  Traffic prognosis during the FIFA-WorldCup 2006
- Weltjugendtag2005: Traffic prognosis during the world youth day 2005
- [TrafficTower](https://www.dlr.de/en/research-and-transfer/research-infrastructure/traffic-tower-en):
  A virtual traffic management centre
- [INVENT](https://web.archive.org/web/20070310215410/http://www.invent-online.de/de/projekte.html): Evaluation of modern traffic
  management approaches
- [OIS](https://web.archive.org/web/20040826034935/https://www.dlr.de/vf/forschung/projekte/ois): Verification of
  using optical sensors for optimization of traffic lights
- [CityMobil](https://web.archive.org/web/20191204150245/http://www.citymobil-project.eu/) Automatic urban
  transportation. A [simulation for a parking lot](../Tutorials/CityMobil.md) inspired by the Rome
  demonstrator is included with SUMO.
- [DRIVE C2X](https://web.archive.org/web/20170311043037/https://www.drive-c2x.eu/project) Driving implementation
  and evaluation of C2X communication technology
- [MENDEL](https://ikt-em-projekte.de/projekte/mendel-minimal-belastung-elektrischer-netze/) modeling electric
  buses and optimizing charging with respect to grid load

## At other Institutions

### Current Projects

- [MultiAgent Control of Traffic
  Signals](https://github.com/k0emt/macts)
- [VENTOS](https://maniam.github.io/VENTOS/) a VEhicular NeTwork Open
  Simulator
- [Webots](https://www.cyberbotics.com/) a 3D physics robot simulator
  connected to SUMO
- [eWorld](https://web.archive.org/web/20161205050209/https://eworld.sourceforge.net/) - an application that
  allows to convert and enrich roads networks; interaction is done via
  the [TraCI](../TraCI.md)-protocol
- [Environmental Monitoring in/of Metropolitan Areas](https://www.ibr.cs.tu-bs.de/projects/emma/index.xml?lang=en)
  by Sven Lahde, Michael Doering, Wolf-Bastian Pöttner, Moritz Rosin,
  Gerrit Lammert and Lars Wolf from the University of Braunschweig,
  Germany
- [AutoNomos - A Distributed and Self-Regulating Approach for Organizing a Large System of Mobile Objects.](https://web.archive.org/web/20180307071524/https://auto-nomos.de/) Axel Wegener, Horst Hellbrück
  and Stefan Fischer from the University of Luebeck, Germany in
  cooperation with Sándor Fekete from Braunschweig Technical
  University, Germany
- [TraNS - Traffic and Network Simulation environment for design, implementation
  and realistic evaluation of VANET
  applications](https://web.archive.org/web/20190512111856/http://lca.epfl.ch/projects/trans/)
  by Michal Piorkowski, Maxim Raya, Ada Lezama Lugo and Jean-Pierre
  Hubaux from Laboratory for Computer Communications and Applications
  (LCA), [EPFL](https://www.epfl.ch),
  Switzerland
  TraNS is the first open-source project providing a full-blown
  application-centric evaluation framework for VANETs. It has a unique
  set of features necessary to build VANET applications and evaluate
  them in realistic conditions. It comes with a set of ready to use
  examples.
  publications: [Piorkowski, Raya, Lugo, Papadimitratos, Grossglauser,
  Hubaux
  2007](../Publications.md#publications_using_sumo)
- [Veins - "Vehicles in Network Simulation"](https://veins.car2x.org/)
  by Christoph Sommer from the Department of Computer Science,
  University of Erlangen, Germany
  publications: [Sommer, Yao, German, Dressler, 2008](../Publications.md#publications_using_sumo), [Sommer,
  Yao, German, Dressler, 2008
  (2)](../Publications.md#publications_using_sumo)
- "Assessment of traffic regulation policies for the minimization of
  pollutants emissions"
  by Mauro Bianchi at [CEFRIEL](https://www.cefriel.com/), Italy.
  This project uses SUMO in combination with EMEP/CORINAIR methodology
  for evaluating the impact of different traffic regulation strategies
  on pollutants emissions. Traffic simulations are performed offline
  for identifying some optimal regulation policies for different local
  traffic conditions, using a simple evolutionary algorithm. We
  hypothesize an online regulation system with a network of sensors
  that is used to recognize the current traffic situations and deploy
  the optimal traffic regulation policies.
- [Fidens – Trust between Cooperative Systems in Application to VANETs](https://web.archive.org/web/20120313075112/https://www.ldv.ei.tum.de/en/research/fidens/)
  This project investigates trust in vehicular networks (VANETs).
  Besides the trust research, it features a simulation environment for
  large scale vehicular network applications. Our typical scenario
  involves about 13000 vehicles per day over 26 weeks. We build on top
  of SUMO and the network simulator Shawn.
  [Shawn](https://github.com/itm/shawn) aims on investigating an
  algorithm in a network while the underlying layers are kept well
  controlled. To do so, it simulates the effects of the underlying
  layers, not their protocols in detail. This makes it especially fast
  and suitable for application developers.
- [PedSUMO](https://github.com/M-Colley/pedsumo): PedSUMO is an enhancement to SUMO that explores the dynamic interaction between automated vehicles and pedestrians at unprioritized crossings, focusing on pedestrian behavior in response to vehicle-priority communication methods. This open-source project offers detailed algorithms, parameter insights, and an initial data analysis of Ingolstadt, Germany, paving the way for understanding the complex impact of automated vehicles in urban environments.


### Past Projects

- [Congestion-Aware Vehicular Traffic Routing Using WiFi Hotspots](https://www.cottinghams.com/david/downloads/ciiCongestionPoster.pdf)
  by David N. Cottingham, Jonathan J. Davies, & Alastair R. Beresford
  from the University of Cambridge, UK
  publications: [Cottingham, Davies, Beresford,
  2005](../Publications.md#publications_using_sumo)
- GPS-Route by Stefan Edelkamp, Shahidd Jabar and Tilman Mehrer (supervisors)
  from the University of Dortmund, Germany
  many thanks go to students who have extendended SUMO: Maik
  Drozdzynski, Andreas Gaubatz and Miguel Liebe
  publications: [Edelkamp, Jabar, Mehrer, 2005](../Publications.md#publications_using_sumo)
- [Rapid Generation of Realistic Simulation for VANET](https://web.archive.org/web/20230609155720/https://lens.csie.ncku.edu.tw/index.php/research-projects/past/18-rapid-vanet)
  by Feliz Karnadi, Zhi Hai Mo, and Kun Chan Lan from the University
  of New South Wales, Sydney, Australia
  many thanks for extending SUMO\!
  publications: [Karnadi, Mo, Lan,
  2005](../Publications.md#publications_using_sumo)
- ["iTranSIM - Simulation-based Vehicle
  Location"](https://www.cs.tcd.ie/publications/tech-reports/reports.07/TCD-CS-2007-56.pdf)
  by Tino Morenz; Master thesis; 2008
- "Analyse und Simulation von Verkettbarkeitsmaßen in pseudonymer,
  mobiler
  Kommunikation" by Clemens Honomichl; Diploma thesis; 2008
- [emil - Elektrobusse mit induktiver Ladetechnik (german only)](https://web.archive.org/web/20150722031908/https://www.verkehr-bs.de/unternehmen/forschungsprojekt-emil.html)
- [Metro Traffic Simulator](https://www.youtube.com/watch?v=P9rHo6yHRNc)

## Code repositories with SUMO related stuff

- [NetPopulate](https://github.com/maslab-ufrgs/net-populate) Demand generation for SUMO
- [C\# and ANSI C TraCI interface](https://github.com/CodingConnected/CodingConnected.Traci)
- [Integrated Framework for Mathematical Simulations (IFMS)](https://web.archive.org/web/20180611001733/https://github.com/nitindesh/IFMS)
- [Veins](https://github.com/sommer/veins)
- [Secure Cycle project established during the BCX 2018](https://github.com/kratz00/bcx18_secureCycle)
- [An open source traffic light control program](https://github.com/MartijnHarmenzon/openTLC)
- [PyPML - Python Parking Monitoring Library](https://github.com/lcodeca/PyPML)
- [SAGA](https://github.com/lcodeca/SUMOActivityGen) - An Activity-based Multi-modal Mobility Scenario Generator for SUMO.
- [RLLIB+SUMO Utils](https://github.com/lcodeca/rllibsumoutils) is a connector between the RLLIB library and SUMO that uses TraCI. It can be tested using [RLLIB+SUMO Docker](https://github.com/lcodeca/rllibsumodocker) based on a GPU-enabled official TensorFlow image.
- [DCARP-SUMO-Simulation](https://github.com/HawkTom/DCARP-SUMO-Simulation) Benchmarking Dynamic Capacitated Arc Routing Algorithms Using Real-World Traffic Simulation. There is also a [related paper](https://ieeexplore.ieee.org/abstract/document/9870399)
- [RandomActivityGen](https://github.com/d610f20/random-activitygen-py/)  generating a population [statistics file](../Demand/Activity-based_Demand_Generation.md#the_statistics_file) for [ACTIVITYGEN](../activitygen.md).

### Visualization related

- [Web-based 3D visualization of SUMO microsimulations using TraCI and three.js](https://github.com/sidewalklabs/sumo-web3d)
- [Unity based 3D driving simulator](https://github.com/DarraghMac97/Real-time-Traffic-Simulation-with-3D-Visualisation)
- [Unity visualization of pedestrian trajectories](https://github.com/danielbuechele/SumoVizUnity) based on a [WebGL project](https://github.com/danielbuechele/SumoViz3D)
- [SUMO3d - A partial unity 3D project for coupling SUMO and Unity3D](https://github.com/SvenMertin/SUMO3d)
- [Unity frontend for SUMO](https://github.com/Andrew-Stebel/Unity-SUMO)
- https://github.com/BMEAutomatedDrive/SUMO-Unity3D-connection
