// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Hubble

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.3
// 	protoc        (unknown)
// source: tetragon/sensors.proto

package tetragon

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type TracingPolicyState int32

const (
	// unknown state
	TracingPolicyState_TP_STATE_UNKNOWN TracingPolicyState = 0
	// loaded and enabled
	TracingPolicyState_TP_STATE_ENABLED TracingPolicyState = 1
	// loaded but disabled
	TracingPolicyState_TP_STATE_DISABLED TracingPolicyState = 2
	// failed to load
	TracingPolicyState_TP_STATE_LOAD_ERROR TracingPolicyState = 3
	// failed during lifetime
	TracingPolicyState_TP_STATE_ERROR TracingPolicyState = 4
	// in the process of loading
	TracingPolicyState_TP_STATE_LOADING TracingPolicyState = 5
	// in the process of unloading
	TracingPolicyState_TP_STATE_UNLOADING TracingPolicyState = 6
)

// Enum value maps for TracingPolicyState.
var (
	TracingPolicyState_name = map[int32]string{
		0: "TP_STATE_UNKNOWN",
		1: "TP_STATE_ENABLED",
		2: "TP_STATE_DISABLED",
		3: "TP_STATE_LOAD_ERROR",
		4: "TP_STATE_ERROR",
		5: "TP_STATE_LOADING",
		6: "TP_STATE_UNLOADING",
	}
	TracingPolicyState_value = map[string]int32{
		"TP_STATE_UNKNOWN":    0,
		"TP_STATE_ENABLED":    1,
		"TP_STATE_DISABLED":   2,
		"TP_STATE_LOAD_ERROR": 3,
		"TP_STATE_ERROR":      4,
		"TP_STATE_LOADING":    5,
		"TP_STATE_UNLOADING":  6,
	}
)

func (x TracingPolicyState) Enum() *TracingPolicyState {
	p := new(TracingPolicyState)
	*p = x
	return p
}

func (x TracingPolicyState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TracingPolicyState) Descriptor() protoreflect.EnumDescriptor {
	return file_tetragon_sensors_proto_enumTypes[0].Descriptor()
}

func (TracingPolicyState) Type() protoreflect.EnumType {
	return &file_tetragon_sensors_proto_enumTypes[0]
}

func (x TracingPolicyState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TracingPolicyState.Descriptor instead.
func (TracingPolicyState) EnumDescriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{0}
}

type TracingPolicyMode int32

const (
	TracingPolicyMode_TP_MODE_UNKNOWN TracingPolicyMode = 0
	TracingPolicyMode_TP_MODE_ENFORCE TracingPolicyMode = 1
	TracingPolicyMode_TP_MODE_MONITOR TracingPolicyMode = 2
)

// Enum value maps for TracingPolicyMode.
var (
	TracingPolicyMode_name = map[int32]string{
		0: "TP_MODE_UNKNOWN",
		1: "TP_MODE_ENFORCE",
		2: "TP_MODE_MONITOR",
	}
	TracingPolicyMode_value = map[string]int32{
		"TP_MODE_UNKNOWN": 0,
		"TP_MODE_ENFORCE": 1,
		"TP_MODE_MONITOR": 2,
	}
)

func (x TracingPolicyMode) Enum() *TracingPolicyMode {
	p := new(TracingPolicyMode)
	*p = x
	return p
}

func (x TracingPolicyMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TracingPolicyMode) Descriptor() protoreflect.EnumDescriptor {
	return file_tetragon_sensors_proto_enumTypes[1].Descriptor()
}

func (TracingPolicyMode) Type() protoreflect.EnumType {
	return &file_tetragon_sensors_proto_enumTypes[1]
}

func (x TracingPolicyMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TracingPolicyMode.Descriptor instead.
func (TracingPolicyMode) EnumDescriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{1}
}

// For now, we only want to support debug-related config flags to be configurable.
type ConfigFlag int32

const (
	ConfigFlag_CONFIG_FLAG_LOG_LEVEL          ConfigFlag = 0
	ConfigFlag_CONFIG_FLAG_DUMP_PROCESS_CACHE ConfigFlag = 1
)

// Enum value maps for ConfigFlag.
var (
	ConfigFlag_name = map[int32]string{
		0: "CONFIG_FLAG_LOG_LEVEL",
		1: "CONFIG_FLAG_DUMP_PROCESS_CACHE",
	}
	ConfigFlag_value = map[string]int32{
		"CONFIG_FLAG_LOG_LEVEL":          0,
		"CONFIG_FLAG_DUMP_PROCESS_CACHE": 1,
	}
)

func (x ConfigFlag) Enum() *ConfigFlag {
	p := new(ConfigFlag)
	*p = x
	return p
}

func (x ConfigFlag) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConfigFlag) Descriptor() protoreflect.EnumDescriptor {
	return file_tetragon_sensors_proto_enumTypes[2].Descriptor()
}

func (ConfigFlag) Type() protoreflect.EnumType {
	return &file_tetragon_sensors_proto_enumTypes[2]
}

func (x ConfigFlag) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConfigFlag.Descriptor instead.
func (ConfigFlag) EnumDescriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{2}
}

type LogLevel int32

const (
	LogLevel_LOG_LEVEL_PANIC LogLevel = 0
	LogLevel_LOG_LEVEL_FATAL LogLevel = 1
	LogLevel_LOG_LEVEL_ERROR LogLevel = 2
	LogLevel_LOG_LEVEL_WARN  LogLevel = 3
	LogLevel_LOG_LEVEL_INFO  LogLevel = 4
	LogLevel_LOG_LEVEL_DEBUG LogLevel = 5
	LogLevel_LOG_LEVEL_TRACE LogLevel = 6
)

// Enum value maps for LogLevel.
var (
	LogLevel_name = map[int32]string{
		0: "LOG_LEVEL_PANIC",
		1: "LOG_LEVEL_FATAL",
		2: "LOG_LEVEL_ERROR",
		3: "LOG_LEVEL_WARN",
		4: "LOG_LEVEL_INFO",
		5: "LOG_LEVEL_DEBUG",
		6: "LOG_LEVEL_TRACE",
	}
	LogLevel_value = map[string]int32{
		"LOG_LEVEL_PANIC": 0,
		"LOG_LEVEL_FATAL": 1,
		"LOG_LEVEL_ERROR": 2,
		"LOG_LEVEL_WARN":  3,
		"LOG_LEVEL_INFO":  4,
		"LOG_LEVEL_DEBUG": 5,
		"LOG_LEVEL_TRACE": 6,
	}
)

func (x LogLevel) Enum() *LogLevel {
	p := new(LogLevel)
	*p = x
	return p
}

func (x LogLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LogLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_tetragon_sensors_proto_enumTypes[3].Descriptor()
}

func (LogLevel) Type() protoreflect.EnumType {
	return &file_tetragon_sensors_proto_enumTypes[3]
}

func (x LogLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LogLevel.Descriptor instead.
func (LogLevel) EnumDescriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{3}
}

type ListSensorsRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListSensorsRequest) Reset() {
	*x = ListSensorsRequest{}
	mi := &file_tetragon_sensors_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSensorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSensorsRequest) ProtoMessage() {}

func (x *ListSensorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSensorsRequest.ProtoReflect.Descriptor instead.
func (*ListSensorsRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{0}
}

type SensorStatus struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// name is the name of the sensor
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// enabled marks whether the sensor is enabled
	Enabled bool `protobuf:"varint,2,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// collection is the collection the sensor belongs to (typically a tracing policy)
	Collection    string `protobuf:"bytes,3,opt,name=collection,proto3" json:"collection,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SensorStatus) Reset() {
	*x = SensorStatus{}
	mi := &file_tetragon_sensors_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SensorStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SensorStatus) ProtoMessage() {}

func (x *SensorStatus) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SensorStatus.ProtoReflect.Descriptor instead.
func (*SensorStatus) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{1}
}

func (x *SensorStatus) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SensorStatus) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *SensorStatus) GetCollection() string {
	if x != nil {
		return x.Collection
	}
	return ""
}

type ListSensorsResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Sensors       []*SensorStatus        `protobuf:"bytes,1,rep,name=sensors,proto3" json:"sensors,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListSensorsResponse) Reset() {
	*x = ListSensorsResponse{}
	mi := &file_tetragon_sensors_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSensorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSensorsResponse) ProtoMessage() {}

func (x *ListSensorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSensorsResponse.ProtoReflect.Descriptor instead.
func (*ListSensorsResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{2}
}

func (x *ListSensorsResponse) GetSensors() []*SensorStatus {
	if x != nil {
		return x.Sensors
	}
	return nil
}

type ListTracingPoliciesRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListTracingPoliciesRequest) Reset() {
	*x = ListTracingPoliciesRequest{}
	mi := &file_tetragon_sensors_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTracingPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTracingPoliciesRequest) ProtoMessage() {}

func (x *ListTracingPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTracingPoliciesRequest.ProtoReflect.Descriptor instead.
func (*ListTracingPoliciesRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{3}
}

type TracingPolicyStatus struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// id is the id of the policy
	Id uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// name is the name of the policy
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// namespace is the namespace of the policy (or empty of the policy is global)
	Namespace string `protobuf:"bytes,3,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// info is additional information about the policy
	Info string `protobuf:"bytes,4,opt,name=info,proto3" json:"info,omitempty"`
	// sensors loaded in the scope of this policy
	Sensors []string `protobuf:"bytes,5,rep,name=sensors,proto3" json:"sensors,omitempty"`
	// indicating if the policy is enabled. Deprecated: use 'state' instead.
	//
	// Deprecated: Marked as deprecated in tetragon/sensors.proto.
	Enabled bool `protobuf:"varint,6,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// filter ID of the policy used for k8s filtering
	FilterId uint64 `protobuf:"varint,7,opt,name=filter_id,json=filterId,proto3" json:"filter_id,omitempty"`
	// potential error of the policy
	Error string `protobuf:"bytes,8,opt,name=error,proto3" json:"error,omitempty"`
	// current state of the tracing policy
	State TracingPolicyState `protobuf:"varint,9,opt,name=state,proto3,enum=tetragon.TracingPolicyState" json:"state,omitempty"`
	// the amount of kernel memory in bytes used by policy's sensors non-shared BPF maps (memlock)
	KernelMemoryBytes uint64 `protobuf:"varint,10,opt,name=kernel_memory_bytes,json=kernelMemoryBytes,proto3" json:"kernel_memory_bytes,omitempty"`
	// current mode of the tracing policy
	Mode          TracingPolicyMode `protobuf:"varint,11,opt,name=mode,proto3,enum=tetragon.TracingPolicyMode" json:"mode,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TracingPolicyStatus) Reset() {
	*x = TracingPolicyStatus{}
	mi := &file_tetragon_sensors_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TracingPolicyStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TracingPolicyStatus) ProtoMessage() {}

func (x *TracingPolicyStatus) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TracingPolicyStatus.ProtoReflect.Descriptor instead.
func (*TracingPolicyStatus) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{4}
}

func (x *TracingPolicyStatus) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *TracingPolicyStatus) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TracingPolicyStatus) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *TracingPolicyStatus) GetInfo() string {
	if x != nil {
		return x.Info
	}
	return ""
}

func (x *TracingPolicyStatus) GetSensors() []string {
	if x != nil {
		return x.Sensors
	}
	return nil
}

// Deprecated: Marked as deprecated in tetragon/sensors.proto.
func (x *TracingPolicyStatus) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *TracingPolicyStatus) GetFilterId() uint64 {
	if x != nil {
		return x.FilterId
	}
	return 0
}

func (x *TracingPolicyStatus) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

func (x *TracingPolicyStatus) GetState() TracingPolicyState {
	if x != nil {
		return x.State
	}
	return TracingPolicyState_TP_STATE_UNKNOWN
}

func (x *TracingPolicyStatus) GetKernelMemoryBytes() uint64 {
	if x != nil {
		return x.KernelMemoryBytes
	}
	return 0
}

func (x *TracingPolicyStatus) GetMode() TracingPolicyMode {
	if x != nil {
		return x.Mode
	}
	return TracingPolicyMode_TP_MODE_UNKNOWN
}

type ListTracingPoliciesResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Policies      []*TracingPolicyStatus `protobuf:"bytes,1,rep,name=policies,proto3" json:"policies,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListTracingPoliciesResponse) Reset() {
	*x = ListTracingPoliciesResponse{}
	mi := &file_tetragon_sensors_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTracingPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTracingPoliciesResponse) ProtoMessage() {}

func (x *ListTracingPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTracingPoliciesResponse.ProtoReflect.Descriptor instead.
func (*ListTracingPoliciesResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{5}
}

func (x *ListTracingPoliciesResponse) GetPolicies() []*TracingPolicyStatus {
	if x != nil {
		return x.Policies
	}
	return nil
}

type AddTracingPolicyRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Yaml          string                 `protobuf:"bytes,1,opt,name=yaml,proto3" json:"yaml,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AddTracingPolicyRequest) Reset() {
	*x = AddTracingPolicyRequest{}
	mi := &file_tetragon_sensors_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddTracingPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddTracingPolicyRequest) ProtoMessage() {}

func (x *AddTracingPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddTracingPolicyRequest.ProtoReflect.Descriptor instead.
func (*AddTracingPolicyRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{6}
}

func (x *AddTracingPolicyRequest) GetYaml() string {
	if x != nil {
		return x.Yaml
	}
	return ""
}

type AddTracingPolicyResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AddTracingPolicyResponse) Reset() {
	*x = AddTracingPolicyResponse{}
	mi := &file_tetragon_sensors_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddTracingPolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddTracingPolicyResponse) ProtoMessage() {}

func (x *AddTracingPolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddTracingPolicyResponse.ProtoReflect.Descriptor instead.
func (*AddTracingPolicyResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{7}
}

type DeleteTracingPolicyRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Namespace     string                 `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteTracingPolicyRequest) Reset() {
	*x = DeleteTracingPolicyRequest{}
	mi := &file_tetragon_sensors_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteTracingPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTracingPolicyRequest) ProtoMessage() {}

func (x *DeleteTracingPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTracingPolicyRequest.ProtoReflect.Descriptor instead.
func (*DeleteTracingPolicyRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteTracingPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteTracingPolicyRequest) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

type DeleteTracingPolicyResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteTracingPolicyResponse) Reset() {
	*x = DeleteTracingPolicyResponse{}
	mi := &file_tetragon_sensors_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteTracingPolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTracingPolicyResponse) ProtoMessage() {}

func (x *DeleteTracingPolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTracingPolicyResponse.ProtoReflect.Descriptor instead.
func (*DeleteTracingPolicyResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{9}
}

type EnableTracingPolicyRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Namespace     string                 `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EnableTracingPolicyRequest) Reset() {
	*x = EnableTracingPolicyRequest{}
	mi := &file_tetragon_sensors_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnableTracingPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnableTracingPolicyRequest) ProtoMessage() {}

func (x *EnableTracingPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnableTracingPolicyRequest.ProtoReflect.Descriptor instead.
func (*EnableTracingPolicyRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{10}
}

func (x *EnableTracingPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EnableTracingPolicyRequest) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

type EnableTracingPolicyResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EnableTracingPolicyResponse) Reset() {
	*x = EnableTracingPolicyResponse{}
	mi := &file_tetragon_sensors_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnableTracingPolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnableTracingPolicyResponse) ProtoMessage() {}

func (x *EnableTracingPolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnableTracingPolicyResponse.ProtoReflect.Descriptor instead.
func (*EnableTracingPolicyResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{11}
}

type DisableTracingPolicyRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Namespace     string                 `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DisableTracingPolicyRequest) Reset() {
	*x = DisableTracingPolicyRequest{}
	mi := &file_tetragon_sensors_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisableTracingPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableTracingPolicyRequest) ProtoMessage() {}

func (x *DisableTracingPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableTracingPolicyRequest.ProtoReflect.Descriptor instead.
func (*DisableTracingPolicyRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{12}
}

func (x *DisableTracingPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DisableTracingPolicyRequest) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

type DisableTracingPolicyResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DisableTracingPolicyResponse) Reset() {
	*x = DisableTracingPolicyResponse{}
	mi := &file_tetragon_sensors_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisableTracingPolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableTracingPolicyResponse) ProtoMessage() {}

func (x *DisableTracingPolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableTracingPolicyResponse.ProtoReflect.Descriptor instead.
func (*DisableTracingPolicyResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{13}
}

type ConfigureTracingPolicyRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Namespace     string                 `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Enable        *bool                  `protobuf:"varint,3,opt,name=enable,proto3,oneof" json:"enable,omitempty"`
	Mode          *TracingPolicyMode     `protobuf:"varint,4,opt,name=mode,proto3,enum=tetragon.TracingPolicyMode,oneof" json:"mode,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConfigureTracingPolicyRequest) Reset() {
	*x = ConfigureTracingPolicyRequest{}
	mi := &file_tetragon_sensors_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigureTracingPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigureTracingPolicyRequest) ProtoMessage() {}

func (x *ConfigureTracingPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigureTracingPolicyRequest.ProtoReflect.Descriptor instead.
func (*ConfigureTracingPolicyRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{14}
}

func (x *ConfigureTracingPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConfigureTracingPolicyRequest) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *ConfigureTracingPolicyRequest) GetEnable() bool {
	if x != nil && x.Enable != nil {
		return *x.Enable
	}
	return false
}

func (x *ConfigureTracingPolicyRequest) GetMode() TracingPolicyMode {
	if x != nil && x.Mode != nil {
		return *x.Mode
	}
	return TracingPolicyMode_TP_MODE_UNKNOWN
}

type ConfigureTracingPolicyResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConfigureTracingPolicyResponse) Reset() {
	*x = ConfigureTracingPolicyResponse{}
	mi := &file_tetragon_sensors_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigureTracingPolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigureTracingPolicyResponse) ProtoMessage() {}

func (x *ConfigureTracingPolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigureTracingPolicyResponse.ProtoReflect.Descriptor instead.
func (*ConfigureTracingPolicyResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{15}
}

type RemoveSensorRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RemoveSensorRequest) Reset() {
	*x = RemoveSensorRequest{}
	mi := &file_tetragon_sensors_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemoveSensorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveSensorRequest) ProtoMessage() {}

func (x *RemoveSensorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveSensorRequest.ProtoReflect.Descriptor instead.
func (*RemoveSensorRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{16}
}

func (x *RemoveSensorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type RemoveSensorResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RemoveSensorResponse) Reset() {
	*x = RemoveSensorResponse{}
	mi := &file_tetragon_sensors_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemoveSensorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveSensorResponse) ProtoMessage() {}

func (x *RemoveSensorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveSensorResponse.ProtoReflect.Descriptor instead.
func (*RemoveSensorResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{17}
}

type EnableSensorRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EnableSensorRequest) Reset() {
	*x = EnableSensorRequest{}
	mi := &file_tetragon_sensors_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnableSensorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnableSensorRequest) ProtoMessage() {}

func (x *EnableSensorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnableSensorRequest.ProtoReflect.Descriptor instead.
func (*EnableSensorRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{18}
}

func (x *EnableSensorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type EnableSensorResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EnableSensorResponse) Reset() {
	*x = EnableSensorResponse{}
	mi := &file_tetragon_sensors_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnableSensorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnableSensorResponse) ProtoMessage() {}

func (x *EnableSensorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnableSensorResponse.ProtoReflect.Descriptor instead.
func (*EnableSensorResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{19}
}

type DisableSensorRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DisableSensorRequest) Reset() {
	*x = DisableSensorRequest{}
	mi := &file_tetragon_sensors_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisableSensorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableSensorRequest) ProtoMessage() {}

func (x *DisableSensorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableSensorRequest.ProtoReflect.Descriptor instead.
func (*DisableSensorRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{20}
}

func (x *DisableSensorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type DisableSensorResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DisableSensorResponse) Reset() {
	*x = DisableSensorResponse{}
	mi := &file_tetragon_sensors_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisableSensorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableSensorResponse) ProtoMessage() {}

func (x *DisableSensorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableSensorResponse.ProtoReflect.Descriptor instead.
func (*DisableSensorResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{21}
}

type GetStackTraceTreeRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetStackTraceTreeRequest) Reset() {
	*x = GetStackTraceTreeRequest{}
	mi := &file_tetragon_sensors_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetStackTraceTreeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStackTraceTreeRequest) ProtoMessage() {}

func (x *GetStackTraceTreeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStackTraceTreeRequest.ProtoReflect.Descriptor instead.
func (*GetStackTraceTreeRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{22}
}

func (x *GetStackTraceTreeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type GetStackTraceTreeResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Root          *StackTraceNode        `protobuf:"bytes,1,opt,name=root,proto3" json:"root,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetStackTraceTreeResponse) Reset() {
	*x = GetStackTraceTreeResponse{}
	mi := &file_tetragon_sensors_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetStackTraceTreeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStackTraceTreeResponse) ProtoMessage() {}

func (x *GetStackTraceTreeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStackTraceTreeResponse.ProtoReflect.Descriptor instead.
func (*GetStackTraceTreeResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{23}
}

func (x *GetStackTraceTreeResponse) GetRoot() *StackTraceNode {
	if x != nil {
		return x.Root
	}
	return nil
}

type GetVersionRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetVersionRequest) Reset() {
	*x = GetVersionRequest{}
	mi := &file_tetragon_sensors_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVersionRequest) ProtoMessage() {}

func (x *GetVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVersionRequest.ProtoReflect.Descriptor instead.
func (*GetVersionRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{24}
}

type GetVersionResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Version       string                 `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetVersionResponse) Reset() {
	*x = GetVersionResponse{}
	mi := &file_tetragon_sensors_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVersionResponse) ProtoMessage() {}

func (x *GetVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVersionResponse.ProtoReflect.Descriptor instead.
func (*GetVersionResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{25}
}

func (x *GetVersionResponse) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type DumpProcessCacheReqArgs struct {
	state                     protoimpl.MessageState `protogen:"open.v1"`
	SkipZeroRefcnt            bool                   `protobuf:"varint,1,opt,name=skip_zero_refcnt,json=skipZeroRefcnt,proto3" json:"skip_zero_refcnt,omitempty"`
	ExcludeExecveMapProcesses bool                   `protobuf:"varint,2,opt,name=exclude_execve_map_processes,json=excludeExecveMapProcesses,proto3" json:"exclude_execve_map_processes,omitempty"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *DumpProcessCacheReqArgs) Reset() {
	*x = DumpProcessCacheReqArgs{}
	mi := &file_tetragon_sensors_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DumpProcessCacheReqArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DumpProcessCacheReqArgs) ProtoMessage() {}

func (x *DumpProcessCacheReqArgs) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DumpProcessCacheReqArgs.ProtoReflect.Descriptor instead.
func (*DumpProcessCacheReqArgs) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{26}
}

func (x *DumpProcessCacheReqArgs) GetSkipZeroRefcnt() bool {
	if x != nil {
		return x.SkipZeroRefcnt
	}
	return false
}

func (x *DumpProcessCacheReqArgs) GetExcludeExecveMapProcesses() bool {
	if x != nil {
		return x.ExcludeExecveMapProcesses
	}
	return false
}

type ProcessInternal struct {
	state   protoimpl.MessageState  `protogen:"open.v1"`
	Process *Process                `protobuf:"bytes,1,opt,name=process,proto3" json:"process,omitempty"`
	Color   string                  `protobuf:"bytes,2,opt,name=color,proto3" json:"color,omitempty"`
	Refcnt  *wrapperspb.UInt32Value `protobuf:"bytes,3,opt,name=refcnt,proto3" json:"refcnt,omitempty"`
	// refcnt_ops is a map of operations to refcnt change
	// keys can be:
	// - "process++": process increased refcnt (i.e. this process starts)
	// - "process--": process decreased refcnt (i.e. this process exits)
	// - "parent++": parent increased refcnt (i.e. a process starts that has this process as a parent)
	// - "parent--": parent decreased refcnt (i.e. a process exits that has this process as a parent)
	// - "ancestor++": ancestor increased refcnt (i.e. a process starts that has this process as an ancestor)
	// - "ancestor--": ancestor decreased refcnt (i.e. a process exits that has this process as an ancestor)
	RefcntOps     map[string]int32 `protobuf:"bytes,4,rep,name=refcnt_ops,json=refcntOps,proto3" json:"refcnt_ops,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProcessInternal) Reset() {
	*x = ProcessInternal{}
	mi := &file_tetragon_sensors_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProcessInternal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessInternal) ProtoMessage() {}

func (x *ProcessInternal) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessInternal.ProtoReflect.Descriptor instead.
func (*ProcessInternal) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{27}
}

func (x *ProcessInternal) GetProcess() *Process {
	if x != nil {
		return x.Process
	}
	return nil
}

func (x *ProcessInternal) GetColor() string {
	if x != nil {
		return x.Color
	}
	return ""
}

func (x *ProcessInternal) GetRefcnt() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Refcnt
	}
	return nil
}

func (x *ProcessInternal) GetRefcntOps() map[string]int32 {
	if x != nil {
		return x.RefcntOps
	}
	return nil
}

type DumpProcessCacheResArgs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Processes     []*ProcessInternal     `protobuf:"bytes,1,rep,name=processes,proto3" json:"processes,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DumpProcessCacheResArgs) Reset() {
	*x = DumpProcessCacheResArgs{}
	mi := &file_tetragon_sensors_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DumpProcessCacheResArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DumpProcessCacheResArgs) ProtoMessage() {}

func (x *DumpProcessCacheResArgs) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DumpProcessCacheResArgs.ProtoReflect.Descriptor instead.
func (*DumpProcessCacheResArgs) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{28}
}

func (x *DumpProcessCacheResArgs) GetProcesses() []*ProcessInternal {
	if x != nil {
		return x.Processes
	}
	return nil
}

type GetDebugRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Flag  ConfigFlag             `protobuf:"varint,1,opt,name=flag,proto3,enum=tetragon.ConfigFlag" json:"flag,omitempty"`
	// Types that are valid to be assigned to Arg:
	//
	//	*GetDebugRequest_Dump
	Arg           isGetDebugRequest_Arg `protobuf_oneof:"arg"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetDebugRequest) Reset() {
	*x = GetDebugRequest{}
	mi := &file_tetragon_sensors_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDebugRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDebugRequest) ProtoMessage() {}

func (x *GetDebugRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDebugRequest.ProtoReflect.Descriptor instead.
func (*GetDebugRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{29}
}

func (x *GetDebugRequest) GetFlag() ConfigFlag {
	if x != nil {
		return x.Flag
	}
	return ConfigFlag_CONFIG_FLAG_LOG_LEVEL
}

func (x *GetDebugRequest) GetArg() isGetDebugRequest_Arg {
	if x != nil {
		return x.Arg
	}
	return nil
}

func (x *GetDebugRequest) GetDump() *DumpProcessCacheReqArgs {
	if x != nil {
		if x, ok := x.Arg.(*GetDebugRequest_Dump); ok {
			return x.Dump
		}
	}
	return nil
}

type isGetDebugRequest_Arg interface {
	isGetDebugRequest_Arg()
}

type GetDebugRequest_Dump struct {
	Dump *DumpProcessCacheReqArgs `protobuf:"bytes,2,opt,name=dump,proto3,oneof"`
}

func (*GetDebugRequest_Dump) isGetDebugRequest_Arg() {}

type GetDebugResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Flag  ConfigFlag             `protobuf:"varint,1,opt,name=flag,proto3,enum=tetragon.ConfigFlag" json:"flag,omitempty"`
	// Types that are valid to be assigned to Arg:
	//
	//	*GetDebugResponse_Level
	//	*GetDebugResponse_Processes
	Arg           isGetDebugResponse_Arg `protobuf_oneof:"arg"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetDebugResponse) Reset() {
	*x = GetDebugResponse{}
	mi := &file_tetragon_sensors_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDebugResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDebugResponse) ProtoMessage() {}

func (x *GetDebugResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDebugResponse.ProtoReflect.Descriptor instead.
func (*GetDebugResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{30}
}

func (x *GetDebugResponse) GetFlag() ConfigFlag {
	if x != nil {
		return x.Flag
	}
	return ConfigFlag_CONFIG_FLAG_LOG_LEVEL
}

func (x *GetDebugResponse) GetArg() isGetDebugResponse_Arg {
	if x != nil {
		return x.Arg
	}
	return nil
}

func (x *GetDebugResponse) GetLevel() LogLevel {
	if x != nil {
		if x, ok := x.Arg.(*GetDebugResponse_Level); ok {
			return x.Level
		}
	}
	return LogLevel_LOG_LEVEL_PANIC
}

func (x *GetDebugResponse) GetProcesses() *DumpProcessCacheResArgs {
	if x != nil {
		if x, ok := x.Arg.(*GetDebugResponse_Processes); ok {
			return x.Processes
		}
	}
	return nil
}

type isGetDebugResponse_Arg interface {
	isGetDebugResponse_Arg()
}

type GetDebugResponse_Level struct {
	Level LogLevel `protobuf:"varint,2,opt,name=level,proto3,enum=tetragon.LogLevel,oneof"`
}

type GetDebugResponse_Processes struct {
	Processes *DumpProcessCacheResArgs `protobuf:"bytes,3,opt,name=processes,proto3,oneof"`
}

func (*GetDebugResponse_Level) isGetDebugResponse_Arg() {}

func (*GetDebugResponse_Processes) isGetDebugResponse_Arg() {}

type SetDebugRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Flag  ConfigFlag             `protobuf:"varint,1,opt,name=flag,proto3,enum=tetragon.ConfigFlag" json:"flag,omitempty"`
	// Types that are valid to be assigned to Arg:
	//
	//	*SetDebugRequest_Level
	Arg           isSetDebugRequest_Arg `protobuf_oneof:"arg"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetDebugRequest) Reset() {
	*x = SetDebugRequest{}
	mi := &file_tetragon_sensors_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetDebugRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetDebugRequest) ProtoMessage() {}

func (x *SetDebugRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetDebugRequest.ProtoReflect.Descriptor instead.
func (*SetDebugRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{31}
}

func (x *SetDebugRequest) GetFlag() ConfigFlag {
	if x != nil {
		return x.Flag
	}
	return ConfigFlag_CONFIG_FLAG_LOG_LEVEL
}

func (x *SetDebugRequest) GetArg() isSetDebugRequest_Arg {
	if x != nil {
		return x.Arg
	}
	return nil
}

func (x *SetDebugRequest) GetLevel() LogLevel {
	if x != nil {
		if x, ok := x.Arg.(*SetDebugRequest_Level); ok {
			return x.Level
		}
	}
	return LogLevel_LOG_LEVEL_PANIC
}

type isSetDebugRequest_Arg interface {
	isSetDebugRequest_Arg()
}

type SetDebugRequest_Level struct {
	Level LogLevel `protobuf:"varint,2,opt,name=level,proto3,enum=tetragon.LogLevel,oneof"`
}

func (*SetDebugRequest_Level) isSetDebugRequest_Arg() {}

type SetDebugResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Flag  ConfigFlag             `protobuf:"varint,1,opt,name=flag,proto3,enum=tetragon.ConfigFlag" json:"flag,omitempty"`
	// Types that are valid to be assigned to Arg:
	//
	//	*SetDebugResponse_Level
	Arg           isSetDebugResponse_Arg `protobuf_oneof:"arg"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetDebugResponse) Reset() {
	*x = SetDebugResponse{}
	mi := &file_tetragon_sensors_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetDebugResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetDebugResponse) ProtoMessage() {}

func (x *SetDebugResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_sensors_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetDebugResponse.ProtoReflect.Descriptor instead.
func (*SetDebugResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_sensors_proto_rawDescGZIP(), []int{32}
}

func (x *SetDebugResponse) GetFlag() ConfigFlag {
	if x != nil {
		return x.Flag
	}
	return ConfigFlag_CONFIG_FLAG_LOG_LEVEL
}

func (x *SetDebugResponse) GetArg() isSetDebugResponse_Arg {
	if x != nil {
		return x.Arg
	}
	return nil
}

func (x *SetDebugResponse) GetLevel() LogLevel {
	if x != nil {
		if x, ok := x.Arg.(*SetDebugResponse_Level); ok {
			return x.Level
		}
	}
	return LogLevel_LOG_LEVEL_PANIC
}

type isSetDebugResponse_Arg interface {
	isSetDebugResponse_Arg()
}

type SetDebugResponse_Level struct {
	Level LogLevel `protobuf:"varint,2,opt,name=level,proto3,enum=tetragon.LogLevel,oneof"`
}

func (*SetDebugResponse_Level) isSetDebugResponse_Arg() {}

var File_tetragon_sensors_proto protoreflect.FileDescriptor

var file_tetragon_sensors_proto_rawDesc = []byte{
	0x0a, 0x16, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2f, 0x73, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x08, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67,
	0x6f, 0x6e, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x15, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x14, 0x74, 0x65, 0x74, 0x72, 0x61,
	0x67, 0x6f, 0x6e, 0x2f, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2f, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x14, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x5c,
	0x0a, 0x0c, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x1e, 0x0a, 0x0a,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x47, 0x0a, 0x13,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x07, 0x73, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e,
	0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x07, 0x73, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x73, 0x22, 0x1c, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61,
	0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x22, 0xeb, 0x02, 0x0a, 0x13, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x69, 0x6e, 0x66,
	0x6f, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x07, 0x73, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x73, 0x12, 0x1c, 0x0a, 0x07, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x32, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x74, 0x65,
	0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x2e, 0x0a, 0x13, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x5f, 0x6d, 0x65, 0x6d, 0x6f, 0x72,
	0x79, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x04, 0x52, 0x11, 0x6b,
	0x65, 0x72, 0x6e, 0x65, 0x6c, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x12, 0x2f, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b,
	0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64,
	0x65, 0x22, 0x58, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x39, 0x0a, 0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x54, 0x72,
	0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x22, 0x2d, 0x0a, 0x17, 0x41,
	0x64, 0x64, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x79, 0x61, 0x6d, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x79, 0x61, 0x6d, 0x6c, 0x22, 0x1a, 0x0a, 0x18, 0x41, 0x64,
	0x64, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4e, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x22, 0x1d, 0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4e, 0x0a, 0x1a, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x54,
	0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x22, 0x1d, 0x0a, 0x1b, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x54,
	0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4f, 0x0a, 0x1b, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x54,
	0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x22, 0x1e, 0x0a, 0x1c, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb8, 0x01, 0x0a, 0x1d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x65, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x06, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x34, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e,
	0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4d, 0x6f, 0x64,
	0x65, 0x48, 0x01, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x42, 0x09, 0x0a, 0x07,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x22, 0x20, 0x0a, 0x1e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x54, 0x72, 0x61,
	0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x29, 0x0a, 0x13, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x53, 0x65, 0x6e, 0x73,
	0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x16, 0x0a,
	0x14, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x29, 0x0a, 0x13, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53,
	0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x16, 0x0a, 0x14, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2a, 0x0a, 0x14, 0x44, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x17, 0x0a, 0x15, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53,
	0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2e, 0x0a,
	0x18, 0x47, 0x65, 0x74, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x54, 0x72,
	0x65, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x49, 0x0a,
	0x19, 0x47, 0x65, 0x74, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x54, 0x72,
	0x65, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x04, 0x72, 0x6f,
	0x6f, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61,
	0x67, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x4e, 0x6f,
	0x64, 0x65, 0x52, 0x04, 0x72, 0x6f, 0x6f, 0x74, 0x22, 0x13, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x2e, 0x0a,
	0x12, 0x47, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x84, 0x01,
	0x0a, 0x17, 0x44, 0x75, 0x6d, 0x70, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x43, 0x61, 0x63,
	0x68, 0x65, 0x52, 0x65, 0x71, 0x41, 0x72, 0x67, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x73, 0x6b, 0x69,
	0x70, 0x5f, 0x7a, 0x65, 0x72, 0x6f, 0x5f, 0x72, 0x65, 0x66, 0x63, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0e, 0x73, 0x6b, 0x69, 0x70, 0x5a, 0x65, 0x72, 0x6f, 0x52, 0x65, 0x66,
	0x63, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x1c, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x65,
	0x78, 0x65, 0x63, 0x76, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x45, 0x78, 0x65, 0x63, 0x76, 0x65, 0x4d, 0x61, 0x70, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x65, 0x73, 0x22, 0x91, 0x02, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x12, 0x2b, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x65, 0x74, 0x72,
	0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x07, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x34, 0x0a, 0x06, 0x72,
	0x65, 0x66, 0x63, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49,
	0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x72, 0x65, 0x66, 0x63, 0x6e,
	0x74, 0x12, 0x47, 0x0a, 0x0a, 0x72, 0x65, 0x66, 0x63, 0x6e, 0x74, 0x5f, 0x6f, 0x70, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e,
	0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x2e, 0x52, 0x65, 0x66, 0x63, 0x6e, 0x74, 0x4f, 0x70, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x09, 0x72, 0x65, 0x66, 0x63, 0x6e, 0x74, 0x4f, 0x70, 0x73, 0x1a, 0x3c, 0x0a, 0x0e, 0x52, 0x65,
	0x66, 0x63, 0x6e, 0x74, 0x4f, 0x70, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x52, 0x0a, 0x17, 0x44, 0x75, 0x6d, 0x70,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x43, 0x61, 0x63, 0x68, 0x65, 0x52, 0x65, 0x73, 0x41,
	0x72, 0x67, 0x73, 0x12, 0x37, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f,
	0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x22, 0x7b, 0x0a, 0x0f,
	0x47, 0x65, 0x74, 0x44, 0x65, 0x62, 0x75, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x28, 0x0a, 0x04, 0x66, 0x6c, 0x61, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x14, 0x2e,
	0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x46,
	0x6c, 0x61, 0x67, 0x52, 0x04, 0x66, 0x6c, 0x61, 0x67, 0x12, 0x37, 0x0a, 0x04, 0x64, 0x75, 0x6d,
	0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67,
	0x6f, 0x6e, 0x2e, 0x44, 0x75, 0x6d, 0x70, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x43, 0x61,
	0x63, 0x68, 0x65, 0x52, 0x65, 0x71, 0x41, 0x72, 0x67, 0x73, 0x48, 0x00, 0x52, 0x04, 0x64, 0x75,
	0x6d, 0x70, 0x42, 0x05, 0x0a, 0x03, 0x61, 0x72, 0x67, 0x22, 0xb2, 0x01, 0x0a, 0x10, 0x47, 0x65,
	0x74, 0x44, 0x65, 0x62, 0x75, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x28,
	0x0a, 0x04, 0x66, 0x6c, 0x61, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x14, 0x2e, 0x74,
	0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x46, 0x6c,
	0x61, 0x67, 0x52, 0x04, 0x66, 0x6c, 0x61, 0x67, 0x12, 0x2a, 0x0a, 0x05, 0x6c, 0x65, 0x76, 0x65,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67,
	0x6f, 0x6e, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x05, 0x6c,
	0x65, 0x76, 0x65, 0x6c, 0x12, 0x41, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67,
	0x6f, 0x6e, 0x2e, 0x44, 0x75, 0x6d, 0x70, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x43, 0x61,
	0x63, 0x68, 0x65, 0x52, 0x65, 0x73, 0x41, 0x72, 0x67, 0x73, 0x48, 0x00, 0x52, 0x09, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x42, 0x05, 0x0a, 0x03, 0x61, 0x72, 0x67, 0x22, 0x6e,
	0x0a, 0x0f, 0x53, 0x65, 0x74, 0x44, 0x65, 0x62, 0x75, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x28, 0x0a, 0x04, 0x66, 0x6c, 0x61, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x14, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x46, 0x6c, 0x61, 0x67, 0x52, 0x04, 0x66, 0x6c, 0x61, 0x67, 0x12, 0x2a, 0x0a, 0x05, 0x6c,
	0x65, 0x76, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x74, 0x65, 0x74,
	0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x48, 0x00,
	0x52, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x42, 0x05, 0x0a, 0x03, 0x61, 0x72, 0x67, 0x22, 0x6f,
	0x0a, 0x10, 0x53, 0x65, 0x74, 0x44, 0x65, 0x62, 0x75, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x28, 0x0a, 0x04, 0x66, 0x6c, 0x61, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x14, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x46, 0x6c, 0x61, 0x67, 0x52, 0x04, 0x66, 0x6c, 0x61, 0x67, 0x12, 0x2a, 0x0a, 0x05,
	0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x74, 0x65,
	0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x48,
	0x00, 0x52, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x42, 0x05, 0x0a, 0x03, 0x61, 0x72, 0x67, 0x2a,
	0xb2, 0x01, 0x0a, 0x12, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x50, 0x5f, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10,
	0x54, 0x50, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x54, 0x50, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x44,
	0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x54, 0x50, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x54, 0x50, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x50, 0x5f, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x4c, 0x4f, 0x41, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x16, 0x0a, 0x12,
	0x54, 0x50, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x4c, 0x4f, 0x41, 0x44, 0x49,
	0x4e, 0x47, 0x10, 0x06, 0x2a, 0x52, 0x0a, 0x11, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x50, 0x5f,
	0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x13,
	0x0a, 0x0f, 0x54, 0x50, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x45, 0x4e, 0x46, 0x4f, 0x52, 0x43,
	0x45, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x50, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x4d,
	0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x10, 0x02, 0x2a, 0x4b, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x46, 0x6c, 0x61, 0x67, 0x12, 0x19, 0x0a, 0x15, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47,
	0x5f, 0x46, 0x4c, 0x41, 0x47, 0x5f, 0x4c, 0x4f, 0x47, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x10,
	0x00, 0x12, 0x22, 0x0a, 0x1e, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x46, 0x4c, 0x41, 0x47,
	0x5f, 0x44, 0x55, 0x4d, 0x50, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x43, 0x41,
	0x43, 0x48, 0x45, 0x10, 0x01, 0x2a, 0x9b, 0x01, 0x0a, 0x08, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x12, 0x13, 0x0a, 0x0f, 0x4c, 0x4f, 0x47, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f,
	0x50, 0x41, 0x4e, 0x49, 0x43, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x4c, 0x4f, 0x47, 0x5f, 0x4c,
	0x45, 0x56, 0x45, 0x4c, 0x5f, 0x46, 0x41, 0x54, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f,
	0x4c, 0x4f, 0x47, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10,
	0x02, 0x12, 0x12, 0x0a, 0x0e, 0x4c, 0x4f, 0x47, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x57,
	0x41, 0x52, 0x4e, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x4c, 0x4f, 0x47, 0x5f, 0x4c, 0x45, 0x56,
	0x45, 0x4c, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x04, 0x12, 0x13, 0x0a, 0x0f, 0x4c, 0x4f, 0x47,
	0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x44, 0x45, 0x42, 0x55, 0x47, 0x10, 0x05, 0x12, 0x13,
	0x0a, 0x0f, 0x4c, 0x4f, 0x47, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x54, 0x52, 0x41, 0x43,
	0x45, 0x10, 0x06, 0x32, 0xf3, 0x0b, 0x0a, 0x13, 0x46, 0x69, 0x6e, 0x65, 0x47, 0x75, 0x69, 0x64,
	0x61, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x73, 0x12, 0x48, 0x0a, 0x09, 0x47,
	0x65, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x1a, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61,
	0x67, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e,
	0x47, 0x65, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x00, 0x30, 0x01, 0x12, 0x52, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x12, 0x20, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x47, 0x65,
	0x74, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e,
	0x47, 0x65, 0x74, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x5b, 0x0a, 0x10, 0x41, 0x64, 0x64,
	0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x21, 0x2e,
	0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x41, 0x64, 0x64, 0x54, 0x72, 0x61, 0x63,
	0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x22, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x41, 0x64, 0x64, 0x54,
	0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x64, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x24, 0x2e,
	0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54,
	0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x64, 0x0a, 0x13,
	0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x12, 0x24, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x74, 0x65, 0x74, 0x72,
	0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x00, 0x12, 0x6d, 0x0a, 0x16, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x54,
	0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x27, 0x2e, 0x74,
	0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x65, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e,
	0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x00, 0x12, 0x67, 0x0a, 0x13, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x72, 0x61, 0x63, 0x69,
	0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x24, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61,
	0x67, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25,
	0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x88, 0x02, 0x01, 0x12, 0x6a, 0x0a, 0x14, 0x44, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x25, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x44, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x74, 0x65, 0x74, 0x72,
	0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x72, 0x61, 0x63,
	0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x03, 0x88, 0x02, 0x01, 0x12, 0x4f, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x73, 0x12, 0x1c, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x03, 0x88, 0x02, 0x01, 0x12, 0x52, 0x0a, 0x0c, 0x45, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x12, 0x1d, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67,
	0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f,
	0x6e, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x88, 0x02, 0x01, 0x12, 0x55, 0x0a, 0x0d, 0x44,
	0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x12, 0x1e, 0x2e, 0x74,
	0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53,
	0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x74,
	0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53,
	0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x88,
	0x02, 0x01, 0x12, 0x52, 0x0a, 0x0c, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x53, 0x65, 0x6e, 0x73,
	0x6f, 0x72, 0x12, 0x1d, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x52, 0x65,
	0x6d, 0x6f, 0x76, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1e, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x03, 0x88, 0x02, 0x01, 0x12, 0x5e, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x53, 0x74, 0x61,
	0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x54, 0x72, 0x65, 0x65, 0x12, 0x22, 0x2e, 0x74, 0x65,
	0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54,
	0x72, 0x61, 0x63, 0x65, 0x54, 0x72, 0x65, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x23, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x74,
	0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x54, 0x72, 0x65, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x49, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e,
	0x47, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1c, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x00, 0x12, 0x4c, 0x0a, 0x0b, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x48, 0x6f, 0x6f, 0x6b,
	0x12, 0x1c, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x48, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x48, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12,
	0x43, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x44, 0x65, 0x62, 0x75, 0x67, 0x12, 0x19, 0x2e, 0x74, 0x65,
	0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x62, 0x75, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f,
	0x6e, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x62, 0x75, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x12, 0x43, 0x0a, 0x08, 0x53, 0x65, 0x74, 0x44, 0x65, 0x62, 0x75, 0x67,
	0x12, 0x19, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x74, 0x44,
	0x65, 0x62, 0x75, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x74, 0x65,
	0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x74, 0x44, 0x65, 0x62, 0x75, 0x67, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x42, 0x2c, 0x5a, 0x2a, 0x67, 0x69, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x63, 0x69, 0x6c, 0x69, 0x75, 0x6d, 0x2f, 0x74,
	0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x74,
	0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_tetragon_sensors_proto_rawDescOnce sync.Once
	file_tetragon_sensors_proto_rawDescData = file_tetragon_sensors_proto_rawDesc
)

func file_tetragon_sensors_proto_rawDescGZIP() []byte {
	file_tetragon_sensors_proto_rawDescOnce.Do(func() {
		file_tetragon_sensors_proto_rawDescData = protoimpl.X.CompressGZIP(file_tetragon_sensors_proto_rawDescData)
	})
	return file_tetragon_sensors_proto_rawDescData
}

var file_tetragon_sensors_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_tetragon_sensors_proto_msgTypes = make([]protoimpl.MessageInfo, 34)
var file_tetragon_sensors_proto_goTypes = []any{
	(TracingPolicyState)(0),                // 0: tetragon.TracingPolicyState
	(TracingPolicyMode)(0),                 // 1: tetragon.TracingPolicyMode
	(ConfigFlag)(0),                        // 2: tetragon.ConfigFlag
	(LogLevel)(0),                          // 3: tetragon.LogLevel
	(*ListSensorsRequest)(nil),             // 4: tetragon.ListSensorsRequest
	(*SensorStatus)(nil),                   // 5: tetragon.SensorStatus
	(*ListSensorsResponse)(nil),            // 6: tetragon.ListSensorsResponse
	(*ListTracingPoliciesRequest)(nil),     // 7: tetragon.ListTracingPoliciesRequest
	(*TracingPolicyStatus)(nil),            // 8: tetragon.TracingPolicyStatus
	(*ListTracingPoliciesResponse)(nil),    // 9: tetragon.ListTracingPoliciesResponse
	(*AddTracingPolicyRequest)(nil),        // 10: tetragon.AddTracingPolicyRequest
	(*AddTracingPolicyResponse)(nil),       // 11: tetragon.AddTracingPolicyResponse
	(*DeleteTracingPolicyRequest)(nil),     // 12: tetragon.DeleteTracingPolicyRequest
	(*DeleteTracingPolicyResponse)(nil),    // 13: tetragon.DeleteTracingPolicyResponse
	(*EnableTracingPolicyRequest)(nil),     // 14: tetragon.EnableTracingPolicyRequest
	(*EnableTracingPolicyResponse)(nil),    // 15: tetragon.EnableTracingPolicyResponse
	(*DisableTracingPolicyRequest)(nil),    // 16: tetragon.DisableTracingPolicyRequest
	(*DisableTracingPolicyResponse)(nil),   // 17: tetragon.DisableTracingPolicyResponse
	(*ConfigureTracingPolicyRequest)(nil),  // 18: tetragon.ConfigureTracingPolicyRequest
	(*ConfigureTracingPolicyResponse)(nil), // 19: tetragon.ConfigureTracingPolicyResponse
	(*RemoveSensorRequest)(nil),            // 20: tetragon.RemoveSensorRequest
	(*RemoveSensorResponse)(nil),           // 21: tetragon.RemoveSensorResponse
	(*EnableSensorRequest)(nil),            // 22: tetragon.EnableSensorRequest
	(*EnableSensorResponse)(nil),           // 23: tetragon.EnableSensorResponse
	(*DisableSensorRequest)(nil),           // 24: tetragon.DisableSensorRequest
	(*DisableSensorResponse)(nil),          // 25: tetragon.DisableSensorResponse
	(*GetStackTraceTreeRequest)(nil),       // 26: tetragon.GetStackTraceTreeRequest
	(*GetStackTraceTreeResponse)(nil),      // 27: tetragon.GetStackTraceTreeResponse
	(*GetVersionRequest)(nil),              // 28: tetragon.GetVersionRequest
	(*GetVersionResponse)(nil),             // 29: tetragon.GetVersionResponse
	(*DumpProcessCacheReqArgs)(nil),        // 30: tetragon.DumpProcessCacheReqArgs
	(*ProcessInternal)(nil),                // 31: tetragon.ProcessInternal
	(*DumpProcessCacheResArgs)(nil),        // 32: tetragon.DumpProcessCacheResArgs
	(*GetDebugRequest)(nil),                // 33: tetragon.GetDebugRequest
	(*GetDebugResponse)(nil),               // 34: tetragon.GetDebugResponse
	(*SetDebugRequest)(nil),                // 35: tetragon.SetDebugRequest
	(*SetDebugResponse)(nil),               // 36: tetragon.SetDebugResponse
	nil,                                    // 37: tetragon.ProcessInternal.RefcntOpsEntry
	(*StackTraceNode)(nil),                 // 38: tetragon.StackTraceNode
	(*Process)(nil),                        // 39: tetragon.Process
	(*wrapperspb.UInt32Value)(nil),         // 40: google.protobuf.UInt32Value
	(*GetEventsRequest)(nil),               // 41: tetragon.GetEventsRequest
	(*GetHealthStatusRequest)(nil),         // 42: tetragon.GetHealthStatusRequest
	(*RuntimeHookRequest)(nil),             // 43: tetragon.RuntimeHookRequest
	(*GetEventsResponse)(nil),              // 44: tetragon.GetEventsResponse
	(*GetHealthStatusResponse)(nil),        // 45: tetragon.GetHealthStatusResponse
	(*RuntimeHookResponse)(nil),            // 46: tetragon.RuntimeHookResponse
}
var file_tetragon_sensors_proto_depIdxs = []int32{
	5,  // 0: tetragon.ListSensorsResponse.sensors:type_name -> tetragon.SensorStatus
	0,  // 1: tetragon.TracingPolicyStatus.state:type_name -> tetragon.TracingPolicyState
	1,  // 2: tetragon.TracingPolicyStatus.mode:type_name -> tetragon.TracingPolicyMode
	8,  // 3: tetragon.ListTracingPoliciesResponse.policies:type_name -> tetragon.TracingPolicyStatus
	1,  // 4: tetragon.ConfigureTracingPolicyRequest.mode:type_name -> tetragon.TracingPolicyMode
	38, // 5: tetragon.GetStackTraceTreeResponse.root:type_name -> tetragon.StackTraceNode
	39, // 6: tetragon.ProcessInternal.process:type_name -> tetragon.Process
	40, // 7: tetragon.ProcessInternal.refcnt:type_name -> google.protobuf.UInt32Value
	37, // 8: tetragon.ProcessInternal.refcnt_ops:type_name -> tetragon.ProcessInternal.RefcntOpsEntry
	31, // 9: tetragon.DumpProcessCacheResArgs.processes:type_name -> tetragon.ProcessInternal
	2,  // 10: tetragon.GetDebugRequest.flag:type_name -> tetragon.ConfigFlag
	30, // 11: tetragon.GetDebugRequest.dump:type_name -> tetragon.DumpProcessCacheReqArgs
	2,  // 12: tetragon.GetDebugResponse.flag:type_name -> tetragon.ConfigFlag
	3,  // 13: tetragon.GetDebugResponse.level:type_name -> tetragon.LogLevel
	32, // 14: tetragon.GetDebugResponse.processes:type_name -> tetragon.DumpProcessCacheResArgs
	2,  // 15: tetragon.SetDebugRequest.flag:type_name -> tetragon.ConfigFlag
	3,  // 16: tetragon.SetDebugRequest.level:type_name -> tetragon.LogLevel
	2,  // 17: tetragon.SetDebugResponse.flag:type_name -> tetragon.ConfigFlag
	3,  // 18: tetragon.SetDebugResponse.level:type_name -> tetragon.LogLevel
	41, // 19: tetragon.FineGuidanceSensors.GetEvents:input_type -> tetragon.GetEventsRequest
	42, // 20: tetragon.FineGuidanceSensors.GetHealth:input_type -> tetragon.GetHealthStatusRequest
	10, // 21: tetragon.FineGuidanceSensors.AddTracingPolicy:input_type -> tetragon.AddTracingPolicyRequest
	12, // 22: tetragon.FineGuidanceSensors.DeleteTracingPolicy:input_type -> tetragon.DeleteTracingPolicyRequest
	7,  // 23: tetragon.FineGuidanceSensors.ListTracingPolicies:input_type -> tetragon.ListTracingPoliciesRequest
	18, // 24: tetragon.FineGuidanceSensors.ConfigureTracingPolicy:input_type -> tetragon.ConfigureTracingPolicyRequest
	14, // 25: tetragon.FineGuidanceSensors.EnableTracingPolicy:input_type -> tetragon.EnableTracingPolicyRequest
	16, // 26: tetragon.FineGuidanceSensors.DisableTracingPolicy:input_type -> tetragon.DisableTracingPolicyRequest
	4,  // 27: tetragon.FineGuidanceSensors.ListSensors:input_type -> tetragon.ListSensorsRequest
	22, // 28: tetragon.FineGuidanceSensors.EnableSensor:input_type -> tetragon.EnableSensorRequest
	24, // 29: tetragon.FineGuidanceSensors.DisableSensor:input_type -> tetragon.DisableSensorRequest
	20, // 30: tetragon.FineGuidanceSensors.RemoveSensor:input_type -> tetragon.RemoveSensorRequest
	26, // 31: tetragon.FineGuidanceSensors.GetStackTraceTree:input_type -> tetragon.GetStackTraceTreeRequest
	28, // 32: tetragon.FineGuidanceSensors.GetVersion:input_type -> tetragon.GetVersionRequest
	43, // 33: tetragon.FineGuidanceSensors.RuntimeHook:input_type -> tetragon.RuntimeHookRequest
	33, // 34: tetragon.FineGuidanceSensors.GetDebug:input_type -> tetragon.GetDebugRequest
	35, // 35: tetragon.FineGuidanceSensors.SetDebug:input_type -> tetragon.SetDebugRequest
	44, // 36: tetragon.FineGuidanceSensors.GetEvents:output_type -> tetragon.GetEventsResponse
	45, // 37: tetragon.FineGuidanceSensors.GetHealth:output_type -> tetragon.GetHealthStatusResponse
	11, // 38: tetragon.FineGuidanceSensors.AddTracingPolicy:output_type -> tetragon.AddTracingPolicyResponse
	13, // 39: tetragon.FineGuidanceSensors.DeleteTracingPolicy:output_type -> tetragon.DeleteTracingPolicyResponse
	9,  // 40: tetragon.FineGuidanceSensors.ListTracingPolicies:output_type -> tetragon.ListTracingPoliciesResponse
	19, // 41: tetragon.FineGuidanceSensors.ConfigureTracingPolicy:output_type -> tetragon.ConfigureTracingPolicyResponse
	15, // 42: tetragon.FineGuidanceSensors.EnableTracingPolicy:output_type -> tetragon.EnableTracingPolicyResponse
	17, // 43: tetragon.FineGuidanceSensors.DisableTracingPolicy:output_type -> tetragon.DisableTracingPolicyResponse
	6,  // 44: tetragon.FineGuidanceSensors.ListSensors:output_type -> tetragon.ListSensorsResponse
	23, // 45: tetragon.FineGuidanceSensors.EnableSensor:output_type -> tetragon.EnableSensorResponse
	25, // 46: tetragon.FineGuidanceSensors.DisableSensor:output_type -> tetragon.DisableSensorResponse
	21, // 47: tetragon.FineGuidanceSensors.RemoveSensor:output_type -> tetragon.RemoveSensorResponse
	27, // 48: tetragon.FineGuidanceSensors.GetStackTraceTree:output_type -> tetragon.GetStackTraceTreeResponse
	29, // 49: tetragon.FineGuidanceSensors.GetVersion:output_type -> tetragon.GetVersionResponse
	46, // 50: tetragon.FineGuidanceSensors.RuntimeHook:output_type -> tetragon.RuntimeHookResponse
	34, // 51: tetragon.FineGuidanceSensors.GetDebug:output_type -> tetragon.GetDebugResponse
	36, // 52: tetragon.FineGuidanceSensors.SetDebug:output_type -> tetragon.SetDebugResponse
	36, // [36:53] is the sub-list for method output_type
	19, // [19:36] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_tetragon_sensors_proto_init() }
func file_tetragon_sensors_proto_init() {
	if File_tetragon_sensors_proto != nil {
		return
	}
	file_tetragon_events_proto_init()
	file_tetragon_stack_proto_init()
	file_tetragon_tetragon_proto_init()
	file_tetragon_sensors_proto_msgTypes[14].OneofWrappers = []any{}
	file_tetragon_sensors_proto_msgTypes[29].OneofWrappers = []any{
		(*GetDebugRequest_Dump)(nil),
	}
	file_tetragon_sensors_proto_msgTypes[30].OneofWrappers = []any{
		(*GetDebugResponse_Level)(nil),
		(*GetDebugResponse_Processes)(nil),
	}
	file_tetragon_sensors_proto_msgTypes[31].OneofWrappers = []any{
		(*SetDebugRequest_Level)(nil),
	}
	file_tetragon_sensors_proto_msgTypes[32].OneofWrappers = []any{
		(*SetDebugResponse_Level)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_tetragon_sensors_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   34,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_tetragon_sensors_proto_goTypes,
		DependencyIndexes: file_tetragon_sensors_proto_depIdxs,
		EnumInfos:         file_tetragon_sensors_proto_enumTypes,
		MessageInfos:      file_tetragon_sensors_proto_msgTypes,
	}.Build()
	File_tetragon_sensors_proto = out.File
	file_tetragon_sensors_proto_rawDesc = nil
	file_tetragon_sensors_proto_goTypes = nil
	file_tetragon_sensors_proto_depIdxs = nil
}
