## Upgrade notes

Read the upgrade notes carefully before upgrading Tetragon.
Depending on your setup, changes listed here might require a manual intervention.

### Agent Options

### Helm Values

* `tetragonOperator.skipCRDCreation` value is deprecated and will be removed. Use `crds.installMethod=none` instead.

### TracingPolicy (k8s CRD)

* The `symbol` field (string) in uprobe spec is replaced with `symbols` (array of strings). If using policies with uprobes, you need to replace the symbol field.
* Killer is renamed to enforcer. If using policies with killers, you need to replace `killers` with `enforcers` and `action: NotifyKiller` with `action: NotifyEnforcer`.
* To distinguish different stacktraces, kernel stacktraces are now enabled with `kernelStackTrace` policy field (renamed from `stackTrace`).

### Events (protobuf API)

* Deprecated `pod.labels` field is removed. Use `pod.pod_labels` instead.
* To distinguish different stacktraces, kernel stacktraces are now posted in `kernel_stack_trace` event field (renamed from `stack_trace`).

### Metrics

* Metrics related to monitoring BPF maps and userspace caches are fixed:
  * tetragon_map_drops_total is removed (it was duplicating tetragon_errors_total{type="process_cache_evicted"})
  * tetragon_map_in_use_gauge{map="eventcache"} is removed (event cache is not a BPF map)
  * tetragon_map_in_use_gauge{map="processLru"} is replaced with tetragon_process_cache_size (process cache is not a BPF map)
* Metrics with known labels values are initialized to 0 on startup. This helps to ensure stable resources usage and metrics queries. This also involves changes in several metrics labels:
  * error_type label on tetragon_handler_errors_total metric is either "unknown_opcode" or "event_handler_failed" instead of the Go type of the error
  * event_type label on tetragon_event_cache*_errors_total metrics is one of the values defined in Tetragon API (tetragon.EventType) instead of the Go type of the event
  * error label on tetragon_event_cache_errors_total metric is "nil_process_pid"
  * error label is removed from tetragon_policyfilter_metrics_total metric
* Metrics for map and cache sizes are improved:
  * tetragon_map_in_use_gauge metric is renamed to tetragon_map_entries and doesn't have total label anymore
  * New tetragon_map_capacity metric exposes the BPF maps capacity
  * New tetragon_event_cache_entries metric measures the event cache size
  * New tetragon_process_cache_size metric measures the process cache size
  * New tetragon_process_cache_capacity metric exposes the process cache capacity
