/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.htmlparser.Node;
import org.htmlparser.NodeFactory;
import org.htmlparser.NodeFilter;
import org.htmlparser.PrototypicalNodeFactory;
import org.htmlparser.filters.NodeClassFilter;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.util.DefaultParserFeedback;
import org.htmlparser.util.IteratorImpl;
import org.htmlparser.util.NodeIterator;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.ParserFeedback;
import org.htmlparser.visitors.NodeVisitor;

public class Parser
implements Serializable {
    public static final double VERSION_NUMBER = 1.5;
    public static final String VERSION_TYPE = "Integration Build";
    public static final String VERSION_DATE = "Jul 28, 2004";
    public static final String VERSION_STRING = "1.5 (Integration Build Jul 28, 2004)";
    protected static Map mDefaultRequestProperties = new HashMap();
    protected ParserFeedback mFeedback;
    protected Lexer mLexer;
    protected static String lineSeparator;
    public static ParserFeedback noFeedback;
    public static ParserFeedback stdout;

    public static void setLineSeparator(String lineSeparatorString) {
        lineSeparator = lineSeparatorString;
    }

    public static String getVersion() {
        return VERSION_STRING;
    }

    public static double getVersionNumber() {
        return 1.5;
    }

    public static Map getDefaultRequestProperties() {
        return mDefaultRequestProperties;
    }

    public static void setDefaultRequestProperties(Map properties) {
        mDefaultRequestProperties = properties;
    }

    public Parser() {
        this(new Lexer(new Page("")), noFeedback);
    }

    public Parser(Lexer lexer, ParserFeedback fb) {
        this.setFeedback(fb);
        if (null == lexer) {
            throw new IllegalArgumentException("lexer cannot be null");
        }
        this.setLexer(lexer);
        this.setNodeFactory(new PrototypicalNodeFactory());
    }

    public Parser(URLConnection connection, ParserFeedback fb) throws ParserException {
        this(new Lexer(connection), fb);
    }

    public Parser(String resourceLocn, ParserFeedback feedback) throws ParserException {
        this(Parser.openConnection(resourceLocn, feedback), feedback);
    }

    public Parser(String resourceLocn) throws ParserException {
        this(resourceLocn, stdout);
    }

    public Parser(Lexer lexer) {
        this(lexer, stdout);
    }

    public Parser(URLConnection connection) throws ParserException {
        this(connection, stdout);
    }

    public void setConnection(URLConnection connection) throws ParserException {
        if (null != connection) {
            this.setLexer(new Lexer(connection));
        }
    }

    public URLConnection getConnection() {
        return this.getLexer().getPage().getConnection();
    }

    public void setURL(String url) throws ParserException {
        if (null != url && !"".equals(url)) {
            this.setConnection(Parser.openConnection(url, this.getFeedback()));
        }
    }

    public String getURL() {
        return this.getLexer().getPage().getUrl();
    }

    public void setEncoding(String encoding) throws ParserException {
        this.getLexer().getPage().setEncoding(encoding);
    }

    public String getEncoding() {
        return this.getLexer().getPage().getEncoding();
    }

    public void setLexer(Lexer lexer) {
        if (null != lexer) {
            NodeFactory factory = null;
            if (null != this.getLexer()) {
                factory = this.getLexer().getNodeFactory();
            }
            if (null != factory) {
                lexer.setNodeFactory(factory);
            }
            this.mLexer = lexer;
            String type = this.mLexer.getPage().getContentType();
            if (type != null && !type.startsWith("text")) {
                this.getFeedback().warning("URL " + this.mLexer.getPage().getUrl() + " does not contain text");
            }
        }
    }

    public Lexer getLexer() {
        return this.mLexer;
    }

    public NodeFactory getNodeFactory() {
        return this.getLexer().getNodeFactory();
    }

    public void setNodeFactory(NodeFactory factory) {
        if (null == factory) {
            throw new IllegalArgumentException("node factory cannot be null");
        }
        this.getLexer().setNodeFactory(factory);
    }

    public void setFeedback(ParserFeedback fb) {
        this.mFeedback = null == fb ? noFeedback : fb;
    }

    public ParserFeedback getFeedback() {
        return this.mFeedback;
    }

    public void reset() {
        this.getLexer().reset();
    }

    public NodeIterator elements() throws ParserException {
        return new IteratorImpl(this.getLexer(), this.getFeedback());
    }

    public void parse(NodeFilter filter) throws ParserException {
        NodeList list = new NodeList();
        NodeIterator e = this.elements();
        while (e.hasMoreNodes()) {
            Node node = e.nextNode();
            if (null != filter) {
                node.collectInto(list, filter);
                for (int i = 0; i < list.size(); ++i) {
                    System.out.println(list.elementAt(i));
                }
                list.removeAll();
                continue;
            }
            System.out.println(node);
        }
    }

    public static URLConnection openConnection(URL url, ParserFeedback feedback) throws ParserException {
        URLConnection ret;
        try {
            ret = url.openConnection();
            Map properties = Parser.getDefaultRequestProperties();
            if (null != properties) {
                Iterator iterator = properties.keySet().iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    String value = (String)properties.get(key);
                    ret.setRequestProperty(key, value);
                }
            }
        }
        catch (IOException ioe) {
            String msg = "HTMLParser.openConnection() : Error in opening a connection to " + url.toExternalForm();
            ParserException ex = new ParserException(msg, ioe);
            if (null != feedback) {
                feedback.error(msg, ex);
            }
            throw ex;
        }
        return ret;
    }

    public static String fixSpaces(String url) {
        int index = url.indexOf(32);
        if (-1 != index) {
            int length = url.length();
            StringBuffer returnURL = new StringBuffer(length * 3);
            returnURL.append(url.substring(0, index));
            for (int i = index; i < length; ++i) {
                char ch = url.charAt(i);
                if (ch == ' ') {
                    returnURL.append("%20");
                    continue;
                }
                returnURL.append(ch);
            }
            url = returnURL.toString();
        }
        return url;
    }

    public static URLConnection openConnection(String string, ParserFeedback feedback) throws ParserException {
        URLConnection ret;
        String prefix = "file://localhost";
        try {
            URL url = new URL(Parser.fixSpaces(string));
            ret = Parser.openConnection(url, feedback);
        }
        catch (MalformedURLException murle) {
            try {
                File file = new File(string);
                String resource = file.getCanonicalPath();
                StringBuffer buffer = new StringBuffer("file://localhost".length() + resource.length());
                buffer.append("file://localhost");
                if (!resource.startsWith("/")) {
                    buffer.append("/");
                }
                buffer.append(resource);
                URL url = new URL(Parser.fixSpaces(buffer.toString()));
                ret = Parser.openConnection(url, feedback);
                if (null != feedback) {
                    feedback.info(url.toExternalForm());
                }
            }
            catch (MalformedURLException murle2) {
                String msg = "HTMLParser.openConnection() : Error in opening a connection to " + string;
                ParserException ex = new ParserException(msg, murle2);
                if (null != feedback) {
                    feedback.error(msg, ex);
                }
                throw ex;
            }
            catch (IOException ioe) {
                String msg = "HTMLParser.openConnection() : Error in opening a connection to " + string;
                ParserException ex = new ParserException(msg, ioe);
                if (null != feedback) {
                    feedback.error(msg, ex);
                }
                throw ex;
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        System.out.println("HTMLParser v1.5 (Integration Build Jul 28, 2004)");
        if (args.length < 1 || args[0].equals("-help")) {
            System.out.println();
            System.out.println("Syntax : java -jar htmlparser.jar <resourceLocn/website> [node_type]");
            System.out.println("   <resourceLocn/website> the URL or file to be parsed");
            System.out.println("   node_type an optional node name, for example:");
            System.out.println("     A - Show only the link tags extracted from the document");
            System.out.println("     IMG - Show only the image tags extracted from the document");
            System.out.println("     TITLE - Extract the title from the document");
            System.out.println();
            System.out.println("Example : java -jar htmlparser.jar http://www.yahoo.com");
            System.out.println();
            System.out.println("For support, please join the HTMLParser mailing list (user/developer) from the HTML Parser home page...");
            System.out.println("HTML Parser home page : http://htmlparser.sourceforge.net");
            System.out.println();
            System.exit(-1);
        }
        try {
            Parser parser = new Parser(args[0]);
            System.out.println("Parsing " + parser.getURL());
            TagNameFilter filter = 1 < args.length ? new TagNameFilter(args[1]) : null;
            parser.parse(filter);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
    }

    public void visitAllNodesWith(NodeVisitor visitor) throws ParserException {
        visitor.beginParsing();
        NodeIterator e = this.elements();
        while (e.hasMoreNodes()) {
            Node node = e.nextNode();
            node.accept(visitor);
        }
        visitor.finishedParsing();
    }

    public void setInputHTML(String inputHTML) throws ParserException {
        if (null == inputHTML) {
            throw new IllegalArgumentException("html cannot be null");
        }
        if (!"".equals(inputHTML)) {
            this.setLexer(new Lexer(new Page(inputHTML)));
        }
    }

    public NodeList extractAllNodesThatMatch(NodeFilter filter) throws ParserException {
        NodeList ret = new NodeList();
        NodeIterator e = this.elements();
        while (e.hasMoreNodes()) {
            e.nextNode().collectInto(ret, filter);
        }
        return ret;
    }

    public Node[] extractAllNodesThatAre(Class nodeType) throws ParserException {
        NodeList ret = this.extractAllNodesThatMatch(new NodeClassFilter(nodeType));
        return ret.toNodeArray();
    }

    public static Parser createParser(String html, String charset) {
        if (null == html) {
            throw new IllegalArgumentException("html cannot be null");
        }
        Parser ret = new Parser(new Lexer(new Page(html, charset)));
        return ret;
    }

    public static String getLineSeparator() {
        return lineSeparator;
    }

    static {
        mDefaultRequestProperties.put("User-Agent", "HTMLParser/1.5");
        lineSeparator = System.getProperty("line.separator", "\n");
        noFeedback = new DefaultParserFeedback(0);
        stdout = new DefaultParserFeedback();
    }
}

