/*
 * Decompiled with CFR 0.152.
 */
package org.openamf.examples;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.HashMap;

public class Java2AS
implements Serializable {
    private static Class collectionClass;

    public static void main(String[] args) {
        if (args.length == 1) {
            Java2AS.generateAS(args[0]);
        } else {
            System.out.println("Invalid list of arguments");
            System.out.println("Usage: java Java2AS classname");
        }
    }

    public HashMap generateAS2(String javaClass) {
        return Java2AS.generateAS(javaClass);
    }

    public static HashMap generateAS(String javaClass) {
        StringBuffer amfconfigSource = new StringBuffer();
        StringBuffer asSource = new StringBuffer();
        StringBuffer messages = new StringBuffer();
        try {
            String newName;
            String fc;
            int i;
            int i2;
            Class<?> c = Class.forName(javaClass);
            String className = c.getName();
            amfconfigSource.append("\n\t<custom-class-mapping>\n");
            amfconfigSource.append("\t   <java-class>" + className + "</java-class>\n");
            amfconfigSource.append("\t   <custom-class>" + className + "</custom-class>\n");
            amfconfigSource.append("</custom-class-mapping>\n");
            c.newInstance();
            BeanInfo info = Introspector.getBeanInfo(c);
            PropertyDescriptor[] propertyDescriptors = info.getPropertyDescriptors();
            PropertyDescriptor pd = null;
            String propertyName = null;
            String propertyDisplayName = null;
            asSource.append("\n\n/** \n");
            asSource.append("* see Java:" + className + " \n");
            asSource.append("*/\n\n");
            Class<?> suC = c.getSuperclass();
            asSource.append("//extends " + suC.getName() + " \n\n");
            Class<?>[] i_ary = c.getInterfaces();
            if (i_ary != null) {
                for (i2 = 0; i2 < i_ary.length; ++i2) {
                    Class<?> ic = i_ary[i2];
                    asSource.append("//implements " + ic.getName() + " \n\n");
                }
            }
            asSource.append("class  " + className + " {\n\n");
            for (i2 = 0; i2 < propertyDescriptors.length; ++i2) {
                pd = propertyDescriptors[i2];
                propertyName = pd.getName();
                if (propertyName.equals("class")) continue;
                asSource.append("\tprivate var " + propertyName + " : " + Java2AS.getASType(pd.getPropertyType()) + ";\n");
            }
            int lastDot = className.lastIndexOf(".");
            String shortClassName = lastDot < 0 ? className : className.substring(lastDot + 1);
            asSource.append("\n\tstatic var registered=Object.registerClass(\"" + className + "\", " + className + ");");
            asSource.append("\n\n");
            asSource.append("\tpublic function " + shortClassName + "(){\n");
            asSource.append("\t};\n\n");
            for (i = 0; i < propertyDescriptors.length; ++i) {
                pd = propertyDescriptors[i];
                propertyName = pd.getName();
                fc = propertyName.toUpperCase();
                propertyDisplayName = fc.substring(0, 1) + propertyName.substring(1, propertyName.length());
                if (propertyName.equals("class")) continue;
                asSource.append("\t//-------- Bean getter and setter for " + propertyDisplayName + " -----------// \n");
                asSource.append("\tpublic function get" + propertyDisplayName + "():" + Java2AS.getASType(pd.getPropertyType()) + "{\n");
                asSource.append("\t   return this." + propertyName + ";\n");
                asSource.append("\t};\n");
                newName = "new" + propertyDisplayName;
                asSource.append("\tpublic function set" + propertyDisplayName + "(" + newName + ":" + Java2AS.getASType(pd.getPropertyType()) + "):Void{\n");
                asSource.append("\t  this." + propertyName + " = " + newName + ";\n");
                asSource.append("\t};\n\n");
            }
            asSource.append("\tpublic function initSampleData():Void{\n");
            for (i = 0; i < propertyDescriptors.length; ++i) {
                pd = propertyDescriptors[i];
                propertyName = pd.getName();
                fc = propertyName.toUpperCase();
                propertyDisplayName = fc.substring(0, 1) + propertyName.substring(1, propertyName.length());
                if (propertyName.equals("class")) continue;
                newName = "new" + propertyDisplayName;
                String typeName = Java2AS.getASType(pd.getPropertyType());
                if (typeName.equalsIgnoreCase("String")) {
                    asSource.append("\t  this." + propertyName + " = \"sample_" + propertyName + "\";\n");
                    continue;
                }
                if (typeName.equalsIgnoreCase("Number")) {
                    asSource.append("\t  this." + propertyName + " = " + i + ";\n");
                    continue;
                }
                if (typeName.equalsIgnoreCase("Boolean")) {
                    asSource.append("\t  this." + propertyName + " = false;\n");
                    continue;
                }
                asSource.append("\t  this." + propertyName + " = new " + typeName + "();\n");
            }
            asSource.append("\t};\n\n");
            asSource.append("\tpublic function toString():String{\n");
            asSource.append("\t  return \"" + className + "\";\n");
            asSource.append("\t};\n\n");
            asSource.append("}");
            System.out.println(asSource);
            messages.append(shortClassName + ".as generated successfully");
        }
        catch (ClassNotFoundException e) {
            messages.append("ERROR: Class " + javaClass + " not found");
        }
        catch (InstantiationException e) {
            messages.append("ERROR: Class " + javaClass + " must have a no-argument constructor");
        }
        catch (IllegalAccessException e) {
            messages.append(e.getMessage());
        }
        catch (IntrospectionException e) {
            messages.append(e.getMessage());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("<<<<<<<< openamf-config.xml >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>", amfconfigSource.toString());
        map.put("<<<<<<<< *.as source  >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>", asSource.toString());
        map.put("<<<<<<<<  messages    >>>>>>>>>>>>>>>>>>>>>>>>>>>", messages.toString());
        return map;
    }

    public static String getASType(Class type) {
        String typeName = type.getName();
        if (typeName.equals("java.lang.String")) {
            return "String";
        }
        if (typeName.equals("int") || typeName.equals("long") || typeName.equals("short") || typeName.equals("double") || typeName.equals("float") || typeName.equals("byte") || typeName.equals("java.lang.Integer") || typeName.equals("java.lang.Long") || typeName.equals("java.lang.Short") || typeName.equals("java.lang.Double") || typeName.equals("java.lang.Float") || typeName.equals("java.lang.Byte")) {
            return "Number";
        }
        if (typeName.equals("boolean") || typeName.equals("java.lang.Boolean")) {
            return "Boolean";
        }
        if (type.isArray()) {
            return "Array";
        }
        if (typeName.equals("java.util.Date")) {
            return "Date";
        }
        if (typeName.equals("org.w3c.dom.Document")) {
            return "XML";
        }
        try {
            Object obj = type.newInstance();
            if (collectionClass.isInstance(obj)) {
                return "Array";
            }
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return typeName;
    }

    public String getString() {
        return "Hello World!";
    }

    static {
        try {
            collectionClass = Class.forName("java.util.Collection");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

