/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SortOrder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.api.DialogAddPermittedAddress;
import org.zaproxy.zap.extension.api.DialogModifyPermittedAddress;
import org.zaproxy.zap.extension.api.ExtensionAPI;
import org.zaproxy.zap.extension.api.PermittedAddressesTableModel;
import org.zaproxy.zap.network.DomainMatcher;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.ZapHtmlLabel;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.AbstractMultipleOptionsTablePanel;
import org.zaproxy.zap.view.LayoutHelper;

public class OptionsApiPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JPanel panelMisc = null;
    private JCheckBox chkEnabled = null;
    private JCheckBox chkUiEnabled = null;
    private JCheckBox chkSecureOnly = null;
    private JCheckBox fileTransferEnabled = null;
    private JCheckBox reportPermErrors = null;
    private JCheckBox disableKey = null;
    private JCheckBox incErrorDetails = null;
    private JCheckBox autofillKey = null;
    private JCheckBox enableJSONP = null;
    private JCheckBox noKeyForSafeOps = null;
    private ZapTextField keyField = null;
    private JTextField transferDirectory = null;
    private JButton generateKeyButton = null;
    private JButton transferDirectoryButton = null;
    private PermittedAddressesPanel permittedAddressesPanel;
    private PermittedAddressesTableModel permittedAddressesTableModel;

    public OptionsApiPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("api.options.title"));
        this.add((Component)this.getPanelMisc(), this.getPanelMisc().getName());
    }

    private JPanel getPanelMisc() {
        if (this.panelMisc == null) {
            this.panelMisc = new JPanel();
            this.panelMisc.setLayout(new GridBagLayout());
            int y = 0;
            JLabel directoryLabel = new JLabel(Constant.messages.getString("api.options.label.xferDirectory"));
            directoryLabel.setLabelFor(this.getTransferDirectoryButton());
            this.panelMisc.add((Component)this.getChkEnabled(), LayoutHelper.getGBC(0, y++, 2, 0.5));
            this.panelMisc.add((Component)this.getChkUiEnabled(), LayoutHelper.getGBC(0, y++, 2, 0.5));
            this.panelMisc.add((Component)this.getChkSecureOnly(), LayoutHelper.getGBC(0, y++, 2, 0.5));
            this.panelMisc.add((Component)this.getFileTransferEnabled(), LayoutHelper.getGBC(0, y++, 2, 0.5));
            this.panelMisc.add((Component)directoryLabel, LayoutHelper.getGBC(0, y, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getTransferDirectory(), LayoutHelper.getGBC(1, y++, 1, 0.5));
            this.panelMisc.add((Component)this.getTransferDirectoryButton(), LayoutHelper.getGBC(1, y++, 1, 0.5));
            this.panelMisc.add((Component)new JLabel(Constant.messages.getString("api.options.label.apiKey")), LayoutHelper.getGBC(0, y, 1, 0.5));
            this.panelMisc.add((Component)this.getKeyField(), LayoutHelper.getGBC(1, y++, 1, 0.5));
            this.panelMisc.add((Component)this.getGenerateKeyButton(), LayoutHelper.getGBC(1, y++, 1, 0.5));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("api.options.addr.title"), 0, 0, FontUtils.getFont(FontUtils.Size.standard)));
            jPanel.add((Component)this.getProxyPermittedAddressesPanel(), LayoutHelper.getGBC(0, 0, 1, 1.0, 1.0));
            this.panelMisc.add((Component)jPanel, LayoutHelper.getGBC(0, y++, 2, 1.0, 1.0));
            ZapHtmlLabel warning = new ZapHtmlLabel(Constant.messages.getString("api.options.label.testingWarning"));
            warning.setForeground(Color.RED);
            this.panelMisc.add((Component)warning, LayoutHelper.getGBC(0, y++, 2, 0.5));
            this.panelMisc.add((Component)this.getDisableKey(), LayoutHelper.getGBC(0, y++, 2, 0.5));
            this.panelMisc.add((Component)this.getNoKeyForSafeOps(), LayoutHelper.getGBC(0, y++, 2, 0.5));
            this.panelMisc.add((Component)this.getReportPermErrors(), LayoutHelper.getGBC(0, y++, 2, 0.5));
            this.panelMisc.add((Component)this.getIncErrorDetails(), LayoutHelper.getGBC(0, y++, 2, 0.5));
            this.panelMisc.add((Component)this.getAutofillKey(), LayoutHelper.getGBC(0, y++, 2, 0.5));
            this.panelMisc.add((Component)this.getEnableJSONP(), LayoutHelper.getGBC(0, y++, 2, 0.5));
            this.panelMisc.add((Component)new JLabel(), LayoutHelper.getGBC(0, y, 1, 0.5, 1.0));
        }
        return this.panelMisc;
    }

    private JCheckBox getChkEnabled() {
        if (this.chkEnabled == null) {
            this.chkEnabled = new JCheckBox();
            this.chkEnabled.setText(Constant.messages.getString("api.options.enabled"));
            this.chkEnabled.setVerticalAlignment(1);
            this.chkEnabled.setVerticalTextPosition(1);
        }
        return this.chkEnabled;
    }

    private JCheckBox getChkUiEnabled() {
        if (this.chkUiEnabled == null) {
            this.chkUiEnabled = new JCheckBox();
            this.chkUiEnabled.setText(Constant.messages.getString("api.options.uiEnabled"));
            this.chkUiEnabled.setVerticalAlignment(1);
            this.chkUiEnabled.setVerticalTextPosition(1);
        }
        return this.chkUiEnabled;
    }

    private JCheckBox getChkSecureOnly() {
        if (this.chkSecureOnly == null) {
            this.chkSecureOnly = new JCheckBox();
            this.chkSecureOnly.setText(Constant.messages.getString("api.options.secure"));
            this.chkSecureOnly.setVerticalAlignment(1);
            this.chkSecureOnly.setVerticalTextPosition(1);
        }
        return this.chkSecureOnly;
    }

    private JCheckBox getFileTransferEnabled() {
        if (this.fileTransferEnabled == null) {
            this.fileTransferEnabled = new JCheckBox();
            this.fileTransferEnabled.setText(Constant.messages.getString("api.options.fileTransfer"));
            this.fileTransferEnabled.setVerticalAlignment(1);
            this.fileTransferEnabled.setVerticalTextPosition(1);
            this.fileTransferEnabled.addActionListener(e -> this.setTransferControlsState());
        }
        return this.fileTransferEnabled;
    }

    private JCheckBox getDisableKey() {
        if (this.disableKey == null) {
            this.disableKey = new JCheckBox();
            this.disableKey.setText(Constant.messages.getString("api.options.disableKey"));
            this.disableKey.setVerticalAlignment(1);
            this.disableKey.setVerticalTextPosition(1);
            this.disableKey.addActionListener(e -> {
                this.getKeyField().setEnabled(!this.disableKey.isSelected());
                this.getGenerateKeyButton().setEnabled(!this.disableKey.isSelected());
                if (!this.disableKey.isSelected()) {
                    this.getKeyField().setText(Model.getSingleton().getOptionsParam().getApiParam().getRealKey());
                }
                this.setTransferControlsState();
            });
        }
        return this.disableKey;
    }

    private JCheckBox getEnableJSONP() {
        if (this.enableJSONP == null) {
            this.enableJSONP = new JCheckBox();
            this.enableJSONP.setText(Constant.messages.getString("api.options.enableJSONP"));
            this.enableJSONP.setVerticalAlignment(1);
            this.enableJSONP.setVerticalTextPosition(1);
        }
        return this.enableJSONP;
    }

    private JCheckBox getReportPermErrors() {
        if (this.reportPermErrors == null) {
            this.reportPermErrors = new JCheckBox();
            this.reportPermErrors.setText(Constant.messages.getString("api.options.reportPermErrors"));
            this.reportPermErrors.setVerticalAlignment(1);
            this.reportPermErrors.setVerticalTextPosition(1);
        }
        return this.reportPermErrors;
    }

    private JCheckBox getNoKeyForSafeOps() {
        if (this.noKeyForSafeOps == null) {
            this.noKeyForSafeOps = new JCheckBox();
            this.noKeyForSafeOps.setText(Constant.messages.getString("api.options.noKeyForSafeOps"));
            this.noKeyForSafeOps.setVerticalAlignment(1);
            this.noKeyForSafeOps.setVerticalTextPosition(1);
        }
        return this.noKeyForSafeOps;
    }

    private JCheckBox getIncErrorDetails() {
        if (this.incErrorDetails == null) {
            this.incErrorDetails = new JCheckBox();
            this.incErrorDetails.setText(Constant.messages.getString("api.options.incErrors"));
            this.incErrorDetails.setVerticalAlignment(1);
            this.incErrorDetails.setVerticalTextPosition(1);
        }
        return this.incErrorDetails;
    }

    private JCheckBox getAutofillKey() {
        if (this.autofillKey == null) {
            this.autofillKey = new JCheckBox();
            this.autofillKey.setText(Constant.messages.getString("api.options.autofillKey"));
            this.autofillKey.setVerticalAlignment(1);
            this.autofillKey.setVerticalTextPosition(1);
        }
        return this.autofillKey;
    }

    private ZapTextField getKeyField() {
        if (this.keyField == null) {
            this.keyField = new ZapTextField();
        }
        return this.keyField;
    }

    private JButton getGenerateKeyButton() {
        if (this.generateKeyButton == null) {
            this.generateKeyButton = new JButton(Constant.messages.getString("api.options.button.generateKey"));
            this.generateKeyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsApiPanel.this.getKeyField().setText(ExtensionAPI.generateApiKey());
                }
            });
        }
        return this.generateKeyButton;
    }

    private JButton getTransferDirectoryButton() {
        if (this.transferDirectoryButton == null) {
            this.transferDirectoryButton = new JButton(Constant.messages.getString("api.options.button.xferDirectory"));
            this.transferDirectoryButton.addActionListener(new FileChooserAction(this.getTransferDirectory()));
        }
        return this.transferDirectoryButton;
    }

    private JTextField getTransferDirectory() {
        if (this.transferDirectory == null) {
            this.transferDirectory = new JTextField(20);
        }
        return this.transferDirectory;
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam options = (OptionsParam)obj;
        this.getChkEnabled().setSelected(options.getApiParam().isEnabled());
        this.getChkUiEnabled().setSelected(options.getApiParam().isUiEnabled());
        this.getChkSecureOnly().setSelected(options.getApiParam().isSecureOnly());
        this.getFileTransferEnabled().setSelected(options.getApiParam().isFileTransferAllowed());
        this.getDisableKey().setSelected(options.getApiParam().isDisableKey());
        this.getIncErrorDetails().setSelected(options.getApiParam().isIncErrorDetails());
        this.getAutofillKey().setSelected(options.getApiParam().isAutofillKey());
        this.getEnableJSONP().setSelected(options.getApiParam().isEnableJSONP());
        this.getReportPermErrors().setSelected(options.getApiParam().isReportPermErrors());
        this.getNoKeyForSafeOps().setSelected(options.getApiParam().isNoKeyForSafeOps());
        this.getTransferDirectory().setText(options.getApiParam().getTransferDir());
        this.getKeyField().setText(options.getApiParam().getKey());
        this.getKeyField().setEnabled(!this.disableKey.isSelected());
        this.getGenerateKeyButton().setEnabled(!this.disableKey.isSelected());
        this.setTransferControlsState();
        this.getPermittedAddressesTableModel().setAddresses(options.getApiParam().getPermittedAddresses());
        this.getProxyPermittedAddressesPanel().setRemoveWithoutConfirmation(!options.getApiParam().isConfirmRemovePermittedAddress());
    }

    private void setTransferControlsState() {
        this.getFileTransferEnabled().setEnabled(!this.disableKey.isSelected());
        boolean enabled = !this.disableKey.isSelected() && this.getFileTransferEnabled().isSelected();
        this.getTransferDirectory().setEnabled(enabled);
        this.getTransferDirectoryButton().setEnabled(enabled);
    }

    @Override
    public void validateParam(Object obj) throws Exception {
        File xferDir;
        if (!this.getDisableKey().isSelected() && this.getKeyField().getText().length() == 0) {
            this.getKeyField().requestFocusInWindow();
            throw new Exception(Constant.messages.getString("api.options.nokey.error"));
        }
        if (!(!this.getFileTransferEnabled().isSelected() || (xferDir = new File(this.getTransferDirectory().getText())).isDirectory() && xferDir.canWrite())) {
            throw new Exception(Constant.messages.getString("api.options.xferdir.error"));
        }
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam options = (OptionsParam)obj;
        options.getApiParam().setEnabled(this.getChkEnabled().isSelected());
        options.getApiParam().setUiEnabled(this.getChkUiEnabled().isSelected());
        options.getApiParam().setSecureOnly(this.getChkSecureOnly().isSelected());
        options.getApiParam().setFileTransferAllowed(this.getFileTransferEnabled().isSelected());
        options.getApiParam().setDisableKey(this.getDisableKey().isSelected());
        options.getApiParam().setIncErrorDetails(this.getIncErrorDetails().isSelected());
        options.getApiParam().setAutofillKey(this.getAutofillKey().isSelected());
        options.getApiParam().setEnableJSONP(this.getEnableJSONP().isSelected());
        options.getApiParam().setReportPermErrors(this.getReportPermErrors().isSelected());
        options.getApiParam().setNoKeyForSafeOps(this.getNoKeyForSafeOps().isSelected());
        if (this.getFileTransferEnabled().isSelected()) {
            options.getApiParam().setTransferDir(this.getTransferDirectory().getText());
        }
        if (!this.getDisableKey().isSelected()) {
            options.getApiParam().setKey(this.getKeyField().getText());
        }
        options.getApiParam().setPermittedAddresses(this.getPermittedAddressesTableModel().getElements());
        options.getApiParam().setConfirmRemovePermittedAddress(!this.getProxyPermittedAddressesPanel().isRemoveWithoutConfirmation());
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.api";
    }

    private PermittedAddressesPanel getProxyPermittedAddressesPanel() {
        if (this.permittedAddressesPanel == null) {
            this.permittedAddressesPanel = new PermittedAddressesPanel(this.getPermittedAddressesTableModel());
        }
        return this.permittedAddressesPanel;
    }

    private PermittedAddressesTableModel getPermittedAddressesTableModel() {
        if (this.permittedAddressesTableModel == null) {
            this.permittedAddressesTableModel = new PermittedAddressesTableModel();
        }
        return this.permittedAddressesTableModel;
    }

    private static class PermittedAddressesPanel
    extends AbstractMultipleOptionsTablePanel<DomainMatcher> {
        private static final long serialVersionUID = 2332044353650231701L;
        private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("api.options.addr.dialog.remove.title");
        private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("api.options.addr.dialog.remove.text");
        private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("api.options.addr.dialog.remove.button.confirm");
        private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("api.options.addr.dialog.remove.button.cancel");
        private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("api.options.addr.dialog.remove.checkbox.label");
        private DialogAddPermittedAddress addDialog = null;
        private DialogModifyPermittedAddress modifyDialog = null;

        public PermittedAddressesPanel(PermittedAddressesTableModel model) {
            super(model);
            this.getTable().setVisibleRowCount(5);
            this.getTable().setSortOrder(2, SortOrder.ASCENDING);
        }

        @Override
        public DomainMatcher showAddDialogue() {
            if (this.addDialog == null) {
                this.addDialog = new DialogAddPermittedAddress(View.getSingleton().getOptionsDialog(null));
                this.addDialog.pack();
            }
            this.addDialog.setVisible(true);
            DomainMatcher hostAuthentication = this.addDialog.getAddress();
            this.addDialog.clear();
            return hostAuthentication;
        }

        @Override
        public DomainMatcher showModifyDialogue(DomainMatcher e) {
            if (this.modifyDialog == null) {
                this.modifyDialog = new DialogModifyPermittedAddress(View.getSingleton().getOptionsDialog(null));
                this.modifyDialog.pack();
            }
            this.modifyDialog.setAddress(e);
            this.modifyDialog.setVisible(true);
            DomainMatcher addr = this.modifyDialog.getAddress();
            this.modifyDialog.clear();
            if (!addr.equals(e)) {
                return addr;
            }
            return null;
        }

        @Override
        public boolean showRemoveDialogue(DomainMatcher e) {
            JCheckBox removeWithoutConfirmationCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
            Object[] messages = new Object[]{REMOVE_DIALOG_TEXT, " ", removeWithoutConfirmationCheckBox};
            int option = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), messages, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
            if (option == 0) {
                this.setRemoveWithoutConfirmation(removeWithoutConfirmationCheckBox.isSelected());
                return true;
            }
            return false;
        }
    }

    private static class FileChooserAction
    implements ActionListener {
        private final JTextField textField;

        public FileChooserAction(JTextField bindTextField) {
            this.textField = bindTextField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file;
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            String path = this.textField.getText();
            if (path != null && (file = new File(path)).canWrite() && file.isDirectory()) {
                fileChooser.setSelectedFile(file);
            }
            if (fileChooser.showOpenDialog(null) == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                this.textField.setText(selectedFile.getAbsolutePath());
            }
        }
    }
}

