/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.rangetree;

import org.apache.lucene.rangetree.SliceReader;

final class HeapSliceReader
implements SliceReader {
    private int curRead;
    final long[] values;
    final long[] ords;
    final int[] docIDs;
    final int end;

    HeapSliceReader(long[] values, long[] ords, int[] docIDs, int start, int end) {
        this.values = values;
        this.ords = ords;
        this.docIDs = docIDs;
        this.curRead = start - 1;
        this.end = end;
    }

    @Override
    public boolean next() {
        ++this.curRead;
        return this.curRead < this.end;
    }

    @Override
    public long value() {
        return this.values[this.curRead];
    }

    @Override
    public int docID() {
        return this.docIDs[this.curRead];
    }

    @Override
    public long ord() {
        return this.ords[this.curRead];
    }

    @Override
    public void close() {
    }
}

