/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class EditDialogDisplayer
extends DialogDisplayer {
    private static DialogDisplayer _displayer;

    public EditDialogDisplayer() {
        this(null);
    }

    public EditDialogDisplayer(DialogDisplayer delegate) {
        _displayer = delegate;
    }

    private DialogDisplayer displayer() {
        if (_displayer == null) {
            ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            try {
                Class<?> clazz = loader.loadClass("org.netbeans.core.windows.services.DialogDisplayerImpl");
                _displayer = (DialogDisplayer)clazz.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return _displayer;
    }

    public Object notify(NotifyDescriptor descriptor) {
        if (descriptor instanceof EditDialogDescriptor) {
            return this.notify((EditDialogDescriptor)descriptor);
        }
        return this.displayer().notify(descriptor);
    }

    public Dialog createDialog(DialogDescriptor descriptor) {
        if (descriptor instanceof EditDialogDescriptor) {
            return this.createDialog((EditDialogDescriptor)descriptor);
        }
        return this.displayer().createDialog(descriptor);
    }

    public Object notify(EditDialogDescriptor descriptor) {
        Dialog dlg = this.createDialog(descriptor);
        try {
            dlg.setVisible(true);
        }
        finally {
            dlg.dispose();
        }
        return descriptor.getValue();
    }

    public Dialog createDialog(final EditDialogDescriptor descriptor) {
        JButton button;
        DialogDescriptor dd = descriptor.createDialogDescriptor();
        final Object[] array = new Object[1];
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                descriptor.setValue(e.getSource());
                if (e.getSource() == DialogDescriptor.OK_OPTION && descriptor.tryClose()) {
                    Dialog dlg = (Dialog)array[0];
                    try {
                        dlg.setVisible(false);
                    }
                    finally {
                        dlg.dispose();
                    }
                }
            }
        };
        dd.setButtonListener(listener);
        dd.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
        Dialog dialog = this.displayer().createDialog(dd);
        array[0] = dialog;
        JRootPane rootpane = SwingUtilities.getRootPane(dialog);
        if (descriptor.enforceDefaultButton() && rootpane != null && (button = rootpane.getDefaultButton()) != null) {
            this.attachDefaultButtonFunction(rootpane.getComponents(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    button.doClick();
                }
            });
        }
        return dialog;
    }

    private void attachDefaultButtonFunction(Component[] components, ActionListener al) {
        for (Component component : components) {
            if (component instanceof JTextField) {
                JTextField field = (JTextField)component;
                if (field.getActionListeners().length == 0) continue;
                field.addActionListener(al);
                continue;
            }
            if (!(component instanceof JComponent)) continue;
            this.attachDefaultButtonFunction(((JComponent)component).getComponents(), al);
        }
    }
}

