/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.transactions;

import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.EntityUpdate;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.LinkUpdate;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutReader;
import com.paterva.maltego.graph.store.layout.GraphLayoutWriter;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptorSet;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.GraphUser;
import com.paterva.maltego.ui.graph.ModifiedHelper;
import com.paterva.maltego.ui.graph.transacting.GraphTransactor;
import com.paterva.maltego.ui.graph.transacting.GraphTransactorRegistry;
import com.paterva.maltego.ui.graph.transactions.GraphOperation;
import com.paterva.maltego.ui.graph.transactions.GraphPositionAndPathHelper;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import com.paterva.maltego.ui.graph.transactions.GraphTransactions;
import com.paterva.maltego.ui.graph.transactions.TransactionBatchFactory;
import com.paterva.maltego.util.SimilarStrings;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;
import yguard.A.A.D;
import yguard.A.J.SA;

public class GraphTransactionHelper {
    private static final Logger LOGGER = Logger.getLogger(GraphTransactionHelper.class.getName());
    private static final int DISPLAYNAME_LIMIT = 35;

    private GraphTransactionHelper() {
    }

    public static Map<EntityUpdate, MaltegoEntity> createEntityUpdates(Collection<MaltegoEntity> entities) {
        HashMap<EntityUpdate, MaltegoEntity> updates = new HashMap<EntityUpdate, MaltegoEntity>(entities.size());
        for (MaltegoEntity entity : entities) {
            updates.put(new EntityUpdate(entity), entity);
        }
        return updates;
    }

    public static Set<EntityUpdate> createEntityUpdatesIdsOnly(Set<EntityID> entityIDs) {
        HashSet<EntityUpdate> updates = new HashSet<EntityUpdate>(entityIDs.size());
        for (EntityID entityID : entityIDs) {
            updates.add(new EntityUpdate(entityID));
        }
        return updates;
    }

    public static Map<LinkUpdate, MaltegoLink> createLinkUpdates(Collection<MaltegoLink> links) {
        HashMap<LinkUpdate, MaltegoLink> updates = new HashMap<LinkUpdate, MaltegoLink>(links.size());
        for (MaltegoLink link : links) {
            updates.put(new LinkUpdate(link), link);
        }
        return updates;
    }

    public static Set<LinkUpdate> createLinkUpdatesIdsOnly(Set<LinkID> linkIDs) {
        HashSet<LinkUpdate> updates = new HashSet<LinkUpdate>(linkIDs.size());
        for (LinkID linkID : linkIDs) {
            updates.add(new LinkUpdate(linkID));
        }
        return updates;
    }

    public static Set<MaltegoEntity> getGraphEntities(GraphID graphID, Set<EntityID> entityIDs, boolean ignoreMissing) {
        Set<Object> entities = new HashSet<MaltegoEntity>();
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            if (ignoreMissing) {
                entityIDs = structureReader.getExistingEntities(entityIDs);
            }
            entities = GraphStoreHelper.getMaltegoEntities((GraphID)graphID, entityIDs);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return entities;
    }

    public static Set<MaltegoEntity> getGraphEntityClones(D graph, Set<EntityID> entityIDs, boolean ignoreMissing) {
        HashSet<MaltegoEntity> clones = new HashSet<MaltegoEntity>();
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((D)graph);
        for (EntityID entityID : entityIDs) {
            MaltegoEntity graphEntity = wrapper.getEntity(entityID);
            if (graphEntity != null) {
                clones.add(graphEntity.createClone());
                continue;
            }
            String msg = "Entity does not exist with id: " + entityID;
            if (!ignoreMissing) {
                throw new IllegalArgumentException(msg);
            }
            Logger.getLogger(GraphTransactionHelper.class.getName()).warning(msg);
        }
        return clones;
    }

    public static Set<MaltegoLink> getGraphLinks(GraphID graphID, Set<LinkID> linkIDs, boolean ignoreMissing) {
        HashSet<MaltegoLink> links = new HashSet<MaltegoLink>();
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            GraphDataStoreReader dataStoreReader = graphStore.getGraphDataStore().getDataStoreReader();
            for (LinkID linkID : linkIDs) {
                if (structureReader.exists(linkID)) {
                    links.add(dataStoreReader.getLink(linkID));
                    continue;
                }
                String msg = "Link does not exist with id: " + linkID;
                if (!ignoreMissing) {
                    throw new IllegalArgumentException(msg);
                }
                Logger.getLogger(GraphTransactionHelper.class.getName()).warning(msg);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return links;
    }

    public static Set<MaltegoLink> getGraphLinkClones(D graph, Set<LinkID> linkIDs, boolean ignoreMissing) {
        HashSet<MaltegoLink> clones = new HashSet<MaltegoLink>();
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((D)graph);
        for (LinkID linkID : linkIDs) {
            MaltegoLink graphLink = wrapper.getLink(linkID);
            if (graphLink != null) {
                clones.add(graphLink.createClone());
                continue;
            }
            String msg = "Link does not exist with id: " + linkID;
            if (!ignoreMissing) {
                throw new IllegalArgumentException(msg);
            }
            Logger.getLogger(GraphTransactionHelper.class.getName()).warning(msg);
        }
        return clones;
    }

    public static Set<MaltegoLink> getLinks(D graph, Set<EntityID> entityIDs) {
        HashSet<MaltegoLink> links = new HashSet<MaltegoLink>();
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((D)graph);
        for (EntityID entityID : entityIDs) {
            Iterable linkIDs = wrapper.linkIDs(entityID);
            for (LinkID linkID : linkIDs) {
                links.add(wrapper.getLink(linkID));
            }
        }
        return links;
    }

    public static Set<LinkID> getLinkIDs(D graph, Collection<EntityID> entityIDs) {
        HashSet<LinkID> linkIDs = new HashSet<LinkID>();
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((D)graph);
        for (EntityID entityID : entityIDs) {
            if (wrapper.isCollectionNode(entityID)) continue;
            Iterable entityLinkIDs = wrapper.linkIDs(entityID);
            for (LinkID entityLinkID : entityLinkIDs) {
                linkIDs.add(entityLinkID);
            }
        }
        return linkIDs;
    }

    public static void doDeleteEntities(SimilarStrings description, GraphID graphID, Set<EntityID> entityIDs) {
        GraphTransaction transaction = GraphTransactions.deleteEntities(entityIDs);
        GraphTransactionBatch batch = new GraphTransactionBatch(description, true, transaction);
        GraphTransactorRegistry.getDefault().get(graphID).doTransactions(batch);
    }

    public static void doDeleteLinks(SimilarStrings description, GraphID graphID, Set<LinkID> linkIDs) {
        GraphTransaction transaction = GraphTransactions.deleteLinks(linkIDs);
        GraphTransactionBatch batch = new GraphTransactionBatch(description, true, transaction);
        GraphTransactorRegistry.getDefault().get(graphID).doTransactions(batch);
    }

    public static void doDeleteEntitiesAndLinks(SimilarStrings description, GraphID graphID, Set<EntityID> entityIDs, Set<LinkID> linkIDs) {
        GraphTransaction t1 = GraphTransactions.deleteLinks(linkIDs);
        GraphTransaction t2 = GraphTransactions.deleteEntities(entityIDs);
        GraphTransactionBatch batch = new GraphTransactionBatch(description, true, t1, t2);
        GraphTransactorRegistry.getDefault().get(graphID).doTransactions(batch);
    }

    public static void doChangeBookmark(SimilarStrings description, GraphID graphID, Collection<MaltegoEntity> entities, int bookmark) {
        Set entityIDs = GraphStoreHelper.getIds(entities);
        GraphTransactionBatch batch = TransactionBatchFactory.createBookmarkChangeBatch(description, entityIDs, bookmark);
        Collection<EntityUpdate> updates = ModifiedHelper.createEntityUpdates(GraphUser.getUser(graphID), entities);
        if (!updates.isEmpty()) {
            batch.add(GraphTransactions.updateEntitiesAndLinks(updates, Collections.emptySet()));
        }
        GraphTransactorRegistry.getDefault().get(graphID).doTransactions(batch);
    }

    public static void doChangeBookmark(GraphID graphID, Collection<MaltegoEntity> entities, int bookmark) {
        String bookmarkStr = "bookmark";
        if (entities.size() > 1) {
            bookmarkStr = bookmarkStr + "s";
        }
        String entityDescription = GraphTransactionHelper.getDescriptionForEntities(graphID, entities, true);
        String description = String.format("Change %s of %s", bookmarkStr, entityDescription);
        GraphTransactionHelper.doChangeBookmark(new SimilarStrings(description), graphID, entities, bookmark);
    }

    public static void doChangePinned(SimilarStrings description, GraphID graphID, Collection<EntityID> entityIDs, boolean pinned) {
        GraphTransactionBatch batch = new GraphTransactionBatch(description, true, new GraphTransaction[0]);
        ArrayList<EntityUpdate> updates = new ArrayList<EntityUpdate>();
        String user = GraphUser.getUser(graphID);
        HashMap<EntityID, Boolean> pinnedMap = new HashMap<EntityID, Boolean>();
        for (EntityID entityID : entityIDs) {
            EntityUpdate update = ModifiedHelper.createUpdate(user, graphID, entityID);
            if (update == null) {
                update = new EntityUpdate(entityID, GraphStoreHelper.getEntity((GraphID)graphID, (EntityID)entityID).getTypeName());
            }
            updates.add(update);
            pinnedMap.put(entityID, pinned);
        }
        if (!pinnedMap.isEmpty()) {
            batch.add(GraphTransactions.updateEntitiesAndLinks(updates, Collections.emptySet(), pinnedMap));
        }
        GraphTransactorRegistry.getDefault().get(graphID).doTransactions(batch);
    }

    public static void doChangePinned(GraphID graphID, Collection<EntityID> entityIDs, boolean pinned) {
        String pinStr = "pin state";
        if (entityIDs.size() > 1) {
            pinStr = pinStr + "s";
        }
        String entityDescription = GraphTransactionHelper.getDescriptionForEntityIDs(graphID, entityIDs, true);
        String description = String.format("Change %s of %s", pinStr, entityDescription);
        GraphTransactionHelper.doChangePinned(new SimilarStrings(description), graphID, entityIDs, pinned);
    }

    public static void doChangeNotes(D graph, Collection<MaltegoEntity> entities, boolean isShowNotes) {
        ArrayList<EntityUpdate> entityUpdates = new ArrayList<EntityUpdate>();
        for (MaltegoEntity entity : entities) {
            if (isShowNotes == entity.isShowNotes()) continue;
            EntityUpdate entityUpdate = new EntityUpdate(entity);
            entityUpdate.setShowNotes(Boolean.valueOf(isShowNotes));
            ModifiedHelper.addToUpdate(GraphUser.getUser(graph), entity, entityUpdate);
            entityUpdates.add(entityUpdate);
        }
        if (!entityUpdates.isEmpty()) {
            D modelGraph = graph;
            String entityDesc = GraphTransactionHelper.getDescriptionForEntities(modelGraph, entities, true);
            SimilarStrings descriptions = GraphTransactionHelper.getShowNotesDescriptions(isShowNotes, entityDesc);
            GraphTransactionBatch batch = new GraphTransactionBatch(descriptions, true, new GraphTransaction[0]);
            batch.add(GraphTransactions.updateEntitiesAndLinks(entityUpdates, Collections.emptySet()));
            GraphID graphID = GraphIDProvider.forGraph((D)modelGraph);
            GraphTransactorRegistry.getDefault().get(graphID).doTransactions(batch);
        }
    }

    public static void doChangeNotes(D graph, Collection<MaltegoEntity> entities, String notes, boolean isShowNotes) {
        ArrayList<EntityUpdate> entityUpdates = new ArrayList<EntityUpdate>();
        boolean onlyVisibility = true;
        for (MaltegoEntity entity : entities) {
            EntityUpdate entityUpdate = new EntityUpdate(entity);
            boolean update = false;
            if (!notes.equals(entity.getNotes())) {
                entityUpdate.setNotes(notes);
                update = true;
                onlyVisibility = false;
            }
            if (isShowNotes != entity.isShowNotes()) {
                entityUpdate.setShowNotes(Boolean.valueOf(isShowNotes));
                update = true;
            }
            if (!update) continue;
            ModifiedHelper.addToUpdate(GraphUser.getUser(graph), entity, entityUpdate);
            entityUpdates.add(entityUpdate);
        }
        if (!entityUpdates.isEmpty()) {
            D modelGraph = graph;
            String entityDesc = GraphTransactionHelper.getDescriptionForEntities(modelGraph, entities, true);
            SimilarStrings descriptions = onlyVisibility ? GraphTransactionHelper.getShowNotesDescriptions(isShowNotes, entityDesc) : new SimilarStrings("Update notes of " + entityDesc);
            GraphTransactionBatch batch = new GraphTransactionBatch(descriptions, true, new GraphTransaction[0]);
            batch.add(GraphTransactions.updateEntitiesAndLinks(entityUpdates, Collections.emptySet()));
            GraphID graphID = GraphIDProvider.forGraph((D)modelGraph);
            GraphTransactorRegistry.getDefault().get(graphID).doTransactions(batch);
        }
    }

    private static SimilarStrings getShowNotesDescriptions(boolean isShowNotes, String entityDesc) {
        String show = "Show";
        String hide = "Hide";
        String doArg = isShowNotes ? show : hide;
        String undoArg = isShowNotes ? hide : show;
        SimilarStrings descriptions = new SimilarStrings("%s notes for " + entityDesc, doArg, undoArg);
        return descriptions;
    }

    public static void updateViewGraphs(GraphID graphID) {
        D modelGraph = MaltegoGraphManager.getWrapper((GraphID)graphID).getGraph();
        Set<D> viewGraphs = Collections.singleton(modelGraph);
        if (viewGraphs != null) {
            for (D viewGraph : viewGraphs) {
                ((SA)viewGraph).\u0107();
            }
        }
    }

    public static List<GraphTransaction> createUpdateTransactions(Map<MaltegoEntity, MaltegoEntity> beforeAfterEntities, Map<MaltegoLink, MaltegoLink> beforeAfterLinks) {
        ArrayList<GraphTransaction> transactions = new ArrayList<GraphTransaction>();
        Collection<EntityUpdate> entityUpdates = GraphTransactionHelper.castEntitiesToUpdates(GraphTransactionHelper.createDeletePropertiesUpdates(beforeAfterEntities));
        Collection<LinkUpdate> linkUpdates = GraphTransactionHelper.castLinksToUpdates(GraphTransactionHelper.createDeletePropertiesUpdates(beforeAfterLinks));
        if (!entityUpdates.isEmpty() || !linkUpdates.isEmpty()) {
            transactions.add(GraphTransactions.deleteProperties(entityUpdates, linkUpdates));
        }
        entityUpdates = GraphTransactionHelper.castEntitiesToUpdates(GraphTransactionHelper.createAddPropertiesUpdates(beforeAfterEntities));
        linkUpdates = GraphTransactionHelper.castLinksToUpdates(GraphTransactionHelper.createAddPropertiesUpdates(beforeAfterLinks));
        if (!entityUpdates.isEmpty() || !linkUpdates.isEmpty()) {
            transactions.add(GraphTransactions.addProperties(entityUpdates, linkUpdates));
        }
        entityUpdates = GraphTransactionHelper.createEntityUpdates(beforeAfterEntities);
        linkUpdates = GraphTransactionHelper.createLinkUpdates(beforeAfterLinks);
        if (!entityUpdates.isEmpty() || !linkUpdates.isEmpty()) {
            transactions.add(GraphTransactions.updateEntitiesAndLinks(entityUpdates, linkUpdates));
        }
        return transactions;
    }

    public static List<GraphTransaction> createUpdateTransactions(MaltegoEntity before, MaltegoEntity after) {
        ArrayList<GraphTransaction> transactions = new ArrayList<GraphTransaction>();
        EntityUpdate update = (EntityUpdate)GraphTransactionHelper.createDeletePropertiesUpdate(before, after);
        if (update != null) {
            transactions.add(GraphTransactions.deleteProperties(Collections.singleton(update), Collections.emptySet()));
        }
        if ((update = (EntityUpdate)GraphTransactionHelper.createAddPropertiesUpdate(before, after)) != null) {
            transactions.add(GraphTransactions.addProperties(Collections.singleton(update), Collections.emptySet()));
        }
        if ((update = GraphTransactionHelper.createEntityUpdate(before, after)) != null) {
            transactions.add(GraphTransactions.updateEntitiesAndLinks(Collections.singleton(update), Collections.emptySet()));
        }
        return transactions;
    }

    public static List<GraphTransaction> createUpdateTransactions(MaltegoLink before, MaltegoLink after) {
        ArrayList<GraphTransaction> transactions = new ArrayList<GraphTransaction>();
        LinkUpdate update = (LinkUpdate)GraphTransactionHelper.createDeletePropertiesUpdate(before, after);
        if (update != null) {
            transactions.add(GraphTransactions.deleteProperties(Collections.emptySet(), Collections.singleton(update)));
        }
        if ((update = (LinkUpdate)GraphTransactionHelper.createAddPropertiesUpdate(before, after)) != null) {
            transactions.add(GraphTransactions.addProperties(Collections.emptySet(), Collections.singleton(update)));
        }
        if ((update = GraphTransactionHelper.createLinkUpdate(before, after)) != null) {
            transactions.add(GraphTransactions.updateEntitiesAndLinks(Collections.emptySet(), Collections.singleton(update)));
        }
        return transactions;
    }

    public static Collection<EntityUpdate> createEntityUpdates(Map<MaltegoEntity, MaltegoEntity> beforeAfterEntities) {
        ArrayList<EntityUpdate> entityUpdates = new ArrayList<EntityUpdate>();
        for (Map.Entry<MaltegoEntity, MaltegoEntity> entry : beforeAfterEntities.entrySet()) {
            MaltegoEntity after;
            MaltegoEntity before = entry.getKey();
            if (before.isCopy((MaltegoPart)(after = entry.getValue()))) continue;
            entityUpdates.add(GraphTransactionHelper.createEntityUpdate(before, after));
        }
        return entityUpdates;
    }

    public static EntityUpdate createEntityUpdate(MaltegoEntity before, MaltegoEntity after) {
        EntityUpdate entityUpdate = new EntityUpdate(after);
        GraphTransactionHelper.populatePartUpdate((MaltegoPart<? extends Guid>)entityUpdate, (MaltegoPart<? extends Guid>)before, (MaltegoPart<? extends Guid>)after);
        if (!Utilities.compareObjects((Object)before.getImageExpression(), (Object)after.getImageExpression())) {
            entityUpdate.setImageExpression(after.getImageExpression().orElse(""));
        }
        if (before.getWeight() != after.getWeight()) {
            entityUpdate.setWeight(Integer.valueOf(after.getWeight()));
        }
        return entityUpdate;
    }

    public static GraphTransaction createEntityUpdateTransaction(MaltegoEntity before, MaltegoEntity after) {
        EntityUpdate update = GraphTransactionHelper.createEntityUpdate(before, after);
        return GraphTransactions.updateEntitiesAndLinks(Collections.singleton(update), Collections.emptySet());
    }

    public static Collection<LinkUpdate> createLinkUpdates(Map<MaltegoLink, MaltegoLink> beforeAfterLinks) {
        ArrayList<LinkUpdate> linkUpdates = new ArrayList<LinkUpdate>();
        for (Map.Entry<MaltegoLink, MaltegoLink> entry : beforeAfterLinks.entrySet()) {
            MaltegoLink after;
            MaltegoLink before = entry.getKey();
            if (before.isCopy((MaltegoPart)(after = entry.getValue()))) continue;
            linkUpdates.add(GraphTransactionHelper.createLinkUpdate(before, after));
        }
        return linkUpdates;
    }

    public static GraphTransaction createLinkUpdateTransaction(MaltegoLink before, MaltegoLink after) {
        LinkUpdate update = GraphTransactionHelper.createLinkUpdate(before, after);
        return GraphTransactions.updateEntitiesAndLinks(Collections.emptySet(), Collections.singleton(update));
    }

    public static LinkUpdate createLinkUpdate(MaltegoLink before, MaltegoLink after) {
        LinkUpdate linkUpdate = new LinkUpdate(after);
        GraphTransactionHelper.populatePartUpdate((MaltegoPart<? extends Guid>)linkUpdate, (MaltegoPart<? extends Guid>)before, (MaltegoPart<? extends Guid>)after);
        if (!Utilities.compareObjects((Object)before.isReversed(), (Object)after.isReversed())) {
            linkUpdate.setReversed(after.isReversed());
        }
        return linkUpdate;
    }

    private static void populatePartUpdate(MaltegoPart<? extends Guid> partUpdate, MaltegoPart<? extends Guid> before, MaltegoPart<? extends Guid> after) {
        DisplayInformationCollection afterDisplayInfo;
        String afterNotes;
        String beforeNotes;
        if (!Utilities.compareObjects((Object)before.getValueProperty(), (Object)after.getValueProperty())) {
            partUpdate.setValueProperty(after.getValueProperty());
        }
        if (!Utilities.compareObjects((Object)before.getDisplayValueExpression(), (Object)after.getDisplayValueExpression())) {
            partUpdate.setDisplayValueExpression((String)after.getDisplayValueExpression().orElse(null));
        }
        if (!(Utilities.compareObjects((Object)(beforeNotes = before.getNotes()), (Object)(afterNotes = after.getNotes())) || StringUtilities.isNullOrEmpty((String)beforeNotes) && StringUtilities.isNullOrEmpty((String)afterNotes))) {
            partUpdate.setNotes(afterNotes != null ? afterNotes : "");
        }
        if (before.isShowNotes() != after.isShowNotes()) {
            partUpdate.setShowNotes(Boolean.valueOf(after.isShowNotes()));
        }
        if (before.getBookmark() != after.getBookmark()) {
            partUpdate.setBookmark(Integer.valueOf(after.getBookmark()));
        }
        if (!(afterDisplayInfo = after.getOrCreateDisplayInformation()).isCopy(before.getOrCreateDisplayInformation())) {
            partUpdate.setDisplayInformation(afterDisplayInfo);
        }
        PropertyDescriptorSet beforeProperties = (PropertyDescriptorSet)before.getProperties();
        PropertyDescriptorSet afterProperties = (PropertyDescriptorSet)after.getProperties();
        for (PropertyDescriptor pd : beforeProperties) {
            PropertyDescriptor afterPd = afterProperties.get(pd.getName());
            if (afterPd == null) continue;
            Object afterValue = after.getValue(pd);
            if (pd.getType().equals(afterPd.getType()) && Utilities.compareObjects((Object)before.getValue(pd), (Object)afterValue)) continue;
            partUpdate.addProperty(afterPd);
            partUpdate.setValue(afterPd, afterValue, false, false);
        }
        if (Utilities.compareObjects((Object)before.getTypeName(), (Object)after.getTypeName()) && partUpdate.getProperties().isEmpty()) {
            partUpdate.setTypeName(null);
        }
    }

    public static <ID extends Guid, T extends MaltegoPart<ID>> Collection<T> createAddPropertiesUpdates(Map<T, T> beforeAfter) {
        HashSet<MaltegoPart> updates = new HashSet<MaltegoPart>();
        for (Map.Entry<T, T> entry : beforeAfter.entrySet()) {
            MaltegoPart after;
            MaltegoPart before = (MaltegoPart)entry.getKey();
            MaltegoPart update = GraphTransactionHelper.createAddPropertiesUpdate(before, after = (MaltegoPart)entry.getValue());
            if (update == null) continue;
            updates.add(update);
        }
        return updates;
    }

    public static <ID extends Guid, T extends MaltegoPart<ID>> T createAddPropertiesUpdate(T before, T after) {
        Object update = null;
        PropertyDescriptorSet beforeProperties = (PropertyDescriptorSet)before.getProperties();
        PropertyDescriptorSet afterProperties = (PropertyDescriptorSet)after.getProperties();
        ArrayList<PropertyDescriptor> addedProperties = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor pd : afterProperties) {
            if (beforeProperties.contains(pd)) continue;
            addedProperties.add(pd);
        }
        if (addedProperties.size() > 0) {
            update = before instanceof MaltegoEntity ? new EntityUpdate((MaltegoEntity)after) : new LinkUpdate((MaltegoLink)after);
            for (PropertyDescriptor pd : addedProperties) {
                update.addProperty(pd);
                update.setValue(pd, after.getValue(pd), false, false);
            }
        }
        return (T)update;
    }

    public static <ID extends Guid, T extends MaltegoPart<ID>> Collection<T> createDeletePropertiesUpdates(Map<T, T> beforeAfter) {
        HashSet<MaltegoPart> updates = new HashSet<MaltegoPart>();
        for (Map.Entry<T, T> entry : beforeAfter.entrySet()) {
            MaltegoPart after;
            MaltegoPart before = (MaltegoPart)entry.getKey();
            MaltegoPart update = GraphTransactionHelper.createDeletePropertiesUpdate(before, after = (MaltegoPart)entry.getValue());
            if (update == null) continue;
            updates.add(update);
        }
        return updates;
    }

    public static <ID extends Guid, T extends MaltegoPart<ID>> T createDeletePropertiesUpdate(T before, T after) {
        Object update = null;
        PropertyDescriptorSet beforeProperties = (PropertyDescriptorSet)before.getProperties();
        PropertyDescriptorSet afterProperties = (PropertyDescriptorSet)after.getProperties();
        ArrayList<PropertyDescriptor> deletedProperties = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor pd : beforeProperties) {
            if (afterProperties.contains(pd)) continue;
            deletedProperties.add(pd);
        }
        if (deletedProperties.size() > 0) {
            update = before instanceof MaltegoEntity ? new EntityUpdate((MaltegoEntity)after) : new LinkUpdate((MaltegoLink)after);
            for (PropertyDescriptor pd : deletedProperties) {
                update.addProperty(pd);
            }
        }
        return (T)update;
    }

    public static void doEntityChanged(GraphID graphID, SimilarStrings description, MaltegoEntity before, MaltegoEntity after) {
        GraphTransactionBatch batch = TransactionBatchFactory.createEntityUpdateBatch(description, before, after);
        if (!batch.isEmpty()) {
            GraphTransactorRegistry.getDefault().get(graphID).doTransactions(batch);
        }
    }

    public static void doEntitiesChanged(GraphID graphID, SimilarStrings description, Map<MaltegoEntity, MaltegoEntity> beforeAfterEntities) {
        GraphTransactionBatch batch = TransactionBatchFactory.createUpdateBatch(description, beforeAfterEntities, Collections.emptyMap());
        if (!batch.isEmpty()) {
            GraphTransactorRegistry.getDefault().get(graphID).doTransactions(batch);
        }
    }

    public static void commitLayoutChanges(SimilarStrings description, SA viewGraph2D, Set<EntityID> entitiesAfter, Map<EntityID, Point> centersBefore, Map<LinkID, List<Point>> pathsBefore, boolean isSignificant) {
        GraphTransactionHelper.commitLayoutChanges(description, viewGraph2D, entitiesAfter, centersBefore, pathsBefore, null, isSignificant);
    }

    public static void commitLayoutChanges(SimilarStrings description, SA viewGraph2D, Set<EntityID> entitiesAfter, Map<EntityID, Point> centersBefore, Map<LinkID, List<Point>> pathsBefore, Integer reservedNumber, boolean isSignificant) {
        block9: {
            Map<EntityID, Point> centersAfter = null;
            Map<LinkID, List<Point>> pathsAfter = null;
            Set<LinkID> linksAfter = null;
            try {
                Iterator<EntityID> entityItr = entitiesAfter.iterator();
                while (entityItr.hasNext()) {
                    EntityID entity = entityItr.next();
                    if (centersBefore.containsKey(entity)) continue;
                    entityItr.remove();
                }
                Set<EntityID> entitiesAfterIDs = entitiesAfter;
                centersAfter = GraphPositionAndPathHelper.getViewCenters(viewGraph2D, entitiesAfterIDs);
                pathsAfter = GraphPositionAndPathHelper.getViewPathsForEntities(viewGraph2D, entitiesAfterIDs);
                linksAfter = pathsAfter.keySet();
                Iterator<LinkID> linkItr = linksAfter.iterator();
                while (linkItr.hasNext()) {
                    LinkID linkID = linkItr.next();
                    if (pathsBefore.containsKey(linkID)) continue;
                    linkItr.remove();
                }
                GraphPositionAndPathHelper.removeCentersForMissingEntities(centersBefore, entitiesAfterIDs);
                GraphPositionAndPathHelper.removePathsForMissingLinks(pathsBefore, linksAfter);
                GraphPositionAndPathHelper.removeUnchangedCenters(centersBefore, centersAfter);
                GraphPositionAndPathHelper.removeUnchangedPaths(pathsBefore, pathsAfter);
                if ((centersBefore.isEmpty() || centersAfter.isEmpty()) && (pathsBefore.isEmpty() || pathsAfter.isEmpty())) break block9;
                GraphID graphID = GraphIDProvider.forGraph((SA)viewGraph2D);
                centersBefore = GraphTransactionHelper.toModelEntities(graphID, centersBefore, true);
                centersAfter = GraphTransactionHelper.toModelEntities(graphID, centersAfter, false);
                pathsBefore = GraphTransactionHelper.toModelLinks(graphID, pathsBefore, true);
                pathsAfter = GraphTransactionHelper.toModelLinks(graphID, pathsAfter, false);
                HashSet<EntityUpdate> entityUpdates = new HashSet<EntityUpdate>();
                Set<EntityID> modelEntities = GraphTransactionHelper.toModelEntities(graphID, entitiesAfter);
                for (EntityID entity : modelEntities) {
                    if (!centersAfter.containsKey(entity)) continue;
                    entityUpdates.add(new EntityUpdate(entity));
                }
                HashSet<LinkUpdate> linkUpdates = new HashSet<LinkUpdate>();
                Set<LinkID> modelLinks = GraphTransactionHelper.toModelLinks(graphID, linksAfter);
                for (LinkID linkID : modelLinks) {
                    if (!pathsAfter.containsKey(linkID)) continue;
                    linkUpdates.add(new LinkUpdate(linkID));
                }
                try {
                    GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                    GraphLayoutWriter layoutWriter = graphStore.getGraphLayoutStore().getLayoutWriter();
                    layoutWriter.setCenters(centersAfter);
                    layoutWriter.setPaths(pathsAfter);
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                GraphTransactionBatch batch = TransactionBatchFactory.createPostitionAndPathsBatch(description, (D)viewGraph2D, entityUpdates, linkUpdates, centersAfter, pathsAfter, isSignificant);
                GraphTransactionBatch inverseBatch = TransactionBatchFactory.createPostitionAndPathsBatch(description, (D)viewGraph2D, entityUpdates, linkUpdates, centersBefore, pathsBefore, isSignificant);
                GraphTransactor transactor = GraphTransactorRegistry.getDefault().get(graphID);
                if (reservedNumber != null) {
                    batch.setSequenceNumber(reservedNumber);
                }
                transactor.commitTransactions(batch, inverseBatch);
            }
            catch (NullPointerException ex) {
                LOGGER.log(Level.INFO, "description: {0}", description);
                LOGGER.log(Level.INFO, "viewGraph2D: {0}", viewGraph2D);
                LOGGER.log(Level.INFO, "entitiesAfter: {0}", entitiesAfter);
                LOGGER.log(Level.INFO, "centersBefore: {0}", centersBefore);
                LOGGER.log(Level.INFO, "pathsBefore: {0}", pathsBefore);
                LOGGER.log(Level.INFO, "reservedNumber: {0}", reservedNumber);
                LOGGER.log(Level.INFO, "isSignificant: {0}", isSignificant);
                LOGGER.log(Level.INFO, "centersAfter: {0}", centersAfter);
                LOGGER.log(Level.INFO, "pathsAfter: {0}", pathsAfter);
                LOGGER.log(Level.INFO, "linksAfter: {0}", linksAfter);
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static Set<EntityID> toModelEntities(GraphID graphID, Collection<EntityID> entityIDs) {
        Set modelEntities = null;
        try {
            GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
            GraphModelViewMappings mappings = view.getModelViewMappings();
            modelEntities = mappings.getModelEntities(entityIDs);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return modelEntities;
    }

    private static Map<EntityID, Point> toModelEntities(GraphID graphID, Map<EntityID, Point> centers, boolean useModelCenters) {
        GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
        GraphModelViewMappings mappings = view.getModelViewMappings();
        HashMap<EntityID, Point> modelCenters = new HashMap<EntityID, Point>(centers.size());
        try {
            GraphStore modelStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphLayoutReader modelLayoutReader = modelStore.getGraphLayoutStore().getLayoutReader();
            HashMap<EntityID, Point> entitiesToQuery = new HashMap<EntityID, Point>();
            for (Map.Entry<EntityID, Point> entry : centers.entrySet()) {
                EntityID viewEntity = entry.getKey();
                Point center = entry.getValue();
                Set modelEntities = mappings.getModelEntities(viewEntity);
                boolean queryCenters = useModelCenters && modelEntities.size() != 1;
                for (EntityID modelEntity : modelEntities) {
                    if (queryCenters) {
                        entitiesToQuery.put(modelEntity, center);
                        continue;
                    }
                    modelCenters.put(modelEntity, center);
                }
            }
            if (!entitiesToQuery.isEmpty()) {
                Map collectedEntityCenters = modelLayoutReader.getCenters(entitiesToQuery.keySet());
                for (Map.Entry otherEntry : collectedEntityCenters.entrySet()) {
                    EntityID modelEntity = (EntityID)otherEntry.getKey();
                    Point modelCenter = (Point)otherEntry.getValue();
                    modelCenters.put(modelEntity, modelCenter != null ? modelCenter : (Point)entitiesToQuery.get(modelEntity));
                }
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return modelCenters;
    }

    private static Set<LinkID> toModelLinks(GraphID graphID, Collection<LinkID> linkIDs) {
        Set modelLinks = null;
        try {
            GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
            GraphModelViewMappings mappings = view.getModelViewMappings();
            modelLinks = mappings.getModelLinks(linkIDs);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return modelLinks;
    }

    private static Map<LinkID, List<Point>> toModelLinks(GraphID graphID, Map<LinkID, List<Point>> paths, boolean useModelPaths) {
        GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
        GraphModelViewMappings mappings = view.getModelViewMappings();
        HashMap<LinkID, List<Point>> modelPaths = new HashMap<LinkID, List<Point>>(paths.size());
        try {
            GraphStore modelStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphLayoutReader modelLayoutReader = modelStore.getGraphLayoutStore().getLayoutReader();
            HashMap<LinkID, List<Point>> linksToQuery = new HashMap<LinkID, List<Point>>();
            for (Map.Entry<LinkID, List<Point>> entry : paths.entrySet()) {
                LinkID viewLink = entry.getKey();
                List<Point> path = entry.getValue();
                Set modelLinks = mappings.getModelLinks(viewLink);
                boolean queryPaths = useModelPaths && modelLinks.size() != 1;
                for (LinkID modelLink : modelLinks) {
                    if (queryPaths) {
                        linksToQuery.put(modelLink, path);
                        continue;
                    }
                    modelPaths.put(modelLink, path);
                }
            }
            if (!linksToQuery.isEmpty()) {
                Map collectedEntityPaths = modelLayoutReader.getPaths(linksToQuery.keySet());
                for (Map.Entry otherEntry : collectedEntityPaths.entrySet()) {
                    LinkID modelLink = (LinkID)otherEntry.getKey();
                    List modelPath = (List)otherEntry.getValue();
                    modelPaths.put(modelLink, modelPath != null ? modelPath : (List)linksToQuery.get(modelLink));
                }
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return modelPaths;
    }

    public static <K, V> HashMap<V, K> reverse(Map<K, V> map) {
        HashMap<V, K> rev = new HashMap<V, K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            rev.put(entry.getValue(), entry.getKey());
        }
        return rev;
    }

    public static List<MaltegoEntity> cloneEntities(Collection<MaltegoEntity> entities) {
        ArrayList<MaltegoEntity> clones = new ArrayList<MaltegoEntity>(entities.size());
        for (MaltegoEntity entity : entities) {
            clones.add(entity.createClone());
        }
        return clones;
    }

    public static List<MaltegoLink> cloneLinks(Collection<MaltegoLink> links) {
        ArrayList<MaltegoLink> clones = new ArrayList<MaltegoLink>(links.size());
        for (MaltegoLink link : links) {
            clones.add(link.createClone());
        }
        return clones;
    }

    public static <T> Map<LinkID, T> convertLinksToGuids(Map<? extends MaltegoLink, T> linkEntities) {
        HashMap<Guid, T> entitiesForGuid = new HashMap<Guid, T>(linkEntities.size());
        for (Map.Entry<MaltegoLink, T> entry : linkEntities.entrySet()) {
            entitiesForGuid.put(entry.getKey().getID(), entry.getValue());
        }
        return entitiesForGuid;
    }

    public static Collection<EntityUpdate> castEntitiesToUpdates(Collection<MaltegoEntity> entities) {
        return entities;
    }

    public static Collection<LinkUpdate> castLinksToUpdates(Collection<MaltegoLink> links) {
        return links;
    }

    public static String getDescriptionForEntitiesItr(D modelGraph, Iterable<MaltegoEntity> entities, boolean escape) {
        HashSet<MaltegoEntity> entitySet = new HashSet<MaltegoEntity>();
        for (MaltegoEntity entity : entities) {
            entitySet.add(entity);
        }
        return GraphTransactionHelper.getDescriptionForEntities(modelGraph, entitySet, escape);
    }

    public static String getDescriptionForEntitiesItr(GraphID graphID, Iterable<MaltegoEntity> entities, boolean escape) {
        HashSet<MaltegoEntity> entitySet = new HashSet<MaltegoEntity>();
        for (MaltegoEntity entity : entities) {
            entitySet.add(entity);
        }
        return GraphTransactionHelper.getDescriptionForEntities(graphID, entitySet, escape);
    }

    public static String getDescriptionForEntityIDs(D modelGraph, Collection<EntityID> entityIDs, boolean escape) {
        GraphID graphID = GraphIDProvider.forGraph((D)modelGraph);
        return GraphTransactionHelper.getDescriptionForEntityIDs(graphID, entityIDs, escape);
    }

    public static String getDescriptionForEntityIDs(GraphID graphID, Collection<EntityID> entityIDs, boolean escape) {
        String description;
        int count = entityIDs.size();
        if (count == 1) {
            MaltegoEntity entity = GraphStoreHelper.getEntity((GraphID)graphID, (EntityID)entityIDs.iterator().next());
            description = GraphTransactionHelper.getDescriptionForEntity(graphID, entity, escape);
        } else {
            description = count + " entities";
        }
        return description;
    }

    public static String getDescriptionForEntities(D modelGraph, Collection<MaltegoEntity> entities, boolean escape) {
        String description;
        int count = entities.size();
        if (count == 1) {
            MaltegoEntity entity = entities.iterator().next();
            description = GraphTransactionHelper.getDescriptionForEntity(modelGraph, entity, escape);
        } else {
            description = count + " entities";
        }
        return description;
    }

    public static String getDescriptionForEntities(GraphID graphID, Collection<MaltegoEntity> entities, boolean escape) {
        String description;
        int count = entities.size();
        if (count == 1) {
            MaltegoEntity entity = entities.iterator().next();
            description = GraphTransactionHelper.getDescriptionForEntity(graphID, entity, escape);
        } else {
            description = count + " entities";
        }
        return description;
    }

    public static String getDescriptionForEntity(GraphID graphID, MaltegoEntity entity, boolean escape) {
        return GraphTransactionHelper.getDescriptionForEntity(EntityRegistry.forGraphID((GraphID)graphID), entity, escape);
    }

    public static String getDescriptionForEntity(D modelGraph, MaltegoEntity entity, boolean escape) {
        return GraphTransactionHelper.getDescriptionForEntity(EntityRegistry.forGraph((D)modelGraph), entity, escape);
    }

    private static String getDescriptionForEntity(EntityRegistry registry, MaltegoEntity entity, boolean escape) {
        String description = "entity";
        String displayName = InheritanceHelper.getDisplayString((SpecRegistry)registry, (TypedPropertyBag)entity);
        if (!StringUtilities.isNullOrEmpty((String)displayName)) {
            description = description + " \"" + GraphTransactionHelper.shorten(displayName, 35) + "\"";
        }
        return escape ? SimilarStrings.escape((String)description) : description;
    }

    public static String getDescriptionForLinkIDs(GraphID graphID, Collection<LinkID> linkIDs, boolean escape) {
        String description;
        int count = linkIDs.size();
        if (count == 1) {
            MaltegoLink link = GraphStoreHelper.getLink((GraphID)graphID, (LinkID)linkIDs.iterator().next());
            description = GraphTransactionHelper.getDescriptionForLink(graphID, link, escape);
        } else {
            description = count + " links";
        }
        return description;
    }

    public static String getDescriptionForLinkIDs(D modelGraph, Collection<LinkID> linkIDs, boolean escape) {
        String description;
        int count = linkIDs.size();
        if (count == 1) {
            MaltegoLink link = GraphStoreHelper.getLink((D)modelGraph, (LinkID)linkIDs.iterator().next());
            description = GraphTransactionHelper.getDescriptionForLink(modelGraph, link, escape);
        } else {
            description = count + " links";
        }
        return description;
    }

    public static String getDescriptionForLinks(D modelGraph, Collection<MaltegoLink> links, boolean escape) {
        String description;
        int count = links.size();
        if (count == 1) {
            MaltegoLink link = links.iterator().next();
            description = GraphTransactionHelper.getDescriptionForLink(modelGraph, link, escape);
        } else {
            description = count + " links";
        }
        return description;
    }

    public static String getDescriptionForLinks(GraphID graphID, Collection<MaltegoLink> links, boolean escape) {
        String description;
        int count = links.size();
        if (count == 1) {
            MaltegoLink link = links.iterator().next();
            description = GraphTransactionHelper.getDescriptionForLink(graphID, link, escape);
        } else {
            description = count + " links";
        }
        return description;
    }

    public static String getDescriptionForLink(GraphID graphID, MaltegoLink link, boolean escape) {
        return GraphTransactionHelper.getDescriptionForLink(LinkRegistry.forGraphID((GraphID)graphID), link, escape);
    }

    public static String getDescriptionForLink(D modelGraph, MaltegoLink link, boolean escape) {
        return GraphTransactionHelper.getDescriptionForLink(LinkRegistry.forGraph((D)modelGraph), link, escape);
    }

    private static String getDescriptionForLink(LinkRegistry registry, MaltegoLink link, boolean escape) {
        String description = "link";
        String displayName = InheritanceHelper.getDisplayString((SpecRegistry)registry, (TypedPropertyBag)link);
        if (!StringUtilities.isNullOrEmpty((String)displayName)) {
            description = description + " \"" + GraphTransactionHelper.shorten(displayName, 35) + "\"";
        }
        return escape ? SimilarStrings.escape((String)description) : description;
    }

    private static String shorten(String text, int length) {
        if (text.length() > length) {
            text = text.substring(0, length - 3) + "...";
        }
        return text;
    }

    public static Map<LinkID, LinkEntityIDs> getLinkEntities(GraphTransaction transaction) {
        HashMap<LinkID, LinkEntityIDs> linkEntities = new HashMap<LinkID, LinkEntityIDs>();
        for (LinkID linkID : transaction.getLinkIDs()) {
            EntityID sourceID = transaction.getSourceID(linkID);
            EntityID targetID = transaction.getTargetID(linkID);
            if (sourceID == null || targetID == null) continue;
            linkEntities.put(linkID, new LinkEntityIDs(sourceID, targetID));
        }
        return linkEntities;
    }

    public static GraphTransaction removeExisting(GraphID graphID, GraphTransaction transaction) {
        return GraphTransactionHelper.removeIf(graphID, transaction, true);
    }

    public static GraphTransaction removeMissing(GraphID graphID, GraphTransaction transaction) {
        return GraphTransactionHelper.removeIf(graphID, transaction, false);
    }

    public static GraphTransaction removeIf(GraphID graphID, GraphTransaction transaction, boolean exist) {
        try {
            boolean addIfExist = !exist;
            ArrayList<MaltegoEntity> entities = new ArrayList<MaltegoEntity>();
            ArrayList<MaltegoLink> links = new ArrayList<MaltegoLink>();
            HashMap<LinkID, LinkEntityIDs> linkEntities = new HashMap<LinkID, LinkEntityIDs>();
            HashMap<String, Map<EntityID, Point>> tCenters = new HashMap<String, Map<EntityID, Point>>();
            HashMap<String, Map<LinkID, List<Point>>> tPaths = new HashMap<String, Map<LinkID, List<Point>>>();
            HashMap<EntityID, Boolean> pinned = transaction.getPinned() != null ? new HashMap<EntityID, Boolean>() : null;
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            for (EntityID entityID : transaction.getEntityIDs()) {
                Boolean pinState;
                if (structureReader.exists(entityID) != addIfExist) continue;
                entities.add(transaction.getEntity(entityID));
                for (String view : transaction.getViews()) {
                    Point center = transaction.getCenter(view, entityID);
                    if (center == null) continue;
                    HashMap<EntityID, Point> points = (HashMap<EntityID, Point>)tCenters.get(view);
                    if (points == null) {
                        points = new HashMap<EntityID, Point>();
                        tCenters.put(view, points);
                    }
                    points.put(entityID, center);
                }
                if (pinned == null || (pinState = transaction.getPinned().get(entityID)) == null) continue;
                pinned.put(entityID, pinState);
            }
            for (LinkID linkID : transaction.getLinkIDs()) {
                if (structureReader.exists(linkID) != addIfExist) continue;
                links.add(transaction.getLink(linkID));
                EntityID sourceID = transaction.getSourceID(linkID);
                EntityID targetID = transaction.getTargetID(linkID);
                if (sourceID != null && targetID != null) {
                    linkEntities.put(linkID, new LinkEntityIDs(sourceID, targetID));
                }
                for (String view : transaction.getViews()) {
                    List<Point> path = transaction.getPath(view, linkID);
                    if (path == null) continue;
                    HashMap<LinkID, List<Point>> points = (HashMap<LinkID, List<Point>>)tPaths.get(view);
                    if (points == null) {
                        points = new HashMap<LinkID, List<Point>>();
                        tPaths.put(view, points);
                    }
                    points.put(linkID, path);
                }
            }
            return GraphTransactions.create(transaction.getOperation(), entities, links, tCenters, tPaths, linkEntities, pinned, transaction.needsLayout());
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return transaction;
        }
    }

    public static GraphTransaction removeExistingProperties(D graph, GraphTransaction transaction) {
        MaltegoEntity clone;
        if (transaction.getOperation() != GraphOperation.AddProperties) {
            throw new IllegalArgumentException("Transaction must add properties");
        }
        ArrayList<MaltegoEntity> entities = new ArrayList<MaltegoEntity>();
        ArrayList<MaltegoEntity> links = new ArrayList<MaltegoEntity>();
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((D)graph);
        for (EntityID entityID : transaction.getEntityIDs()) {
            clone = transaction.getEntity(entityID).createClone();
            MaltegoEntity graphEntity = wrapper.getEntity((EntityID)clone.getID());
            GraphTransactionHelper.removeExistingProperties((MaltegoPart<? extends Guid>)clone, (MaltegoPart<? extends Guid>)graphEntity);
            if (clone.getProperties().isEmpty()) continue;
            entities.add(clone);
        }
        for (LinkID linkID : transaction.getLinkIDs()) {
            clone = transaction.getLink(linkID).createClone();
            MaltegoLink graphLink = wrapper.getLink((LinkID)clone.getID());
            GraphTransactionHelper.removeExistingProperties((MaltegoPart<? extends Guid>)clone, (MaltegoPart<? extends Guid>)graphLink);
            if (clone.getProperties().isEmpty()) continue;
            links.add(clone);
        }
        return GraphTransactions.create(transaction.getOperation(), entities, links, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), null, transaction.needsLayout());
    }

    private static void removeExistingProperties(MaltegoPart<? extends Guid> part, MaltegoPart<? extends Guid> graphPart) {
        PropertyDescriptorCollection properties = part.getProperties();
        Iterator itr = properties.iterator();
        while (itr.hasNext()) {
            PropertyDescriptor pd = (PropertyDescriptor)itr.next();
            if (!graphPart.getProperties().contains(pd)) continue;
            itr.remove();
        }
    }

    public static GraphTransaction removeWrongTypeProperties(D graph, GraphTransaction transaction) {
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((D)graph);
        for (EntityID entityID : transaction.getEntityIDs()) {
            MaltegoEntity graphEntity = wrapper.getEntity(entityID);
            MaltegoEntity transactionEntity = transaction.getEntity(entityID);
            GraphTransactionHelper.removeWrongTypeProperties((MaltegoPart<? extends Guid>)transactionEntity, (MaltegoPart<? extends Guid>)graphEntity);
        }
        for (LinkID linkID : transaction.getLinkIDs()) {
            MaltegoLink graphLink = wrapper.getLink(linkID);
            MaltegoLink transactionLink = transaction.getLink(linkID);
            GraphTransactionHelper.removeWrongTypeProperties((MaltegoPart<? extends Guid>)transactionLink, (MaltegoPart<? extends Guid>)graphLink);
        }
        return transaction;
    }

    private static void removeWrongTypeProperties(MaltegoPart<? extends Guid> part, MaltegoPart<? extends Guid> graphPart) {
        PropertyDescriptorCollection graphProperties = graphPart.getProperties();
        PropertyDescriptorCollection properties = part.getProperties();
        Iterator itr = properties.iterator();
        while (itr.hasNext()) {
            PropertyDescriptor pd = (PropertyDescriptor)itr.next();
            PropertyDescriptor graphPd = graphProperties.get(pd.getName());
            if (graphPd == null || graphPd.getType().equals(pd.getType())) continue;
            itr.remove();
        }
    }
}

