/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.server;

import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BadMessageException;
import org.xlightweb.BodyDataSink;
import org.xlightweb.HttpResponse;
import org.xlightweb.HttpResponseHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IBodyDataHandler;
import org.xlightweb.IHttpConnection;
import org.xlightweb.IHttpConnectionHandler;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpMessage;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpRequestTimeoutHandler;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.IHttpSession;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.RequestHandlerInfo;
import org.xlightweb.ResponseHandlerInfo;
import org.xlightweb.server.HttpSession;
import org.xlightweb.server.ISessionManager;
import org.xlightweb.server.ServerUtils;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.INonBlockingConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpServerConnection
extends AbstractHttpConnection {
    private static final Logger LOG = Logger.getLogger(HttpServerConnection.class.getName());
    public static final String CALL_DEREGISTER_HANDLER_KEY = "org.xsocket.connection.http.server.call.deregisterHandler";
    public static final String CALL_DEREGISTER_HANDLER_DEFAULT = "false";
    private static boolean deregisterHandle = Boolean.parseBoolean(System.getProperty("org.xsocket.connection.http.server.call.deregisterHandler", "false"));
    public static final boolean DEFAULT_REMOVE_REQUEST_CONNECTION_HEADER = false;
    public static final Integer DEFAULT_RECEIVE_TIMEOUT_MILLIS = Integer.MAX_VALUE;
    public static final boolean DEFAULT_AUTOCONFIRM_EXPECT_100CONTINUE_HEADER = true;
    public static final boolean DEFAULT_AUTOHANDLE_CONNECTION_UPGRADE_HEADER = true;
    public static final boolean DEFAULT_SESSION_MANAGEMENT = true;
    static final int MIN_REQUEST_TIMEOUT_MILLIS = 1000;
    private final ConnectionCloser connectionCloser = new ConnectionCloser();
    private boolean isCloseOnSendingError = true;
    private static final long MIN_WATCHDOG_PERIOD_MILLIS = 10000L;
    private TimeoutWatchDogTask watchDogTask;
    private Long requestTimeoutMillis;
    boolean isAutconfirmExpect100ContinueHeader = true;
    boolean isAutohandleUpgadeHeader = true;
    private final ISessionManager sessionManager;
    private final int sessionMaxInactiveIntervalSec;
    private boolean useCookies = true;
    private Integer maxTransactions;
    private final ConcurrentLinkedQueue<IHttpRequest> requestQueue = new ConcurrentLinkedQueue();
    private final AbstractHttpConnection.IMessageHandler messageHandler = new MessageHandler();
    private final IHttpRequestHandler requestHandler;
    private final RequestHandlerInfo requestHandlerInfo;

    HttpServerConnection(ISessionManager sessionManager, int defaultMaxInactiveIntervalSec, INonBlockingConnection tcpConnection, IHttpRequestHandler requestHandler, RequestHandlerInfo requestHandlerInfo, boolean isCloseOnSendingError, List<IHttpConnectionHandler> connectionHandlers, boolean useCookies) throws IOException {
        super(tcpConnection, false);
        this.sessionManager = sessionManager;
        this.sessionMaxInactiveIntervalSec = defaultMaxInactiveIntervalSec;
        this.requestHandler = requestHandler;
        this.requestHandlerInfo = requestHandlerInfo;
        this.isCloseOnSendingError = isCloseOnSendingError;
        this.useCookies = useCookies;
        if (connectionHandlers != null) {
            for (IHttpConnectionHandler connectionHandler : connectionHandlers) {
                this.addConnectionHandler(connectionHandler);
            }
        }
        this.init();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] http server connection established");
        }
    }

    public boolean isServerSide() {
        return true;
    }

    public void setMaxTransactions(int maxTransactions) {
        this.maxTransactions = maxTransactions;
    }

    protected static void schedule(TimerTask task, long delay, long period) {
        AbstractHttpConnection.schedule(task, delay, period);
    }

    protected static RequestHandlerInfo getRequestHandlerInfo(IHttpRequestHandler requestHandler) {
        return AbstractHttpConnection.getRequestHandlerInfo(requestHandler);
    }

    protected static ResponseHandlerInfo getResponseHandlerInfo(IHttpResponseHandler responseHandler) {
        return AbstractHttpConnection.getResponseHandlerInfo(responseHandler);
    }

    public void setRequestTimeoutMillis(long requestTimeoutMillis) {
        if (requestTimeoutMillis < 1000L) {
            LOG.warning("try to set request timeout with " + requestTimeoutMillis + " millis. This value will be ignored because it is smaller that " + 1000 + " millis");
        }
        if (requestTimeoutMillis <= 0L) {
            this.performRequestTimeoutHandler();
            return;
        }
        this.setLastTimeDataReceivedMillis(System.currentTimeMillis());
        if (this.requestTimeoutMillis == null || this.requestTimeoutMillis != requestTimeoutMillis) {
            this.requestTimeoutMillis = requestTimeoutMillis;
            if (requestTimeoutMillis == Long.MAX_VALUE) {
                this.terminateWatchDogTask();
            } else {
                long watchdogPeriod = 100L;
                if (requestTimeoutMillis > 1000L) {
                    watchdogPeriod = requestTimeoutMillis / 10L;
                }
                if (watchdogPeriod > 10000L) {
                    watchdogPeriod = 10000L;
                }
                this.updateWatchDog(watchdogPeriod);
            }
        }
    }

    private void checkRequestTimeout(long currentTimeMillis) {
        if (this.requestTimeoutMillis != null) {
            long timeoutReceived = this.getLastTimeDataReceivedMillis() + this.requestTimeoutMillis;
            long timeoutSend = this.getLastTimeWritten() + this.requestTimeoutMillis;
            if (currentTimeMillis > timeoutReceived && currentTimeMillis > timeoutSend) {
                this.onRequestTimeout();
            }
        }
    }

    private void onRequestTimeout() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("request timeout " + DataConverter.toFormatedDuration((long)this.getBodyDataReceiveTimeoutMillis()) + " reached");
        }
        this.terminateWatchDogTask();
        this.performRequestTimeoutHandler();
    }

    private void performRequestTimeoutHandler() {
        if (this.requestHandlerInfo.isRequestTimeoutHandler()) {
            Runnable requestTimeoutHandlerCaller = new Runnable(){

                public void run() {
                    try {
                        boolean isHandled = ((IHttpRequestTimeoutHandler)((Object)HttpServerConnection.this.requestHandler)).onRequestTimeout(HttpServerConnection.this);
                        if (!isHandled) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("request timeout " + DataConverter.toFormatedDuration((long)HttpServerConnection.this.requestTimeoutMillis) + " reached for http server connection. terminate connection (timeout handler returned false)");
                            }
                            HttpServerConnection.this.closeSilence();
                        }
                    }
                    catch (Exception e) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[" + HttpServerConnection.this.getId() + "] error occured by calling on request " + HttpServerConnection.this.requestHandler + " " + e.toString());
                        }
                        HttpServerConnection.this.destroy();
                        throw new RuntimeException(e);
                    }
                }
            };
            if (this.requestHandlerInfo.isRequestTimeoutHandlerMultithreaded()) {
                this.getExecutor().processMultithreaded(requestTimeoutHandlerCaller);
            } else {
                this.getExecutor().processNonthreaded(requestTimeoutHandlerCaller);
            }
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("request timeout  " + DataConverter.toFormatedDuration((long)this.requestTimeoutMillis) + " for http server connection reached. terminate connection");
            }
            this.closeSilence();
        }
    }

    private synchronized void updateWatchDog(long watchDogPeriod) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("update timeout watchdog task period to " + DataConverter.toFormatedDuration((long)watchDogPeriod));
        }
        this.terminateWatchDogTask();
        this.watchDogTask = new TimeoutWatchDogTask(this);
        AbstractHttpConnection.schedule(this.watchDogTask, watchDogPeriod, watchDogPeriod);
    }

    private synchronized void terminateWatchDogTask() {
        if (this.watchDogTask != null) {
            this.watchDogTask.close();
            this.watchDogTask = null;
        }
    }

    @Override
    protected void onProtocolException(Exception ex) {
        if (ex instanceof BadMessageException) {
            this.setPersistent(false);
            try {
                this.send(new HttpResponse(400, "text/html", HttpServerConnection.generateErrorMessageHtml(400, ex.getMessage(), this.getId())));
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("could not send error message 400 reason " + ioe.toString());
                }
                this.destroy();
            }
        } else {
            super.onProtocolException(ex);
        }
    }

    @Override
    protected AbstractHttpConnection.IMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    @Override
    protected void onDisconnect() {
        super.onDisconnect();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] http server connection destroyed");
        }
    }

    private void suspendMessageReceiving() {
        block2: {
            try {
                super.suspendReceiving();
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("[" + this.getId() + "] error occured by suspending read " + ioe.toString());
            }
        }
    }

    private void resumeMessageReceiving() {
        block2: {
            try {
                super.resumeReceiving();
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("[" + this.getId() + "] error occured by resuming read " + ioe.toString());
            }
        }
    }

    private void handleLifeCycleHeaders(IHttpRequest request) {
        String connectionHeader;
        IHttpRequestHeader header = request.getRequestHeader();
        String keepAliveHeader = header.getKeepAlive();
        if (keepAliveHeader != null) {
            String[] tokens;
            for (String token : tokens = keepAliveHeader.split(",")) {
                this.handleKeepAlive(token);
            }
        }
        if ((connectionHeader = header.getConnection()) != null) {
            String[] values;
            for (String value : values = connectionHeader.split(",")) {
                if ((value = value.trim()).equalsIgnoreCase("close")) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("received connection: closed header. destroying connection");
                    }
                    this.setPersistent(false);
                }
                if (!value.equalsIgnoreCase("Keep-Alive")) continue;
                this.setPersistent(true);
            }
        }
    }

    private void handleKeepAlive(String option) {
        Integer timeoutSec = null;
        timeoutSec = option.toUpperCase().startsWith("TIMEOUT=") ? Integer.valueOf(Integer.parseInt(option.substring("TIMEOUT=".length(), option.length()))) : Integer.valueOf(Integer.parseInt(option));
        if (timeoutSec != null && this.getBodyDataReceiveTimeoutMillis() == Long.MAX_VALUE) {
            this.setBodyDataReceiveTimeoutMillis((long)timeoutSec.intValue() * 1000L);
        }
    }

    void processMultithreaded(Runnable task) {
        this.getExecutor().processMultithreaded(task);
    }

    void processNonthreaded(Runnable task) {
        this.getExecutor().processNonthreaded(task);
    }

    private BodyDataSink send(IHttpResponseHeader header) throws IOException {
        try {
            if (deregisterHandle) {
                this.resumeMessageReceiving();
            }
            this.enhanceResponseHeader(header);
            BodyDataSink bodyDataSink = this.writeMessage(header, !this.isPersistent());
            if (!this.isPersistent()) {
                this.setBodyCloseListener(bodyDataSink, this.connectionCloser);
            }
            return bodyDataSink;
        }
        catch (IOException ioe) {
            this.destroy();
            throw ioe;
        }
    }

    private BodyDataSink send(IHttpResponseHeader header, int contentLength) throws IOException {
        try {
            if (deregisterHandle) {
                this.resumeMessageReceiving();
            }
            this.enhanceResponseHeader(header);
            BodyDataSink bodyDataSink = this.writeMessage(header, !this.isPersistent(), contentLength);
            if (!this.isPersistent()) {
                this.setBodyCloseListener(bodyDataSink, this.connectionCloser);
            }
            return bodyDataSink;
        }
        catch (IOException ioe) {
            this.destroy();
            throw ioe;
        }
    }

    public void send(IHttpResponse response) throws IOException {
        try {
            if (deregisterHandle) {
                this.resumeMessageReceiving();
            }
            IHttpResponseHeader responseHeader = response.getResponseHeader();
            this.enhanceResponseHeader(responseHeader);
            if (response.getNonBlockingBody() == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] sending (bodyless): " + response.getResponseHeader());
                }
                if (response.getContentLength() == -1) {
                    response.setContentLength(0);
                }
                BodyDataSink bodyDataSink = this.writeMessage(responseHeader, !this.isPersistent(), 0);
                bodyDataSink.setFlushmode(IConnection.FlushMode.ASYNC);
                bodyDataSink.close();
                if (!this.isPersistent()) {
                    this.closeSilence();
                }
            } else {
                if (response.getNonBlockingBody().getDataHandler() != null) {
                    LOG.warning("a body handler is already assigned to the message body. current body handler will be removed");
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] sending: " + response.getResponseHeader());
                }
                this.writeMessage(response, !this.isPersistent());
            }
        }
        catch (IOException ioe) {
            this.destroy();
            throw ioe;
        }
    }

    private void enhanceResponseHeader(IHttpResponseHeader header) {
        String connectionHeader;
        String server = header.getServer();
        if (server == null) {
            header.setServer(ServerUtils.getComponentInfo());
        }
        int remainingTransactions = 0;
        if (this.maxTransactions != null && (remainingTransactions = this.maxTransactions - this.getCountMessagesReceived()) <= 0) {
            this.setPersistent(false);
        }
        if (this.isPersistent() && header.getConnection() == null && (this.maxTransactions != null || this.requestTimeoutMillis != null)) {
            header.setConnection("Keep-Alive");
            String keepAliveValue = null;
            if (this.maxTransactions != null) {
                keepAliveValue = "max=" + remainingTransactions;
            }
            if (this.requestTimeoutMillis != null) {
                keepAliveValue = keepAliveValue == null ? "timeout=" + this.requestTimeoutMillis / 1000L : keepAliveValue + ", timeout=" + this.requestTimeoutMillis / 1000L;
            }
            header.setHeader("Keep-Alive", keepAliveValue);
        }
        if ((connectionHeader = header.getConnection()) != null && connectionHeader.equalsIgnoreCase("close")) {
            this.setPersistent(false);
        } else if (!this.isPersistent()) {
            header.setConnection("close");
        }
    }

    private HttpSession getSession(IHttpRequest request) throws IOException {
        HttpSession session = null;
        if (this.useCookies) {
            List<String> cookieHeaders = request.getHeaderList("Cookie");
            for (String cookieHeader : cookieHeaders) {
                String[] cookies;
                for (String cookie : cookies = cookieHeader.split(";")) {
                    String sessionId;
                    String name;
                    int idx = (cookie = cookie.trim()).indexOf("=");
                    if (idx == -1 || !(name = cookie.substring(0, idx)).equals("JSESSIONID") || (session = this.sessionManager.getSession(sessionId = cookie.substring(idx + 1, cookie.length()).trim())) == null) continue;
                    return session;
                }
            }
        } else {
            String sessionToken;
            String uri = request.getRequestURI();
            int pos = uri.lastIndexOf(";");
            if (pos != -1 && (sessionToken = uri.substring(pos + 1, uri.length())) != null && sessionToken.startsWith("jsessionid=") && (session = this.sessionManager.getSession(sessionToken.substring("jsessionid=".length(), sessionToken.length()))) != null) {
                return session;
            }
        }
        return null;
    }

    private boolean isLargerOrEquals(String protocolVersion, String otherProtocolVersion) {
        int idx = protocolVersion.indexOf(".");
        int major = Integer.parseInt(protocolVersion.substring(0, idx));
        int minor = Integer.parseInt(protocolVersion.substring(idx + 1, protocolVersion.length()));
        int idxOther = otherProtocolVersion.indexOf(".");
        int majorOther = Integer.parseInt(otherProtocolVersion.substring(0, idxOther));
        int minorOther = Integer.parseInt(otherProtocolVersion.substring(idxOther + 1, otherProtocolVersion.length()));
        if (major > majorOther) {
            return true;
        }
        if (major < majorOther) {
            return false;
        }
        if (minor > minorOther) {
            return true;
        }
        return minor >= minorOther;
    }

    private boolean isContentTypeFormUrlencoded(IHttpMessage message) {
        if (!message.hasBody()) {
            return false;
        }
        String contentType = message.getContentType();
        return contentType != null && contentType.startsWith("application/x-www-form-urlencoded");
    }

    private static final class SessionSynchronizedRequestHandlerWrapper
    implements IHttpRequestHandler {
        private IHttpRequestHandler delegee = null;

        public SessionSynchronizedRequestHandlerWrapper(IHttpRequestHandler delegee) {
            this.delegee = delegee;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRequest(IHttpExchange exchange) throws IOException {
            IHttpSession session = exchange.getSession(false);
            if (session == null) {
                this.delegee.onRequest(exchange);
            } else {
                IHttpSession iHttpSession = session;
                synchronized (iHttpSession) {
                    this.delegee.onRequest(exchange);
                }
            }
        }
    }

    @Execution(value=0)
    private static final class DoNothingResponseHandler
    implements IHttpResponseHandler {
        private DoNothingResponseHandler() {
        }

        public void onResponse(IHttpResponse response) throws IOException {
        }

        public void onException(IOException ioe) throws IOException {
        }
    }

    @Execution(value=0)
    private static final class ForwardingResponseHandler
    implements IHttpResponseHandler {
        private IHttpExchange exchange = null;

        public ForwardingResponseHandler(IHttpExchange exchange) {
            this.exchange = exchange;
        }

        public void onResponse(IHttpResponse response) throws IOException {
            this.exchange.send(response);
        }

        public void onException(IOException ioe) throws IOException {
            this.exchange.sendError(ioe);
        }
    }

    private class ServerExchange
    implements IHttpExchange {
        private final AtomicBoolean isResponseCommitted = new AtomicBoolean(false);
        private IHttpRequest request = null;
        private HttpSession session = null;
        private boolean isSessionCreated = false;

        protected ServerExchange(IHttpRequest request) {
            this.request = request;
            if (!HttpServerConnection.this.sessionManager.isEmtpy()) {
                this.resolveSession();
            }
        }

        public IHttpSession getSession(boolean create) {
            this.resolveSession();
            if (this.session != null) {
                return this.session;
            }
            if (create) {
                this.isSessionCreated = true;
                try {
                    int prefix = this.request.getContextPath().hashCode();
                    this.session = HttpServerConnection.this.sessionManager.getSession(HttpServerConnection.this.sessionManager.newSession(Integer.toHexString(prefix)));
                    this.session.setMaxInactiveInterval(HttpServerConnection.this.sessionMaxInactiveIntervalSec);
                    return this.session;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe.toString());
                }
            }
            return null;
        }

        public String encodeURL(String url) {
            if (HttpServerConnection.this.useCookies) {
                return url;
            }
            int pos = url.indexOf(63);
            if (pos == -1) {
                pos = url.indexOf(35);
            }
            if (pos == -1) {
                return url + ";jsessionid=" + this.session.getId();
            }
            return url.substring(0, pos) + ";jsessionid=" + this.session.getId() + url.substring(pos);
        }

        private void resolveSession() {
            block6: {
                if (this.session != null) {
                    return;
                }
                try {
                    this.session = HttpServerConnection.this.getSession(this.request);
                    if (this.session != null) {
                        String idPrefix = Integer.toHexString(this.request.getContextPath().hashCode());
                        if (this.session.getId().startsWith(idPrefix)) {
                            this.session.setLastAccessTime(System.currentTimeMillis());
                        } else {
                            this.session = null;
                        }
                    }
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block6;
                    LOG.fine("error occured by resolving session " + ioe.toString());
                }
            }
        }

        public final IHttpRequest getRequest() {
            return this.request;
        }

        public IHttpConnection getConnection() {
            return HttpServerConnection.this;
        }

        private final void ensureResponseHasNotBeenCommitted() throws IOException {
            if (this.isResponseCommitted.get()) {
                throw new IOException("response has already been committed");
            }
        }

        public final boolean isResponseCommitted() {
            return this.isResponseCommitted.get();
        }

        protected final void setResponseCommited(boolean isCommitted) {
            this.isResponseCommitted.set(isCommitted);
        }

        public final void destroy() {
            HttpServerConnection.this.destroy();
        }

        public BodyDataSink send(IHttpResponseHeader header) throws IOException {
            this.ensureResponseHasNotBeenCommitted();
            this.handleCookieOnSend(header);
            if (!HttpServerConnection.isAcceptingChunkedResponseBody(this.getRequest())) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("the requestor does not support chunked response messages (request protocol: " + this.getRequest().getProtocol() + "). Converting chunked response into length-defined response.");
                }
                HttpResponseHeader newHeader = new HttpResponseHeader(header.getStatus(), header.getReason());
                newHeader.copyHeaderFrom(header, new String[0]);
                newHeader.setProtocol(this.getRequest().getProtocol());
                newHeader.setHeader("Connection", "close");
                BodyHandlerDecorador bdh = new BodyHandlerDecorador(newHeader);
                return HttpServerConnection.this.newBufferedBodyDataSink(bdh, header.getCharacterEncoding());
            }
            this.setResponseCommited(true);
            assert (header.getContentLength() == -1);
            header.setTransferEncoding("chunked");
            BodyDataSink bodyDataSink = HttpServerConnection.this.send(header);
            return bodyDataSink;
        }

        public BodyDataSink send(IHttpResponseHeader header, int contentLength) throws IOException {
            this.ensureResponseHasNotBeenCommitted();
            this.handleCookieOnSend(header);
            if (!this.getRequest().getProtocolVersion().equals(header.getProtocolVersion()) && HttpServerConnection.this.isLargerOrEquals(header.getProtocolVersion(), this.getRequest().getRequestHeader().getProtocolVersion())) {
                header.setHeader("Connection", "close");
                header.setProtocol(this.getRequest().getProtocol());
            }
            this.setResponseCommited(true);
            BodyDataSink bodyDataSink = HttpServerConnection.this.send(header, contentLength);
            return bodyDataSink;
        }

        public void send(IHttpResponse response) throws IOException {
            this.ensureResponseHasNotBeenCommitted();
            this.handleCookieOnSend(response.getResponseHeader());
            if (!response.getProtocolVersion().equals(this.getRequest().getProtocolVersion())) {
                if (response.getProtocolVersion().equals("0.9") && response.getContentLength() == -1) {
                    HttpResponseHeader header = new HttpResponseHeader(200);
                    header.copyHeaderFrom(response.getResponseHeader(), new String[0]);
                    header.setProtocol(this.getRequest().getProtocol());
                    header.setHeader("Connection", "close");
                    BodyHandlerDecorador bdh = new BodyHandlerDecorador(header);
                    response.getNonBlockingBody().setDataHandler(bdh);
                    return;
                }
                if (HttpServerConnection.this.isLargerOrEquals(response.getResponseHeader().getProtocolVersion(), this.getRequest().getRequestHeader().getProtocolVersion())) {
                    response.getResponseHeader().setProtocol(this.getRequest().getProtocol());
                    response.getResponseHeader().setHeader("Connection", "close");
                }
            }
            this.setResponseCommited(true);
            HttpServerConnection.this.send(response);
        }

        private void handleCookieOnSend(IHttpResponseHeader header) {
            block5: {
                if (this.session != null) {
                    try {
                        HttpServerConnection.this.sessionManager.saveSession(this.session.getId());
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block5;
                        LOG.fine("error occured by saving session " + this.session.getId());
                    }
                }
            }
            if (this.isSessionCreated && HttpServerConnection.this.useCookies) {
                StringBuilder sb = new StringBuilder("JSESSIONID=" + this.session.getId() + ";path=/");
                if (HttpServerConnection.this.isSecure()) {
                    sb.append(";secure");
                }
                header.addHeader("Set-Cookie", sb.toString());
            }
        }

        public BodyDataSink forward(IHttpRequestHeader requestHeader) throws IOException, ConnectException, IllegalStateException {
            return this.forward(requestHeader, (IHttpResponseHandler)new ForwardingResponseHandler(this));
        }

        public BodyDataSink forward(IHttpRequestHeader requestHeader, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
            if (responseHandler == null) {
                responseHandler = new DoNothingResponseHandler();
            }
            BodyDataSink bodyDataSink = HttpServerConnection.this.newEmtpyBodyDataSink();
            HttpServerConnection.this.setBodyCloseListener(bodyDataSink, this.newCloseListener(responseHandler));
            return bodyDataSink;
        }

        public BodyDataSink forward(IHttpRequestHeader requestHeader, int contentLength) throws IOException, ConnectException, IllegalStateException {
            return this.forward(requestHeader, contentLength, new ForwardingResponseHandler(this));
        }

        public BodyDataSink forward(IHttpRequestHeader requestHeader, int contentLength, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
            if (responseHandler == null) {
                responseHandler = new DoNothingResponseHandler();
            }
            BodyDataSink bodyDataSink = HttpServerConnection.this.newEmtpyBodyDataSink();
            HttpServerConnection.this.setBodyCloseListener(bodyDataSink, this.newCloseListener(responseHandler));
            return bodyDataSink;
        }

        private Runnable newCloseListener(final IHttpResponseHandler responseHandler) {
            return new Runnable(){

                public void run() {
                    ServerExchange.this.sendNotHandledError(responseHandler);
                }
            };
        }

        public void forward(IHttpRequest request, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
            if (responseHandler == null) {
                responseHandler = new DoNothingResponseHandler();
            }
            this.sendNotHandledError(responseHandler);
        }

        public void forward(IHttpRequest request) throws IOException, ConnectException, IllegalStateException {
            this.forward(request, (IHttpResponseHandler)new ForwardingResponseHandler(this));
        }

        private void sendNotHandledError(final IHttpResponseHandler responseHandler) {
            try {
                final HttpResponse response = new HttpResponse(404, "text/html", HttpServerConnection.generateErrorMessageHtml(404, null, HttpServerConnection.this.getId()));
                Runnable task = new Runnable(){

                    public void run() {
                        try {
                            responseHandler.onResponse(response);
                        }
                        catch (IOException ioe) {
                            HttpServerConnection.this.closeSilence();
                        }
                    }
                };
                if (HttpServerConnection.getResponseHandlerInfo(responseHandler).isResponseHandlerMultithreaded()) {
                    HttpServerConnection.this.getExecutor().processMultithreaded(task);
                } else {
                    HttpServerConnection.this.getExecutor().processNonthreaded(task);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.toString());
            }
        }

        public void sendError(Exception e) {
            int code = 500;
            if (e instanceof BadMessageException) {
                code = 400;
            }
            if (HttpUtils.isShowDetailedError()) {
                this.sendError(code, DataConverter.toString((Throwable)e));
            } else {
                this.sendError(code);
            }
        }

        public void sendError(int errorCode) {
            this.sendError(errorCode, HttpUtils.getReason(errorCode));
        }

        public void sendError(int errorCode, String msg) {
            if (HttpServerConnection.this.isCloseOnSendingError) {
                HttpServerConnection.this.setPersistent(false);
            }
            if (this.isResponseCommitted()) {
                throw new IllegalStateException("response is already committed");
            }
            try {
                this.send(new HttpResponse(errorCode, "text/html", HttpServerConnection.generateErrorMessageHtml(errorCode, msg, HttpServerConnection.this.getId())));
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("could not send error message " + errorCode + " reason " + ioe.toString());
                }
                this.destroy();
            }
        }

        private final class BodyHandlerDecorador
        implements IBodyDataHandler {
            private final IHttpResponseHeader header;
            private boolean isHeaderWritten = false;
            private BodyDataSink bodyDataSink = null;

            public BodyHandlerDecorador(IHttpResponseHeader header) {
                this.header = header;
            }

            @Execution(value=0)
            public boolean onData(NonBlockingBodyDataSource bodyDataSource) {
                try {
                    int available;
                    if (!this.isHeaderWritten) {
                        this.isHeaderWritten = true;
                        this.bodyDataSink = HttpServerConnection.this.writeMessage(this.header, !HttpServerConnection.this.isPersistent());
                        this.bodyDataSink.setFlushmode(IConnection.FlushMode.ASYNC);
                    }
                    if ((available = bodyDataSource.available()) > 0) {
                        ByteBuffer[] bufs = bodyDataSource.readByteBufferByLength(available);
                        this.bodyDataSink.write(bufs);
                    }
                    if (available == -1) {
                        this.bodyDataSink.close();
                        bodyDataSource.setDataHandler(null);
                    }
                }
                catch (IOException exception) {
                    ServerExchange.this.sendError(500);
                }
                return true;
            }
        }
    }

    private final class MessageHandler
    implements AbstractHttpConnection.IMessageHandler,
    Runnable {
        private MessageHandler() {
        }

        public boolean isBodylessMessageExpected() {
            return false;
        }

        public void onException(IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("error occured by receiving request " + ioe.toString());
            }
            HttpServerConnection.this.destroy();
        }

        public void onMessage(IHttpMessage message) throws IOException {
            String expectHeader;
            String upgrade;
            IHttpRequest request = (IHttpRequest)message;
            HttpServerConnection.this.handleLifeCycleHeaders(request);
            if (LOG.isLoggable(Level.FINE)) {
                if (request.getNonBlockingBody() == null) {
                    LOG.fine("[" + HttpServerConnection.this.getId() + "] bodyless request received from " + HttpServerConnection.this.getRemoteAddress() + ":" + HttpServerConnection.this.getRemotePort() + " (" + HttpServerConnection.this.getCountMessagesReceived() + ". request) " + request.getRequestHeader().toString());
                } else {
                    String body = "";
                    String contentType = request.getContentType();
                    if (contentType != null && contentType.startsWith("application/x-www-form-urlencode")) {
                        body = request.getNonBlockingBody().toString() + "\n";
                    }
                    LOG.fine("[" + HttpServerConnection.this.getId() + "] request received  from " + HttpServerConnection.this.getRemoteAddress() + ":" + HttpServerConnection.this.getRemotePort() + " (" + HttpServerConnection.this.getCountMessagesReceived() + ". request) " + request.getRequestHeader().toString() + body);
                }
            }
            if (HttpServerConnection.this.isAutohandleUpgadeHeader && (upgrade = request.getRequestHeader().getUpgrade()) != null && upgrade.equalsIgnoreCase("TLS/1.0")) {
                if (!HttpServerConnection.this.getUnderlyingTcpConnection().isSecuredModeActivateable()) {
                    HttpServerConnection.this.send(new HttpResponse(400, "text/html", HttpServerConnection.generateErrorMessageHtml(400, "upgrade TLS is not supported", HttpServerConnection.this.getId())));
                    return;
                }
                HttpServerConnection.this.suspendReceiving();
                HttpResponse response = new HttpResponse(101);
                response.setHeader("Connection", "Upgrade");
                response.setHeader("Upgrade", "TLS/1.0, HTTP/1.1");
                HttpServerConnection.this.writeMessage(response, false);
                HttpServerConnection.this.getUnderlyingTcpConnection().activateSecuredMode();
                HttpServerConnection.this.resumeReceiving();
                return;
            }
            if (HttpServerConnection.this.isAutconfirmExpect100ContinueHeader && (expectHeader = request.getHeader("Expect")) != null && expectHeader.equalsIgnoreCase("100-Continue")) {
                HttpServerConnection.this.writeMessage(new HttpResponse(100), false);
            }
            if (message.hasBody()) {
                if (HttpServerConnection.this.getBodyDataReceiveTimeoutMillis() != Long.MAX_VALUE) {
                    message.getNonBlockingBody().setBodyDataReceiveTimeoutMillis(HttpServerConnection.this.getBodyDataReceiveTimeoutMillis());
                }
                if (HttpServerConnection.this.isContentTypeFormUrlencoded(request)) {
                    final IHttpRequest req = request;
                    IBodyCompleteListener cl = new IBodyCompleteListener(){

                        @Execution(value=0)
                        public void onComplete() throws IOException {
                            MessageHandler.this.handleMessage(HttpServerConnection.newFormEncodedRequestWrapper(req));
                        }
                    };
                    request.getNonBlockingBody().addCompleteListener(cl);
                    return;
                }
            }
            this.handleMessage(request);
        }

        private void handleMessage(final IHttpRequest request) throws IOException {
            if (deregisterHandle) {
                IBodyCompleteListener deregisterHandlerListener = new IBodyCompleteListener(){

                    @Execution(value=0)
                    public void onComplete() throws IOException {
                        HttpServerConnection.this.suspendMessageReceiving();
                    }
                };
                request.getNonBlockingBody().addCompleteListener(deregisterHandlerListener);
            }
            if (HttpServerConnection.this.requestHandlerInfo.isRequestHandlerInvokeOnMessageReceived() && request.hasBody()) {
                IBodyCompleteListener messageReceivedListener = new IBodyCompleteListener(){

                    @Execution(value=0)
                    public void onComplete() throws IOException {
                        MessageHandler.this.handle(request);
                    }
                };
                request.getNonBlockingBody().addCompleteListener(messageReceivedListener);
            } else {
                this.handle(request);
            }
        }

        private void handle(IHttpRequest request) {
            if (HttpServerConnection.this.requestHandler != null) {
                HttpServerConnection.this.requestQueue.add(request);
                if (HttpServerConnection.this.requestHandlerInfo.isRequestHandlerMultithreaded()) {
                    HttpServerConnection.this.getExecutor().processMultithreaded(this);
                } else {
                    HttpServerConnection.this.getExecutor().processNonthreaded(this);
                }
            }
        }

        public void run() {
            IHttpRequest request = null;
            do {
                if ((request = (IHttpRequest)HttpServerConnection.this.requestQueue.poll()) == null) continue;
                ServerExchange exchange = new ServerExchange(request);
                try {
                    if (HttpServerConnection.this.requestHandlerInfo.isRequestHandlerSynchronizedOnSession()) {
                        SessionSynchronizedRequestHandlerWrapper wrapper = new SessionSynchronizedRequestHandlerWrapper(HttpServerConnection.this.requestHandler);
                        wrapper.onRequest(exchange);
                        continue;
                    }
                    HttpServerConnection.this.requestHandler.onRequest(exchange);
                }
                catch (BadMessageException bme) {
                    if (HttpUtils.isShowDetailedError()) {
                        exchange.sendError(400, DataConverter.toString((Throwable)bme));
                        continue;
                    }
                    exchange.sendError(400);
                }
                catch (Exception e) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + HttpServerConnection.this.getId() + "] error occured by calling on request " + HttpServerConnection.this.requestHandler + " " + e.toString());
                    }
                    if (!exchange.isResponseCommitted()) {
                        if (HttpUtils.isShowDetailedError()) {
                            exchange.sendError(500, DataConverter.toString((Throwable)e));
                        } else {
                            exchange.sendError(500);
                        }
                    }
                    HttpServerConnection.this.closeSilence();
                }
            } while (request != null);
        }
    }

    private final class ConnectionCloser
    implements Runnable {
        private ConnectionCloser() {
        }

        public void run() {
            HttpServerConnection.this.closeSilence();
        }
    }

    private static final class TimeoutWatchDogTask
    extends TimerTask
    implements Closeable {
        private WeakReference<HttpServerConnection> connectionRef = null;

        public TimeoutWatchDogTask(HttpServerConnection connection) {
            this.connectionRef = new WeakReference<HttpServerConnection>(connection);
        }

        public void run() {
            WeakReference<HttpServerConnection> ref = this.connectionRef;
            if (ref != null) {
                HttpServerConnection connection = (HttpServerConnection)ref.get();
                if (connection == null) {
                    this.close();
                } else {
                    connection.checkRequestTimeout(System.currentTimeMillis());
                }
            }
        }

        public void close() {
            this.cancel();
            this.connectionRef = null;
        }
    }
}

