/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view.startup;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineDescriptorComparator;
import com.paterva.maltego.automation.MachineInput;
import com.paterva.maltego.automation.MachineRepository;
import com.paterva.maltego.automation.impl.AutomationContexts;
import com.paterva.maltego.automation.view.MachineInputProvider;
import com.paterva.maltego.automation.view.startup.EntityNodePayload;
import com.paterva.maltego.automation.view.startup.Helper;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.transform.descriptor.InheritedTypesProvider;
import com.paterva.maltego.transform.runner.RegistryInheritedTypesProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MachinesForNodes {
    public static List<MachineDescriptor> get(GraphID graphID, Collection<EntityID> entities) throws IOException {
        if (graphID == null || entities == null || entities.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Collection<? extends MachineDescriptor> machines = MachineRepository.getDefault().getAll();
        return MachinesForNodes.filterApplicable(machines, graphID, entities);
    }

    private static List<MachineDescriptor> filterApplicable(Collection<? extends MachineDescriptor> machines, GraphID graphID, Collection<EntityID> entities) {
        EntityNodePayload payload = new EntityNodePayload(graphID, entities);
        AutomationContexts.ReadOnly ctx = new AutomationContexts.ReadOnly(Helper.getTarget(), payload);
        ArrayList<MachineDescriptor> filtered = new ArrayList<MachineDescriptor>();
        ArrayList<? extends MachineDescriptor> machinesCopy = new ArrayList<MachineDescriptor>(machines);
        for (MachineDescriptor machineDescriptor : machinesCopy) {
            RegistryInheritedTypesProvider typesProvider;
            MachineInput constraint;
            if (!machineDescriptor.isEnabled() || !(constraint = MachineInputProvider.getDefault().getInputDescriptor(machineDescriptor)).isSatisfiedByAny(ctx, payload, (InheritedTypesProvider)(typesProvider = new RegistryInheritedTypesProvider(graphID, ctx.getEntityRegistry(), entities)))) continue;
            filtered.add(machineDescriptor);
        }
        Collections.sort(filtered, new MachineDescriptorComparator());
        return filtered;
    }
}

