/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v3.prompts.choice;

import com.maltego.tx3.java.api.execution.ChoicePromptControl;
import com.maltego.tx3.java.api.execution.TransformRunChoicePromptEvent;
import com.maltego.tx3.java.api.execution.TransformRunMultiChoicePromptEvent;
import com.paterva.maltego.transform.protocol.v3.prompts.choice.controls.ButtonPromptControl;
import com.paterva.maltego.transform.protocol.v3.prompts.choice.controls.CheckboxPromptControl;
import com.paterva.maltego.transform.protocol.v3.prompts.choice.controls.DropdownPromptControl;
import com.paterva.maltego.transform.protocol.v3.prompts.choice.controls.MultiChoicePromptControl;
import com.paterva.maltego.transform.protocol.v3.prompts.choice.controls.PromptControl;
import com.paterva.maltego.transform.protocol.v3.prompts.choice.controls.RadioPromptControl;
import java.util.logging.Logger;

public class PromptControlFactory {
    private static final Logger LOG = Logger.getLogger(PromptControlFactory.class.getName());

    public static PromptControl build(String transforName, TransformRunChoicePromptEvent prompt) {
        ChoicePromptControl control = prompt.getControl();
        if (control == null || control.getControlType() == null) {
            LOG.fine("Prompt choice control or control type not set, defaulting to button prompt control.");
            return new ButtonPromptControl(transforName, prompt);
        }
        switch (control.getControlType()) {
            case DROPDOWN: {
                return new DropdownPromptControl(transforName, prompt);
            }
            case CHECKBOX: {
                return new CheckboxPromptControl(transforName, prompt);
            }
            case RADIO: {
                return new RadioPromptControl(transforName, prompt);
            }
            case BUTTON: {
                return new ButtonPromptControl(transforName, prompt);
            }
        }
        throw new RuntimeException(String.format("Prompt choice control %s is not supported.", control.getControlType().name()));
    }

    public static PromptControl build(String transformDisplayName, TransformRunMultiChoicePromptEvent prompt) {
        return new MultiChoicePromptControl(transformDisplayName, prompt);
    }
}

