/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.webtx.action;

import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.serializers.compact.CompactGraphNameMappings;
import com.paterva.maltego.serializers.compact.CompactGraphWriter;
import com.paterva.maltego.serializers.compact.LinkNameMappings;
import com.paterva.maltego.ui.graph.GraphStructureUtils;
import com.paterva.maltego.ui.graph.actions.TopGraphEntitySelectionAction;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import com.paterva.maltego.webtx.action.SendToUrlController;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.HtmlBrowser;

public class SendToUrlAction
extends TopGraphEntitySelectionAction {
    public SendToUrlAction() {
        this.putValue("position", 750);
    }

    public String getName() {
        return "Send to URL";
    }

    protected String iconResource() {
        return "com/paterva/maltego/webtx/action/SendToURL.png";
    }

    protected void actionPerformed() {
        SendToUrlController controller = new SendToUrlController();
        EditDialogDescriptor descriptor = new EditDialogDescriptor("Send to URL", (WizardDescriptor.Panel)controller);
        DialogDisplayer displayer = DialogDisplayer.getDefault();
        if (DialogDescriptor.OK_OPTION.equals(displayer.notify((NotifyDescriptor)descriptor))) {
            SendToUrlAction.sendToUrl(this.getTopGraphID(), this.getSelectedModelEntities(), controller.getUrl().toString(), displayer, this.getName());
        }
    }

    public static void sendToUrl(GraphID graphID, Set<EntityID> modelEntities, String urlString, DialogDisplayer displayer, String errorDialogTitle) {
        Runnable entitiesToUrl = () -> {
            try {
                URL url = new URL(urlString);
                CompactGraphWriter serializer = new CompactGraphWriter((CompactGraphNameMappings)new LinkNameMappings());
                Set links = GraphStructureUtils.getLinksBetween((GraphID)graphID, (Collection)modelEntities);
                String data = serializer.toString(graphID, (Collection)modelEntities, (Collection)links, false);
                HttpAgent agent = new HttpAgent(url);
                String result = agent.doPostString("text/xml", data);
                try {
                    URL target = new URL(result);
                    if (!FileUtilities.isRemoteFileURL((URL)target)) {
                        HtmlBrowser.URLDisplayer.getDefault().showURL(target);
                    }
                }
                catch (MalformedURLException ex) {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)("Returned URL is not valid: " + result));
                    msg.setMessageType(2);
                    msg.setTitle(errorDialogTitle);
                    displayer.notify((NotifyDescriptor)msg);
                }
            }
            catch (Exception ex) {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)("Error: " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
                msg.setMessageType(0);
                msg.setTitle(errorDialogTitle);
                displayer.notify((NotifyDescriptor)msg);
                NormalException.logStackTrace((Throwable)ex);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            entitiesToUrl.run();
        } else {
            SwingUtilities.invokeLater(entitiesToUrl);
        }
    }
}

