/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.wizard;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.GraphFactory;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.io.convert.TabularGraphBuilder;
import com.paterva.maltego.graph.table.io.convert.TabularGraphImportResult;
import com.paterva.maltego.graph.table.ui.wizard.ImportFailurePanel;
import com.paterva.maltego.graph.table.ui.wizard.ImportSuccessPanel;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.ui.dialog.PassFailProgressController;
import java.util.List;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;

class ImportProgressController
extends PassFailProgressController<TabularGraphImportResult, ImportSuccessPanel, ImportFailurePanel> {
    private TabularGraphImportResult _result;

    public ImportProgressController() {
        this.setName("Import");
        this.setDescription("The summary of the progress to import a graph from a table structured file is shown below.");
    }

    protected void storeSettings(WizardDescriptor settings) {
        super.storeSettings(settings);
        if (this._result != null) {
            settings.putProperty("importedGraphID", (Object)this._result.getConvertResult().getGraphID());
        }
    }

    protected ImportSuccessPanel createPassComponent() {
        return new ImportSuccessPanel();
    }

    protected ImportFailurePanel createFailComponent() {
        return new ImportFailurePanel("Data read error!");
    }

    protected void pass(WizardDescriptor descriptor, ImportSuccessPanel successPanel, TabularGraphImportResult result) {
        this._result = result;
        successPanel.setResult(result);
    }

    protected void fail(ImportFailurePanel failurePanel, Exception e) {
        if (e == null) {
            failurePanel.setError(null);
        } else {
            NormalException.logStackTrace((Throwable)e);
            failurePanel.setError(e.getMessage());
        }
    }

    protected TabularGraphImportResult doProcessing(WizardDescriptor descriptor, ProgressHandle handle) throws Exception {
        TabularGraph tabularGraph = (TabularGraph)this.getDescriptor().getProperty("graphTable");
        List files = (List)this.getDescriptor().getProperty("files");
        GraphID graphID = GraphFactory.getDefault().createInvisibleInMemoryGraph();
        TabularGraphBuilder builder = new TabularGraphBuilder(graphID, tabularGraph, files, handle);
        TabularGraphImportResult result = new TabularGraphImportResult(builder.build());
        return result;
    }

    public boolean canBack() {
        return true;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }
}

