/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository;

import com.paterva.maltego.transform.repository.TransformDataObject;
import java.io.IOException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;

public class TransformDataLoader
extends MultiFileLoader {
    public static final String MIME_TYPE = "text/maltegotransform+xml";
    public static final String TRANSFORM_EXTENSION = "transform";
    public static final String SETTINGS_EXTENSION = "transformsettings";
    public static final String PROP_EXTENSIONS = "extensions";

    public TransformDataLoader() {
        super("com.paterva.maltego.transform.repository.TransformDataObject");
    }

    protected String defaultDisplayName() {
        return "Transform Data Loader";
    }

    protected void initialize() {
        super.initialize();
        this.getExtensions();
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        return new TransformDataObject(primaryFile, FileUtil.findBrother((FileObject)primaryFile, (String)SETTINGS_EXTENSION), this);
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        if (fo.isFolder()) {
            return null;
        }
        String ext = fo.getExt();
        if (ext.equalsIgnoreCase(SETTINGS_EXTENSION)) {
            FileObject info = FileUtil.findBrother((FileObject)fo, (String)TRANSFORM_EXTENSION);
            return info;
        }
        if (ext.equalsIgnoreCase(TRANSFORM_EXTENSION)) {
            return fo;
        }
        return null;
    }

    protected String actionsContext() {
        return "Loaders/text/maltegotransform+xml/Actions";
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        return new FileEntry(obj, primaryFile);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject obj, FileObject secondaryFile) {
        assert (SETTINGS_EXTENSION.equals(secondaryFile.getExt()));
        FileEntry settingsEntry = new FileEntry(obj, secondaryFile);
        ((TransformDataObject)obj).setSettingsFileEntry(settingsEntry);
        return settingsEntry;
    }

    public ExtensionList getExtensions() {
        ExtensionList extensions = (ExtensionList)this.getProperty(PROP_EXTENSIONS);
        if (extensions == null) {
            extensions = new ExtensionList();
            extensions.addExtension(TRANSFORM_EXTENSION);
            extensions.addExtension(SETTINGS_EXTENSION);
            this.putProperty(PROP_EXTENSIONS, extensions, false);
        }
        return extensions;
    }
}

