/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.gen.TransformSourceSettingsUpdater;
import com.paterva.maltego.transforms.tabular.TabularTransformGlobalPreferences;
import com.paterva.maltego.transforms.tabular.TabularTransformSourceRepository;
import com.paterva.maltego.transforms.tabular.TabularTransformType;
import com.paterva.maltego.transforms.tabular.data.TabularTransform;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.util.Args;
import java.util.ArrayList;
import java.util.Optional;

public class TabularTransformSettingsUpdater
implements TransformSourceSettingsUpdater {
    public boolean updateSettings(TransformDefinition transform) {
        boolean handled;
        Args.notNull((Object)transform, (String)"transform");
        if (TabularTransformType.isGlobalSearch((TransformDescriptor)transform)) {
            TabularTransformGlobalPreferences.setGlobalSearchFavorited(transform.isFavorite());
            handled = true;
        } else {
            Optional<TabularTransformSource> txSourceOpt = TabularTransformType.getSearchTransformSource((TransformDescriptor)transform);
            if (txSourceOpt.isPresent()) {
                TabularTransformSource txSource = txSourceOpt.get();
                if (txSource.isSearchFavorited() != transform.isFavorite()) {
                    this.updateSearchFavorite(txSource, transform);
                }
                handled = true;
            } else {
                TabularTransformSource txSource = TabularTransformType.getTransformSource((TransformDescriptor)transform).orElseThrow(() -> new IllegalStateException("Tabular transform source not found for transform: " + transform.getName()));
                TabularTransform tabularTransform = txSource.getTabularTransform((TransformDescriptor)transform).orElseThrow(() -> new IllegalStateException("Tabular transform not found: " + transform.getName()));
                if (transform.isFavorite() != tabularTransform.isFavorite()) {
                    this.updateFavorite(txSource, transform, tabularTransform);
                }
                handled = true;
            }
        }
        return handled;
    }

    private void updateSearchFavorite(TabularTransformSource txSource, TransformDefinition transform) {
        txSource = txSource.setSearchFavorited(transform.isFavorite());
        TabularTransformSourceRepository.getInstance().update((Object)txSource);
    }

    private void updateFavorite(TabularTransformSource txSource, TransformDefinition transform, TabularTransform tabularTransform) {
        ArrayList<TabularTransform> tabularTransforms = new ArrayList<TabularTransform>();
        for (TabularTransform tabularTx : txSource.getTabularTransforms()) {
            if (tabularTx.equals(tabularTransform)) {
                tabularTx = new TabularTransform(tabularTx.getLinkIndexes(), tabularTx.isReverse(), transform.isFavorite());
            }
            tabularTransforms.add(tabularTx);
        }
        txSource = txSource.setTabularTransforms(tabularTransforms);
        TabularTransformSourceRepository.getInstance().update((Object)txSource);
    }
}

