/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.forms;

import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PropertyTypes {
    public static final List<TypeDescriptor> valueTypes;
    public static final List<TypeDescriptor> imageTypes;

    private PropertyTypes() {
    }

    public static List<DisplayDescriptor> getValueProperties(TypeSpec spec) {
        return PropertyTypes.getValueProperties(spec, Collectors.toList());
    }

    public static <C extends Collection<DisplayDescriptor>> C getValueProperties(TypeSpec spec, Supplier<C> collectionFactory) {
        return PropertyTypes.getValueProperties(spec, Collectors.toCollection(collectionFactory));
    }

    public static <C extends Collection<DisplayDescriptor>> C getValueProperties(TypeSpec spec, Collector<DisplayDescriptor, ?, C> collector) {
        Predicate<DisplayDescriptor> valueFilter = descriptor -> valueTypes.contains(descriptor.getTypeDescriptor());
        return PropertyTypes.getProperties((Collection<DisplayDescriptor>)spec.getProperties(), valueFilter, collector);
    }

    public static List<DisplayDescriptor> getImageProperties(TypeSpec spec) {
        return PropertyTypes.getImageProperties(spec, Collectors.toList());
    }

    public static <C extends Collection<DisplayDescriptor>> C getImageProperties(TypeSpec spec, Supplier<C> collectionFactory) {
        return PropertyTypes.getImageProperties(spec, Collectors.toCollection(collectionFactory));
    }

    public static <C extends Collection<DisplayDescriptor>> C getImageProperties(TypeSpec spec, Collector<DisplayDescriptor, ?, C> collector) {
        Predicate<DisplayDescriptor> imageFilter = descriptor -> imageTypes.contains(descriptor.getTypeDescriptor());
        return PropertyTypes.getProperties((Collection<DisplayDescriptor>)spec.getProperties(), imageFilter, collector);
    }

    public static List<DisplayDescriptor> getDisplayValueProperties(TypeSpec spec) {
        return PropertyTypes.getValueProperties(spec);
    }

    public static <C extends Collection<DisplayDescriptor>> C getDisplayValueProperties(TypeSpec spec, Supplier<C> collectionFactory) {
        return PropertyTypes.getValueProperties(spec, collectionFactory);
    }

    public static <C extends Collection<DisplayDescriptor>> C getImageProperties(Collection<DisplayDescriptor> properties, Supplier<C> collectionFactory) {
        Predicate<DisplayDescriptor> imageFilter = descriptor -> imageTypes.contains(descriptor.getTypeDescriptor());
        return PropertyTypes.getProperties(properties, imageFilter, Collectors.toCollection(collectionFactory));
    }

    static <C extends Collection<DisplayDescriptor>> C getProperties(Collection<DisplayDescriptor> properties, Predicate<DisplayDescriptor> filter, Collector<DisplayDescriptor, ?, C> collector) {
        return (C)((Collection)properties.stream().filter(filter).collect(collector));
    }

    static {
        TypeRegistry registry = TypeRegistry.getDefault();
        List valueList = Stream.of("string", "date", "int", "double").map(name -> registry.getType(name)).collect(Collectors.toList());
        valueTypes = Collections.unmodifiableList(valueList);
        List imageList = Stream.of("image", "url", "string", "attachments").map(name -> registry.getType(name)).collect(Collectors.toList());
        imageTypes = Collections.unmodifiableList(imageList);
    }
}

